/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAddToPartitionDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmRSMNodeManager;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTree;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeNode;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class SMFmPartitionPopupMenu
extends JPopupMenu
implements ActionListener {
    String[] menus = new String[]{SMFmConfGlobal.getI18NString("EDIT_MANAGE_PARTITION"), "managepart", "", SMFmConfGlobal.getI18NString("ADD_NODE_DIALOG"), "addnode", SMFmConfGlobal.getI18NString("DELETE_DIALOG"), "delete"};
    private SMFmPartitionData partition;
    private SMFmFabricData fabricData;
    private SMFmResourceAccess resAcc;

    public SMFmPartitionPopupMenu(SMFmResourceAccess sMFmResourceAccess) {
        super(SMFmConfGlobal.getI18NString("PARTITION_MENU"));
        this.resAcc = sMFmResourceAccess;
        this.fabricData = sMFmResourceAccess.getFabricData();
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n].length() == 0) {
                this.addSeparator();
                ++n;
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(this.menus[n]);
            jMenuItem.setActionCommand(this.menus[++n]);
            jMenuItem.addActionListener(this);
            this.add(jMenuItem);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        if (this.partition == null) {
            SMFmConfGlobal.DebugPrint("ERROR: Null partition");
            return;
        }
        if (string.equals("managepart")) {
            int n = this.partition.getMode();
            SMFmRSMNodeManager sMFmRSMNodeManager = new SMFmRSMNodeManager((JFrame)this.getTopLevelAncestor(), true, this.fabricData, this.partition, this.resAcc);
            sMFmRSMNodeManager.show();
        } else if (string.equals("routesAndLinks")) {
            JOptionPane.showMessageDialog((JFrame)this.getTopLevelAncestor(), SMFmConfGlobal.getI18NString("MENU_ITEM_NOT_SUPPORTED"));
        } else if (string.equals("addnode")) {
            int n = this.partition.getMode();
            SMFmAddToPartitionDialog sMFmAddToPartitionDialog = null;
            sMFmAddToPartitionDialog = new SMFmAddToPartitionDialog((JFrame)this.getTopLevelAncestor(), true, this.fabricData, this.partition, this.resAcc);
            if (sMFmAddToPartitionDialog != null) {
                sMFmAddToPartitionDialog.show();
            }
        } else if (string.equals("delete")) {
            if (this.partition.getNodeCount() != 0) {
                JOptionPane.showMessageDialog((JFrame)this.getTopLevelAncestor(), String.valueOf(SMFmConfGlobal.getI18NString("PAR_NOT_EMPTY_ERR")) + "\n" + SMFmConfGlobal.getI18NString("HOW_TO_EMPTY_HELP"), SMFmConfGlobal.getI18NString("ERROR"), 0);
            } else {
                int n = JOptionPane.showConfirmDialog((JFrame)this.getTopLevelAncestor(), SMFmConfGlobal.getI18NString("DELETE_SELECTED"), SMFmConfGlobal.getI18NString("WARNING"), 2);
                if (n == 0) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            SMFmPartitionPopupMenu.this.resAcc.deletePartition(SMFmPartitionPopupMenu.this.partition.getName());
                            String string = SMFmPartitionPopupMenu.this.resAcc.getErrorMessage();
                            if (string != null) {
                                JOptionPane.showMessageDialog((JFrame)SMFmPartitionPopupMenu.this.getTopLevelAncestor(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                            }
                        }
                    });
                    thread.start();
                }
            }
        } else {
            SMFmConfGlobal.DebugPrint("Unrecognized menu command:" + string);
        }
    }

    public void show(Component component, int n, int n2) {
        SMFmConfGlobal.DebugPrint("Got Show popup command");
        if (!(component instanceof SMFmTree)) {
            SMFmConfGlobal.DebugPrint("Unrecognized popup invoker:" + component);
            this.partition = null;
            return;
        }
        SMFmTree sMFmTree = (SMFmTree)component;
        SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)sMFmTree.getLastSelectedPathComponent();
        this.partition = (SMFmPartitionData)sMFmTreeNode.getUserObject();
        super.show(component, n, n2);
    }
}

