/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class SMFmPartitionNodeManager
extends SMFmAbstractBaseDialog {
    protected JLabel nodeCount = new JLabel();
    protected JLabel partStatus = new JLabel();
    protected JLabel partMastHostname = new JLabel();
    protected JLabel partName;
    protected JLabel partTop;
    protected JLabel partMode;
    protected JLabel partStripe;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JButton closeButton;
    protected JButton helpButton;
    protected JButton propertiesButton;
    protected SMFmTable table;
    protected SMFmFabricData fabricData;
    protected SMFmPartitionData partData;
    private SMFmResourceAccessListener resAccListener;
    protected JDialog dialog;
    private JPanel contentPanel;

    public SMFmPartitionNodeManager(Dialog dialog, String string, boolean bl, SMFmFabricData sMFmFabricData, SMFmPartitionData sMFmPartitionData, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, string, 2, true, bl);
        this.fabricData = sMFmFabricData;
        this.partData = sMFmPartitionData;
        this.dialog = this;
        this.buildDialog();
    }

    public SMFmPartitionNodeManager(Frame frame, String string, boolean bl, SMFmFabricData sMFmFabricData, SMFmPartitionData sMFmPartitionData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, string, 2, true, bl);
        this.fabricData = sMFmFabricData;
        this.partData = sMFmPartitionData;
        this.dialog = this;
        this.buildDialog();
    }

    public void addButtonsToPanel() {
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
        this.helpButton = new JButton(SMFmConfGlobal.getI18NString("helpButton.label"));
        this.helpButton.setMnemonic(SMFmConfGlobal.getI18NString("helpButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.helpButton);
    }

    private void addListeners() {
        this.enableDelButton(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmPartitionNodeManager.this.closeDialog();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = SMFmPartitionNodeManager.this.resAcc.getHelpFileURL("index.html");
                SMFmPartitionNodeManager.this.resAcc.launchNetscape(uRL.toString());
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPartitionNodeManager.this.closeDialog();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPartitionNodeManager.this.enableAllButtons(false);
                int[] nArray = SMFmPartitionNodeManager.this.table.getSelectedRows();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < nArray.length) {
                    Vector vector = SMFmPartitionNodeManager.this.table.getRowVector(nArray[n]);
                    String string = (String)vector.get(2);
                    String string2 = (String)vector.get(3);
                    String string3 = string2.equals("") ? string : String.valueOf(string) + ":" + string2;
                    arrayList.add(string3);
                    ++n;
                }
                if (SMFmPartitionNodeManager.this.partData.isDeleteAllowed(arrayList)) {
                    int n2 = JOptionPane.showConfirmDialog(SMFmPartitionNodeManager.this.dialog, SMFmConfGlobal.getI18NString("DELETE_NODE_SELECTED"), SMFmConfGlobal.getI18NString("WARNING"), 2);
                    if (n2 == 0) {
                        SMFmPartitionNodeManager.this.deleteNode(arrayList);
                    } else {
                        SMFmPartitionNodeManager.this.enableAllButtons(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(SMFmPartitionNodeManager.this.dialog, SMFmConfGlobal.getI18NString("CANNOT_DELETE_SWITCH"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                    SMFmPartitionNodeManager.this.enableAllButtons(true);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    SMFmPartitionNodeManager.this.enableDelButton(false);
                    SMFmPartitionNodeManager.this.propertiesButton.setEnabled(false);
                } else {
                    SMFmPartitionNodeManager.this.enableDelButton(true);
                    SMFmPartitionNodeManager.this.propertiesButton.setEnabled(true);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SMFmPartitionNodeManager.this.propertiesButton.doClick();
                }
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmPartitionData sMFmPartitionData = SMFmPartitionNodeManager.this.fabricData.getPartitionByName(SMFmPartitionNodeManager.this.partData.getName());
                if (sMFmPartitionData == null) {
                    SMFmConfGlobal.DebugPrint("SMFmPartitionNodeManager: Partition " + sMFmPartitionData.getName() + "was removed unexpectedly, exiting");
                    SMFmPartitionNodeManager.this.closeDialog();
                } else {
                    SMFmPartitionNodeManager.this.partData = sMFmPartitionData;
                    SMFmPartitionNodeManager.this.procPartDataForStats();
                    SMFmPartitionNodeManager.this.procPartForTableData();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void buildDialog() {
        this.status = this.resAcc.getStatusJLabel();
        this.procPartInfoForStats();
        this.procPartDataForStats();
        this.initComponents();
        this.addListeners();
    }

    protected void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private JPanel createRightButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 10));
        this.addButton = new JButton(SMFmConfGlobal.getI18NString("addButton.label"));
        this.addButton.setMnemonic(SMFmConfGlobal.getI18NString("addButton.mnemonic").charAt(0));
        this.addButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_ADD_BUTTON"));
        jPanel.add(this.addButton);
        this.deleteButton = new JButton(SMFmConfGlobal.getI18NString("deleteButton.label"));
        this.deleteButton.setMnemonic(SMFmConfGlobal.getI18NString("deleteButton.mnemonic").charAt(0));
        this.deleteButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_DELETE_BUTTON"));
        jPanel.add(this.deleteButton);
        this.propertiesButton = new JButton(SMFmConfGlobal.getI18NString("PROPERTIES_DIALOG"));
        this.propertiesButton.setMnemonic(SMFmConfGlobal.getI18NString("PROPERTIES_DIALOG.mnemonic").charAt(0));
        this.propertiesButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_PROPERTIES_BUTTON"));
        this.propertiesButton.setEnabled(false);
        jPanel.add(this.propertiesButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 0, new Insets(37, 12, 10, 0), 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    private JPanel createStatPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("PARTITION_NAME"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_PARTITION_NAME"));
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("MODE_COLON"));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("MODE"));
        this.partName.setForeground(Color.black);
        this.partName.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_PARTITION_NAME"));
        this.partMode.setHorizontalAlignment(2);
        this.partMode.setForeground(Color.black);
        this.partMode.setToolTipText(SMFmConfGlobal.getI18NString("MODE"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.partName, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.partMode, gridBagConstraints);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("TOPOLOGY_TYPE"));
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_TOPOLOGY_TYPE"));
        JLabel jLabel4 = new JLabel(SMFmConfGlobal.getI18NString("LINK_STRIPING_LEVEL_POLICY"));
        jLabel4.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_LINK_STRIPING"));
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.add(jLabel3);
        jPanel4.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        this.partTop.setForeground(Color.black);
        this.partTop.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_TOPOLOGY_TYPE"));
        this.partStripe.setForeground(Color.black);
        this.partStripe.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_LINK_STRIPING"));
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        jPanel5.add(this.partTop);
        jPanel5.add(this.partStripe);
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        JLabel jLabel5 = new JLabel(SMFmConfGlobal.getI18NString("STATUS_LABEL"));
        jLabel5.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_PART_STATUS"));
        JLabel jLabel6 = new JLabel(SMFmConfGlobal.getI18NString("NO_OF_NODES"));
        jLabel6.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_NO_OF_NODES"));
        this.partStatus.setForeground(Color.black);
        this.partStatus.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_PART_STATUS"));
        this.nodeCount.setForeground(Color.black);
        this.nodeCount.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_MGR_NO_OF_NODES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel6.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel6.add((Component)this.partStatus, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel6.add((Component)this.nodeCount, gridBagConstraints);
        jPanel.add((Component)jPanel6, "East");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel7.add(new JSeparator());
        return jPanel7;
    }

    private JPanel createTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("NODES_IN_PARTITION"));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 6, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.table = new SMFmTable();
        this.table.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.table){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private void deleteNode(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string2 == null || string2.equals("")) {
                    arrayList.add(string);
                } else {
                    arrayList.add(String.valueOf(string) + ":" + string2);
                }
                SMFmPartitionData sMFmPartitionData = resAcc.downgradePartition(partName.getText(), arrayList);
                String string3 = resAcc.getErrorMessage();
                if (string3 != null) {
                    JOptionPane.showMessageDialog(dialog, string3, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                    this.enableAllButtons(true);
                } else {
                    this.enableAddHelpCloseButtons(true);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void deleteNode(final List list) {
        Runnable runnable = new Runnable(){

            public void run() {
                SMFmPartitionData sMFmPartitionData = resAcc.downgradePartition(partName.getText(), list);
                String string = resAcc.getErrorMessage();
                if (string != null) {
                    JOptionPane.showMessageDialog(dialog, string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                    this.enableAllButtons(true);
                } else {
                    this.enableAddHelpCloseButtons(true);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void enableAddHelpCloseButtons(boolean bl) {
        this.addButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
    }

    private void enableAllButtons(boolean bl) {
        this.deleteButton.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
    }

    private void enableDelButton(boolean bl) {
        this.deleteButton.setEnabled(bl);
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)this.createStatPanel(), "North");
        this.contentPanel.add((Component)this.createRightButtonPanel(), "East");
        this.contentPanel.add((Component)this.createTablePanel(), "Center");
        this.addButtonsToPanel();
        this.addToMainPanel(this.contentPanel);
    }

    protected void procPartDataForStats() {
        if (this.partData != null) {
            this.partStatus.setText(SMFmConfGlobal.getLinkSetStatusString(this.partData.getStatus()));
            this.nodeCount.setText(String.valueOf(this.partData.getNodeCount()));
            this.partMastHostname.setText(this.partData.getMasterHostname());
        }
    }

    public abstract void procPartForTableData();

    protected void procPartInfoForStats() {
        if (this.partData != null) {
            this.partName = new JLabel(this.partData.getName());
            this.partMode = new JLabel(SMFmConfGlobal.getModeString(this.partData.getMode()));
            this.partTop = new JLabel(SMFmConfGlobal.getTopoString(this.partData.getTopoType()));
            String string = SMFmConfGlobal.getStripeLevelString(this.partData.getStriping());
            this.partStripe = new JLabel(string);
        }
    }
}

