/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmNewPartitionDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmRSMNodeManager;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SMFmPartitionManager
extends SMFmAbstractBaseDialog {
    private JLabel fabName = new JLabel();
    private JLabel nodeCount = new JLabel();
    private JLabel partCount = new JLabel();
    private JLabel linkCount = new JLabel();
    private static final int STATUS_COLUMN = 4;
    private String[] colNameStrings = new String[]{SMFmConfGlobal.getI18NString("NAME"), SMFmConfGlobal.getI18NString("MODE"), SMFmConfGlobal.getI18NString("TOPOLOGY"), SMFmConfGlobal.getI18NString("LINK_STRIPING"), SMFmConfGlobal.getI18NString("STATUS")};
    private String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_PM_PARTITION_NAME"), SMFmConfGlobal.getI18NString("TT_PM_PARTITION_MODE"), SMFmConfGlobal.getI18NString("TT_PM_PARTITION_TOPOLOGY"), SMFmConfGlobal.getI18NString("TT_PM_LINK_STRIPING"), SMFmConfGlobal.getI18NString("TT_PM_PARTITION_STATUS")};
    private JButton newButton;
    private JButton deleteButton;
    private JButton nodesButton;
    private JButton closeButton;
    private JButton helpButton;
    private SMFmTable table;
    private SMFmFabricData fabricData;
    private SMFmResourceAccessListener resAccListener;
    private JDialog dialog;

    public SMFmPartitionManager(Frame frame, boolean bl, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, SMFmConfGlobal.getI18NString("PARTITION_MANAGER_TITLE"), 2, true, bl);
        this.fabricData = sMFmFabricData;
        this.dialog = this;
        this.table = new SMFmTable(this.colNameStrings, this.colToolTipStrings);
        this.procFabForStats();
        this.procFabtForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    public void addButtonsToPanel() {
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
        this.helpButton = new JButton(SMFmConfGlobal.getI18NString("helpButton.label"));
        this.helpButton.setMnemonic(SMFmConfGlobal.getI18NString("helpButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.helpButton);
    }

    private void addListeners() {
        this.enableDelNodeButton(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmPartitionManager.this.closeDialog();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = SMFmPartitionManager.this.resAcc.getHelpFileURL("index.html");
                SMFmPartitionManager.this.resAcc.launchNetscape(uRL.toString());
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPartitionManager.this.closeDialog();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPartitionManager.this.enableAllButtons(false);
                int n = SMFmPartitionManager.this.table.getSelectedRow();
                Vector vector = SMFmPartitionManager.this.table.getRowVector(n);
                if (SMFmPartitionManager.this.isDeletionAllowed(vector)) {
                    int n2 = JOptionPane.showConfirmDialog(SMFmPartitionManager.this.dialog, SMFmConfGlobal.getI18NString("DELETE_SELECTED"), SMFmConfGlobal.getI18NString("WARNING"), 2);
                    if (n2 == 0) {
                        SMFmPartitionManager.this.deletePartition(vector, n);
                    } else {
                        SMFmPartitionManager.this.enableAllButtons(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(SMFmPartitionManager.this.dialog, String.valueOf(SMFmConfGlobal.getI18NString("PAR_NOT_EMPTY_ERR")) + "\n" + SMFmConfGlobal.getI18NString("HOW_TO_EMPTY_HELP"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                    SMFmPartitionManager.this.enableAllButtons(true);
                }
            }
        });
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmNewPartitionDialog sMFmNewPartitionDialog = new SMFmNewPartitionDialog(SMFmPartitionManager.this.dialog, true, SMFmPartitionManager.this.fabricData, SMFmPartitionManager.this.resAcc);
                sMFmNewPartitionDialog.show();
            }
        });
        this.nodesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SMFmPartitionManager.this.fabricData != null) {
                    int n = SMFmPartitionManager.this.table.getSelectedRow();
                    Vector vector = SMFmPartitionManager.this.table.getRowVector(n);
                    String string = (String)vector.get(0);
                    String string2 = (String)vector.get(1);
                    SMFmPartitionData sMFmPartitionData = SMFmPartitionManager.this.fabricData.getPartitionByName(string);
                    SMFmRSMNodeManager sMFmRSMNodeManager = new SMFmRSMNodeManager(SMFmPartitionManager.this.dialog, true, SMFmPartitionManager.this.fabricData, sMFmPartitionData, SMFmPartitionManager.this.resAcc);
                    sMFmRSMNodeManager.show();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    SMFmPartitionManager.this.enableDelNodeButton(false);
                } else {
                    SMFmPartitionManager.this.enableDelNodeButton(true);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SMFmPartitionManager.this.nodesButton.doClick();
                }
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                System.out.println("Got notice");
                SMFmPartitionManager.this.procFabForStats();
                SMFmPartitionManager.this.procFabtForTableData();
                SMFmPartitionManager.this.validate();
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private JPanel createRightButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 10));
        this.newButton = new JButton(SMFmConfGlobal.getI18NString("newButton.label"));
        this.newButton.setMnemonic(SMFmConfGlobal.getI18NString("newButton.mnemonic").charAt(0));
        this.newButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NEW_BUTTON"));
        jPanel.add(this.newButton);
        this.deleteButton = new JButton(SMFmConfGlobal.getI18NString("deleteButton.label"));
        this.deleteButton.setMnemonic(SMFmConfGlobal.getI18NString("deleteButton.mnemonic").charAt(0));
        this.deleteButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_DELETE_BUTTON"));
        jPanel.add(this.deleteButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        this.nodesButton = new JButton(SMFmConfGlobal.getI18NString("nodesButton.label"));
        this.nodesButton.setMnemonic(SMFmConfGlobal.getI18NString("nodesButton.mnemonic").charAt(0));
        this.nodesButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NODES_BUTTON"));
        jPanel2.add(this.nodesButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 2, new Insets(37, 10, 0, 0), 0, 0);
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 10, 0, 0), 0, 0);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        return jPanel3;
    }

    private JPanel createStatPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("FABRIC_NAME_COLON"));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.fabName);
        this.fabName.setForeground(Color.black);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(2, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("NO_OF_NODES"));
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_NODES"));
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("NO_OF_PARTITIONS"));
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_PARTITIONS"));
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        this.nodeCount.setForeground(Color.black);
        this.nodeCount.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_NODES"));
        this.partCount.setForeground(Color.black);
        this.partCount.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_PARTITIONS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        jPanel5.add((Component)this.nodeCount, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel5.add((Component)this.partCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel(new FlowLayout(2, 0, 0));
        JLabel jLabel4 = new JLabel(SMFmConfGlobal.getI18NString("NO_OF_LINKS"));
        jLabel4.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_LINKS"));
        this.linkCount.setForeground(Color.black);
        this.linkCount.setToolTipText(SMFmConfGlobal.getI18NString("TT_PM_NO_OF_LINKS"));
        jPanel6.add(jLabel4);
        jPanel6.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel6.add(this.linkCount);
        jPanel.add((Component)jPanel6, "East");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel7.add(new JSeparator());
        return jPanel7;
    }

    private JPanel createTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("PARTITIONS_IN_FABRIC"));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 0, 6, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private void deletePartition(Vector vector, int n) {
        if (vector == null || this.fabricData == null || this.resAcc == null) {
            return;
        }
        final String string = (String)vector.get(0);
        Runnable runnable = new Runnable(){

            public void run() {
                resAcc.deletePartition(string);
                String string2 = resAcc.getErrorMessage();
                if (string2 != null) {
                    JOptionPane.showMessageDialog(dialog, string2, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                }
                this.enableNewHelpCloseButton(true);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void enableAllButtons(boolean bl) {
        this.newButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.nodesButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
    }

    private void enableDelNodeButton(boolean bl) {
        this.deleteButton.setEnabled(bl);
        this.nodesButton.setEnabled(bl);
    }

    private void enableNewHelpCloseButton(boolean bl) {
        this.newButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
    }

    private Vector getPartitionData() {
        Vector vector;
        Vector<Vector<String>> vector2 = new Vector<Vector<String>>();
        if (this.fabricData != null && (vector = this.fabricData.getPartitions()) != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)vector.get(n2);
                String[] stringArray = new String[this.colNameStrings.length];
                stringArray[0] = sMFmPartitionData.getName();
                stringArray[1] = SMFmConfGlobal.getModeString(sMFmPartitionData.getMode());
                stringArray[2] = SMFmConfGlobal.getTopoString(sMFmPartitionData.getTopoType());
                stringArray[3] = SMFmConfGlobal.getStripeLevelString(sMFmPartitionData.getStriping());
                stringArray[4] = SMFmConfGlobal.getLinkSetStatusString(sMFmPartitionData.getStatus());
                vector2.add(new Vector<String>(Arrays.asList(stringArray)));
                ++n2;
            }
        }
        return vector2;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createStatPanel(), "North");
        jPanel.add((Component)this.createRightButtonPanel(), "East");
        jPanel.add((Component)this.createTablePanel(), "Center");
        this.addButtonsToPanel();
        this.addToMainPanel(jPanel);
    }

    private boolean isDeletionAllowed(Vector vector) {
        if (vector == null || this.fabricData == null) {
            return false;
        }
        String string = (String)vector.get(0);
        SMFmPartitionData sMFmPartitionData = this.fabricData.getPartitionByName(string);
        return sMFmPartitionData.getNodeCount() == 0;
    }

    private void procFabForStats() {
        if (this.fabricData != null) {
            this.fabName.setText(this.fabricData.getFabricName());
            this.partCount.setText(String.valueOf(this.fabricData.getPartitionCount()));
            this.nodeCount.setText(String.valueOf(this.fabricData.getPartitionNodeCount()));
            this.linkCount.setText(String.valueOf(this.fabricData.getPatitionLinkCount()));
        }
    }

    private void procFabtForTableData() {
        this.table.setDataVector(this.getPartitionData());
    }
}

