/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmRegisterDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SMFmNodeRegistry
extends SMFmAbstractBaseDialog {
    private JLabel fabName = new JLabel();
    private SMFmTable table;
    private String[] colNameStrings = new String[]{SMFmConfGlobal.getI18NString("NODE_TYPE"), SMFmConfGlobal.getI18NString("SC_HOST"), SMFmConfGlobal.getI18NString("DOMAIN_ID"), SMFmConfGlobal.getI18NString("SOLARIS_HOSTNAME"), SMFmConfGlobal.getI18NString("CHASSIS_TYPE"), SMFmConfGlobal.getI18NString("MODE")};
    private String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_NODE_REG_NODE_TYPE"), SMFmConfGlobal.getI18NString("TT_NODE_REG_SC_HOST"), SMFmConfGlobal.getI18NString("TT_NODE_REG_DOMAIN_ID"), SMFmConfGlobal.getI18NString("TT_NODE_REG_SOLARIS_HOSTNAME"), SMFmConfGlobal.getI18NString("TT_NODE_REG_CHASSIS_TYPE"), SMFmConfGlobal.getI18NString("TT_NODE_REG_TBL_IN_USE")};
    private JButton registerButton;
    private JButton unregisterButton;
    private JButton closeButton;
    private JButton helpButton;
    private SMFmFabricData fabricData;
    private String FMName;
    private SMFmResourceAccessListener resAccListener;
    private JDialog dialog;
    private JPanel contentPanel;

    public SMFmNodeRegistry(Frame frame, boolean bl, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, SMFmConfGlobal.getI18NString("NODE_REGISTRY_TITLE"), 2, true, bl);
        this.fabricData = sMFmFabricData;
        this.dialog = this;
        this.FMName = sMFmFabricData.getFabricName();
        this.table = new SMFmTable(this.colNameStrings, this.colToolTipStrings);
        this.table.setPreferredTableHeight(150);
        this.procFabricForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    public void addButtonsToPanel() {
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
        this.helpButton = new JButton(SMFmConfGlobal.getI18NString("helpButton.label"));
        this.helpButton.setMnemonic(SMFmConfGlobal.getI18NString("helpButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.helpButton);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmNodeRegistry.this.closeDialog();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = SMFmNodeRegistry.this.resAcc.getHelpFileURL("index.html");
                SMFmNodeRegistry.this.resAcc.launchNetscape(uRL.toString());
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmNodeRegistry.this.closeDialog();
            }
        });
        this.registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmRegisterDialog sMFmRegisterDialog = new SMFmRegisterDialog((Dialog)SMFmNodeRegistry.this.dialog, SMFmNodeRegistry.this.FMName, SMFmNodeRegistry.this.fabricData, SMFmNodeRegistry.this.resAcc);
                sMFmRegisterDialog.show();
            }
        });
        this.unregisterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SMFmNodeRegistry.this.table.getSelectedRows();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < nArray.length) {
                    Vector vector = SMFmNodeRegistry.this.table.getRowVector(nArray[n]);
                    String string = (String)vector.get(1);
                    String string2 = (String)vector.get(2);
                    String string3 = string2.equals("") ? string : String.valueOf(string) + ":" + string2;
                    String string4 = (String)vector.get(5);
                    if (!string4.equals(SMFmConfGlobal.MODE_FREE_STRING)) {
                        JOptionPane.showMessageDialog(SMFmNodeRegistry.this.dialog, String.valueOf(string3) + " " + SMFmConfGlobal.getI18NString("UNREGISTER_NODE_NOT_FREE"), SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                        return;
                    }
                    arrayList.add(string3);
                    ++n;
                }
                int n2 = JOptionPane.showConfirmDialog(SMFmNodeRegistry.this.dialog, SMFmConfGlobal.getI18NString("UNREGISTER_NODES_QUERY"), SMFmConfGlobal.getI18NString("CONFIRM_UNREG"), 0);
                if (n2 == 0) {
                    SMFmNodeRegistry.this.unregisterNode(arrayList);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    SMFmNodeRegistry.this.enableNodeRegistryButtons(false);
                } else {
                    SMFmNodeRegistry.this.enableNodeRegistryButtons(true);
                }
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmNodeRegistry.this.procFabricForTableData();
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void enableNodeRegistryButtons(boolean bl) {
        this.registerButton.setEnabled(bl);
        this.unregisterButton.setEnabled(bl);
    }

    private Vector getNodeRegistryData() {
        Vector vector;
        Vector<Vector<String>> vector2 = new Vector<Vector<String>>();
        if (this.fabricData != null && (vector = this.fabricData.getMembers()) != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.get(n2);
                String string = sMFmNodeData.getHostName();
                if (string == null) {
                    string = "";
                }
                String[] stringArray = new String[]{SMFmConfGlobal.getNodeTypeString(sMFmNodeData.getNodeType()), sMFmNodeData.getScHost(), sMFmNodeData.getDomainId(), string, SMFmConfGlobal.getChassisString(sMFmNodeData.getChassisType()), SMFmConfGlobal.getModeString(sMFmNodeData.getOpMode())};
                vector2.add(new Vector<String>(Arrays.asList(stringArray)));
                ++n2;
            }
        }
        return vector2;
    }

    private void initBottomButtonPanel() {
        this.addButtonsToPanel();
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.initTopPanel();
        this.initRightButtonPanel();
        this.initBottomButtonPanel();
        this.initTablePanel();
        this.addToMainPanel(this.contentPanel);
    }

    private void initRightButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 10));
        this.registerButton = new JButton(SMFmConfGlobal.getI18NString("registerButton.label"));
        this.registerButton.setMnemonic(SMFmConfGlobal.getI18NString("registerButton.mnemonic").charAt(0));
        jPanel.add(this.registerButton);
        this.unregisterButton = new JButton(SMFmConfGlobal.getI18NString("unregisterButton.label"));
        this.unregisterButton.setMnemonic(SMFmConfGlobal.getI18NString("unregisterButton.mnemonic").charAt(0));
        jPanel.add(this.unregisterButton);
        this.unregisterButton.setEnabled(false);
        this.registerButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_REG_REGISTER_BUTTON"));
        this.unregisterButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_NODE_REG_UNREGISTER_BUTTON"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 0, new Insets(40, 10, 10, 10), 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.contentPanel.add((Component)jPanel2, "East");
    }

    private void initTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("NODES_REGISTERED_TO_FABRIC"));
        jLabel.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.table.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 30){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "Center");
    }

    private void initTopPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(String.valueOf(SMFmConfGlobal.getI18NString("FABRIC_NAME")) + ":  " + this.FMName);
        jLabel.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "North");
    }

    private void procFabricForTableData() {
        this.table.setDataVector(this.getNodeRegistryData());
    }

    private void unregisterNode(final List list) {
        this.enableNodeRegistryButtons(false);
        Runnable runnable = new Runnable(){

            public void run() {
                resAcc.remNodeFromFabric(list);
                String string = resAcc.getErrorMessage();
                if (string != null) {
                    JOptionPane.showMessageDialog(dialog, string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                } else {
                    this.enableNodeRegistryButtons(true);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

