/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPartitionDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class SMFmNewPartitionDialog
extends SMFmPartitionDialog {
    private static boolean[] fiveSelected = new boolean[]{true, true, true, true, true};
    private static boolean[] fourSelected;
    private SMFmFabricData fabricData;
    JButton okButton;
    JButton cancelButton;
    private JLabel status;
    private SMFmPartitionData createdPartition;
    private boolean[] selection = new boolean[5];

    static {
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        fourSelected = blArray;
    }

    public SMFmNewPartitionDialog(JDialog jDialog, boolean bl, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(jDialog, sMFmResourceAccess, SMFmConfGlobal.getI18NString("NEW_PARTITION_TITLE"), bl, 2);
        this.fabricData = sMFmFabricData;
        this.buildDialog();
    }

    public SMFmNewPartitionDialog(JFrame jFrame, boolean bl, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(jFrame, sMFmResourceAccess, SMFmConfGlobal.getI18NString("NEW_PARTITION_TITLE"), bl, 2);
        this.fabricData = sMFmFabricData;
        this.buildDialog();
    }

    static /* synthetic */ SMFmPartitionData access$4(SMFmNewPartitionDialog sMFmNewPartitionDialog) {
        return sMFmNewPartitionDialog.createdPartition;
    }

    public void addButtonsToPanel() {
        this.okButton = new JButton(SMFmConfGlobal.getI18NString("okButton.label"));
        this.okButton.setMnemonic(SMFmConfGlobal.getI18NString("okButton.mnemonic").charAt(0));
        this.cancelButton = new JButton(SMFmConfGlobal.getI18NString("cancelButton.label"));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmNewPartitionDialog.this.closeDialog();
            }
        });
        this.partNameText.getDocument().addDocumentListener(new DocListener(0));
        this.dcButton.addActionListener(new RadioListener(2));
        this.wcixButton.addActionListener(new RadioListener(2));
        this.l1Button.addActionListener(new RadioListener(3));
        this.l2Button.addActionListener(new RadioListener(3));
        this.l4Button.addActionListener(new RadioListener(3));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmNewPartitionDialog.this.enableAllButtons(false);
                Vector vector = SMFmNewPartitionDialog.this.getSelections();
                SMFmNewPartitionDialog.this.createPartition(vector);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmNewPartitionDialog.this.closeDialog();
            }
        });
    }

    protected void addToolTips() {
        super.addToolTips();
        this.okButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_PMN_OK"));
    }

    private void buildDialog() {
        this.status = this.resAcc.getStatusJLabel();
        this.addListeners();
        this.addToolTips();
        this.resetSelections();
        this.pack();
    }

    private void closeDialog() {
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void createPartition(final Vector vector) {
        if (vector == null || this.resAcc == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                String string = ((String)vector.get(0)).trim();
                String string2 = SMFmConfGlobal.getI18NString("rsmButton.label");
                String string3 = (String)vector.get(1);
                int n = SMFmConfGlobal.getStripeLevelInt((String)vector.get(2));
                String string4 = "";
                createdPartition = resAcc.createPartition(string, string2, string3, n, string4);
                String string5 = resAcc.getErrorMessage();
                if (string5 != null) {
                    JOptionPane.showMessageDialog(this.getParent(), string5, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                    this.enableAllButtons(true);
                } else {
                    this.closeDialog();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void enableAllButtons(boolean bl) {
        this.okButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
    }

    public SMFmPartitionData getCreatedPartition() {
        return this.createdPartition;
    }

    private Vector getSelections() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.partNameText.getText());
        if (this.dcButton.isSelected()) {
            vector.add(SMFmConfGlobal.TOPOLOGY_DIRECT_CONNECT_STRING);
        } else {
            vector.add(SMFmConfGlobal.TOPOLOGY_WCIX_STRING);
        }
        if (this.l1Button.isSelected()) {
            vector.add(this.l1Button.getText());
        } else if (this.l2Button.isSelected()) {
            vector.add(this.l2Button.getText());
        } else if (this.l4Button.isSelected()) {
            vector.add(this.l4Button.getText());
        }
        return vector;
    }

    private void resetSelections() {
        this.partNameText.setText("");
        this.selection[0] = false;
        this.selection[1] = true;
        this.dcButton.setSelected(true);
        this.selection[2] = true;
        this.l1Button.setSelected(true);
        this.selection[3] = true;
    }

    private void tryToEnableOk() {
        if (Arrays.equals(this.selection, fourSelected)) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    class DocListener
    implements DocumentListener {
        int selIndex;

        public DocListener(int n) {
            this.selIndex = n;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        private void checkLength(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = document.getLength();
            String string = "";
            try {
                string = document.getText(0, n).trim();
            }
            catch (Exception exception) {}
            if (string.length() > 0) {
                ((SMFmNewPartitionDialog)SMFmNewPartitionDialog.this).selection[this.selIndex] = true;
                SMFmNewPartitionDialog.this.tryToEnableOk();
            } else {
                ((SMFmNewPartitionDialog)SMFmNewPartitionDialog.this).selection[this.selIndex] = false;
                SMFmNewPartitionDialog.this.okButton.setEnabled(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }
    }

    class RadioListener
    implements ActionListener {
        int selIndex;

        public RadioListener(int n) {
            this.selIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((SMFmNewPartitionDialog)SMFmNewPartitionDialog.this).selection[this.selIndex] = true;
            SMFmNewPartitionDialog.this.tryToEnableOk();
        }
    }
}

