/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmConfGlobalShared;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkSetData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import com.sun.symon.base.client.SMResourceAccess;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class SMFmLinkSetDetailsDialog
extends JDialog {
    private static final String[] COLUMN_NAMES = new String[]{SMFmConfGlobal.getI18NString("FROM"), SMFmConfGlobal.getI18NString("TO"), SMFmConfGlobal.getI18NString("CABLE_START"), SMFmConfGlobal.getI18NString("CABLE_END"), SMFmConfGlobal.getI18NString("STATUS")};
    private static final String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_RT_DET_FROM_COLUMN"), SMFmConfGlobal.getI18NString("TT_RT_DET_TO_COLUMN"), SMFmConfGlobal.getI18NString("TT_RT_DET_CABLE_START_COLUMN"), SMFmConfGlobal.getI18NString("TT_RT_DET_CABLE_END_COLUMN"), SMFmConfGlobal.getI18NString("TT_RT_DET_STATUS_COLUMN")};
    private JLabel scHostDomain0 = new JLabel();
    private JLabel scHostDomain1 = new JLabel();
    private JLabel stripeLevel = new JLabel();
    private JLabel state = new JLabel();
    private JButton closeButton;
    private SMFmTable table;
    private SMFmWciLinkSetData linkset;
    private SMFmResourceAccess resAcc;
    private SMFmResourceAccessListener resAccListener;
    private static final int STATUS_COLUMN = 4;

    public SMFmLinkSetDetailsDialog(Frame frame, SMFmWciLinkSetData sMFmWciLinkSetData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, SMFmConfGlobal.getI18NString("ROUTE_DETAILS_TITLE"), false);
        this.setLocationRelativeTo(frame);
        this.linkset = sMFmWciLinkSetData;
        this.resAcc = sMFmResourceAccess;
        this.table = new SMFmTable(COLUMN_NAMES, colToolTipStrings);
        this.procLinkSetForStats();
        this.procLinkSetForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    static /* synthetic */ void access$3(SMFmLinkSetDetailsDialog sMFmLinkSetDetailsDialog) {
        sMFmLinkSetDetailsDialog.procLinkSetForStats();
    }

    static /* synthetic */ void access$4(SMFmLinkSetDetailsDialog sMFmLinkSetDetailsDialog) {
        sMFmLinkSetDetailsDialog.procLinkSetForTableData();
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmLinkSetDetailsDialog.this.closeDialog();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmLinkSetDetailsDialog.this.closeDialog();
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmFabricData sMFmFabricData = sMFmResourceAccessEvent.getFabricData();
                Vector vector = sMFmFabricData.getPartitionList();
                boolean bl = false;
                if (SMFmLinkSetDetailsDialog.this.linkset != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        Vector vector2 = ((SMFmPartitionData)vector.get(n)).getRoutes();
                        int n2 = 0;
                        while (n2 < vector2.size()) {
                            if (SMFmLinkSetDetailsDialog.this.linkset.equals((SMFmWciLinkSetData)vector2.get(n2))) {
                                SMFmLinkSetDetailsDialog.this.linkset = (SMFmWciLinkSetData)vector2.get(n2);
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(SMFmLinkSetDetailsDialog.this){
                        private final /* synthetic */ SMFmLinkSetDetailsDialog this$0;
                        {
                            this.this$0 = sMFmLinkSetDetailsDialog;
                        }

                        public void run() {
                            SMFmLinkSetDetailsDialog.access$3(this.this$0);
                            SMFmLinkSetDetailsDialog.access$4(this.this$0);
                        }
                    });
                } else {
                    SMFmLinkSetDetailsDialog.this.closeDialog();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private JPanel createBottomButtonPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(17, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.closeButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createStatPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMRawDataRequestHandle.dataReq);
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("ROUTE_BETWEEN_NODES"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_ROUTE_BETWEEN_NODES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_xsm.gif"));
        this.scHostDomain0.setIcon(imageIcon);
        this.scHostDomain0.setForeground(Color.black);
        this.scHostDomain0.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_ROUTE_BETWEEN_NODES"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)this.scHostDomain0, gridBagConstraints);
        this.scHostDomain1.setIcon(imageIcon);
        this.scHostDomain1.setForeground(Color.black);
        this.scHostDomain1.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_ROUTE_BETWEEN_NODES"));
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.scHostDomain1, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("STRIPE_LEVEL"));
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_STRIPE_LEVEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.stripeLevel.setForeground(Color.black);
        this.stripeLevel.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_STRIPE_LEVEL"));
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.stripeLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("STATUS_LABEL"));
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_STATUS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        this.state.setForeground(Color.black);
        this.state.setToolTipText(SMFmConfGlobal.getI18NString("TT_RT_DET_STATUS"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.state, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 6, 0), 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel(new ImageIcon(sMResourceAccess.getImage("fmimages/route_small.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        return jPanel;
    }

    private JPanel createTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.table){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public Map getLinkMapByHost(List list) {
        HashMap<String, ArrayList<SMFmWciLinkData>> hashMap = new HashMap<String, ArrayList<SMFmWciLinkData>>();
        if (list == null || list.size() == 0) {
            return hashMap;
        }
        int n = 0;
        while (n < list.size()) {
            String string;
            String[] stringArray;
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)list.get(n);
            String[] stringArray2 = sMFmWciLinkData.getScHosts();
            String string2 = String.valueOf(SMFmConfGlobalShared.concatSCNameDomain(stringArray2[0], (stringArray = sMFmWciLinkData.getDomainIds())[0])) + "=" + SMFmConfGlobalShared.concatSCNameDomain(stringArray2[1], stringArray[1]);
            ArrayList<SMFmWciLinkData> arrayList = (ArrayList<SMFmWciLinkData>)hashMap.get(string2);
            if (arrayList == null && (arrayList = (List)hashMap.get(string = String.valueOf(SMFmConfGlobalShared.concatSCNameDomain(stringArray2[0], stringArray[0])) + "=" + SMFmConfGlobalShared.concatSCNameDomain(stringArray2[1], stringArray[1]))) == null) {
                arrayList = new ArrayList<SMFmWciLinkData>();
                hashMap.put(string2, arrayList);
            }
            arrayList.add(sMFmWciLinkData);
            ++n;
        }
        return hashMap;
    }

    private Vector getLinkSetTableData() {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (this.linkset != null) {
            Map map = this.getLinkMapByHost(this.linkset.getLinks());
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            int n = 0;
            while (n < arrayList.size()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)arrayList.get(n), "=");
                List list = (List)map.get((String)arrayList.get(n));
                int n2 = 0;
                while (n2 < list.size()) {
                    String[] stringArray;
                    SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)list.get(n2);
                    String[] stringArray2 = sMFmWciLinkData.getLinkString();
                    if (n2 == 0) {
                        stringArray = new String[]{(String)stringTokenizer.nextElement(), (String)stringTokenizer.nextElement(), stringArray2[0], stringArray2[1], this.getLinkStatusString(sMFmWciLinkData)};
                        vector.add(new Vector<String>(Arrays.asList(stringArray)));
                    } else {
                        stringArray = new String[]{"", "", stringArray2[0], stringArray2[1], this.getLinkStatusString(sMFmWciLinkData)};
                        vector.add(new Vector<String>(Arrays.asList(stringArray)));
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return vector;
    }

    private String getLinkStatusString(SMFmWciLinkData sMFmWciLinkData) {
        int[] nArray = sMFmWciLinkData.getAllStatus();
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = String.valueOf(string) + SMFmConfGlobal.getLinkStatusString(nArray[n]);
            if (n + 1 < nArray.length) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        return string;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jPanel.add((Component)this.createStatPanel(), "North");
        jPanel.add((Component)this.createTablePanel(), "Center");
        jPanel.add((Component)this.createBottomButtonPanel(), "South");
        this.getContentPane().add(jPanel);
    }

    private void procLinkSetForStats() {
        if (this.linkset != null) {
            String[] stringArray = this.linkset.getScHosts();
            String[] stringArray2 = this.linkset.getDomainIds();
            this.scHostDomain0.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[0], stringArray2[0]));
            this.scHostDomain1.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[1], stringArray2[1]));
            this.stripeLevel.setText(String.valueOf(this.linkset.getStripeLevel()));
            this.state.setText(SMFmConfGlobal.getLinkSetStatusString(this.linkset.getStatus()));
        }
    }

    private void procLinkSetForTableData() {
        this.table.setDataVector(this.getLinkSetTableData());
    }

    private class TableCellRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n % 2 == 1) {
                Color color = new Color(230, 230, 230);
                jTable.setBackground(color);
                jTable.setGridColor(color);
            } else {
                jTable.setBackground(Color.white);
                jTable.setGridColor(Color.white);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

