/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmConfGlobalShared;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import com.sun.symon.base.client.SMResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SMFmLinkDetailsDialog
extends JDialog {
    private static final int STATUS_COLUMN = 2;
    private static final String[] COLUMN_NAMES = new String[]{SMFmConfGlobal.getI18NString("CABLE_START"), SMFmConfGlobal.getI18NString("CABLE_END"), SMFmConfGlobal.getI18NString("STATUS")};
    private static final String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_LINK_DET_CABLE_START_COLUMN"), SMFmConfGlobal.getI18NString("TT_LINK_DET_CABLE_END_COLUMN"), SMFmConfGlobal.getI18NString("TT_LINK_DET_STATUS_COLUMN")};
    private JLabel scHostDomain0 = new JLabel();
    private JLabel scHostDomain1 = new JLabel();
    private JLabel stripeLevel = new JLabel();
    private JLabel state = new JLabel();
    private JButton closeButton;
    private SMFmTable table;
    private List links;
    private SMFmWciLinkData link;
    private SMFmResourceAccess resAcc;
    private SMFmResourceAccessListener resAccListener;

    public SMFmLinkDetailsDialog(Frame frame, SMFmWciLinkData sMFmWciLinkData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, SMFmConfGlobal.getI18NString("LINK_DETAILS_TITLE"), false);
        this.setLocationRelativeTo(frame);
        this.link = sMFmWciLinkData;
        this.resAcc = sMFmResourceAccess;
        this.table = new SMFmTable(COLUMN_NAMES, colToolTipStrings);
        this.procLinksForStats();
        this.procLinksForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    public SMFmLinkDetailsDialog(Frame frame, List list, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, SMFmConfGlobal.getI18NString("LINK_DETAILS_TITLE"), false);
        this.setLocationRelativeTo(frame);
        this.links = list;
        this.resAcc = sMFmResourceAccess;
        this.table = new SMFmTable(COLUMN_NAMES, colToolTipStrings);
        this.procLinksForStats();
        this.procLinksForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    static /* synthetic */ void access$5(SMFmLinkDetailsDialog sMFmLinkDetailsDialog) {
        sMFmLinkDetailsDialog.procLinksForStats();
    }

    static /* synthetic */ void access$6(SMFmLinkDetailsDialog sMFmLinkDetailsDialog) {
        sMFmLinkDetailsDialog.procLinksForTableData();
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmLinkDetailsDialog.this.closeDialog();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmLinkDetailsDialog.this.closeDialog();
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmFabricData sMFmFabricData = sMFmResourceAccessEvent.getFabricData();
                Vector vector = sMFmFabricData.getPartitionList();
                boolean bl = false;
                if (SMFmLinkDetailsDialog.this.links != null) {
                    int n = 0;
                    while (n < SMFmLinkDetailsDialog.this.links.size()) {
                        SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)SMFmLinkDetailsDialog.this.links.get(n);
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            Vector vector2 = ((SMFmPartitionData)vector.get(n2)).getLinks();
                            int n3 = 0;
                            while (n3 < vector2.size()) {
                                if (sMFmWciLinkData.equals((SMFmWciLinkData)vector2.get(n3))) {
                                    SMFmLinkDetailsDialog.this.links = vector2;
                                    bl = true;
                                    break;
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                } else if (SMFmLinkDetailsDialog.this.link != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        Vector vector3 = ((SMFmPartitionData)vector.get(n)).getLinks();
                        int n4 = 0;
                        while (n4 < vector3.size()) {
                            if (SMFmLinkDetailsDialog.this.link.equals((SMFmWciLinkData)vector3.get(n4))) {
                                SMFmLinkDetailsDialog.this.link = (SMFmWciLinkData)vector3.get(n4);
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(SMFmLinkDetailsDialog.this){
                        private final /* synthetic */ SMFmLinkDetailsDialog this$0;
                        {
                            this.this$0 = sMFmLinkDetailsDialog;
                        }

                        public void run() {
                            SMFmLinkDetailsDialog.access$5(this.this$0);
                            SMFmLinkDetailsDialog.access$6(this.this$0);
                        }
                    });
                } else {
                    SMFmLinkDetailsDialog.this.closeDialog();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private String getLinkStatusString(SMFmWciLinkData sMFmWciLinkData) {
        int[] nArray = sMFmWciLinkData.getAllStatus();
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            if (nArray.length > 1 && n > 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + SMFmConfGlobal.getLinkStatusString(nArray[n]);
            ++n;
        }
        return string;
    }

    private Vector getLinkTableData() {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (this.links != null && this.links.size() > 0) {
            int n = 0;
            while (n < this.links.size()) {
                SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n);
                String[] stringArray = sMFmWciLinkData.getLinkString();
                String[] stringArray2 = new String[]{stringArray[0], stringArray[1], this.getLinkStatusString(sMFmWciLinkData)};
                vector.add(new Vector<String>(Arrays.asList(stringArray2)));
                ++n;
            }
        } else if (this.link != null) {
            String[] stringArray = this.link.getLinkString();
            String[] stringArray3 = new String[]{stringArray[0], stringArray[1], this.getLinkStatusString(this.link)};
            vector.add(new Vector<String>(Arrays.asList(stringArray3)));
        }
        return vector;
    }

    private void initBottomButtonPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(17, 0, 5, 5), 0, 0);
        jPanel.add((Component)this.closeButton, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
    }

    private void initComponents() {
        this.initStatPanel();
        this.initTablePanel();
        this.initBottomButtonPanel();
    }

    private void initStatPanel() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMRawDataRequestHandle.dataReq);
        JLabel jLabel = this.links != null ? new JLabel(SMFmConfGlobal.getI18NString("LINKS_BETWEEN_NODES")) : new JLabel(SMFmConfGlobal.getI18NString("LINK_BETWEEN_NODES"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_LINK_DET_LINKS_BETWEEN_NODES"));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_xsm.gif"));
        this.scHostDomain0.setIcon(imageIcon);
        this.scHostDomain0.setForeground(Color.black);
        this.scHostDomain0.setToolTipText(SMFmConfGlobal.getI18NString("TT_LINK_DET_LINKS_BETWEEN_NODES"));
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0);
        jPanel.add((Component)this.scHostDomain0, gridBagConstraints);
        this.scHostDomain1.setIcon(imageIcon);
        this.scHostDomain1.setForeground(Color.black);
        this.scHostDomain1.setToolTipText(SMFmConfGlobal.getI18NString("TT_LINK_DET_LINKS_BETWEEN_NODES"));
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.scHostDomain1, gridBagConstraints);
        if (this.links != null) {
            jComponent = new JPanel(new GridBagLayout());
            JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("STRIPE_LEVEL"));
            jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_LINK_DET_STRIPE_LEVEL"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jComponent.add((Component)jLabel2, gridBagConstraints);
            this.stripeLevel.setForeground(Color.black);
            this.stripeLevel.setToolTipText(SMFmConfGlobal.getI18NString("TT_LINK_DET_STRIPE_LEVEL"));
            jComponent.add((Component)this.stripeLevel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0);
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        jComponent = new JLabel(new ImageIcon(sMResourceAccess.getImage("fmimages/link.gif")));
        gridBagConstraints = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 5, 10), 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
    }

    private void initTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 30){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 5), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
    }

    private void procLinksForStats() {
        if (this.links != null && this.links.size() > 0) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(0);
            String[] stringArray = sMFmWciLinkData.getScHosts();
            String[] stringArray2 = sMFmWciLinkData.getDomainIds();
            this.scHostDomain0.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[0], stringArray2[0]));
            this.scHostDomain1.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[1], stringArray2[1]));
            this.stripeLevel.setText(String.valueOf(this.links.size()));
        } else if (this.link != null) {
            String[] stringArray = this.link.getScHosts();
            String[] stringArray3 = this.link.getDomainIds();
            this.scHostDomain0.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[0], stringArray3[0]));
            this.scHostDomain1.setText(SMFmConfGlobalShared.concatSCNameDomain(stringArray[1], stringArray3[1]));
        }
    }

    private void procLinksForTableData() {
        this.table.setDataVector(this.getLinkTableData());
    }
}

