/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmConfExportDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmConfImportDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.server.types.StString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SMFmConfigManager
extends SMFmAbstractBaseDialog {
    private static final String fixedTempDir = "/opt/SUNWwcfm/xml_config_files";
    private boolean bCurrentCfgSaved;
    private boolean bInitialOpen;
    private String fmNameStr;
    private JTextArea configText;
    private JButton openButton;
    private JButton configButton;
    private JButton saveAsButton;
    private JButton closeButton;
    private JLabel cfgTextLabel;
    private SMFmFabricData fabricData;
    private String defaultXMLCfg;
    private String defaultCfgPath;
    private static final int CM_DIALOG_WIDTH = 640;
    private static final int CM_DIALOG_HEIGHT = 380;
    private JDialog dialog;
    private JPanel contentPanel;
    private ApplyThread applyThread;

    public SMFmConfigManager(Frame frame, boolean bl, SMFmFabricData sMFmFabricData, String string, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, SMFmConfGlobal.getI18NString("CONFIGURATION"), 4, true, bl);
        ((Component)this).setSize(640, 380);
        this.dialog = this;
        this.fmNameStr = string;
        this.fabricData = sMFmFabricData;
        this.bCurrentCfgSaved = true;
        this.bInitialOpen = true;
        this.setDefaultCloseOperation(0);
        this.dialog.setTitle(SMFmConfGlobal.getI18NString("CONFIGURATION"));
        this.initComponents();
        this.addListeners();
        this.addToolTips();
    }

    static /* synthetic */ boolean access$5(SMFmConfigManager sMFmConfigManager) {
        return sMFmConfigManager.bCurrentCfgSaved;
    }

    public void addButtonsToPanel() {
        this.openButton = new JButton(String.valueOf(SMFmConfGlobal.getI18NString("openButton.label")) + SMFmConfGlobal.getI18NString("DotDotDot"));
        this.openButton.setMnemonic(SMFmConfGlobal.getI18NString("openButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.openButton);
        this.configButton = new JButton(SMFmConfGlobal.getI18NString("configureButton.label"));
        this.configButton.setMnemonic(SMFmConfGlobal.getI18NString("configureButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.configButton);
        this.saveAsButton = new JButton(String.valueOf(SMFmConfGlobal.getI18NString("saveAsButton.label")) + SMFmConfGlobal.getI18NString("DotDotDot"));
        this.saveAsButton.setMnemonic(SMFmConfGlobal.getI18NString("saveAsButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.saveAsButton);
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmConfigManager.this.closeAction();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfigManager.this.closeAction();
            }
        });
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfGlobal.DebugPrint("Text is as follows:  " + SMFmConfigManager.this.configText.getText());
                SMFmConfExportDialog sMFmConfExportDialog = new SMFmConfExportDialog((Dialog)SMFmConfigManager.this.dialog, true, SMFmConfigManager.this.fmNameStr, SMFmConfigManager.fixedTempDir, SMFmConfigManager.this.configText.getText(), SMFmConfigManager.this.resAcc);
                sMFmConfExportDialog.show();
                if (!sMFmConfExportDialog.wasCancelSelected()) {
                    SMFmConfigManager.this.cfgTextLabel.setText(String.valueOf(SMFmConfGlobal.getI18NString("CONFIGURATION_TEXT")) + "  " + sMFmConfExportDialog.getCfgFileName());
                    SMFmConfigManager.this.bCurrentCfgSaved = true;
                    SMFmConfigManager.this.bInitialOpen = true;
                } else {
                    SMFmConfigManager.this.bCurrentCfgSaved = false;
                }
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SMFmConfigManager.this.dialog, String.valueOf(SMFmConfGlobal.getI18NString("APPLY_WARNING")) + "\n" + SMFmConfGlobal.getI18NString("APPLY_THIS_CFG_DATA_TO_FAB_QUERY"), SMFmConfGlobal.getI18NString("CONFIRM_APPLY"), 0, 2);
                if (n == 0) {
                    SMFmConfigManager.this.applyConfig();
                }
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfImportDialog sMFmConfImportDialog = new SMFmConfImportDialog(SMFmConfigManager.this.dialog, true, SMFmConfigManager.this.fmNameStr, SMFmConfigManager.fixedTempDir, SMFmConfigManager.this.resAcc);
                sMFmConfImportDialog.show();
                if (!sMFmConfImportDialog.wasCancelSelected()) {
                    SMFmConfigManager.this.configText.setText(sMFmConfImportDialog.getConfigText());
                    SMFmConfigManager.this.cfgTextLabel.setText(String.valueOf(SMFmConfGlobal.getI18NString("CONFIGURATION_TEXT")) + "  " + sMFmConfImportDialog.getCfgFileName());
                    SMFmConfigManager.this.bInitialOpen = true;
                    SMFmConfigManager.this.bCurrentCfgSaved = true;
                }
            }
        });
    }

    private void addToolTips() {
        this.configText.setToolTipText(SMFmConfGlobal.getI18NString("TT_CFG_TEXT_BOX"));
        this.openButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_CFG_IMPORT_BUTTON"));
        this.configButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_CFG_APPLY_BUTTON"));
        this.saveAsButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_CFG_EXPORT_BUTTON"));
    }

    private void applyConfig() {
        this.enableSaveAsOpenConfigButton(false);
        this.applyThread = new ApplyThread(this.configText.getText());
        this.applyThread.start();
    }

    private void closeAction() {
        this.closeButton.setEnabled(false);
        if (this.applyThread == null || !this.applyThread.isAlive()) {
            if (!this.bCurrentCfgSaved) {
                Object[] objectArray = new Object[]{SMFmConfGlobal.getI18NString("saveAndClose.label"), SMFmConfGlobal.getI18NString("closeWithoutSave.label"), SMFmConfGlobal.getI18NString("cancelButton.label")};
                int n = JOptionPane.showOptionDialog(this.dialog, SMFmConfGlobal.getI18NString("SAVE_CURRENT_CFG_TO_FILE_QUERY"), SMFmConfGlobal.getI18NString("CONFIRM_SAVE"), 1, 2, null, objectArray, objectArray[0]);
                if (n == 0) {
                    SMFmConfExportDialog sMFmConfExportDialog = new SMFmConfExportDialog((Dialog)this.dialog, true, this.fmNameStr, fixedTempDir, this.configText.getText(), this.resAcc);
                    sMFmConfExportDialog.show();
                    if (!sMFmConfExportDialog.wasCancelSelected()) {
                        this.cfgTextLabel.setText(String.valueOf(SMFmConfGlobal.getI18NString("CONFIGURATION_TEXT")) + "  " + sMFmConfExportDialog.getCfgFileName());
                        this.bCurrentCfgSaved = true;
                        this.bInitialOpen = true;
                    } else {
                        this.bCurrentCfgSaved = false;
                    }
                    this.closeDialog();
                } else if (n == 1) {
                    this.closeDialog();
                } else if (n == 2) {
                    this.closeButton.setEnabled(true);
                }
            } else {
                this.closeDialog();
            }
        } else {
            int n = JOptionPane.showConfirmDialog(this, String.valueOf(SMFmConfGlobal.getI18NString("SUNMC_NOT_FINISHED_VERIFYING_PARTS")) + "\n" + SMFmConfGlobal.getI18NString("OK_TO_ACCEPT_CURRENT_LINKS"), SMFmConfGlobal.getI18NString("WARNING"), 0, 2);
            if (n == 0) {
                this.applyThread.cancelWait();
            } else {
                this.closeButton.setEnabled(true);
            }
        }
    }

    private void closeDialog() {
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void enableSaveAsOpenConfigButton(boolean bl) {
        this.saveAsButton.setEnabled(bl);
        this.openButton.setEnabled(bl);
        this.configButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
    }

    private void initButtonPanel() {
        this.addButtonsToPanel();
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.initTopPanel();
        this.initButtonPanel();
        this.initTextPanel();
        this.initDefaultCfg();
        this.addToMainPanel(this.contentPanel);
    }

    private void initDefaultCfg() {
        try {
            Vector<String> vector = new Vector<String>();
            Vector vector2 = new Vector();
            Vector<StString> vector3 = new Vector<StString>();
            String string = SMRawDataRequest.createURL((String)this.resAcc.getAgentHost(), (int)this.resAcc.getAgentPort(), (String)this.resAcc.getAgentModule(), (String)"", (String)"", (String)"", (String)"", (String)"");
            String string2 = SMRawDataRequest.createURL((String)string, (String)"fm.properties", (String)"fabricXMLFilePath#0", (String)"", (String)"");
            vector.addElement(string2);
            vector3.addElement(new StString("1"));
            vector2.addElement(vector3);
            vector2 = SMRawDataRequestHandle.dataReq.getURLValue(vector);
            this.defaultCfgPath = ((StString)((Vector)vector2.get(0)).get(0)).getValue();
            this.defaultXMLCfg = String.valueOf(this.defaultCfgPath) + this.fmNameStr + ".xml";
            String string3 = this.resAcc.getTextFile(this.defaultCfgPath, String.valueOf(this.fmNameStr) + ".xml");
            String string4 = this.resAcc.getErrorMessage();
            if (string4 != null) {
                JOptionPane.showMessageDialog(this.dialog, string4, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
            }
            if (string3.length() != 0) {
                this.configText.setText(string3);
                this.cfgTextLabel.setText(String.valueOf(SMFmConfGlobal.getI18NString("CONFIGURATION_TEXT")) + "  " + this.fmNameStr + ".xml");
                this.bCurrentCfgSaved = true;
                this.bInitialOpen = true;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.dialog, SMFmConfGlobal.getI18NString("GETTING_FM_INFO_VALUES"), SMFmConfGlobal.getI18NString("ERROR"), 0);
            this.configButton.setEnabled(false);
            SMFmConfGlobal.DebugPrint("EXCEPT: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    private void initTextPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.configText = new JTextArea("", 30, 30);
        this.configText.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.configText);
        this.configText.getDocument().addDocumentListener(new DocListener());
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "Center");
    }

    private void initTopPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(String.valueOf(SMFmConfGlobal.getI18NString("FABRIC_NAME")) + ":  " + this.fmNameStr);
        jLabel.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.cfgTextLabel = new JLabel(SMFmConfGlobal.getI18NString("CONFIGURATION_TEXT"));
        this.cfgTextLabel.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.cfgTextLabel, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "North");
    }

    class ApplyThread
    extends Thread {
        private String configText;
        private boolean cancel = false;
        private int WAIT_LINK_UP_TIME = 600;

        public ApplyThread(String string) {
            this.configText = string;
        }

        public synchronized void cancelWait() {
            this.cancel = true;
        }

        private boolean continueWaiting() {
            SMFmConfigManager.this.closeButton.setEnabled(false);
            int n = JOptionPane.showConfirmDialog(SMFmConfigManager.this, SMFmConfGlobal.getI18NString("CONTINUE_WAIT_CONFIRM"), SMFmConfGlobal.getI18NString("WARNING"), 0, 2);
            if (n == 0) {
                SMFmConfigManager.this.closeButton.setEnabled(true);
                return true;
            }
            return false;
        }

        public void run() {
            SMFmConfigManager.this.resAcc.applyCfgToFab(this.configText);
            String string = SMFmConfigManager.this.resAcc.getErrorMessage();
            if (string != null) {
                JOptionPane.showMessageDialog(SMFmConfigManager.this.getParent(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                SMFmConfigManager.this.enableSaveAsOpenConfigButton(true);
                SMFmConfigManager.this.resAcc.overrideDefaultStatus(false);
                return;
            }
            boolean bl = SMFmConfigManager.this.fabricData.isAllPartitionsLinksUp();
            if (bl) {
                SMFmConfigManager.this.resAcc.overrideDefaultStatus(false);
                SMFmConfigManager.this.closeDialog();
            }
            SMFmConfigManager.this.closeButton.setEnabled(true);
            SMFmConfGlobal.DebugPrint("Waiting for links to come up");
            SMFmConfigManager.this.resAcc.overrideDefaultStatus(false);
            SMFmConfigManager.this.resAcc.postStatus(SMFmConfGlobal.getI18NString("WAITING_FOR_LINKS"));
            SMFmConfigManager.this.resAcc.overrideDefaultStatus(true);
            int n = 0;
            while (!this.cancel && !bl) {
                if (++n == this.WAIT_LINK_UP_TIME) {
                    if (!this.continueWaiting()) break;
                    n = 0;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                SMFmConfigManager.this.resAcc.updateFabricData(true);
                string = SMFmConfigManager.this.resAcc.getErrorMessage();
                if (string != null) {
                    JOptionPane.showMessageDialog(SMFmConfigManager.this.getParent(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                    break;
                }
                bl = SMFmConfigManager.this.fabricData.isAllPartitionsLinksUp();
            }
            SMFmConfigManager.this.resAcc.overrideDefaultStatus(false);
            SMFmConfigManager.this.closeDialog();
        }
    }

    class DocListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        private void checkLength(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (document.getLength() > 0) {
                SMFmConfigManager.this.configButton.setEnabled(true);
            } else {
                SMFmConfigManager.this.configButton.setEnabled(false);
            }
            if (!SMFmConfigManager.this.bInitialOpen) {
                SMFmConfigManager.this.bCurrentCfgSaved = false;
            } else {
                SMFmConfigManager.this.bCurrentCfgSaved = true;
            }
            SMFmConfigManager.this.bInitialOpen = false;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }
    }
}

