/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SMFmConfImportDialog
extends SMFmAbstractBaseDialog {
    private static final int dialogWidth = 325;
    private static final int dialogHeight = 450;
    private String fabName;
    private String dirPath;
    private String fullDirPath;
    private String addOnPath;
    private int selectedRow;
    private boolean bCancelStatus;
    private JLabel fabNameLabel;
    private JLabel dirPathLabel;
    private JLabel impFabCfgLabel;
    private JLabel cfgWindowLabel;
    private JLabel fNamesLabel;
    private JList configList;
    private DefaultListModel listModel;
    private JScrollPane scrollPane;
    private String cfgFileContents;
    private JTextField dirPathText;
    private JTextField configFileText;
    private JButton openButton;
    private JButton cancelButton;
    private Vector cfgList;
    private JDialog dialog = this;
    private JPanel contentPanel;

    public SMFmConfImportDialog(Dialog dialog, boolean bl, String string, String string2, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, SMFmConfGlobal.getI18NString("IMPORT_CFG_TITLE"), 2, true, bl);
        this.fabName = string;
        this.dirPath = string2;
        this.bCancelStatus = false;
        this.initComponents();
        this.initFileList();
        this.addListeners();
        this.addToolTips();
        this.pack();
    }

    static /* synthetic */ String access$17(SMFmConfImportDialog sMFmConfImportDialog) {
        return sMFmConfImportDialog.addOnPath;
    }

    static /* synthetic */ void access$18(SMFmConfImportDialog sMFmConfImportDialog, String string) {
        sMFmConfImportDialog.addOnPath = string;
    }

    static /* synthetic */ String access$19(SMFmConfImportDialog sMFmConfImportDialog) {
        return sMFmConfImportDialog.cfgFileContents;
    }

    static /* synthetic */ boolean access$2(SMFmConfImportDialog sMFmConfImportDialog) {
        return sMFmConfImportDialog.bCancelStatus;
    }

    public void addButtonsToPanel() {
        this.openButton = new JButton(SMFmConfGlobal.getI18NString("openButton.label"));
        this.openButton.setMnemonic(SMFmConfGlobal.getI18NString("openButton.mnemonic").charAt(0));
        this.getRootPane().setDefaultButton(this.openButton);
        this.buttonPanel.add(this.openButton);
        this.cancelButton = new JButton(SMFmConfGlobal.getI18NString("cancelButton.label"));
        this.buttonPanel.add(this.cancelButton);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmConfImportDialog.this.closeDialog();
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfImportDialog.this.readCfgFile();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfImportDialog.this.bCancelStatus = true;
                SMFmConfImportDialog.this.closeDialog();
            }
        });
        this.dirPathText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfImportDialog.this.initFileList();
            }
        });
        this.configList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    SMFmConfImportDialog.this.selectedRow = listSelectionModel.getMinSelectionIndex();
                    SMFmConfImportDialog.this.configFileText.setText(SMFmConfImportDialog.this.listModel.get(SMFmConfImportDialog.this.selectedRow).toString());
                    SMFmConfImportDialog.this.enableImportButton(true);
                } else {
                    SMFmConfImportDialog.this.configFileText.setText("");
                    SMFmConfImportDialog.this.enableImportButton(false);
                }
            }
        });
        this.configFileText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmConfImportDialog.this.openButton.doClick();
            }
        });
        this.configFileText.getDocument().addDocumentListener(new DocListener());
    }

    private void addToolTips() {
        this.dirPathLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_IMPORT_CFG_DIR_LABEL"));
        this.dirPathText.setToolTipText(SMFmConfGlobal.getI18NString("TT_EXPORT_CFG_FILE_NAME"));
        this.configList.setToolTipText(SMFmConfGlobal.getI18NString("TT_IMPORT_CFG_FILE_NAME_LIST"));
        this.openButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_IMPORT_CFG_IMPORT_BUTTON"));
        this.configFileText.setToolTipText(SMFmConfGlobal.getI18NString("TT_XML_CONFIGURATION_TO_USE"));
    }

    private void closeDialog() {
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void enableImportButton(boolean bl) {
        this.openButton.setEnabled(bl);
    }

    public String getCfgFileName() {
        return this.configFileText.getText();
    }

    public String getConfigText() {
        return this.cfgFileContents;
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.fabNameLabel = new JLabel(SMFmConfGlobal.getI18NString("FABRIC_COLON"));
        JLabel jLabel = new JLabel(" " + this.fabName);
        jLabel.setForeground(Color.black);
        jPanel.add(this.fabNameLabel);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        gridBagConstraints.fill = 2;
        this.contentPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 12);
        this.dirPathLabel = new JLabel(SMFmConfGlobal.getI18NString("DIRECTORY_COLON"));
        jPanel2.add((Component)this.dirPathLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 12);
        this.addOnPath = "";
        this.dirPathText = new JTextField();
        this.dirPathText.setText(String.valueOf(this.dirPath) + "/");
        jPanel2.add((Component)this.dirPathText, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.contentPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.fNamesLabel = new JLabel(SMFmConfGlobal.getI18NString("FILE_NAMES"));
        jPanel3.add((Component)this.fNamesLabel, gridBagConstraints2);
        this.listModel = new DefaultListModel();
        this.configList = new JList(this.listModel);
        this.configList.getSelectionModel().setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.configList);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.ipadx = 10;
        gridBagConstraints2.ipady = 100;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        jPanel3.add((Component)this.scrollPane, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 6, 0);
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("XML_CONFIGURATION_FILE_COLON"));
        this.configFileText = new JTextField();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)this.configFileText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.contentPanel.add((Component)jPanel4, gridBagConstraints);
        this.addButtonsToPanel();
        this.addToMainPanel(this.contentPanel);
    }

    private void initFileList() {
        this.enableImportButton(false);
        Runnable runnable = new Runnable(){

            public void run() {
                SMFmConfImportDialog.this.fullDirPath = SMFmConfImportDialog.this.dirPathText.getText();
                if (!SMFmConfImportDialog.this.fullDirPath.endsWith("/")) {
                    SMFmConfImportDialog sMFmConfImportDialog = SMFmConfImportDialog.this;
                    sMFmConfImportDialog.fullDirPath = String.valueOf(sMFmConfImportDialog.fullDirPath) + "/";
                }
                SMFmConfImportDialog.this.cfgList = SMFmConfImportDialog.this.resAcc.getFileList(SMFmConfImportDialog.this.fullDirPath);
                String string = SMFmConfImportDialog.this.resAcc.getErrorMessage();
                if (string != null) {
                    JOptionPane.showMessageDialog(SMFmConfImportDialog.this.dialog, string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                }
                Runnable runnable = new Runnable(SMFmConfImportDialog.this){
                    private final /* synthetic */ SMFmConfImportDialog this$0;
                    {
                        this.this$0 = sMFmConfImportDialog;
                    }

                    public void run() {
                        SMFmConfImportDialog.access$8(this.this$0).clear();
                        if (SMFmConfImportDialog.access$14(this.this$0) != null) {
                            int n = 0;
                            while (n < SMFmConfImportDialog.access$14(this.this$0).size()) {
                                SMFmConfImportDialog.access$8(this.this$0).addElement((String)SMFmConfImportDialog.access$14(this.this$0).get(n));
                                ++n;
                            }
                        }
                        SMFmConfImportDialog.access$18(this.this$0, SMFmConfImportDialog.access$11(this.this$0).getText());
                        if (SMFmConfImportDialog.access$17(this.this$0).length() > 0 && SMFmConfImportDialog.access$17(this.this$0).charAt(SMFmConfImportDialog.access$17(this.this$0).length() - 1) != '/') {
                            SMFmConfImportDialog sMFmConfImportDialog = this.this$0;
                            SMFmConfImportDialog.access$18(sMFmConfImportDialog, String.valueOf(SMFmConfImportDialog.access$17(sMFmConfImportDialog)) + "/");
                        }
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                    SMFmConfImportDialog.this.resAcc.postStatus(" ");
                }
                catch (Exception exception) {}
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void readCfgFile() {
        this.enableImportButton(false);
        Runnable runnable = new Runnable(){

            public void run() {
                SMFmConfImportDialog.this.fullDirPath = SMFmConfImportDialog.this.dirPathText.getText();
                if (!SMFmConfImportDialog.this.fullDirPath.endsWith("/")) {
                    SMFmConfImportDialog sMFmConfImportDialog = SMFmConfImportDialog.this;
                    sMFmConfImportDialog.fullDirPath = String.valueOf(sMFmConfImportDialog.fullDirPath) + "/";
                }
                if (SMFmConfImportDialog.this.cfgList != null) {
                    if (SMFmConfImportDialog.this.cfgList.size() <= 0) {
                        SMFmConfImportDialog.this.enableImportButton(true);
                    } else {
                        SMFmConfImportDialog.this.cfgFileContents = SMFmConfImportDialog.this.resAcc.getTextFile(SMFmConfImportDialog.this.fullDirPath, SMFmConfImportDialog.this.configFileText.getText());
                        String string = SMFmConfImportDialog.this.resAcc.getErrorMessage();
                        if (string != null) {
                            JOptionPane.showMessageDialog(SMFmConfImportDialog.this.dialog, string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                        } else {
                            SMFmConfImportDialog.this.closeDialog();
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public boolean wasCancelSelected() {
        return this.bCancelStatus;
    }

    class DocListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
            this.removeUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!SMFmConfImportDialog.this.openButton.isEnabled()) {
                SMFmConfImportDialog.this.enableImportButton(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (SMFmConfImportDialog.this.configFileText.getText().equals("")) {
                SMFmConfImportDialog.this.enableImportButton(false);
            }
        }
    }
}

