/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbsentHWHandler;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmEditMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmFabricMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel2;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreePanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMApp;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.server.types.StString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SMFmConfBean
extends JPanel
implements ItemListener,
SMApp,
SMFmResourceAccessListener {
    static final String MODULE_NAME_STRING = "wci-fmconf";
    int agentPort = 0;
    String hostName = null;
    String agentName = null;
    String moduleName = null;
    String moduleUrl = null;
    private String fabricName;
    private SMFmResourceAccess resAcc = null;
    private Object toplevel = null;
    private JPanel main = null;
    private JSplitPane splitPane = null;
    private JScrollPane hierarchyPane = null;
    private JPanel hvpPanel = null;
    private JScrollPane topologyPane = null;
    private SMFmTopologyPanel topovpPanel = null;
    private SMFmTopologyPanel previousPanel = null;
    private JPanel FabricTopoPanel = null;
    private SMFmTreePanel treePanel = null;
    private JPanel TopoPresPanel = null;
    private ImageIcon hierimg = null;
    private ImageIcon topoimg = null;
    private JLabel statusMsg;
    private JLabel infobar;
    private String previousPanelLocation;
    private SMFmFabricMenu fabricMenu;
    private SMFmEditMenu editMenu;
    private JPopupMenu fabricPopup;
    private static final String MENU_SEPERATOR = null;
    private boolean dataLocked;
    private Thread t;
    private static final Color INFOBAR_TEXT_COLOR = Color.black;
    private JComboBox perspectiveCB;
    private final String[] perspectiveList = new String[]{SMFmConfGlobal.getI18NString("NODES_AND_ROUTES"), SMFmConfGlobal.getI18NString("CHASSIS_AND_LINKS")};
    private JComboBox showCb;
    private JComboBox filterCB;
    private JLabel showLabel;
    private JLabel filterLabel;
    SMRawDataRequest dReq = null;
    SMResourceAccess serverResAcc = null;
    SMFmFabricData fabricData;

    public SMFmConfBean() {
        this.main = new JPanel();
        this.fabricData = new SMFmFabricData();
        this.previousPanelLocation = new String("");
        this.previousPanel = new SMFmTopologyPanel2(null);
        SMFmConfGlobal.DebugPrint("SMFmConfBean (): Constructor");
    }

    private void aboutAction() {
        Vector vector = new Vector(1, 1);
        Object var2_2 = null;
        String string = null;
        Vector<String> vector2 = new Vector<String>(1, 1);
        Vector vector3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string = SMRawDataRequest.createURL((String)this.getURL(), (String)"fm.properties", (String)"version#0", (String)"", (String)"");
            vector2.addElement(string);
            vector3 = this.dReq.getURLValue(vector2);
            string2 = ((StString)((Vector)vector3.get(0)).get(0)).getValue();
            vector2.clear();
            string = SMRawDataRequest.createURL((String)this.getURL(), (String)"fm.properties", (String)"daqLogName#0", (String)"", (String)"");
            vector2.addElement(string);
            vector3 = this.dReq.getURLValue(vector2);
            string3 = ((StString)((Vector)vector3.get(0)).get(0)).getValue();
            vector2.clear();
            string = SMRawDataRequest.createURL((String)this.getURL(), (String)"fm.properties", (String)"fabricXMLFilePath#0", (String)"", (String)"");
            vector2.addElement(string);
            vector3 = this.dReq.getURLValue(vector2);
            string4 = ((StString)((Vector)vector3.get(0)).get(0)).getValue();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getToplevelJFrame(), SMFmConfGlobal.getI18NString("GETTING_FM_INFO_VALUES"), SMFmConfGlobal.getI18NString("ERROR"), 0);
            SMFmConfGlobal.DebugPrint("EXCEPT: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(this.getToplevelJFrame(), String.valueOf(SMFmConfGlobal.getI18NString("SUN_FIRE_LINK")) + "\n" + SMFmConfGlobal.getI18NString("CONSOLE_VERSION") + "\n" + SMFmConfGlobal.getI18NString("FM_VERSION") + " " + string2 + "\n" + SMFmConfGlobal.getI18NString("DAQ_LOG_NAME") + " " + string3 + "\n" + SMFmConfGlobal.getI18NString("XML_CONFIG_FILE") + " " + string4 + "\n", SMFmConfGlobal.getI18NString("ABOUT"), 1);
    }

    public void destructService() {
    }

    private void enableAllMenus(boolean bl) {
        this.fabricMenu.setEnabled(bl);
        this.editMenu.setEnabled(bl);
    }

    public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        String string = sMFmResourceAccessEvent.getResAccCommand();
        System.out.println("SMFmConfBean(): Got fabric update failed notice for:" + string);
        this.main.setCursor(Cursor.getPredefinedCursor(0));
        this.enableAllMenus(true);
    }

    public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        String string = sMFmResourceAccessEvent.getResAccCommand();
        this.fabricData = sMFmResourceAccessEvent.getFabricData();
        if (this.fabricData != null) {
            SMFmConfGlobal.DebugPrint("RefreshData: ");
            this.postStatus(SMFmConfGlobal.getI18NString("UPDATING_PANELS"));
            this.treePanel.refresh(this.fabricData);
            SMFmTopologyPanel sMFmTopologyPanel = this.treePanel.getSelectedTopolgyPanel();
            this.setTopologyPanel(sMFmTopologyPanel);
            sMFmTopologyPanel.highlight(this.treePanel.getSelectedTreeNode());
            sMFmTopologyPanel.setTree(this.treePanel.getCurrentlyDisplayedTree());
            this.postStatus(SMFmConfGlobal.getI18NString("UPDATE_COMPLETE"));
        }
        this.main.setCursor(Cursor.getPredefinedCursor(0));
        this.enableAllMenus(true);
    }

    public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        String string = sMFmResourceAccessEvent.getResAccCommand();
        System.out.println("SMFmConfBean(): Got fabirc updating notice for: " + string);
        this.enableAllMenus(false);
        this.main.setCursor(Cursor.getPredefinedCursor(3));
        this.treePanel.setEnabled(false);
    }

    public String getAgentHost() {
        return this.hostName;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.dReq;
    }

    private SMResourceAccess getResourceHandle() {
        return this.serverResAcc;
    }

    public JFrame getToplevelJFrame() {
        JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        return jFrame;
    }

    public SMFmTopologyPanel getTopologyPanel() {
        return this.topovpPanel;
    }

    public String getURL() {
        return this.moduleUrl;
    }

    public JLabel getWindowStatusField() {
        return this.statusMsg;
    }

    public void init() {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        SMFmConfGlobal.DebugPrint("SMFmConfBean (): init");
        if (this.moduleUrl == null || this.moduleUrl.equals("") || this.moduleUrl.indexOf(MODULE_NAME_STRING) == -1) {
            JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("MODULE_NOT_LOADED_STRING"));
            this.postStatus(SMFmConfGlobal.getI18NString("MODULE_NOT_LOADED_STRING"));
            this.add(jLabel);
            return;
        }
        this.moduleName = this.moduleUrl.substring(this.moduleUrl.indexOf(MODULE_NAME_STRING));
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.dReq);
        try {
            SMFmConfGlobal.DebugPrint("SMFmConfBean (): host " + this.getAgentHost() + " port " + this.getAgentPort() + " module " + this.getModuleName());
            if (!sMModuleRequest.isModuleLoaded(this.getAgentHost(), this.getAgentPort(), this.getModuleName())) {
                JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("MODULE_NOT_LOADED_STRING"));
                this.postStatus(SMFmConfGlobal.getI18NString("MODULE_NOT_LOADED_STRING"));
                this.add(jLabel);
                this.getParent().validate();
                return;
            }
            object = SMRawDataRequest.createURL((String)this.getURL(), (String)"fm.properties", (String)"name#0", (String)"", (String)"");
            serializable2 = new Vector<String>();
            serializable2.add((String)object);
            serializable = this.dReq.getURLValue(serializable2);
            this.fabricName = ((StString)((Vector)((Vector)serializable).get(0)).get(0)).getValue();
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("MODULE_NOT_LOADED_STRING"));
            this.postStatus(exception.getMessage());
            this.add(jLabel);
            this.getParent().validate();
            return;
        }
        SMFmConfGlobal.DebugPrint("SMFmConfBean (): // setup the resource access object");
        this.resAcc = new SMFmResourceAccess(this.getRawDataRequestHandle(), this.getAgentHost(), this.getAgentPort(), this.getModuleName());
        this.fabricData = this.resAcc.getFabricData();
        SMFmConfGlobal.DebugPrint("SMFmConfBean (): // setup panels");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        SMFmConfGlobal.DebugPrint("SMFmConfBean (): // setup main container and title information");
        this.main.setLayout(new BorderLayout());
        this.main.setForeground(Color.black);
        serializable2 = this.initMainViewer();
        serializable = this.initMenuBar();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(SMFmConfGlobal.getI18NString("PERSPECTIVE")));
        this.perspectiveCB = new JComboBox();
        int n = 0;
        while (n < this.perspectiveList.length) {
            this.perspectiveCB.addItem(this.perspectiveList[n]);
            ++n;
        }
        this.perspectiveCB.setEditable(false);
        this.perspectiveCB.setEnabled(true);
        this.perspectiveCB.addItemListener(this);
        this.perspectiveCB.setToolTipText(SMFmConfGlobal.getI18NString("TT_MAIN_PERSPECTIVE"));
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel.add(this.perspectiveCB);
        ((Container)serializable).add(jPanel, "East");
        this.main.add((Component)serializable, "North");
        this.main.add((Component)serializable2, "Center");
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).gridheight = 1;
        this.add((Component)this.main, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 16;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        this.add((Component)new JLabel(" "), object);
        this.infobar = new JLabel();
        this.infobar.setForeground(INFOBAR_TEXT_COLOR);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 16;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).gridheight = 1;
        this.add((Component)this.infobar, object);
        this.resAcc.addStatusJLabel(this.getWindowStatusField());
        this.resAcc.addSMFmResourceAccessListener(this);
        SMFmAbsentHWHandler sMFmAbsentHWHandler = new SMFmAbsentHWHandler(this.resAcc);
        this.resAcc.addSMFmResourceAccessListener(sMFmAbsentHWHandler);
        this.fabricMenu.refreshFabricData();
    }

    private JPanel initFabricTopologyPanes() {
        this.FabricTopoPanel = new JPanel();
        this.FabricTopoPanel.setLayout(new BorderLayout());
        this.TopoPresPanel = new JPanel();
        this.TopoPresPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.showLabel = new JLabel(SMFmConfGlobal.getI18NString("VIEW_AS_STR"));
        this.showLabel.setEnabled(false);
        jPanel.add(this.showLabel);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.showCb = new JComboBox();
        this.showCb.setEnabled(false);
        this.showCb.addItemListener(this);
        this.showCb.setToolTipText(SMFmConfGlobal.getI18NString("TT_MAIN_VIEW_AS"));
        jPanel.add(this.showCb);
        this.TopoPresPanel.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.filterLabel = new JLabel(SMFmConfGlobal.getI18NString("FILTER_TO_SHOW"));
        this.filterLabel.setEnabled(false);
        jPanel2.add(this.filterLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        this.filterCB = new JComboBox();
        this.filterCB.setEnabled(false);
        this.filterCB.addItemListener(this);
        this.filterCB.setToolTipText(SMFmConfGlobal.getI18NString("TT_MAIN_FILTER_TO_SHOW"));
        jPanel2.add(this.filterCB);
        this.TopoPresPanel.add((Component)jPanel2, "East");
        this.FabricTopoPanel.add((Component)this.TopoPresPanel, "North");
        this.topovpPanel = new SMFmTopologyPanel2(this.resAcc);
        this.topovpPanel.setBackground(Color.white);
        this.topologyPane = new JScrollPane(this.topovpPanel);
        this.FabricTopoPanel.add((Component)this.topologyPane, "Center");
        return this.FabricTopoPanel;
    }

    private JScrollPane initFabricTreeHierarchyPane() {
        this.hierarchyPane = new JScrollPane();
        this.hierarchyPane.setPreferredSize(new Dimension(180, 300));
        this.hierarchyPane.setMinimumSize(new Dimension(120, 300));
        this.hvpPanel = new JPanel();
        this.hvpPanel.setBackground(Color.white);
        this.treePanel = new SMFmTreePanel(this, this.fabricData, this.resAcc);
        this.hvpPanel.add(this.treePanel);
        this.hierarchyPane.setViewportView(this.hvpPanel);
        return this.hierarchyPane;
    }

    private JPanel initMainViewer() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(this.initFabricTreeHierarchyPane());
        this.splitPane.setRightComponent(this.initFabricTopologyPanes());
        jPanel.add((Component)this.splitPane, "Center");
        return jPanel;
    }

    private JPanel initMenuBar() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JMenuBar jMenuBar = new JMenuBar();
        this.fabricMenu = new SMFmFabricMenu(this.fabricName, this.fabricData, this.statusMsg, this.resAcc);
        jMenuBar.add(this.fabricMenu);
        this.editMenu = new SMFmEditMenu(this.fabricName, this.fabricData, this.statusMsg, this.treePanel, this.getAgentHost(), this.resAcc);
        jMenuBar.add(this.editMenu);
        jPanel.add((Component)jMenuBar, "West");
        return jPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            if (jComboBox == this.showCb && itemEvent.getStateChange() == 1) {
                this.topovpPanel.setShowState((String)jComboBox.getSelectedItem());
                this.topovpPanel.repaint();
                this.topovpPanel.revalidate();
            } else if (jComboBox == this.filterCB && itemEvent.getStateChange() == 1) {
                this.topovpPanel.setFilterState((String)jComboBox.getSelectedItem());
                this.topovpPanel.repaint();
                this.topovpPanel.revalidate();
            } else if (jComboBox == this.perspectiveCB && itemEvent.getStateChange() == 1) {
                SMFmConfGlobal.DebugPrint("Selected: " + jComboBox.getSelectedItem());
                Object var3_3 = null;
                Object var4_4 = null;
                Object var5_5 = null;
                Object var6_6 = null;
                if (((String)jComboBox.getSelectedItem()).compareTo(this.perspectiveList[0]) == 0) {
                    this.treePanel.displayWnodeTree();
                    this.treePanel.repaint();
                    this.treePanel.revalidate();
                    SMFmTopologyPanel sMFmTopologyPanel = this.treePanel.getSelectedTopolgyPanel();
                    this.setTopologyPanel(sMFmTopologyPanel);
                    sMFmTopologyPanel.highlight(this.treePanel.getSelectedTreeNode());
                    sMFmTopologyPanel.setTree(this.treePanel.getCurrentlyDisplayedTree());
                } else {
                    this.treePanel.displayChassisTree();
                    this.treePanel.repaint();
                    this.treePanel.revalidate();
                    SMFmTopologyPanel sMFmTopologyPanel = this.treePanel.getSelectedTopolgyPanel();
                    this.setTopologyPanel(sMFmTopologyPanel);
                    sMFmTopologyPanel.highlight(this.treePanel.getSelectedTreeNode());
                    sMFmTopologyPanel.setTree(this.treePanel.getCurrentlyDisplayedTree());
                }
                this.hvpPanel.repaint();
            }
        }
    }

    private void postStatus(String string) {
        if (this.statusMsg != null) {
            SMFmConfGlobal.DebugPrint("POST Status: " + string);
            this.statusMsg.setText(string);
        }
    }

    public void setAgentHost(String string) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setAgentHost(" + string + ")");
        this.hostName = new String(string);
    }

    public void setAgentName(String string) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setAgentName(" + string + ")");
        this.agentName = new String(string);
    }

    public void setAgentPort(int n) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setAgentPort(" + n + ")");
        this.agentPort = n;
    }

    public void setArgument(String string) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setArgument(" + string + ")");
    }

    public void setArguments(String[] stringArray) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setArguments(" + stringArray + ")");
    }

    public void setInfobarText(String string) {
        this.infobar.setText(string);
        this.infobar.repaint();
    }

    public void setModuleName(String string) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setModuleName(" + string + ")");
        this.moduleName = new String(string);
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setRawDataRequestHandle()");
        SMRawDataRequestHandle.dataReq = this.dReq = sMRawDataRequest;
        this.serverResAcc = new SMResourceAccess(this.dReq);
    }

    public void setTopologyPanel(SMFmTopologyPanel sMFmTopologyPanel) {
        SMFmTopologyPanel sMFmTopologyPanel2 = sMFmTopologyPanel;
        this.FabricTopoPanel.remove(this.topologyPane);
        this.topologyPane = new JScrollPane(sMFmTopologyPanel);
        this.FabricTopoPanel.add((Component)this.topologyPane, "Center");
        this.topovpPanel = sMFmTopologyPanel;
        this.topovpPanel.setPreferredSize(sMFmTopologyPanel.getSize());
        this.topovpPanel.setMinimumSize(new Dimension(50, 300));
        this.topovpPanel.setConfBean(this);
        Vector vector = sMFmTopologyPanel2.getShowStates();
        this.showCb.removeAllItems();
        if (vector != null) {
            this.showCb.setEnabled(true);
            this.showLabel.setEnabled(true);
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                boolean bl = (Boolean)vector.elementAt(++n);
                this.showCb.addItem(string);
                if (bl) {
                    this.showCb.setSelectedItem(string);
                }
                ++n;
            }
        } else {
            this.showCb.setEnabled(false);
            this.showLabel.setEnabled(false);
        }
        Vector vector2 = sMFmTopologyPanel2.getFilters();
        this.filterCB.removeAllItems();
        if (vector2 != null) {
            this.filterCB.setEnabled(true);
            this.filterLabel.setEnabled(true);
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                boolean bl = (Boolean)vector2.elementAt(++n);
                this.filterCB.addItem(string);
                if (bl) {
                    this.filterCB.setSelectedItem(string);
                }
                ++n;
            }
        } else {
            this.filterCB.setEnabled(false);
            this.filterLabel.setEnabled(false);
        }
        this.TopoPresPanel.revalidate();
        this.TopoPresPanel.repaint();
        sMFmTopologyPanel.repaint();
        this.topologyPane.repaint();
        this.topologyPane.revalidate();
        this.FabricTopoPanel.repaint();
    }

    public void setURL(String string) {
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setURL(" + string + ")");
        this.moduleUrl = new String(string);
    }

    public void setUrl(String string) {
        this.moduleUrl = new String(string);
        SMFmConfGlobal.DebugPrint("SMFmConfBean.setUrl(" + string + ")");
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public void startRequest() {
    }

    public void stopRequest() {
    }
}

