/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.CustomLayout;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeGraphic;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMFmChassisGraphic
extends JPanel
implements SMFmGraphicInterface {
    private static final int TYPE = 3;
    private static final int SM_NODE_VGAP = 3;
    private static final int SM_NODE_HGAP = 3;
    private static final int SM_FONT_SIZE = 10;
    private static final int SM_TYPE_TEXT_HEIGHT = 12;
    private static final int SM_NAME_TEXT_HEIGHT = 12;
    private static final int SM_NAME_TEXT_WIDTH = 50;
    private static final int LG_NODE_VGAP = 5;
    private static final int LG_NODE_HGAP = 3;
    private static final int LG_FONT_SIZE = 12;
    private static final int LG_TYPE_TEXT_HEIGHT = 14;
    private static final int LG_NAME_TEXT_HEIGHT = 12;
    private static final int LG_NAME_TEXT_WIDTH = 80;
    private static final Color CHASSIS_COLOR = new Color(220, 220, 220);
    private SMFmChassisPopupMenu POPUP_MENU;
    private int xCoord;
    private int yCoord;
    int chassisWidth;
    int chassisHeight;
    int activeNodeHeight;
    int nodeHgap;
    int nodeVgap;
    int typeTextHeight;
    int nameTextHeight;
    int nameTextWidth;
    int nodeWidth;
    int nodeHeight;
    int panelWidth;
    int panelHeight;
    int fontSize;
    private SMFmChassisData cData;
    private Vector nodes;
    private Vector pNodes;
    private int size;
    private Vector nodeGraphics;
    private Hashtable nodeGraphicsCoordHT;
    private Hashtable pNodesHT;
    JLabel textLabel;
    private boolean singleColumn;
    private SMFmResourceAccess resAcc;

    public SMFmChassisGraphic(SMFmChassisData sMFmChassisData, Vector vector, int n, int n2, int n3, SMFmResourceAccess sMFmResourceAccess) {
        this(sMFmChassisData, vector, n, n2, n3, false, sMFmResourceAccess);
    }

    public SMFmChassisGraphic(SMFmChassisData sMFmChassisData, Vector vector, int n, int n2, int n3, boolean bl, SMFmResourceAccess sMFmResourceAccess) {
        this.nodes = sMFmChassisData.getWnodeList();
        this.pNodes = vector;
        this.xCoord = n;
        this.yCoord = n2;
        this.cData = sMFmChassisData;
        this.size = n3;
        this.singleColumn = bl;
        this.resAcc = sMFmResourceAccess;
        this.POPUP_MENU = new SMFmChassisPopupMenu(sMFmResourceAccess);
        this.textLabel = new JLabel();
        this.pNodesHT = new Hashtable();
        if (vector != null) {
            int n4 = 0;
            while (n4 < vector.size()) {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.get(n4);
                this.pNodesHT.put(String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId(), vector.elementAt(n4));
                ++n4;
            }
        }
        this.redrawAll();
    }

    public SMFmChassisGraphic(SMFmChassisData sMFmChassisData, Vector vector, int n, SMFmResourceAccess sMFmResourceAccess) {
        this(sMFmChassisData, vector, 0, 0, n, sMFmResourceAccess);
    }

    public int getActiveHeight() {
        return this.activeNodeHeight;
    }

    public int getIconHeight() {
        return this.chassisHeight;
    }

    public static int getIconHeight(int n) {
        return 0;
    }

    public int getIconHeight(int n, SMFmChassisData sMFmChassisData) {
        SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(sMFmChassisData, null, 0, 0, n, this.resAcc);
        return sMFmChassisGraphic.getIconHeight();
    }

    public int getIconSize() {
        return this.size;
    }

    public int getIconWidth() {
        return this.chassisWidth;
    }

    public static int getIconWidth(int n) {
        SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(new SMFmChassisData("temp"), null, 0, 0, n, null);
        return sMFmChassisGraphic.getIconWidth();
    }

    public String getInfobarText() {
        String string = String.valueOf(SMFmConfGlobal.getI18NString("SC_HOST_COLON")) + " " + this.cData.getScHost() + "   " + SMFmConfGlobal.getI18NString("TYPE") + " " + SMFmConfGlobal.getChassisString(this.cData.getChassisType());
        return string;
    }

    public int getNodeWidth() {
        return this.nodeWidth;
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public int getTotalHeight() {
        return this.chassisHeight + this.nameTextHeight;
    }

    public static int getTotalHeight(int n) {
        return 0;
    }

    public int getTotalHeight(int n, SMFmChassisData sMFmChassisData) {
        SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(sMFmChassisData, null, 0, 0, n, this.resAcc);
        return sMFmChassisGraphic.getTotalHeight();
    }

    public int getTotalWidth() {
        return this.chassisWidth > this.nameTextWidth ? this.chassisWidth : this.nameTextWidth;
    }

    public static int getTotalWidth(int n) {
        SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(new SMFmChassisData("temp"), null, 0, 0, n, null);
        return sMFmChassisGraphic.getTotalWidth();
    }

    public int getType() {
        return 3;
    }

    public Object getUserObject() {
        return this.cData;
    }

    public Vector getWnodeGraphics() {
        return this.nodeGraphics;
    }

    public int getWnodeXCoordinate(SMFmNodeData sMFmNodeData) {
        int[] nArray = (int[])this.nodeGraphicsCoordHT.get(sMFmNodeData);
        if (nArray != null) {
            return nArray[0];
        }
        return -1;
    }

    public int getWnodeYCoordinate(SMFmNodeData sMFmNodeData) {
        int[] nArray = (int[])this.nodeGraphicsCoordHT.get(sMFmNodeData);
        if (nArray != null) {
            return nArray[1];
        }
        return -1;
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public void highlight() {
        this.setBorder(BorderFactory.createLineBorder(SMFmGraphicInterface.HIGHLIGHT_COLOR, 1));
        this.repaint();
        this.revalidate();
    }

    private void redrawAll() {
        this.removeAll();
        this.setLayout(new CustomLayout());
        this.setOpaque(true);
        this.setBackground(CHASSIS_COLOR);
        this.nodeGraphicsCoordHT = new Hashtable();
        if (this.nodes == null) {
            return;
        }
        this.nodeWidth = SMFmWnodeGraphic.getTotalWidth(this.size);
        this.nodeHeight = SMFmWnodeGraphic.getTotalHeight(this.size);
        if (this.size == 0) {
            this.nodeHgap = 3;
            this.nodeVgap = 3;
            this.typeTextHeight = 12;
            this.nameTextHeight = 12;
            this.nameTextWidth = 50;
            this.fontSize = 10;
        } else {
            this.nodeHgap = 3;
            this.nodeVgap = 5;
            this.typeTextHeight = 14;
            this.nameTextHeight = 12;
            this.nameTextWidth = 80;
            this.fontSize = 12;
        }
        this.chassisWidth = this.nodeHgap * 2 + this.nodeWidth;
        this.chassisHeight = this.nodeHeight * this.nodes.size() + this.nodeVgap * (this.nodes.size() + 1) + this.typeTextHeight;
        this.setLayout(new CustomLayout());
        this.setBackground(CHASSIS_COLOR);
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(jLabel.getFont().deriveFont(this.fontSize));
        jLabel.setText(SMFmConfGlobal.getChassisString(this.cData.getChassisType()));
        jLabel.setToolTipText(SMFmConfGlobal.getChassisString(this.cData.getChassisType()));
        jLabel.setBounds(0, 0, this.chassisWidth, this.typeTextHeight);
        jLabel.setOpaque(false);
        this.add(jLabel);
        SMFmChassisGraphic sMFmChassisGraphic = this;
        jLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MouseEvent mouseEvent2 = new MouseEvent(SMFmChassisGraphic.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                this.dispatchEvent(mouseEvent2);
            }
        });
        int n = (this.chassisWidth - SMFmWnodeGraphic.getIconWidth(this.size)) / 2;
        int n2 = this.typeTextHeight;
        this.nodeGraphics = new Vector();
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.nodes.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.nodes.elementAt(n5);
            if (this.pNodesHT.get(String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId()) != null) {
                SMFmWnodeGraphic sMFmWnodeGraphic = new SMFmWnodeGraphic(sMFmNodeData, n, n2, this.size, this.resAcc);
                this.add(sMFmWnodeGraphic);
                this.add(sMFmWnodeGraphic.getTextLabel());
                this.nodeGraphicsCoordHT.put(sMFmNodeData, new int[]{n, n2});
                this.nodeGraphics.addElement(sMFmWnodeGraphic);
                n2 += this.nodeVgap + this.nodeHeight;
                if (!this.singleColumn) {
                    n += this.nodeWidth;
                }
                ++n4;
            }
            ++n5;
        }
        this.activeNodeHeight = this.nodeHeight * n4 + this.nodeVgap * (this.nodes.size() + 1) + this.typeTextHeight;
        n = n3;
        int n6 = n2;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        while (n9 < this.nodes.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.nodes.elementAt(n9);
            if (this.pNodesHT.get(String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId()) == null) {
                if (n7 > 0) {
                    if (n7 % n4 == 0 || this.singleColumn) {
                        n2 += this.nodeVgap + this.nodeHeight;
                        n = n3;
                        ++n8;
                    } else {
                        n += this.nodeWidth;
                    }
                }
                SMFmWnodeGraphic sMFmWnodeGraphic = new SMFmWnodeGraphic(sMFmNodeData, n, n2, this.size, this.resAcc);
                sMFmWnodeGraphic.grayOut();
                this.add(sMFmWnodeGraphic);
                this.add(sMFmWnodeGraphic.getTextLabel());
                this.nodeGraphicsCoordHT.put(sMFmNodeData, new int[]{n, n2});
                this.nodeGraphics.addElement(sMFmWnodeGraphic);
                ++n7;
            }
            ++n9;
        }
        this.chassisWidth = this.singleColumn ? this.nodeHgap * 2 + this.nodeWidth : this.nodeHgap * 2 + this.nodeWidth * n4;
        this.chassisHeight = this.nodeHeight * (n8 + n4) + this.nodeVgap * (this.nodes.size() + 1) + this.typeTextHeight;
        this.setBounds(this.xCoord, this.yCoord, this.chassisWidth, this.chassisHeight);
        this.textLabel.setHorizontalAlignment(0);
        this.textLabel.setHorizontalTextPosition(0);
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(this.fontSize));
        this.textLabel.setText(this.cData.getScHost());
        this.textLabel.setToolTipText(this.cData.getScHost());
        int n10 = this.xCoord + (this.chassisWidth - this.nameTextWidth) / 2;
        int n11 = this.yCoord + this.chassisHeight;
        this.textLabel.setBounds(n10, n11, this.nameTextWidth, this.nameTextHeight);
    }

    public void setIconSize(int n) {
        this.size = n;
        this.redrawAll();
    }

    public void setLocation(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        this.redrawAll();
    }

    public void setSingleColumn(boolean bl) {
        this.singleColumn = bl;
    }

    public void setUserObject(Object object) {
        this.cData = (SMFmChassisData)object;
    }

    public void showDetailsDialog() {
        SMFmChassisDetailsDialog sMFmChassisDetailsDialog = new SMFmChassisDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), this.cData, this.resAcc);
        sMFmChassisDetailsDialog.setLocationRelativeTo(this);
        sMFmChassisDetailsDialog.show();
    }

    public void showPopupMenu(Component component, int n, int n2) {
        this.POPUP_MENU.show(component, n, n2);
    }

    public void unhighlight() {
        this.setBorder(null);
        this.repaint();
        this.revalidate();
    }
}

