/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTable;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SMFmChassisDetailsDialog
extends SMFmAbstractBaseDialog {
    private static final String[] n = new String[]{SMFmConfGlobal.getI18NString("DOMAIN_ID"), SMFmConfGlobal.getI18NString("MODE"), SMFmConfGlobal.getI18NString("SOLARIS_HOST_NAME"), SMFmConfGlobal.getI18NString("SOLARIS_IP")};
    private static final String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_CH_DET_DOMAIN_ID_COLUMN"), SMFmConfGlobal.getI18NString("TT_CH_DET_MODE_COLUMN"), SMFmConfGlobal.getI18NString("TT_CH_DET_SOLARIS_HOSTNAME_COLUMN"), SMFmConfGlobal.getI18NString("TT_CH_DET_SOLARIS_IP_COLUMN")};
    private SMFmTable table;
    private JLabel scHost = new JLabel();
    private JLabel scIpAdd = new JLabel();
    private JLabel chassisType = new JLabel();
    private JLabel chassisIcon = new JLabel();
    private JButton closeButton;
    private JButton nodeDetailsButton;
    private JPanel tablePanel;
    private SMFmChassisData cData;
    private SMFmResourceAccessListener resAccListener;
    private JDialog dialog;
    private JPanel contentPanel;

    public SMFmChassisDetailsDialog(Dialog dialog, SMFmChassisData sMFmChassisData, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, String.valueOf(SMFmConfGlobal.getI18NString("CHASSIS_DETAILS_TITLE")) + " " + sMFmChassisData.getScHost(), 2, false, false);
        this.resAcc = sMFmResourceAccess;
        this.cData = sMFmChassisData;
        this.buildDialog();
    }

    public SMFmChassisDetailsDialog(Frame frame, SMFmChassisData sMFmChassisData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, String.valueOf(SMFmConfGlobal.getI18NString("CHASSIS_DETAILS_TITLE")) + " " + sMFmChassisData.getScHost(), 2, false, false);
        this.resAcc = sMFmResourceAccess;
        this.cData = sMFmChassisData;
        this.buildDialog();
    }

    public void addButtonsToPanel() {
        this.nodeDetailsButton = new JButton(SMFmConfGlobal.getI18NString("nodeDetailsButton.label"));
        this.nodeDetailsButton.setMnemonic(SMFmConfGlobal.getI18NString("nodeDetailsButton.mnemonic").charAt(0));
        this.nodeDetailsButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_NODE_DETAILS_BUTTON"));
        this.buttonPanel.add(this.nodeDetailsButton);
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
    }

    private void addListeners() {
        this.enableNodeDetailsButton(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmChassisDetailsDialog.this.closeDialog();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmChassisDetailsDialog.this.closeDialog();
            }
        });
        this.nodeDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SMFmChassisDetailsDialog.this.table.getSelectedRow();
                Vector vector = SMFmChassisDetailsDialog.this.table.getRowVector(n);
                SMFmNodeData sMFmNodeData = SMFmChassisDetailsDialog.this.cData.getNodeByDomainId((String)vector.get(0));
                if (sMFmNodeData != null) {
                    SMFmWnodeDetailsDialog sMFmWnodeDetailsDialog = new SMFmWnodeDetailsDialog((Dialog)SMFmChassisDetailsDialog.this.dialog, sMFmNodeData, SMFmChassisDetailsDialog.this.resAcc);
                    sMFmWnodeDetailsDialog.show();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    SMFmChassisDetailsDialog.this.enableNodeDetailsButton(false);
                } else {
                    SMFmChassisDetailsDialog.this.enableNodeDetailsButton(true);
                }
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmFabricData sMFmFabricData = sMFmResourceAccessEvent.getFabricData();
                if (sMFmFabricData != null) {
                    SMFmChassisData sMFmChassisData = sMFmFabricData.getChassisByName(SMFmChassisDetailsDialog.this.cData.getScHost());
                    if (sMFmChassisData != null) {
                        SMFmChassisDetailsDialog.this.cData = sMFmChassisData;
                        SMFmChassisDetailsDialog.this.procChassisForStatData();
                        SMFmChassisDetailsDialog.this.procChassisForTableData();
                    } else {
                        SMFmConfGlobal.DebugPrint("Warning: SMFmChassisDetailsDialog: chassis " + SMFmChassisDetailsDialog.this.cData.getScHost() + " was removed unexpectedly, exiting");
                        SMFmChassisDetailsDialog.this.closeDialog();
                    }
                } else {
                    SMFmConfGlobal.DebugPrint("Warning: SMFmChassisDetailsDialog: node " + SMFmChassisDetailsDialog.this.cData.getScHost() + " was removed unexpectedly, exiting");
                    SMFmChassisDetailsDialog.this.closeDialog();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void buildDialog() {
        this.dialog = this;
        this.table = new SMFmTable(n, colToolTipStrings);
        this.procChassisForStatData();
        this.procChassisForTableData();
        this.initComponents();
        this.addListeners();
        this.pack();
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void enableNodeDetailsButton(boolean bl) {
        this.nodeDetailsButton.setEnabled(bl);
    }

    private Vector getChassisTableData() {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (this.cData == null) {
            return vector;
        }
        Vector vector2 = this.cData.getWnodeList();
        if (vector2 == null || vector2.size() == 0) {
            return vector;
        }
        int n = 0;
        while (n < vector2.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector2.get(n);
            String string = sMFmNodeData.getHostName() == null ? "" : sMFmNodeData.getHostName();
            String string2 = sMFmNodeData.getHostIpAddress() == null ? "" : sMFmNodeData.getHostIpAddress();
            String[] stringArray = new String[]{sMFmNodeData.getDomainId(), SMFmConfGlobal.getModeString(sMFmNodeData.getOpMode()), string, string2};
            vector.add(new Vector<String>(Arrays.asList(stringArray)));
            ++n;
        }
        return vector;
    }

    private void initBottomButtonPanel() {
        this.addButtonsToPanel();
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.initStatPanel();
        this.initBottomButtonPanel();
        this.initTablePanel();
        this.addToMainPanel(this.contentPanel);
    }

    private void initStatPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("SC_HOST_NAME"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_SC_HOST_NAME"));
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("SC_IP_ADDRESS"));
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_SC_IP_ADDRESS"));
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("CHASSIS_TYPE_COLON"));
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_CHASSIS_TYPE"));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        this.scHost.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_SC_HOST_NAME"));
        this.scIpAdd.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_SC_IP_ADDRESS"));
        this.chassisType.setToolTipText(SMFmConfGlobal.getI18NString("TT_CH_DET_CHASSIS_TYPE"));
        jPanel2.add(this.scHost);
        jPanel2.add(this.scIpAdd);
        jPanel2.add(this.chassisType);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(this.chassisIcon);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.contentPanel.add((Component)jPanel4, "North");
    }

    private void initTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("WNODES_IN_CHASSIS"));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 5, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 30){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "Center");
    }

    private void procChassisForStatData() {
        if (this.cData != null) {
            this.scHost.setText(this.cData.getScHost());
            this.scHost.setForeground(Color.black);
            this.scIpAdd.setText(this.cData.getIpAddress());
            this.scIpAdd.setForeground(Color.black);
            this.chassisType.setText(SMFmConfGlobal.getChassisString(this.cData.getChassisType()));
            this.chassisType.setForeground(Color.black);
            Image image = this.resAcc.getImage(SMFmConfGlobal.getChassisTypeLargeIconString(this.cData.getChassisType()));
            this.chassisIcon.setIcon(new ImageIcon(image));
        }
    }

    private void procChassisForTableData() {
        this.table.setDataVector(this.getChassisTableData());
    }
}

