/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmConfGlobalShared;
import com.sun.symon.apps.wci.fmconf.common.SMFmStatusSeverityInterface;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import java.io.Serializable;
import java.util.Vector;

public class SMFmWciLinkSetData
implements Serializable,
SMFmStatusSeverityInterface {
    private static final long serialVersionUID = 1L;
    private String[] scHost = new String[2];
    private String[] domainId = new String[2];
    private Vector links;
    private int striping;
    private int status;
    private int severity;

    public SMFmWciLinkSetData(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null, 1);
    }

    public SMFmWciLinkSetData(String string, String string2, String string3, String string4, Vector vector, int n) {
        this.scHost[0] = string;
        this.domainId[0] = string2;
        this.scHost[1] = string3;
        this.domainId[1] = string4;
        this.setLinks(vector);
        this.setStripeLevel(n);
        this.status = 0;
        this.severity = SMFmConfGlobalShared.getDefaultLinkSetSeverity(this.status);
    }

    public void addLink(SMFmWciLinkData sMFmWciLinkData) {
        this.links.add(sMFmWciLinkData);
    }

    public int getAlarmedLinkCt() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.links.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n2);
            if (sMFmWciLinkData.getStatusSeverity() > 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public String[] getDomainIds() {
        return this.domainId;
    }

    public int getHighestSeverityForLinks() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.links.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n2);
            if (sMFmWciLinkData.getStatusSeverity() > n) {
                n = sMFmWciLinkData.getStatusSeverity();
            }
            ++n2;
        }
        return n;
    }

    public SMFmWciLinkData getLink(int n) {
        if (n > 0 && n < this.links.size()) {
            return (SMFmWciLinkData)this.links.get(n);
        }
        return null;
    }

    public int getLinkCount() {
        if (this.links != null) {
            return this.links.size();
        }
        return 0;
    }

    public int getLinkSetSize() {
        return this.links.size();
    }

    public Vector getLinks() {
        return this.links;
    }

    public int getMostSevereLinkStatus() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.links.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n2);
            if (sMFmWciLinkData.getStatus() > n) {
                n = sMFmWciLinkData.getStatus();
            }
            ++n2;
        }
        return n;
    }

    public String[] getScHosts() {
        return this.scHost;
    }

    public int getStatus() {
        return this.status;
    }

    public int getStatusSeverity() {
        return this.severity;
    }

    public int getStripeLevel() {
        return this.striping;
    }

    public SMFmWciLinkData removeLink(int n) {
        if (n > 0 && n < this.links.size()) {
            return (SMFmWciLinkData)this.links.remove(n);
        }
        return null;
    }

    public void setDomainIds(String[] stringArray) {
        this.domainId[0] = stringArray[0];
        this.domainId[1] = stringArray[1];
    }

    public void setLinks(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        this.links = vector;
    }

    public void setScHosts(String[] stringArray) {
        this.scHost[0] = stringArray[0];
        this.scHost[1] = stringArray[1];
    }

    public void setStatus(int n) {
        this.status = n;
        this.severity = SMFmConfGlobalShared.getDefaultLinkSetSeverity(n);
    }

    public void setStatusSeverity(int n) {
        this.severity = n;
    }

    public void setStripeLevel(int n) {
        this.striping = n == 1 || n == 2 || n == 4 || n == 8 || n == 16 ? n : -1;
    }

    public String toString() {
        return String.valueOf(this.scHost[0]) + "." + this.domainId[0] + " <-> " + this.scHost[1] + "." + this.domainId[1] + ":" + this.getStatus();
    }
}

