/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmConfGlobalShared;
import com.sun.symon.apps.wci.fmconf.common.SMFmRemoteEnd;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SMFmWciLinkData
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static final String SLOT = "S";
    private static final String WCI = "W";
    private static final String PORT = "P";
    private String[] scHost = new String[2];
    private String[] domainId = new String[2];
    private int[] slot = new int[2];
    private int[] wciId = new int[2];
    private int[] paroliId = new int[2];
    private List statusList;

    public SMFmWciLinkData(SMFmRemoteEnd sMFmRemoteEnd, SMFmRemoteEnd sMFmRemoteEnd2, int n) {
        this(sMFmRemoteEnd.getSCName(), sMFmRemoteEnd.getSCDomain(), sMFmRemoteEnd.getSlot(), sMFmRemoteEnd.getWci(), sMFmRemoteEnd.getPort(), sMFmRemoteEnd2.getSCName(), sMFmRemoteEnd2.getSCDomain(), sMFmRemoteEnd2.getSlot(), sMFmRemoteEnd2.getWci(), sMFmRemoteEnd2.getPort(), n);
    }

    public SMFmWciLinkData(String string, String string2, int n, int n2, int n3, String string3, String string4, int n4, int n5, int n6) {
        this(string, string2, n, n2, n3, string3, string4, n4, n5, n6, 12);
    }

    public SMFmWciLinkData(String string, String string2, int n, int n2, int n3, String string3, String string4, int n4, int n5, int n6, int n7) {
        this(string, string2, n, n2, n3, string3, string4, n4, n5, n6, n7, SMFmConfGlobalShared.getDefaultLinkSeverity(n7));
    }

    public SMFmWciLinkData(String string, String string2, int n, int n2, int n3, String string3, String string4, int n4, int n5, int n6, int n7, int n8) {
        this.scHost[0] = string;
        this.scHost[1] = string3;
        this.domainId[0] = string2;
        this.domainId[1] = string4;
        this.slot[0] = n;
        this.slot[1] = n4;
        this.wciId[0] = n2;
        this.wciId[1] = n5;
        this.paroliId[0] = n3;
        this.paroliId[1] = n6;
        this.statusList = new ArrayList();
        this.statusList.add(new StatusEntry("linkStatus", n7, n8));
    }

    public int compareTo(Object object) {
        if (!(object instanceof SMFmWciLinkData)) {
            return 0;
        }
        SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)object;
        String[] stringArray = sMFmWciLinkData.getScHosts();
        if (stringArray[0].equals(this.scHost[0]) && stringArray[1].equals(stringArray[1])) {
            String[] stringArray2 = sMFmWciLinkData.getDomainIds();
            if (stringArray2[0].equals(this.domainId[0]) && stringArray2[1].equals(this.domainId[1])) {
                int[] nArray = sMFmWciLinkData.getSlots();
                if (nArray[0] == this.slot[0] && nArray[1] == this.slot[1]) {
                    int[] nArray2 = sMFmWciLinkData.getWciIds();
                    if (nArray2[0] == this.wciId[0] && nArray2[1] == this.wciId[1]) {
                        int[] nArray3 = sMFmWciLinkData.getParoliIds();
                        if (nArray3[0] == this.paroliId[0] && nArray3[1] == this.paroliId[1]) {
                            return 0;
                        }
                        if (nArray3[0] < this.paroliId[0] || nArray3[1] < this.paroliId[1]) {
                            return 1;
                        }
                        return -1;
                    }
                    if (nArray2[0] < this.wciId[0] || nArray2[1] < this.wciId[1]) {
                        return 1;
                    }
                    return -1;
                }
                if (nArray[0] < this.slot[0] || nArray[1] < this.slot[1]) {
                    return 1;
                }
                return -1;
            }
            if (this.domainId[0].compareTo(stringArray2[0]) == 1 || this.domainId[1].compareTo(stringArray2[1]) == 1) {
                return 1;
            }
            return -1;
        }
        if (this.scHost[0].compareTo(stringArray[0]) > 0 || this.scHost[1].compareTo(stringArray[1]) > 0) {
            return 1;
        }
        return -1;
    }

    public boolean contains(String string, String string2, int n, int n2, int n3) {
        if (string == null || string2 == null) {
            return false;
        }
        return this.scHost[0].equals(string) && this.domainId[0].equals(string2) && this.slot[0] == n && this.wciId[0] == n2 && this.paroliId[0] == n3 || this.scHost[1].equals(string) && this.domainId[1].equals(string2) && this.slot[1] == n && this.wciId[1] == n2 && this.paroliId[1] == n3;
    }

    private StatusEntry findStatusEntry(String string) {
        int n = 0;
        while (n < this.statusList.size()) {
            StatusEntry statusEntry = (StatusEntry)this.statusList.get(n);
            if (statusEntry.property.equals(string)) {
                return statusEntry;
            }
            ++n;
        }
        return null;
    }

    public int[] getAllStatus() {
        Collections.sort(this.statusList);
        int[] nArray = new int[this.statusList.size()];
        int n = 0;
        while (n < this.statusList.size()) {
            nArray[n] = ((StatusEntry)this.statusList.get((int)n)).status;
            ++n;
        }
        return nArray;
    }

    public String[] getDomainIds() {
        return this.domainId;
    }

    public String[] getLinkString() {
        String[] stringArray = new String[]{String.valueOf(SMFmConfGlobalShared.concatSCNameDomain(this.scHost[0], this.domainId[0])) + "." + SLOT + this.slot[0] + "." + WCI + this.wciId[0] + "." + PORT + this.paroliId[0], String.valueOf(SMFmConfGlobalShared.concatSCNameDomain(this.scHost[1], this.domainId[1])) + "." + SLOT + this.slot[1] + "." + WCI + this.wciId[1] + "." + PORT + this.paroliId[1]};
        return stringArray;
    }

    public int[] getParoliIds() {
        return this.paroliId;
    }

    public String[] getScHosts() {
        return this.scHost;
    }

    public int[] getSlots() {
        return this.slot;
    }

    public int getStatus() {
        return ((StatusEntry)Collections.max(this.statusList)).status;
    }

    public int getStatus(String string) {
        int n = 12;
        StatusEntry statusEntry = this.findStatusEntry(string);
        if (statusEntry != null) {
            n = statusEntry.status;
        }
        return n;
    }

    public int getStatusSeverity() {
        return ((StatusEntry)Collections.max(this.statusList)).severity;
    }

    public int[] getWciIds() {
        return this.wciId;
    }

    public void removeStatusEntry(String string) {
        StatusEntry statusEntry = this.findStatusEntry(string);
        if (statusEntry != null) {
            this.statusList.remove(statusEntry);
        }
        if (this.statusList.size() == 0) {
            this.statusList.add(new StatusEntry("linkStatus", 0, 0));
        }
    }

    public void setDomainIds(String[] stringArray) {
        this.domainId[0] = stringArray[0];
        this.domainId[1] = stringArray[1];
    }

    public void setParoliIds(int[] nArray) {
        this.paroliId[0] = nArray[0];
        this.paroliId[1] = nArray[1];
    }

    public void setScHosts(String[] stringArray) {
        this.scHost[0] = stringArray[0];
        this.scHost[1] = stringArray[1];
    }

    public void setSlots(int[] nArray) {
        this.slot[0] = nArray[0];
        this.slot[1] = nArray[1];
    }

    public void setStatus(String string, int n, int n2) {
        StatusEntry statusEntry = this.findStatusEntry(string);
        if (statusEntry != null) {
            statusEntry.status = n;
            statusEntry.severity = n2;
        } else {
            this.statusList.add(new StatusEntry(string, n, n2));
        }
    }

    public void setWciIds(int[] nArray) {
        this.wciId[0] = nArray[0];
        this.wciId[1] = nArray[1];
    }

    public String toString() {
        String[] stringArray = this.getLinkString();
        return String.valueOf(stringArray[0]) + "<->" + stringArray[1] + ":" + this.getStatus();
    }

    class StatusEntry
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public String property;
        public int status;
        public int severity;

        public StatusEntry(String string, int n, int n2) {
            this.property = string;
            this.status = n;
            this.severity = n2;
        }

        public int compareTo(Object object) {
            if (this.severity < ((StatusEntry)object).severity) {
                return -1;
            }
            if (this.severity == ((StatusEntry)object).severity) {
                return 0;
            }
            return 1;
        }
    }
}

