/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmStatusSeverityInterface;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkSetData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMFmPartitionData
implements Serializable,
SMFmStatusSeverityInterface {
    private static final long serialVersionUID = 1L;
    private Vector nodes = new Vector();
    private String name;
    private int topoType = 3;
    private int opMode = 4;
    private int stripingPolicy = 1;
    private Vector routes = new Vector();
    private Vector links = new Vector();
    private int status;
    private int severity;

    public SMFmPartitionData() {
        this(null);
    }

    public SMFmPartitionData(String string) {
        this(string, 4);
    }

    public SMFmPartitionData(String string, int n) {
        this(string, n, 3, 1);
    }

    public SMFmPartitionData(String string, int n, int n2, int n3) {
        this.name = string;
        this.topoType = n2;
        this.opMode = n;
        this.stripingPolicy = n3;
        this.status = 0;
        this.severity = 0;
    }

    public void addLink(SMFmWciLinkData sMFmWciLinkData) {
        this.links.add(sMFmWciLinkData);
    }

    public int addNode(SMFmNodeData sMFmNodeData) {
        this.nodes.addElement(sMFmNodeData);
        return this.nodes.size();
    }

    public void addRoute(SMFmWciLinkSetData sMFmWciLinkSetData) {
        this.routes.addElement(sMFmWciLinkSetData);
        this.updateRouteStatusAndSeverity();
    }

    private boolean areAllRoutesOK() {
        boolean bl = true;
        int n = this.routes.size();
        int n2 = 0;
        while (n2 < n) {
            SMFmWciLinkSetData sMFmWciLinkSetData = (SMFmWciLinkSetData)this.routes.get(n2);
            int n3 = sMFmWciLinkSetData.getAlarmedLinkCt();
            if (n3 != 0) {
                int n4 = sMFmWciLinkSetData.getLinkCount();
                if (n4 == n3) {
                    sMFmWciLinkSetData.setStatus(2);
                    sMFmWciLinkSetData.setStatusSeverity(2);
                } else {
                    sMFmWciLinkSetData.setStatus(1);
                    sMFmWciLinkSetData.setStatusSeverity(3);
                }
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public static Vector convertLinksIntoLinkSets(Vector vector) {
        HashMap<String, SMFmWciLinkSetData> hashMap = new HashMap<String, SMFmWciLinkSetData>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)vector.get(n2);
            String[] stringArray = sMFmWciLinkData.getScHosts();
            String[] stringArray2 = sMFmWciLinkData.getDomainIds();
            String string = String.valueOf(stringArray[0]) + ":" + stringArray2[0] + "." + stringArray[1] + ":" + stringArray2[1];
            SMFmWciLinkSetData sMFmWciLinkSetData = (SMFmWciLinkSetData)hashMap.get(string);
            if (sMFmWciLinkSetData == null) {
                sMFmWciLinkSetData = new SMFmWciLinkSetData(stringArray[0], stringArray2[0], stringArray[1], stringArray2[1]);
                hashMap.put(string, sMFmWciLinkSetData);
            }
            sMFmWciLinkSetData.setStripeLevel(sMFmWciLinkSetData.getLinkCount() + 1);
            sMFmWciLinkSetData.addLink(sMFmWciLinkData);
            int n3 = sMFmWciLinkSetData.getMostSevereLinkStatus();
            if (n3 != 0) {
                sMFmWciLinkSetData.setStatus(2);
            } else {
                sMFmWciLinkSetData.setStatus(0);
            }
            ++n2;
        }
        return new Vector(hashMap.values());
    }

    private int findWorstNodeSeverity() {
        int n = 0;
        int n2 = this.nodes.size();
        int n3 = 0;
        while (n3 < n2) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.nodes.get(n3);
            if (sMFmNodeData.getStatusSeverity() > n) {
                n = sMFmNodeData.getStatusSeverity();
            }
            ++n3;
        }
        return n;
    }

    public SMFmWciLinkData getLinkByName(String string, String string2, int n, int n2, int n3) {
        if (this.links == null) {
            return null;
        }
        int n4 = 0;
        while (n4 < this.links.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n4);
            if (sMFmWciLinkData.contains(string, string2, n, n2, n3)) {
                return sMFmWciLinkData;
            }
            ++n4;
        }
        return null;
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Vector getLinks() {
        return this.links;
    }

    public List getLinksInRoutesByLinkName(String string, String string2, int n, int n2, int n3) {
        if (this.routes == null) {
            return null;
        }
        ArrayList<SMFmWciLinkData> arrayList = new ArrayList<SMFmWciLinkData>();
        int n4 = 0;
        while (n4 < this.routes.size()) {
            SMFmWciLinkSetData sMFmWciLinkSetData = (SMFmWciLinkSetData)this.routes.get(n4);
            Vector vector = sMFmWciLinkSetData.getLinks();
            if (vector != null) {
                int n5 = 0;
                while (n5 < vector.size()) {
                    SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)vector.get(n5);
                    if (sMFmWciLinkData.contains(string, string2, n, n2, n3) && !arrayList.contains(sMFmWciLinkData)) {
                        arrayList.add(sMFmWciLinkData);
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public List getLinksWithSevereAlarms() {
        ArrayList<SMFmWciLinkData> arrayList = new ArrayList<SMFmWciLinkData>();
        if (this.links != null) {
            int n = 0;
            while (n < this.links.size()) {
                SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n);
                int n2 = sMFmWciLinkData.getStatusSeverity();
                if (n2 != 0) {
                    arrayList.add(sMFmWciLinkData);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public String getMasterHostname() {
        String string = "";
        if (this.nodes != null) {
            int n = this.nodes.size();
            int n2 = 0;
            while (n2 < n) {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)this.nodes.get(n2);
                if (sMFmNodeData.isMasterNode()) {
                    string = String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId();
                }
                ++n2;
            }
        }
        return string;
    }

    public int getMode() {
        return this.opMode;
    }

    public String getName() {
        return this.name;
    }

    public SMFmNodeData getNode(int n) {
        SMFmNodeData sMFmNodeData = null;
        try {
            sMFmNodeData = (SMFmNodeData)this.nodes.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return sMFmNodeData;
    }

    public SMFmNodeData getNodeByName(String string, String string2) {
        if (this.nodes == null || string == null) {
            return null;
        }
        String string3 = new String(string2);
        if (string3 == null) {
            string3 = "";
        }
        int n = 0;
        while (n < this.nodes.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.nodes.get(n);
            String string4 = sMFmNodeData.getScHost();
            String string5 = sMFmNodeData.getDomainId();
            if (string5 == null) {
                string5 = "";
            }
            if (string4 != null && string4.equals(string) && string5.equals(string3)) {
                return sMFmNodeData;
            }
            ++n;
        }
        return null;
    }

    public int getNodeCount() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public int getNodeCountByType(int n) {
        int n2 = this.nodes.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (((SMFmNodeData)this.nodes.get(n4)).getNodeType() == n) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getRoutes() {
        return this.routes;
    }

    public List getRoutesWithLink(String string, String string2, int n, int n2, int n3) {
        if (this.routes == null) {
            return null;
        }
        ArrayList<SMFmWciLinkSetData> arrayList = new ArrayList<SMFmWciLinkSetData>();
        int n4 = 0;
        while (n4 < this.routes.size()) {
            SMFmWciLinkSetData sMFmWciLinkSetData = (SMFmWciLinkSetData)this.routes.get(n4);
            Vector vector = sMFmWciLinkSetData.getLinks();
            if (vector != null) {
                int n5 = 0;
                while (n5 < vector.size()) {
                    SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)vector.get(n5);
                    if (sMFmWciLinkData.contains(string, string2, n, n2, n3)) {
                        if (arrayList.contains(sMFmWciLinkSetData)) break;
                        arrayList.add(sMFmWciLinkSetData);
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public int getStatus() {
        return this.status;
    }

    public int getStatusSeverity() {
        return this.severity;
    }

    public int getStriping() {
        return this.stripingPolicy;
    }

    public String getTag() {
        return this.name;
    }

    public int getTopoType() {
        return this.topoType;
    }

    public boolean isAllPartitionLinksUp() {
        return this.status == 0;
    }

    public boolean isDeleteAllowed(SMFmNodeData sMFmNodeData) {
        if (this.topoType == 0) {
            return true;
        }
        if (sMFmNodeData.getNodeType() != 2) {
            return true;
        }
        int n = this.getNodeCountByType(2);
        return n == this.getNodeCount();
    }

    public boolean isDeleteAllowed(List list) {
        int n;
        if (this.topoType == 0) {
            return true;
        }
        int n2 = this.getNodeCount();
        if (n2 == (n = list.size())) {
            return true;
        }
        int n3 = this.getNodeCountByType(2);
        if (n3 == 0 || n3 == n2) {
            return true;
        }
        int n4 = 0;
        while (n4 < n) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)list.get(n4), ":");
            if (stringTokenizer.countTokens() == 1) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public void setLinks(Vector vector) {
        this.links.clear();
        if (vector != null && vector.size() != 0) {
            this.links.addAll(vector);
        }
    }

    public void setNodes(List list) {
        this.nodes.clear();
        this.nodes.addAll(list);
    }

    public void setRoutes(Vector vector) {
        this.routes.clear();
        if (vector != null && vector.size() != 0) {
            this.routes.addAll(vector);
        }
        this.updateRouteStatusAndSeverity();
    }

    public void setStriping(int n) {
        this.stripingPolicy = n;
    }

    public void setTopoType(int n) {
        this.topoType = n;
    }

    public String toString() {
        return "Partiition: " + this.name + "\n" + "Op Mode: " + this.getMode() + "\n" + "Topo Type: " + this.getTopoType() + "\n" + "Stripe Policy: " + this.getStriping() + "\n" + "Status: " + this.getStatus() + "\n" + "Links: " + this.links.toString() + "\n" + "Routes: " + this.routes.toString() + "\n" + "Nodes: " + this.nodes + "\n";
    }

    public void updateRouteStatusAndSeverity() {
        if (this.nodes.size() < 2) {
            this.status = 0;
            this.severity = 0;
            return;
        }
        if (this.routes.size() == 0) {
            this.status = 2;
            this.severity = 2;
            return;
        }
        if (!this.areAllRoutesOK()) {
            this.status = 1;
            this.severity = this.findWorstNodeSeverity();
        } else {
            this.status = 0;
            this.severity = 0;
        }
    }
}

