/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmStatusSeverityInterface;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciData;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class SMFmNodeData
implements Serializable,
Comparable,
SMFmStatusSeverityInterface {
    private static final long serialVersionUID = 1L;
    private String scHost;
    private String domainId;
    private int chassisType;
    private int opMode;
    private int nodeType;
    boolean masterNode;
    private List inUseWcis = new ArrayList();
    private List idleWcis = new ArrayList();
    private InetAddress scInetAddr;
    private String hostName;
    private InetAddress hostInetAddr;
    private String proxyAgentHostName;
    private int agentPort;
    private String physicalLoc;
    private int ncSlice;
    private int status;
    private int severity;

    public SMFmNodeData(String string) {
        this(string, null);
    }

    public SMFmNodeData(String string, String string2) {
        this(string, string2, 6, 4, 0, false, null, null);
    }

    public SMFmNodeData(String string, String string2, int n, int n2, int n3, boolean bl, List list, List list2) {
        this.scHost = string;
        this.domainId = string2;
        this.setChassisType(n);
        this.setOpMode(n2);
        this.setNodeType(n3);
        this.masterNode = bl;
        this.setInUseWcis(list);
        this.setIdleWcis(list2);
        try {
            if (string != null && !string.equals("")) {
                this.scInetAddr = InetAddress.getByName(string);
            }
        }
        catch (UnknownHostException unknownHostException) {}
        this.status = 0;
        this.severity = 0;
        this.hostName = null;
        this.ncSlice = 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof SMFmNodeData)) {
            return 0;
        }
        SMFmNodeData sMFmNodeData = (SMFmNodeData)object;
        String string = String.valueOf(this.getScHost()) + this.getDomainId();
        String string2 = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
        return string.compareTo(string2);
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getChassisType() {
        return this.chassisType;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getHostIpAddress() {
        if (this.hostInetAddr == null) {
            return null;
        }
        return this.hostInetAddr.getHostAddress();
    }

    public String getHostName() {
        return this.hostName;
    }

    public List getIdleWcis() {
        return this.idleWcis;
    }

    public List getInUseWcis() {
        return this.inUseWcis;
    }

    public String getIpAddress() {
        if (this.scInetAddr == null) {
            return null;
        }
        return this.scInetAddr.getHostAddress();
    }

    public int getNCSlice() {
        return this.ncSlice;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public int getOpMode() {
        return this.opMode;
    }

    public String getPhysicalLocation() {
        return this.physicalLoc;
    }

    public String getProxyAgentHostName() {
        return this.proxyAgentHostName;
    }

    public String getScHost() {
        return this.scHost;
    }

    public int getStatus() {
        return this.status;
    }

    public int getStatusSeverity() {
        return this.severity;
    }

    public SMFmWciData getWci(int n, int n2) {
        int n3 = 0;
        while (n3 < this.idleWcis.size()) {
            SMFmWciData sMFmWciData = (SMFmWciData)this.idleWcis.get(n3);
            if (sMFmWciData.getSlot() == n && sMFmWciData.getWci() == n2) {
                return sMFmWciData;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.inUseWcis.size()) {
            SMFmWciData sMFmWciData = (SMFmWciData)this.inUseWcis.get(n4);
            if (sMFmWciData.getSlot() == n && sMFmWciData.getWci() == n2) {
                return sMFmWciData;
            }
            ++n4;
        }
        return null;
    }

    public boolean isIdleWcis() {
        return this.idleWcis != null && this.idleWcis.size() > 0;
    }

    public boolean isMasterNode() {
        return this.masterNode;
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setChassisType(int n) {
        this.chassisType = n >= 0 && n < 6 ? n : 6;
    }

    public void setDomainId(String string) {
        this.domainId = string;
    }

    public void setHostName(String string) {
        this.hostName = string;
        try {
            if (string != null && !string.equals("")) {
                this.hostInetAddr = InetAddress.getByName(string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.hostInetAddr = null;
        }
    }

    public void setIdleWcis(List list) {
        this.idleWcis.clear();
        if (list != null) {
            this.idleWcis.addAll(list);
        }
    }

    public void setInUseWcis(List list) {
        this.inUseWcis.clear();
        if (list != null) {
            this.inUseWcis.addAll(list);
        }
    }

    public void setMasterNode(boolean bl) {
        this.masterNode = bl;
    }

    public void setNCSlice(int n) {
        this.ncSlice = n;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public void setOpMode(int n) {
        this.opMode = n;
    }

    public void setPhysicalLocation(String string) {
        this.physicalLoc = string;
    }

    public void setProxyAgentHostName(String string) {
        this.proxyAgentHostName = string;
    }

    public void setScHost(String string) {
        this.scHost = string;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatusSeverity(int n) {
        this.severity = n;
    }

    public String toString() {
        return new String("SC_HOST: " + this.scHost + "\n" + "DOMAIN_ID" + ": " + this.domainId + "\n" + "CHASSIS_TYPE" + ": " + this.chassisType + "\n" + "OP_MODE" + ": " + this.opMode + "\n" + "NODE_TYPE" + ": " + this.nodeType + "\n" + "MASTER_NODE" + ": " + this.masterNode + "\n" + "SC_INET_ADDR" + ": " + this.scInetAddr + "\n" + "HOST_NAME" + ": " + this.hostName + "\n" + "HOST_INET_ADDR" + ": " + this.hostInetAddr + "\n" + "PROXY_AGENT_HOST_NAME" + ": " + this.proxyAgentHostName + "\n" + "AGENT_PORT" + ": " + this.agentPort + "\n" + "NC_SLICE" + ": " + this.ncSlice + "\n" + "STATUS" + ": " + this.status + "\n" + "SEVERITY" + ": " + this.severity + "\n" + "IN_USE_WCIS" + ": " + this.inUseWcis + "\n" + "IDLE_WCIS" + ": " + this.idleWcis);
    }
}

