/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SMFmFabricData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fabName;
    private Vector partitionList = new Vector();
    private Vector members = new Vector();
    private Vector chassis = new Vector();

    public SMFmFabricData() {
        this(null);
    }

    public SMFmFabricData(String string) {
        this.fabName = string;
    }

    public int addMember(SMFmNodeData sMFmNodeData) {
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData2 = (SMFmNodeData)this.members.elementAt(n);
            if (sMFmNodeData2.getScHost().equals(sMFmNodeData.getScHost()) && sMFmNodeData2.getDomainId().equals(sMFmNodeData.getDomainId())) {
                this.members.remove(n);
                break;
            }
            ++n;
        }
        this.members.addElement(sMFmNodeData);
        int n2 = 0;
        while (n2 < this.chassis.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassis.elementAt(n2);
            if (sMFmChassisData.addWnode(sMFmNodeData) >= 0) {
                return 0;
            }
            ++n2;
        }
        this.chassis.addElement(new SMFmChassisData(sMFmNodeData));
        return 0;
    }

    public int addPartition(SMFmPartitionData sMFmPartitionData) {
        Serializable serializable;
        int n = 0;
        while (n < this.partitionList.size()) {
            serializable = (SMFmPartitionData)this.partitionList.elementAt(n);
            if (((SMFmPartitionData)serializable).getName().equals(sMFmPartitionData.getName())) {
                this.partitionList.remove(n);
                break;
            }
            ++n;
        }
        this.partitionList.addElement(sMFmPartitionData);
        serializable = sMFmPartitionData.getNodes();
        if (serializable != null) {
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                this.addMember((SMFmNodeData)((Vector)serializable).get(n2));
                ++n2;
            }
        }
        this.updateNodeStatusAndSeverity();
        this.updateChassisStatusAndSeverity();
        return this.partitionList.size();
    }

    public Vector getAllAvailableChassis() {
        Vector<SMFmChassisData> vector = new Vector<SMFmChassisData>();
        int n = 0;
        while (n < this.chassis.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassis.get(n);
            if (sMFmChassisData.containsFreeNode()) {
                vector.add(sMFmChassisData);
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllAvailableChassisExcludingSwitches() {
        Vector vector = this.getAllAvailableChassis();
        int n = 0;
        while (n < vector.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)vector.get(n);
            int n2 = sMFmChassisData.getChassisType();
            if (n2 == 5) {
                vector.remove(n);
                continue;
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllAvailableNodes() {
        return this.getAllPartitionlessNodes();
    }

    public Vector getAllAvailableNodesExcludingSwitches() {
        Vector vector = this.getAllAvailableNodes();
        int n = 0;
        while (n < vector.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.get(n);
            int n2 = sMFmNodeData.getNodeType();
            if (n2 != 1) {
                vector.remove(n);
                continue;
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllAvailableSwitchChassis() {
        Vector vector = this.getAllAvailableChassis();
        Vector<SMFmChassisData> vector2 = new Vector<SMFmChassisData>();
        int n = 0;
        while (n < vector.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)vector.get(n);
            int n2 = sMFmChassisData.getChassisType();
            if (n2 == 5) {
                vector2.add(sMFmChassisData);
            }
            ++n;
        }
        return vector2;
    }

    public Vector getAllAvailableSwitchNodes() {
        Vector vector = this.getAllAvailableNodes();
        int n = 0;
        while (n < vector.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.get(n);
            int n2 = sMFmNodeData.getChassisType();
            if (n2 != 5) {
                vector.remove(n);
                continue;
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllEmptyPartitions() {
        Vector<SMFmPartitionData> vector = new Vector<SMFmPartitionData>();
        int n = 0;
        while (n < this.partitionList.size()) {
            SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.elementAt(n);
            if (sMFmPartitionData.getNodes().size() == 0) {
                vector.addElement(sMFmPartitionData);
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllPartitionlessNodes() {
        Vector<SMFmNodeData> vector = new Vector<SMFmNodeData>();
        int n = 0;
        while (n < this.members.size()) {
            block4: {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.elementAt(n);
                int n2 = 0;
                while (n2 < this.partitionList.size()) {
                    SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.elementAt(n2);
                    Vector vector2 = sMFmPartitionData.getNodes();
                    int n3 = 0;
                    while (n3 < vector2.size()) {
                        SMFmNodeData sMFmNodeData2 = (SMFmNodeData)vector2.elementAt(n3);
                        if (sMFmNodeData != sMFmNodeData2) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    ++n2;
                }
                vector.addElement(sMFmNodeData);
            }
            ++n;
        }
        return vector;
    }

    public Vector getAvailableSSMNodes() {
        Vector<SMFmNodeData> vector = new Vector<SMFmNodeData>();
        int n = 0;
        while (n < this.members.size()) {
            block5: {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.elementAt(n);
                if (sMFmNodeData.getOpMode() != 1) {
                    int n2 = 0;
                    while (n2 < this.partitionList.size()) {
                        SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.elementAt(n2);
                        Vector vector2 = sMFmPartitionData.getNodes();
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            SMFmNodeData sMFmNodeData2 = (SMFmNodeData)vector2.elementAt(n3);
                            if (sMFmNodeData != sMFmNodeData2) {
                                ++n3;
                                continue;
                            }
                            break block5;
                        }
                        ++n2;
                    }
                    vector.addElement(sMFmNodeData);
                }
            }
            ++n;
        }
        return vector;
    }

    public Vector getChassis() {
        return this.chassis;
    }

    public SMFmChassisData getChassisByName(String string) {
        if (this.chassis == null) {
            return null;
        }
        int n = 0;
        while (n < this.chassis.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassis.get(n);
            String string2 = sMFmChassisData.getScHost();
            if (string2 != null && string2.equals(string)) {
                return sMFmChassisData;
            }
            ++n;
        }
        return null;
    }

    public String getFabricName() {
        return this.fabName;
    }

    public SMFmWciLinkData getLinkByName(String string, String string2, int n, int n2, int n3) {
        if (this.partitionList != null) {
            int n4 = this.partitionList.size();
            int n5 = 0;
            while (n5 < n4) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n5);
                SMFmWciLinkData sMFmWciLinkData = sMFmPartitionData.getLinkByName(string, string2, n, n2, n3);
                if (sMFmWciLinkData != null) {
                    return sMFmWciLinkData;
                }
                ++n5;
            }
        }
        return null;
    }

    public List getLinksWithSevereAlarms(int n) {
        ArrayList arrayList = new ArrayList();
        if (this.partitionList != null) {
            int n2 = this.partitionList.size();
            int n3 = 0;
            while (n3 < n2) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n3);
                if (sMFmPartitionData.getMode() == n) {
                    arrayList.addAll(sMFmPartitionData.getLinksWithSevereAlarms());
                }
                ++n3;
            }
        }
        return arrayList;
    }

    public SMFmNodeData getMemberByHostName(String string) {
        if (this.members == null) {
            return null;
        }
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.get(n);
            String string2 = sMFmNodeData.getHostName();
            if (string2 != null && string2.equals(string)) {
                return sMFmNodeData;
            }
            ++n;
        }
        return null;
    }

    public SMFmNodeData getMemberByName(String string, String string2) {
        if (this.members == null) {
            return null;
        }
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.get(n);
            String string3 = sMFmNodeData.getScHost();
            String string4 = sMFmNodeData.getDomainId();
            if (string3 != null && string4 != null && string3.equals(string) && string4.equals(string2)) {
                return sMFmNodeData;
            }
            ++n;
        }
        return null;
    }

    public SMFmNodeData getMemberByProxyHostName(String string) {
        return null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public List getMembersHostNames() {
        if (this.members == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.get(n);
            String string = sMFmNodeData.getHostName();
            if (string != null && !string.equals("")) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    public SMFmPartitionData getPartitionByLink(String string, String string2, int n, int n2, int n3) {
        if (this.partitionList != null) {
            int n4 = this.partitionList.size();
            int n5 = 0;
            while (n5 < n4) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n5);
                SMFmWciLinkData sMFmWciLinkData = sMFmPartitionData.getLinkByName(string, string2, n, n2, n3);
                if (sMFmWciLinkData != null) {
                    return sMFmPartitionData;
                }
                ++n5;
            }
        }
        return null;
    }

    public SMFmPartitionData getPartitionByName(String string) {
        if (this.partitionList != null) {
            int n = this.partitionList.size();
            int n2 = 0;
            while (n2 < n) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n2);
                String string2 = sMFmPartitionData.getName();
                if (string2 != null && string2.equals(string)) {
                    return sMFmPartitionData;
                }
                ++n2;
            }
        }
        return null;
    }

    public int getPartitionCount() {
        if (this.partitionList != null) {
            return this.partitionList.size();
        }
        return 0;
    }

    public Vector getPartitionList() {
        return this.getPartitions();
    }

    public int getPartitionNodeCount() {
        int n = 0;
        if (this.partitionList != null) {
            int n2 = this.partitionList.size();
            int n3 = 0;
            while (n3 < n2) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n3);
                n += sMFmPartitionData.getNodeCount();
                ++n3;
            }
        }
        return n;
    }

    public Vector getPartitions() {
        return this.partitionList;
    }

    public int getPatitionLinkCount() {
        int n = 0;
        if (this.partitionList != null) {
            int n2 = this.partitionList.size();
            int n3 = 0;
            while (n3 < n2) {
                SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n3);
                n += sMFmPartitionData.getLinkCount();
                ++n3;
            }
        }
        return n;
    }

    public List getProxyHostNames() {
        if (this.members == null) {
            return null;
        }
        if (this.members == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.get(n);
            String string = sMFmNodeData.getProxyAgentHostName();
            if (string != null && !string.equals("")) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean isAllPartitionsLinksUp() {
        boolean bl = true;
        int n = this.partitionList.size();
        int n2 = 0;
        while (n2 < n) {
            SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n2);
            if (!sMFmPartitionData.isAllPartitionLinksUp()) {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void removeMember(SMFmNodeData sMFmNodeData) {
        if (sMFmNodeData == null) {
            return;
        }
        int n = 0;
        while (n < this.members.size()) {
            SMFmNodeData sMFmNodeData2 = (SMFmNodeData)this.members.get(n);
            if (sMFmNodeData2.getScHost().equals(sMFmNodeData.getScHost()) && sMFmNodeData2.getDomainId().equals(sMFmNodeData.getDomainId())) {
                this.members.remove(n);
                break;
            }
            ++n;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.chassis.size() && !bl) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassis.get(n2);
            if (sMFmChassisData.getScHost().equals(sMFmNodeData.getScHost())) {
                Vector vector = sMFmChassisData.getWnodeList();
                if (vector.size() == 1) {
                    this.chassis.remove(n2);
                    bl = true;
                } else {
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        SMFmNodeData sMFmNodeData3 = (SMFmNodeData)vector.get(n3);
                        if (sMFmNodeData3.getDomainId().equals(sMFmNodeData.getDomainId())) {
                            vector.remove(n3);
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    public void removePartition(SMFmPartitionData sMFmPartitionData) {
        this.partitionList.remove(sMFmPartitionData);
    }

    public String toString() {
        return new String("FAB_NAME: " + this.fabName + "\n" + "AVAILABLE_MEMBERS" + ": " + this.getAllAvailableNodes() + "\n" + "AVAILABLE_CHASSIS" + ": " + this.getAllAvailableChassis() + "\n" + "PARTITION_LIST" + ": " + this.partitionList + "\n");
    }

    public void updateChassisStatusAndSeverity() {
        int n = 0;
        while (n < this.chassis.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassis.get(n);
            sMFmChassisData.updateChassisStatusAndSeverity();
            ++n;
        }
    }

    public void updateFabricData(SMFmFabricData sMFmFabricData) {
        if (sMFmFabricData == null) {
            return;
        }
        this.members.clear();
        this.chassis.clear();
        this.partitionList.clear();
        this.fabName = sMFmFabricData.getFabricName();
        this.members.addAll(sMFmFabricData.getMembers());
        this.chassis.addAll(sMFmFabricData.getChassis());
        this.partitionList.addAll(sMFmFabricData.getPartitionList());
        this.updateNodeStatusAndSeverity();
        this.updateChassisStatusAndSeverity();
    }

    public void updateMemberData(SMFmNodeData sMFmNodeData) {
        this.addMember(sMFmNodeData);
        this.updateMemberInPartitions(sMFmNodeData);
        this.updateNodeStatusAndSeverity();
        this.updateChassisStatusAndSeverity();
    }

    public void updateMemberData(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)list.get(n);
            this.addMember(sMFmNodeData);
            this.updateMemberInPartitions(sMFmNodeData);
            ++n;
        }
        this.updateNodeStatusAndSeverity();
        this.updateChassisStatusAndSeverity();
    }

    public void updateMemberInPartitions(SMFmNodeData sMFmNodeData) {
        int n = 0;
        while (n < this.partitionList.size()) {
            SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)this.partitionList.get(n);
            SMFmNodeData sMFmNodeData2 = sMFmPartitionData.getNodeByName(sMFmNodeData.getScHost(), sMFmNodeData.getDomainId());
            if (sMFmNodeData2 != null) {
                Vector vector = sMFmPartitionData.getNodes();
                vector.remove(sMFmNodeData2);
                sMFmPartitionData.addNode(sMFmNodeData);
            }
            ++n;
        }
    }

    public void updateNodeStatusAndSeverity() {
        List list = this.getLinksWithSevereAlarms(1);
        ArrayList<SMFmNodeData> arrayList = new ArrayList<SMFmNodeData>();
        int n = 0;
        while (n < list.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)list.get(n);
            int n2 = sMFmWciLinkData.getStatusSeverity();
            int n3 = sMFmWciLinkData.getStatus();
            String[] stringArray = sMFmWciLinkData.getScHosts();
            String[] stringArray2 = sMFmWciLinkData.getDomainIds();
            SMFmNodeData sMFmNodeData = this.getMemberByName(stringArray[0], stringArray2[0] == null ? "" : stringArray2[0]);
            SMFmNodeData sMFmNodeData2 = this.getMemberByName(stringArray[1], stringArray2[1] == null ? "" : stringArray2[1]);
            if (sMFmNodeData.getStatusSeverity() < n2) {
                sMFmNodeData.setStatusSeverity(n2);
                sMFmNodeData.setStatus(n3);
            }
            if (sMFmNodeData2.getStatusSeverity() < n2) {
                sMFmNodeData2.setStatusSeverity(n2);
                sMFmNodeData2.setStatus(n3);
            }
            arrayList.add(sMFmNodeData);
            arrayList.add(sMFmNodeData2);
            ++n;
        }
        int n4 = 0;
        while (n4 < this.members.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.members.get(n4);
            if (!arrayList.contains(sMFmNodeData)) {
                sMFmNodeData.setStatus(0);
                sMFmNodeData.setStatusSeverity(0);
            }
            ++n4;
        }
    }
}

