/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.common;

import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmStatusSeverityInterface;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class SMFmChassisData
implements Serializable,
SMFmStatusSeverityInterface {
    private static final long serialVersionUID = 1L;
    private String scHost = null;
    private InetAddress scInetAddr;
    int chassisType = 6;
    Vector wnodeList = new Vector(0);
    private int status;
    private int severity;

    public SMFmChassisData(SMFmNodeData sMFmNodeData) {
        this.scHost = sMFmNodeData.getScHost();
        this.chassisType = sMFmNodeData.getChassisType();
        this.wnodeList.addElement(sMFmNodeData);
        this.wnodeList.trimToSize();
        this.initIpAddr();
        this.updateChassisStatusAndSeverity();
    }

    public SMFmChassisData(String string) {
        this(string, 6);
    }

    public SMFmChassisData(String string, int n) {
        this.scHost = new String(string);
        this.chassisType = n;
        this.initIpAddr();
        this.status = 0;
        this.severity = 0;
    }

    public int addWnode(SMFmNodeData sMFmNodeData) {
        String string = sMFmNodeData.getScHost();
        String string2 = sMFmNodeData.getDomainId();
        int n = sMFmNodeData.getChassisType();
        int n2 = 0;
        while (n2 < this.wnodeList.size()) {
            SMFmNodeData sMFmNodeData2 = (SMFmNodeData)this.wnodeList.get(n2);
            if (string.equals(sMFmNodeData2.getScHost()) && string2.equals(sMFmNodeData2.getDomainId()) && n == sMFmNodeData2.getChassisType()) {
                this.wnodeList.remove(n2);
                break;
            }
            ++n2;
        }
        if (!string.equals(this.scHost)) {
            return -1;
        }
        if (this.chassisType == 6) {
            this.chassisType = n;
        }
        if (n != this.chassisType) {
            return -2;
        }
        this.wnodeList.addElement(sMFmNodeData);
        this.wnodeList.trimToSize();
        this.updateChassisStatusAndSeverity();
        return this.wnodeList.size();
    }

    public boolean containsFreeNode() {
        int n = 0;
        while (n < this.wnodeList.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.wnodeList.get(n);
            if (sMFmNodeData.getOpMode() == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getChassisType() {
        return this.chassisType;
    }

    public String getIpAddress() {
        if (this.scInetAddr != null) {
            return this.scInetAddr.getHostAddress();
        }
        return null;
    }

    public SMFmNodeData getNodeByDomainId(String string) {
        if (string == null || this.wnodeList == null) {
            return null;
        }
        int n = 0;
        while (n < this.wnodeList.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.wnodeList.get(n);
            if (sMFmNodeData.getDomainId().equals(string)) {
                return sMFmNodeData;
            }
            ++n;
        }
        return null;
    }

    public String getScHost() {
        return new String(this.scHost);
    }

    public int getStatus() {
        return this.status;
    }

    public int getStatusSeverity() {
        return this.severity;
    }

    public Vector getWnodeList() {
        return this.wnodeList;
    }

    private void initIpAddr() {
        try {
            if (this.scHost != null && !this.scHost.equals("")) {
                this.scInetAddr = InetAddress.getByName(this.scHost);
            }
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public String toString() {
        return new String("SC_HOST: " + this.scHost + "\n" + "SC_INET_ADDR" + ": " + this.scInetAddr + "\n" + "CHASSIS_TYPE" + ": " + this.chassisType + "\n" + "STATUS" + ": " + this.status + "\n" + "SEVERITY" + ": " + this.severity + "\n" + "WNODE_LIST" + ": " + this.wnodeList);
    }

    public void updateChassisStatusAndSeverity() {
        int n = this.wnodeList.size();
        this.severity = 0;
        this.status = 0;
        int n2 = 0;
        while (n2 < n) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.wnodeList.get(n2);
            if (sMFmNodeData.getStatusSeverity() > this.severity) {
                this.severity = sMFmNodeData.getStatusSeverity();
            }
            if (sMFmNodeData.getStatus() > this.status) {
                this.status = sMFmNodeData.getStatus();
            }
            ++n2;
        }
    }
}

