/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.common;

import com.sun.symon.apps.common.CustomLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class JLine
extends JLabel {
    int thickness;
    Color defaultColor;
    Color currentColor;
    boolean isDiagLine;
    int startX;
    int startY;
    int endX;
    int endY;
    int boundsX;
    int boundsY;
    int boundsHeight;
    int boundsWidth;
    int lineX1;
    int lineY1;
    int lineX2;
    int lineY2;
    float m;
    float b;
    Line2D line;

    public JLine() {
    }

    public JLine(int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.setProperties(n, n2, n3, n4, n5, color, bl);
    }

    public boolean contains(int n, int n2) {
        if (this.isDiagLine) {
            if (n >= 0 && n <= this.boundsWidth && n2 >= 0 && n2 <= this.boundsHeight) {
                double d = this.m * (float)n + this.b;
                return (double)n2 > d - (double)this.thickness && (double)n2 < d + (double)this.thickness;
            }
            return false;
        }
        return super.contains(n, n2);
    }

    public Color getBackground() {
        return this.currentColor;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public static void main(String[] stringArray) {
        JLine jLine = new JLine(40, 20, 10, 50, 2, Color.black, true);
        jLine.setToolTipText("Line1");
        JLine jLine2 = new JLine(10, 20, 200, 300, 3, Color.black, true);
        jLine2.setToolTipText("Line2");
        JLine jLine3 = new JLine(60, 90, 90, 60, 4, Color.black, false);
        jLine3.setToolTipText("Line3");
        JLine jLine4 = new JLine(20, 80, 200, 75, 2, Color.blue, true);
        jLine4.setToolTipText("Line4");
        JLine jLine5 = new JLine(100, 5, 108, 200, 2, Color.black, true);
        jLine5.setToolTipText("Line5");
        JFrame jFrame = new JFrame();
        ((Component)jFrame).setSize(300, 300);
        jFrame.getContentPane().setLayout(new CustomLayout());
        jFrame.getContentPane().add(jLine);
        jFrame.getContentPane().add(jLine2);
        jFrame.getContentPane().add(jLine3);
        jFrame.getContentPane().add(jLine4);
        jFrame.getContentPane().add(jLine5);
        ((Component)jFrame).setVisible(true);
    }

    public void paint(Graphics graphics) {
        if (this.isDiagLine) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(this.thickness));
            graphics2D.setColor(this.currentColor);
            graphics2D.draw(this.line);
        } else {
            super.paint(graphics);
        }
    }

    public void setBackground(Color color) {
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.currentColor = color;
        if (!this.isDiagLine) {
            super.setBackground(color);
        }
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public void setProperties(int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.defaultColor = color;
        this.currentColor = color;
        this.boundsX = n < n3 ? n : n3;
        this.boundsY = n2 < n4 ? n2 : n4;
        this.boundsWidth = Math.abs(n - n3);
        this.boundsHeight = Math.abs(n2 - n4);
        if (n == n3 || n2 == n4) {
            this.isDiagLine = false;
            this.setOpaque(true);
            this.setColor(this.currentColor);
            if (n == n3) {
                this.setBounds(this.boundsX, this.boundsY, n5, this.boundsHeight);
            } else {
                this.setBounds(this.boundsX, this.boundsY, this.boundsWidth, n5);
            }
        } else {
            this.isDiagLine = true;
            this.setOpaque(false);
            this.thickness = n5;
            this.startX = n;
            this.startY = n2;
            this.endX = n3;
            this.endY = n4;
            if (this.boundsWidth < n5) {
                this.boundsWidth = n5;
            }
            if (this.boundsHeight < n5) {
                this.boundsHeight = n5;
            }
            this.setBounds(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            this.lineX1 = this.startX - this.boundsX;
            this.lineY1 = this.startY - this.boundsY;
            this.lineX2 = this.endX - this.boundsX;
            this.lineY2 = this.endY - this.boundsY;
            this.m = (float)(this.lineY1 - this.lineY2) / (float)(this.lineX1 - this.lineX2);
            this.b = (float)this.lineY1 - this.m * (float)this.lineX1;
            this.line = new Line2D.Double(this.lineX1, this.lineY1, this.lineX2, this.lineY2);
        }
    }
}

