/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class BoxIcon
implements Icon {
    protected int width;
    protected int height;
    protected Color shadow;
    protected Color primarySelectionColor;
    protected Color secondarySelectionColor;
    protected int borderSize;
    protected int fillHeight;
    protected int fillWidth;
    protected boolean selected;
    protected boolean halfFull;
    protected boolean colorToggle;
    protected boolean disabled;

    public BoxIcon(boolean bl, int n, int n2) {
        this.selected = bl;
        this.width = n;
        this.height = n;
        this.borderSize = n2;
        this.fillWidth = this.width - 2 * n2;
        this.fillHeight = this.height - 2 * n2;
        this.primarySelectionColor = Color.black;
        this.secondarySelectionColor = Color.gray;
        this.colorToggle = false;
        this.halfFull = false;
    }

    public void drawSelection(Graphics graphics, int n, int n2) {
        if (this.halfFull) {
            int n3 = n + this.borderSize;
            int n4 = n + this.fillWidth;
            int n5 = n2 + this.fillHeight;
            int n6 = n2 + this.borderSize;
            int n7 = 0;
            while (n7 < this.fillHeight) {
                graphics.drawLine(n3 + n7, n5, n4, n6 + n7);
                ++n7;
            }
        } else {
            graphics.fillRect(n, n2, this.fillWidth + this.borderSize, this.fillHeight + this.borderSize);
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.height;
    }

    public Color getSelectionColor() {
        return this.colorToggle ? this.secondarySelectionColor : this.primarySelectionColor;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.disabled) {
            return;
        }
        if (this.borderSize > 0) {
            graphics.setColor(this.getSelectionColor());
            int n3 = 0;
            while (n3 < this.borderSize) {
                graphics.drawRect(n + n3, n2 + n3, this.width - 2 * n3 - 1, this.height - 2 * n3 - 1);
                ++n3;
            }
        }
        if (this.selected) {
            this.drawSelection(graphics, n, n2);
        }
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public void setHalfFull(boolean bl) {
        this.halfFull = bl;
    }

    public void setSecondarySelectionColor(Color color) {
        this.secondarySelectionColor = color;
    }

    public void setSelectionColor(Color color) {
        this.primarySelectionColor = color;
    }

    public void toggleSelectionColor(boolean bl) {
        this.colorToggle = bl;
    }
}

