/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import java.util.Hashtable;

public class Debug {
    Object theInstance = null;
    public static final int NONE = 6;
    public static final int FATAL = 5;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int MESSAGE = 2;
    public static final int INFO = 1;
    public static final int ALL = 0;
    private static int globalDebugLevel = 5;
    private static Hashtable classDB = new Hashtable();

    public static void fatal(String string) {
        Debug.printIf(string, 5);
    }

    public static void error(String string) {
        Debug.printIf(string, 4);
    }

    public static void warning(String string) {
        Debug.printIf(string, 3);
    }

    public static void message(String string) {
        Debug.printIf(string, 2);
    }

    public static void info(String string) {
        Debug.printIf(string, 1);
    }

    public static void fatal(Object object, String string) {
        Debug.printIf(object, string, 5);
    }

    public static void error(Object object, String string) {
        Debug.printIf(object, string, 4);
    }

    public static void warning(Object object, String string) {
        Debug.printIf(object, string, 3);
    }

    public static void message(Object object, String string) {
        Debug.printIf(object, string, 2);
    }

    public static void info(Object object, String string) {
        Debug.printIf(object, string, 1);
    }

    public static void setDebugLevel(int n) {
        if (n < 0 || n > 6) {
            return;
        }
        globalDebugLevel = n;
    }

    public static void setDebugLevel(Object object, int n) {
        if (n < 0 || n > 6) {
            return;
        }
        classDB.put(object.getClass(), new Integer(n));
    }

    public static void setDebugLevel(String string, int n) {
        if (n < 0 || n > 6) {
            return;
        }
        try {
            classDB.put(Class.forName(string), new Integer(n));
        }
        catch (Exception exception) {
            System.out.println("setDebugLevel: " + exception);
        }
    }

    private static void printIf(String string, int n) {
        if (n < globalDebugLevel) {
            return;
        }
        Debug.debugPrint(string);
    }

    private static void printIf(Object object, String string, int n) {
        if (n < Debug.getLevelForClass(object)) {
            return;
        }
        Debug.debugPrint(string);
    }

    private static synchronized int getLevelForClass(Object object) {
        int n = globalDebugLevel;
        Object v = classDB.get(object.getClass());
        if (v != null) {
            n = (Integer)v;
        } else {
            classDB.put(object.getClass(), new Integer(n));
        }
        return n;
    }

    private static void debugPrint(String string) {
        System.out.println(string);
    }

    public Debug(Object object) {
        this.theInstance = object;
    }

    public void SetDebugLevel(int n) {
        if (n < 0 || n > 6) {
            return;
        }
        Debug.setDebugLevel(this.theInstance, n);
    }

    public void Fatal(String string) {
        Debug.fatal(this.theInstance, string);
    }

    public void Warning(String string) {
        Debug.warning(this.theInstance, string);
    }

    public void Error(String string) {
        Debug.error(this.theInstance, string);
    }

    public void Message(String string) {
        Debug.message(this.theInstance, string);
    }

    public void Info(String string) {
        Debug.info(this.theInstance, string);
    }
}

