/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.BogusOptionValue;
import com.sun.dhcpmgr.data.BooleanOptionValue;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionValueFactory;
import com.sun.dhcpmgr.data.ResourceStrings;
import com.sun.dhcpmgr.data.StandardOptions;
import com.sun.dhcpmgr.data.ValidationException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Macro
extends DhcptabRecord
implements Cloneable {
    private boolean valueClean = false;
    private Vector options = new Vector();
    public static final short MAX_NAME_SIZE = 128;
    public static final String BOOLEAN_EDIT_VALUE = "_NULL_VALUE_";
    static final long serialVersionUID = -5255083189703724489L;

    public Macro() {
        super("", "m", "");
    }

    public Macro(String string) throws ValidationException {
        this();
        this.setKey(string);
    }

    public Macro(String string, String string2) throws ValidationException {
        this(string, string2, "0");
    }

    public Macro(String string, String string2, String string3) throws ValidationException {
        this();
        this.setKey(string);
        this.setValue(string2, false, false);
        this.setSignature(string3);
    }

    public void setKey(String string) throws ValidationException {
        if (string.length() > 128) {
            Object[] objectArray = new Object[]{new Short(128)};
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("macro_key_length"));
            String string2 = messageFormat.format(objectArray);
            throw new ValidationException(string2);
        }
        super.setKey(string);
    }

    public void setValue(String string, boolean bl, boolean bl2) throws ValidationException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = !bl ? n : n2;
        int n5 = 0;
        while (n5 < string.length()) {
            char c = string.charAt(n5);
            if (!bl && n4 == n) {
                if (c != ':' || string.length() == 1) {
                    Object[] objectArray = new Object[]{this.getKey()};
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("mac_syntax_error"));
                    String string2 = messageFormat.format(objectArray);
                    throw new ValidationException(string2);
                }
                n4 = n2;
            } else if (n4 == n2) {
                if (c == '=') {
                    n4 = n3;
                } else if (!bl && c == ':') {
                    if (!bl2) {
                        this.storeOption(stringBuffer.toString(), (Object)stringBuffer2.toString());
                    } else {
                        this.setOption(stringBuffer.toString(), stringBuffer2.toString(), false);
                    }
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    n4 = n2;
                } else {
                    stringBuffer.append(c);
                }
            } else if (n4 == n3) {
                if (bl4) {
                    stringBuffer2.append(c);
                    bl4 = false;
                } else if (c == '\\') {
                    bl4 = true;
                } else if (c == '\"') {
                    bl3 = !bl3;
                    stringBuffer2.append(c);
                } else if (bl3) {
                    stringBuffer2.append(c);
                } else if (!bl && c == ':') {
                    if (!bl2) {
                        this.storeOption(stringBuffer.toString(), (Object)stringBuffer2.toString());
                    } else {
                        this.setOption(stringBuffer.toString(), stringBuffer2.toString(), false);
                    }
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    n4 = n2;
                } else {
                    stringBuffer2.append(c);
                }
            }
            ++n5;
        }
        if (bl) {
            this.setOption(stringBuffer.toString(), stringBuffer2.toString(), true);
            this.valueClean = false;
        } else {
            if (n4 != n2) {
                Object[] objectArray = new Object[]{this.getKey()};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("mac_syntax_error"));
                String string3 = messageFormat.format(objectArray);
                throw new ValidationException(string3);
            }
            super.setValue(string);
            this.valueClean = true;
        }
    }

    public void editOption(String string) throws ValidationException {
        this.setValue(string, true, false);
    }

    private void setOption(String string, String string2, boolean bl) throws ValidationException {
        int n = this.getOptionIndex(string);
        if (string2.length() == 0) {
            if (bl) {
                if (n == -1) {
                    Object[] objectArray = new Object[]{string};
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_option"));
                    String string3 = messageFormat.format(objectArray);
                    throw new ValidationException(string3);
                }
                this.deleteOptionAt(n);
            } else {
                OptionValue optionValue = OptionValueFactory.newOptionValue(string, new String());
                if (optionValue instanceof BogusOptionValue) {
                    Object[] objectArray = new Object[]{string};
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_option"));
                    String string4 = messageFormat.format(objectArray);
                    throw new ValidationException(string4);
                }
                if (!(optionValue instanceof BooleanOptionValue)) {
                    Object[] objectArray = new Object[]{string};
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("not_boolean_option"));
                    String string5 = messageFormat.format(objectArray);
                    throw new ValidationException(string5);
                }
            }
        } else if (bl && string2.equals(BOOLEAN_EDIT_VALUE)) {
            OptionValue optionValue = OptionValueFactory.newOptionValue(string, new String());
            if (optionValue instanceof BogusOptionValue) {
                Object[] objectArray = new Object[]{string};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_option"));
                String string6 = messageFormat.format(objectArray);
                throw new ValidationException(string6);
            }
            if (!(optionValue instanceof BooleanOptionValue)) {
                Object[] objectArray = new Object[]{string};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("not_boolean_option"));
                String string7 = messageFormat.format(objectArray);
                throw new ValidationException(string7);
            }
            if (n == -1) {
                this.storeOption(optionValue);
            }
        } else {
            OptionValue optionValue = OptionValueFactory.newOptionValue(string);
            if (optionValue instanceof BogusOptionValue) {
                Object[] objectArray = new Object[]{string};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_option"));
                String string8 = messageFormat.format(objectArray);
                throw new ValidationException(string8);
            }
            if (bl && optionValue instanceof BooleanOptionValue) {
                Object[] objectArray = new Object[]{string};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("boolean_option"));
                String string9 = messageFormat.format(objectArray);
                throw new ValidationException(string9);
            }
            if (n == -1) {
                this.storeOption(optionValue);
            } else {
                optionValue = this.getOptionAt(n);
            }
            optionValue.setValue(string2);
        }
    }

    public void storeOption(OptionValue optionValue) throws ValidationException {
        this.options.addElement(optionValue);
    }

    public void storeOption(String string, Object object) throws ValidationException {
        this.options.addElement(OptionValueFactory.newOptionValue(string, object));
    }

    public void storeOption(int n, Object object) throws ValidationException {
        this.options.addElement(OptionValueFactory.newOptionValue(StandardOptions.nameForCode(n), object));
    }

    public String getValue() {
        if (!this.valueClean) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                OptionValue optionValue = (OptionValue)enumeration.nextElement();
                if (optionValue == null) continue;
                stringBuffer.append(':');
                stringBuffer.append(optionValue.toString());
            }
            stringBuffer.append(':');
            try {
                super.setValue(stringBuffer.toString());
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            this.valueClean = true;
        }
        return super.getValue();
    }

    public Enumeration elements() {
        return this.options.elements();
    }

    public OptionValue[] getOptions() {
        Object[] objectArray = new OptionValue[this.options.size()];
        this.options.copyInto(objectArray);
        return objectArray;
    }

    public OptionValue getOption(String string) {
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            OptionValue optionValue = (OptionValue)enumeration.nextElement();
            if (!string.equals(optionValue.getName())) continue;
            return optionValue;
        }
        return null;
    }

    public int getOptionIndex(String string) {
        int n = -1;
        boolean bl = false;
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements() && !bl) {
            ++n;
            OptionValue optionValue = (OptionValue)enumeration.nextElement();
            if (!string.equals(optionValue.getName())) continue;
            bl = true;
        }
        if (!bl) {
            n = -1;
        }
        return n;
    }

    public OptionValue getOptionAt(int n) {
        return (OptionValue)this.options.elementAt(n);
    }

    public void setOptionAt(OptionValue optionValue, int n) {
        if (n >= this.options.size()) {
            this.options.setSize(n + 1);
        }
        this.options.setElementAt(optionValue, n);
    }

    public int optionCount() {
        return this.options.size();
    }

    public void deleteOptionAt(int n) {
        if (n >= this.options.size()) {
            return;
        }
        this.options.removeElementAt(n);
    }

    public void insertOptionAt(OptionValue optionValue, int n) {
        this.options.insertElementAt(optionValue, n);
    }

    public Object clone() {
        Macro macro = new Macro();
        macro.key = this.key;
        macro.options = new Vector();
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            OptionValue optionValue = (OptionValue)enumeration.nextElement();
            macro.options.addElement((OptionValue)optionValue.clone());
        }
        macro.signature = this.signature;
        return macro;
    }

    public String toString() {
        return this.getKey() + " m " + this.getValue();
    }

    public void validate() throws ValidationException {
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            OptionValue optionValue = (OptionValue)enumeration.nextElement();
            if (optionValue.isValid()) continue;
            throw new ValidationException(optionValue.getName());
        }
    }
}

