/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.ResourceStrings;
import com.sun.dhcpmgr.data.ValidationException;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class IPAddress
implements Cloneable,
Serializable {
    private byte[] bytes = new byte[]{0, 0, 0, 0};
    static final long serialVersionUID = -7439646692550395242L;

    public IPAddress() {
    }

    public IPAddress(String string) throws ValidationException {
        try {
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (!Character.isDigit(cArray[n2])) {
                    if (cArray[n2] == '.') {
                        if (++n > 3) {
                            this.throwException(string);
                        }
                    } else {
                        InetAddress inetAddress = InetAddress.getByName(string);
                        this.bytes = inetAddress.getAddress();
                        return;
                    }
                }
                ++n2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                short s = Short.parseShort(stringTokenizer.nextToken());
                if (s > 255 || s < 0) {
                    this.throwException(string);
                }
                this.bytes[n3++] = (byte)s;
            }
            if (n3 < 4) {
                this.throwException(string);
            }
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Throwable throwable) {
            throw new ValidationException(throwable.getMessage());
        }
    }

    public IPAddress(InetAddress inetAddress) {
        this.bytes = inetAddress.getAddress();
    }

    public IPAddress(int n) {
        this.bytes = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            this.bytes[n2] = (byte)(n >> 8 * (3 - n2) & 0xFF);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            if (n != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.bytes[n] & 0xFF);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int intValue() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            n |= (this.bytes[n2] & 0xFF) << 8 * (3 - n2);
            ++n2;
        }
        return n;
    }

    public String getHostName() {
        try {
            return InetAddress.getByName(this.toString()).getHostName();
        }
        catch (Throwable throwable) {
            return this.toString();
        }
    }

    public byte[] getAddress() {
        return this.bytes;
    }

    public String getHostAddress() {
        return this.toString();
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object == null) {
            return false;
        }
        if (object instanceof InetAddress) {
            byArray = ((InetAddress)object).getAddress();
        } else if (object instanceof IPAddress) {
            byArray = ((IPAddress)object).getAddress();
        } else {
            return false;
        }
        if (byArray.length != this.bytes.length) {
            return false;
        }
        int n = 0;
        while (n < this.bytes.length) {
            if (byArray[n] != this.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object clone() {
        IPAddress iPAddress = new IPAddress();
        iPAddress.bytes = (byte[])this.bytes.clone();
        return iPAddress;
    }

    public long getBinaryAddress() {
        byte[] byArray = this.getAddress();
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l |= ((long)byArray[n] & 0xFFL) << 24 - n * 8;
            ++n;
        }
        return l;
    }

    private void throwException(String string) throws ValidationException {
        Object[] objectArray = new Object[]{string};
        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_ip_address"));
        String string2 = messageFormat.format(objectArray);
        throw new ValidationException(string2);
    }
}

