/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.DhcpConfigOpts;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcpResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class DhcpdOptions
implements DhcpConfigOpts,
Serializable {
    private static final Integer[] loggingFacilities = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7)};
    private ArrayList options;

    public DhcpdOptions() {
        this.options = new ArrayList();
    }

    public DhcpdOptions(DhcpResource[] dhcpResourceArray) {
        this.options = new ArrayList<DhcpResource>(Arrays.asList(dhcpResourceArray));
    }

    public Object clone() {
        DhcpdOptions dhcpdOptions = new DhcpdOptions();
        dhcpdOptions.options = (ArrayList)this.options.clone();
        return dhcpdOptions;
    }

    private boolean isSet(String string) {
        DhcpResource dhcpResource = new DhcpResource();
        dhcpResource.setKey(string);
        return this.options.contains(dhcpResource);
    }

    private void set(String string, String string2) {
        this.set(string, string2, false);
    }

    public void set(String string, String string2, boolean bl) {
        DhcpResource dhcpResource = new DhcpResource(string, string2, bl);
        int n = this.options.indexOf(dhcpResource);
        if (n != -1) {
            this.options.set(n, dhcpResource);
        } else {
            this.options.add(dhcpResource);
        }
    }

    private void clear(String string) {
        DhcpResource dhcpResource = new DhcpResource();
        dhcpResource.setKey(string);
        int n = this.options.indexOf(dhcpResource);
        if (n != -1) {
            this.options.remove(n);
        }
    }

    private String valueOf(String string) {
        DhcpResource dhcpResource = new DhcpResource();
        dhcpResource.setKey(string);
        int n = this.options.indexOf(dhcpResource);
        if (n != -1) {
            return ((DhcpResource)this.options.get(n)).getValue();
        }
        return null;
    }

    public Object[] getAll() {
        return this.options.toArray();
    }

    public boolean isDaemonEnabled() {
        return "TRUE".equals(this.valueOf("DAEMON_ENABLED"));
    }

    public void setDaemonEnabled(boolean bl) {
        this.set("DAEMON_ENABLED", bl ? "TRUE" : "FALSE");
    }

    public void setDhcpDatastore(String string, String string2, String string3, int n) {
        this.setResource(string);
        this.setPath(string2);
        this.setConfig(string3);
        this.setResourceVersion(n);
    }

    public void setDhcpDatastore(DhcpDatastore dhcpDatastore) {
        this.setResource(dhcpDatastore.getResource());
        this.setPath(dhcpDatastore.getLocation());
        this.setConfig(dhcpDatastore.getConfig());
        this.setResourceVersion(dhcpDatastore.getVersion());
    }

    public DhcpDatastore getDhcpDatastore() {
        return new DhcpDatastore(this.getResource(), this.getPath(), this.getConfig(), this.getResourceVersion());
    }

    public void setResource(String string) {
        this.set("RUN_MODE", "server");
        this.set("RESOURCE", string);
    }

    public String getResource() {
        return this.valueOf("RESOURCE");
    }

    public void setResourceVersion(int n) {
        this.set("CONVER", Integer.toString(n));
    }

    public int getResourceVersion() {
        try {
            return Integer.parseInt(this.valueOf("CONVER"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setPath(String string) {
        this.set("RUN_MODE", "server");
        this.set("PATH", string);
    }

    public String getPath() {
        return this.valueOf("PATH");
    }

    public void setConfig(String string) {
        if (string != null) {
            this.set("RESOURCE_CONFIG", string);
        } else {
            this.clear("RESOURCE_CONFIG");
        }
    }

    public String getConfig() {
        return this.valueOf("RESOURCE_CONFIG");
    }

    public void setHostsResource(String string) {
        this.set("HOSTS_RESOURCE", string);
    }

    public String getHostsResource() {
        return this.valueOf("HOSTS_RESOURCE");
    }

    public void setHostsDomain(String string) {
        this.set("HOSTS_DOMAIN", string);
    }

    public String getHostsDomain() {
        return this.valueOf("HOSTS_DOMAIN");
    }

    public boolean isBootpCompatible() {
        return this.isSet("BOOTP_COMPAT");
    }

    public void setBootpCompatible(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                this.set("BOOTP_COMPAT", "automatic");
            } else {
                this.set("BOOTP_COMPAT", "manual");
            }
        } else {
            this.clear("BOOTP_COMPAT");
        }
    }

    public boolean isBootpAutomatic() {
        return "automatic".equals(this.valueOf("BOOTP_COMPAT"));
    }

    public boolean isRelayHops() {
        return this.isSet("RELAY_HOPS");
    }

    public void setRelayHops(boolean bl, Integer n) {
        if (bl) {
            this.set("RELAY_HOPS", n.toString());
        } else {
            this.clear("RELAY_HOPS");
        }
    }

    public Integer getRelayHops() {
        String string = this.valueOf("RELAY_HOPS");
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public boolean isInterfaces() {
        return this.isSet("INTERFACES");
    }

    public void setInterfaces(boolean bl, String string) {
        if (bl) {
            this.set("INTERFACES", string);
        } else {
            this.clear("INTERFACES");
        }
    }

    public String getInterfaces() {
        return this.valueOf("INTERFACES");
    }

    public boolean isICMPVerify() {
        return !"FALSE".equals(this.valueOf("ICMP_VERIFY"));
    }

    public void setICMPVerify(boolean bl) {
        this.set("ICMP_VERIFY", bl ? "TRUE" : "FALSE");
    }

    public boolean isOfferTtl() {
        return this.isSet("OFFER_CACHE_TIMEOUT");
    }

    public void setOfferTtl(boolean bl, Integer n) {
        if (bl) {
            this.set("OFFER_CACHE_TIMEOUT", n.toString());
        } else {
            this.clear("OFFER_CACHE_TIMEOUT");
        }
    }

    public Integer getOfferTtl() {
        String string = this.valueOf("OFFER_CACHE_TIMEOUT");
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public boolean isRelay() {
        return "relay".equals(this.valueOf("RUN_MODE"));
    }

    public void setRelay(boolean bl, String string) {
        if (bl) {
            this.set("RUN_MODE", "relay");
            this.set("RELAY_DESTINATIONS", string);
        } else {
            this.set("RUN_MODE", "server");
            this.clear("RELAY_DESTINATIONS");
        }
    }

    public String getRelay() {
        return this.valueOf("RELAY_DESTINATIONS");
    }

    public boolean isRescan() {
        return this.isSet("RESCAN_INTERVAL");
    }

    public void setRescan(boolean bl, Integer n) {
        if (bl) {
            this.set("RESCAN_INTERVAL", n.toString());
        } else {
            this.clear("RESCAN_INTERVAL");
        }
    }

    public Integer getRescan() {
        String string = this.valueOf("RESCAN_INTERVAL");
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public boolean isDnsUpdated() {
        return this.isSet("UPDATE_TIMEOUT");
    }

    public void setDnsTimeout(boolean bl, Integer n) {
        if (bl) {
            this.set("UPDATE_TIMEOUT", n.toString());
        } else {
            this.clear("UPDATE_TIMEOUT");
        }
    }

    public Integer getDnsTimeout() {
        String string = this.valueOf("UPDATE_TIMEOUT");
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public boolean isVerbose() {
        return "TRUE".equals(this.valueOf("VERBOSE"));
    }

    public void setVerbose(boolean bl) {
        this.set("VERBOSE", bl ? "TRUE" : "FALSE");
    }

    public boolean isLogging() {
        return this.isSet("LOGGING_FACILITY");
    }

    public Integer getLogging() {
        String string = this.valueOf("LOGGING_FACILITY");
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public void setLogging(boolean bl, Integer n) {
        if (bl) {
            this.set("LOGGING_FACILITY", n.toString());
        } else {
            this.clear("LOGGING_FACILITY");
        }
    }

    public static Integer[] getLoggingFacilities() {
        return loggingFacilities;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.options.size()) {
            DhcpResource dhcpResource = (DhcpResource)this.options.get(n);
            stringBuffer.append(dhcpResource.getKey());
            String string = dhcpResource.getValue();
            if (string != null) {
                stringBuffer.append('=');
                stringBuffer.append(string);
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }
}

