/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;
import java.util.Enumeration;
import java.util.Vector;

public class AsciiOptionValue
extends OptionValue {
    private String name;
    private String value;
    private boolean valid;
    static final long serialVersionUID = -4937655446360683504L;

    protected AsciiOptionValue(String string) {
        this.name = string;
        this.value = null;
        this.valid = false;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.value.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\\' || cArray[n] == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setValue(Object object) throws ValidationException {
        Object object2;
        Option option = OptionsTable.getTable().get(this.name);
        if (option == null) {
            object2 = new Object[]{this.name};
            this.throwException("invalid_option", (Object[])object2);
        }
        if (object instanceof String) {
            Object[] objectArray;
            object2 = (Object[])object;
            if (object2.startsWith("\"") ^ object2.endsWith("\"")) {
                objectArray = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
                this.throwException("invalid_option_value", objectArray);
            }
            if (object2.startsWith("\"")) {
                object2 = object2.substring(1, object2.length() - 1);
            }
            if (object2.length() == 0) {
                objectArray = new Object[]{this.name, Option.getTypeDhcptabString(option.getType())};
                this.throwException("invalid_option_value", objectArray);
            }
            if (option.getMaximum() != 0 && object2.length() > option.getMaximum()) {
                objectArray = new Object[]{this.name, Integer.toString(option.getMaximum())};
                this.throwException("invalid_option_maximum", objectArray);
            }
            this.value = object2;
            this.valid = true;
        } else if (object instanceof Vector) {
            object2 = new StringBuffer();
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                if (object2.length() != 0) {
                    object2.append(' ');
                }
                object2.append(enumeration.nextElement().toString());
            }
            this.setValue(object2.toString());
        } else {
            this.setValue(object.toString());
        }
    }

    public String toString() {
        return this.getName() + "=\"" + this.getValue() + "\"";
    }

    public boolean isValid() {
        return this.valid;
    }

    public Object clone() {
        AsciiOptionValue asciiOptionValue = new AsciiOptionValue(this.name);
        asciiOptionValue.value = this.value;
        asciiOptionValue.valid = this.valid;
        return asciiOptionValue;
    }
}

