/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserDefaults
extends Hashtable {
    static ResourceBundle bundle;
    private int indent = 0;
    private boolean needExtraLine = false;

    public static String getMessage(String key) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public void add(String key, Object value) {
        this.put(key, value);
    }

    public void add(String key, Float f) {
        Double value = new Double(f.floatValue());
        this.put(key, value);
    }

    public void add(String key, Integer i) {
        Long value = new Long(i.intValue());
        this.put(key, value);
    }

    public void add(String key, Byte b) {
        Long value = new Long(b.byteValue());
        this.put(key, value);
    }

    public void add(String key, Short s) {
        Long value = new Long(s.shortValue());
        this.put(key, value);
    }

    public void add(String key, Boolean b) {
        String value = b.toString();
        this.put(key, value);
    }

    public void add(String key, Object[] o) {
        UserDefaults.convertArray(o);
        this.put(key, o);
    }

    public void remove(String key) {
        super.remove(key);
    }

    public boolean searchForKey(String key) {
        return this.contains(key);
    }

    public String typeOfKey(String key) {
        Object v = this.get(key);
        if (v != null) {
            return v.getClass().getName();
        }
        return null;
    }

    public Object objectForKey(String key) {
        return this.get(key);
    }

    public Object[] arrayForKey(String key) {
        Object value = this.get(key);
        if (value != null && value.getClass().isArray()) {
            return (Object[])value;
        }
        return null;
    }

    public Dictionary dictForKey(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Dictionary) {
            return (Dictionary)value;
        }
        return null;
    }

    public Long longForKey(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    public String stringForKey(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Double doubleForKey(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    public void saveToTextFile(String filename, boolean backup) {
        File file = new File(filename);
        File path = new File(file.getPath());
        if (file.exists()) {
            if (backup) {
                File bakFile = new File(filename + ".bak");
                file.renameTo(bakFile);
            } else {
                file.delete();
            }
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            this.writeDict(out, this);
            out.close();
        }
        catch (IOException e) {
            System.err.println(UserDefaults.getMessage("userdefaults.error_writing_to_file_'") + file.toString() + "'.");
        }
    }

    public void saveToBinaryFile(String filename, boolean backup) {
        File file = new File(filename);
        if (file.exists()) {
            if (backup) {
                File bakFile = new File(filename + ".bak");
                file.renameTo(bakFile);
            } else {
                file.delete();
            }
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(this);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.err.println(UserDefaults.getMessage("userdefaults.error_writing_to_file_'") + file.toString() + "'.");
        }
    }

    static UserDefaults readFromBinaryFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                UserDefaults userdefs = (UserDefaults)in.readObject();
                in.close();
                return userdefs;
            }
            catch (IOException e) {
                System.err.println(UserDefaults.getMessage("userdefaults.error_reading_from_'") + file.toString() + "'.");
            }
            catch (ClassNotFoundException e) {
                System.err.println(UserDefaults.getMessage("userdefaults.file_is_corrupted:_'") + file.toString() + "'");
            }
        }
        return null;
    }

    static UserDefaults readFromTextFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            try {
                StreamTokenizer scanner = new StreamTokenizer(new FileReader(file));
                scanner.commentChar(39);
                scanner.commentChar(35);
                scanner.commentChar(33);
                scanner.resetSyntax();
                scanner.parseNumbers();
                scanner.wordChars(65, 90);
                scanner.wordChars(95, 95);
                scanner.wordChars(97, 122);
                scanner.wordChars(47, 47);
                scanner.whitespaceChars(0, 32);
                scanner.quoteChar(34);
                scanner.ordinaryChar(40);
                scanner.ordinaryChar(41);
                scanner.ordinaryChar(123);
                scanner.ordinaryChar(125);
                scanner.ordinaryChar(59);
                scanner.ordinaryChar(61);
                return UserDefaults.parseDictionary(scanner, filename);
            }
            catch (IOException e) {
                System.err.println("Error opening file '" + filename + "'.");
            }
        }
        return null;
    }

    private static void convertArray(Object[] o) {
        int l = o.length;
        if (l != 0) {
            int i = 0;
            while (i < l) {
                Object n;
                if (o[i] instanceof Float) {
                    o[i] = n = new Double(((Float)o[i]).floatValue());
                }
                if (o[i] instanceof Integer) {
                    o[i] = n = new Long(((Integer)o[i]).intValue());
                }
                if (o[i] instanceof Byte) {
                    o[i] = n = new Long(((Byte)o[i]).byteValue());
                }
                if (o[i] instanceof Short) {
                    o[i] = n = new Long(((Short)o[i]).shortValue());
                }
                if (o[i] instanceof Boolean) {
                    o[i] = n = new String(((Boolean)o[i]).toString());
                }
                if (o[i].getClass().isArray()) {
                    UserDefaults.convertArray((Object[])o[i]);
                }
                ++i;
            }
        }
    }

    private void nextLineAndIndent(PrintWriter out) {
        out.println("");
        int j = 0;
        while (j < this.indent / 8) {
            out.print("\t");
            ++j;
        }
        int j2 = 0;
        while (j2 < this.indent - this.indent / 8 * 8) {
            out.print(" ");
            ++j2;
        }
    }

    private void writeObject(PrintWriter out, Object value, boolean arrayElement) {
        if (value instanceof Dictionary) {
            boolean empty = ((Dictionary)value).isEmpty();
            if (arrayElement & !empty) {
                if (!this.needExtraLine) {
                    this.indent += 4;
                }
                this.nextLineAndIndent(out);
                this.needExtraLine = true;
            }
            out.print("{");
            if (!empty) {
                out.println("");
                this.indent += 4;
                this.writeDict(out, (Dictionary)value);
                this.indent -= 4;
            }
            if (this.needExtraLine) {
                this.nextLineAndIndent(out);
            }
            out.print("}");
            return;
        }
        if (value.getClass().isArray()) {
            boolean firstTime = true;
            out.print("(");
            Object[] arrValue = (Object[])value;
            this.needExtraLine = false;
            int i = 0;
            while (i < arrValue.length) {
                if (!firstTime) {
                    out.print(", ");
                } else {
                    firstTime = false;
                }
                this.writeObject(out, arrValue[i], true);
                ++i;
            }
            if (this.needExtraLine) {
                this.indent -= 4;
                this.nextLineAndIndent(out);
            }
            out.print(")");
            return;
        }
        if (value instanceof Double) {
            out.println((Double)value);
            return;
        }
        if (value instanceof Long) {
            out.print((Long)value);
            return;
        }
        if (value instanceof String) {
            String str = UserDefaults.toPrintable((String)value);
            if (UserDefaults.quotesNeeded(str)) {
                str = "\"" + str + "\"";
            }
            out.print(str);
            return;
        }
        if (value instanceof DownloadProperties) {
            DownloadProperties dp = (DownloadProperties)value;
            out.print(dp);
            return;
        }
        System.err.println(UserDefaults.getMessage("userdefaults.unrecognized_data_type:_`") + value.getClass().getName() + "`");
    }

    private void writeDict(PrintWriter out, Dictionary dict) {
        Vector sortedKeys = UserDefaults.sortKeys(dict.keys());
        int i = 0;
        while (i < sortedKeys.size()) {
            String key = UserDefaults.toPrintable((String)sortedKeys.elementAt(i));
            Object value = dict.get(key);
            if (UserDefaults.quotesNeeded(key)) {
                key = "\"" + key + "\"";
            }
            int j = 0;
            while (j < this.indent / 8) {
                out.print("\t");
                ++j;
            }
            int j2 = 0;
            while (j2 < this.indent - this.indent / 8 * 8) {
                out.print(" ");
                ++j2;
            }
            out.print(key + " = ");
            this.writeObject(out, value, false);
            out.println(";");
            ++i;
        }
    }

    private static boolean quotesNeeded(String str) {
        if (str.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < str.length()) {
            char Ch = str.charAt(i);
            if (!(Ch >= 'a' && Ch <= 'z' || Ch >= 'A' && Ch <= 'Z' || i > 0 && Ch >= '0' && Ch <= '9' || Ch == '_' || Ch == '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String toPrintable(String str) {
        StringBuffer tmp = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char Ch = str.charAt(i);
            if (Ch == '\n') {
                tmp.append("\\n");
            } else if (Ch == '\\') {
                tmp.append("\\\\");
            } else if (Ch < ' ' || Ch >= '\u007f') {
                String oct = Integer.toOctalString(Ch);
                tmp.append("\\");
                int j = 0;
                while (j < 3 - oct.length()) {
                    tmp.append("0");
                    ++j;
                }
                tmp.append(oct);
            } else {
                tmp.append(Ch);
            }
            ++i;
        }
        return tmp.toString();
    }

    private static Vector sortKeys(Enumeration e) {
        Vector keys = new Vector();
        while (e.hasMoreElements()) {
            keys.addElement(e.nextElement());
        }
        UserDefaults.quickSort(keys, 0, keys.size() - 1);
        return keys;
    }

    private static void quickSort(Vector v, int l, int r) {
        int i = l;
        int j = r;
        String x = (String)v.elementAt(l + r >> 1);
        while (true) {
            if (x.compareTo((String)v.elementAt(i)) > 0) {
                ++i;
                continue;
            }
            while (x.compareTo((String)v.elementAt(j)) < 0) {
                --j;
            }
            if (i <= j) {
                String y = (String)v.elementAt(i);
                v.setElementAt(v.elementAt(j), i++);
                v.setElementAt(y, j--);
            }
            if (i > j) break;
        }
        if (l < j) {
            UserDefaults.quickSort(v, l, j);
        }
        if (i < r) {
            UserDefaults.quickSort(v, i, r);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getValue(StreamTokenizer scanner, String filename) {
        Object[] ret = null;
        try {
            int token = scanner.nextToken();
            switch (token) {
                case -3: 
                case 34: {
                    return scanner.sval;
                }
                case -2: {
                    if ((double)Math.round(scanner.nval) == scanner.nval) {
                        Long longVal = new Long(Math.round(scanner.nval));
                        return longVal;
                    }
                    Double dblVal = new Double(scanner.nval);
                    return dblVal;
                }
                case 40: {
                    Vector<Object> vector = new Vector<Object>();
                    do {
                        Object obj;
                        if ((obj = UserDefaults.getValue(scanner, filename)) != null) {
                            vector.addElement(obj);
                        }
                        if ((token = scanner.nextToken()) != 41) continue;
                        Object[] arrVal = new Object[vector.size()];
                        vector.copyInto(arrVal);
                        return arrVal;
                    } while (token == 44);
                    System.err.println(filename + ": " + scanner.lineno() + " Error: ')' or ',' expected. Got: " + token + ".");
                    return null;
                }
                case 123: {
                    scanner.pushBack();
                    UserDefaults dictValue = UserDefaults.parseDictionary(scanner, filename);
                    if (dictValue != null) return dictValue;
                    return null;
                }
                case 41: {
                    scanner.pushBack();
                    return null;
                }
            }
            System.err.println(filename + ": " + scanner.lineno() + " Error: unrecognized token. Got: " + token + ".");
            return null;
        }
        catch (IOException e) {
            System.err.println(filename + ": Error reading file.");
            return null;
        }
    }

    private static UserDefaults parseDictionary(StreamTokenizer scanner, String filename) {
        UserDefaults dict = new UserDefaults();
        boolean needCloseBrace = false;
        try {
            int token = scanner.nextToken();
            if (token == 123) {
                needCloseBrace = true;
            } else {
                scanner.pushBack();
            }
            while (true) {
                String key;
                token = scanner.nextToken();
                switch (token) {
                    case -3: 
                    case 34: {
                        key = scanner.sval;
                        break;
                    }
                    case -1: {
                        if (needCloseBrace) {
                            System.err.println(filename + ": " + scanner.lineno() + UserDefaults.getMessage("userdefaults.error:_'}'_expected_dot_"));
                            return null;
                        }
                        return dict;
                    }
                    case 125: {
                        if (!needCloseBrace) {
                            System.err.println(filename + ": " + scanner.lineno() + UserDefaults.getMessage("userdefaults.error:_'}'_unexpected_dot_"));
                            return null;
                        }
                        return dict;
                    }
                    default: {
                        System.err.println(filename + ": " + scanner.lineno() + UserDefaults.getMessage("userdefaults.error:_string_expected_dot__got") + token + ".");
                        return null;
                    }
                }
                token = scanner.nextToken();
                if (token != 61) {
                    System.err.println(filename + ": " + scanner.lineno() + UserDefaults.getMessage("userdefaults.error:_'_equals_'_expected_dot_"));
                    return null;
                }
                Object value = UserDefaults.getValue(scanner, filename);
                if (value == null) {
                    return null;
                }
                token = scanner.nextToken();
                if (token != 59) {
                    System.err.println(filename + ": " + scanner.lineno() + UserDefaults.getMessage("userdefaults.error:_';'_expected_dot__got:") + token + ".");
                    return null;
                }
                dict.put(key, value);
            }
        }
        catch (IOException e) {
            System.err.println(filename + UserDefaults.getMessage("userdefaults.:_error_reading_file_dot_"));
            return null;
        }
    }
}

