/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TabbedPropertiesDialog
extends JDialog
implements Runnable,
ListCallbackInt {
    JFrame parent;
    JTabbedPane tabbedPane;
    JButton okButton;
    JButton applyButton;
    JButton cancelButton;
    TabbedPropertiesDialog propDialog;
    FontDownloaderMainFrame fdl;
    final Dimension labelvpad = new Dimension(1, 10);
    static int TAB_INDEX_0 = 0;
    static int TAB_INDEX_1 = 1;
    static int TAB_INDEX_2 = 2;
    int WIDTH = new Integer(this.getMessage("dimensions.tabbedpropertiesdialog_width"));
    int HEIGHT = new Integer(this.getMessage("dimensions.tabbedpropertiesdialog_height"));
    static int BUTTON_PADDING = 12;
    final int BUTTON_WIDTH = new Integer(this.getMessage("dimensions.controlbuttonwidth"));
    final int BUTTON_HEIGHT = new Integer(this.getMessage("dimensions.controlbuttonheight"));
    static int PADDING_LEFT = 12;
    public static int COL1_WIDTH = 150;
    public static int COL2_WIDTH = 60;
    DefaultListSelectionModel rowSelector;
    PrinterTable fontListTable;
    JTableHeader header = null;
    TableModel tm;
    SortableTable sortableModel;
    Vector columnIds;
    TableColumn col1;
    TableColumn col2;
    TableColumn col3;
    JScrollPane CIDScroll;
    JButton removeCIDFont;
    FontDownloaderList cidList;
    JLabel cidLabel;
    public DefaultListModel dlmCID;
    JScrollPane CMapScroll;
    JButton removeCmap;
    FontDownloaderList cmapList;
    JLabel cmapLabel;
    public DefaultListModel dlmCMAP;
    JPanel generalPanel;
    JPanel fontPanel;
    JPanel advancedPanel;
    public DefaultListModel defListModel;
    JLabel diskSizeLabel;
    JLabel availDiskLabel;
    JLabel totalRamLabel;
    PropertiesTextPanel psInterpreter;
    PropertiesTextPanel psLevel;
    PropertiesTextPanel type42Fonts;
    PropertiesTextPanel type11Fonts;
    PropertiesTextPanel totalMemory;
    PropertiesTextPanel numDisks;
    PropertiesTextPanel diskSize;
    PropertiesTextPanel availDisk;
    PropertiesTextPanel product;
    PropertiesTextPanel totalPages;
    public Boolean isOpened = new Boolean(false);
    ButtonGroup buttongroup;
    JRadioButton decButton;
    JRadioButton hexButton;
    JComboBox paperChoice;
    JLabel exitPasswdLabel;
    JLabel fontListStatus;
    JPanel statusPanel;
    JButton printSampleButton;
    JButton printListButton;
    JButton removeFontButton;
    JScrollPane fontListScrollPane;
    JTextField exitServerPasswdTextfield;
    JButton formatDiskButton;
    String PSINTERPRETER = "PSINTERPRETER";
    String PSLEVEL = "PSLEVEL";
    String TYPE42SUPPORT = "TYPE42SUPPORT";
    String TOTALMEM = "TOTALMEM";
    String AVAILMEM = "AVAILMEM";
    String NUMDISKS = "NUMDISKS";
    String DISKSIZE = "DISKSIZE";
    String EMPTY_STRING = "                                                ";
    boolean controlkey = false;
    PrinterProperties prtProps;
    JProgressBar statusBar;
    ProgressMonitorDialog pmd;
    Boolean gotPropsFlag;
    boolean printerPropertiesStatus = false;
    boolean firstTimeFlag;
    private static final int NO_ERROR = 0;
    private static final int ERR_DRIVER = 1;
    private static final int ERR_TIMEOUT = 2;
    private static final int ERR_FORMAT = 3;
    int errCode = 0;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public TabbedPropertiesDialog(JFrame parent, PrinterProperties prtProps) {
        super((Frame)parent, true);
        this.setTitle(this.getMessage("tabbedpropertiesdialog.printer_properties"));
        this.prtProps = prtProps;
        this.parent = parent;
        this.fdl = (FontDownloaderMainFrame)parent;
        this.propDialog = this;
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(this.WIDTH, this.HEIGHT);
        Dimension dim = parent.getSize();
        this.setLocation(parent.getLocation().x, parent.getLocation().y + dim.height);
        this.createPropsDialog();
        RepaintManager repaintManager = RepaintManager.currentManager(this.tabbedPane);
        if (!repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        this.gotPropsFlag = new Boolean(false);
        this.fdl.setBusy(true);
        this.fdl.prtList.prtTable.setBusy(true);
        this.columnIds = new Vector();
        this.columnIds.addElement(new String(this.getMessage("tabbedpropertiesdialog.name")));
        this.columnIds.addElement(new String(this.getMessage("tabbedpropertiesdialog.type")));
        this.columnIds.addElement(new String(this.getMessage("tabbedpropertiesdialog.location")));
        this.sortableModel.setColumnIdentifiers(this.columnIds);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < TabbedPropertiesDialog.this.WIDTH || windim.height < TabbedPropertiesDialog.this.HEIGHT) {
                    TabbedPropertiesDialog.this.setSize(TabbedPropertiesDialog.this.WIDTH, TabbedPropertiesDialog.this.HEIGHT);
                }
            }
        });
        if (this.cancelButton != null) {
            this.cancelButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TabbedPropertiesDialog.this.cancelButton.doClick();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }
        if (this.okButton != null) {
            this.okButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TabbedPropertiesDialog.this.okButton.doClick();
                }
            }, KeyStroke.getKeyStroke(10, 2), 2);
        }
    }

    public void FillTable() {
        if (this.fdl.prtProps.allFonts != null) {
            Vector printerData = new Vector();
            int i = 0;
            while (i < this.fdl.prtProps.allFonts.length) {
                String where;
                String prtType;
                Vector<String> record = new Vector<String>();
                String printername = this.fdl.prtProps.allFonts[i].name;
                switch (this.fdl.prtProps.allFonts[i].type) {
                    case 0: {
                        prtType = this.getMessage("tabbedpropertiesdialog.postscript_composite");
                        break;
                    }
                    case 1: 
                    case 4: {
                        prtType = this.getMessage("tabbedpropertiesdialog.postscript");
                        break;
                    }
                    case 2: {
                        prtType = this.getMessage("tabbedpropertiesdialog.truetype");
                        break;
                    }
                    case 3: {
                        prtType = this.getMessage("tabbedpropertiesdialog.aries");
                        break;
                    }
                    default: {
                        prtType = this.getMessage("tabbedpropertiesdialog.unknown");
                    }
                }
                switch (this.fdl.prtProps.allFonts[i].where) {
                    case 0: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_0");
                        break;
                    }
                    case 1: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_1");
                        break;
                    }
                    case 2: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_2");
                        break;
                    }
                    case 3: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_3");
                        break;
                    }
                    case 4: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_4");
                        break;
                    }
                    case 5: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_5");
                        break;
                    }
                    case 6: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_6");
                        break;
                    }
                    case 7: {
                        where = this.getMessage("tabbedpropertiesdialog.scsi_disk_7");
                        break;
                    }
                    case 8: {
                        where = this.getMessage("tabbedpropertiesdialog.disk");
                        break;
                    }
                    case 9: {
                        where = this.getMessage("tabbedpropertiesdialog.ram");
                        break;
                    }
                    case 10: {
                        where = this.getMessage("tabbedpropertiesdialog.rom");
                        break;
                    }
                    case 11: {
                        where = this.getMessage("tabbedpropertiesdialog.unkown");
                        break;
                    }
                    default: {
                        where = this.getMessage("tabbedpropertiesdialog.unrecognized");
                    }
                }
                record.addElement(printername);
                record.addElement(prtType);
                record.addElement(where);
                printerData.addElement(record);
                ++i;
            }
            this.sortableModel.setDataVector(printerData, this.columnIds);
            this.fontListTable.setBackground(Color.white);
            this.rowSelector.setSelectionInterval(0, 0);
            Vector<Vector> tempPrinterList = this.sortableModel.getDataVector();
            this.sortableModel.setUnsortedDataVector(tempPrinterList);
        }
        if (this.sortableModel.getRowCount() > 0) {
            this.printSampleButton.setEnabled(true);
            this.printListButton.setEnabled(true);
        } else {
            this.printSampleButton.setEnabled(false);
            this.printListButton.setEnabled(false);
        }
        int selectedRow = this.fontListTable.getSelectedRow();
        String where = (String)this.sortableModel.getValueAt(selectedRow, 2);
        if (where.equals(this.getMessage("tabbedpropertiesdialog.rom"))) {
            this.removeFontButton.setEnabled(false);
        } else {
            this.removeFontButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FontDownloaderMainFrame fdl = (FontDownloaderMainFrame)this.parent;
        JProgressBar pbar = fdl.statusPanel.getProgressBar();
        pbar.setMaximum(100);
        int i = 0;
        i = 10;
        while (i < 100) {
            pbar.invalidate();
            pbar.setValue(i);
            fdl.statusPanel.validate();
            Boolean bl = this.gotPropsFlag;
            synchronized (bl) {
                if (this.gotPropsFlag.booleanValue()) {
                    pbar.invalidate();
                    pbar.setValue(100);
                    fdl.statusPanel.validate();
                    break;
                }
            }
            try {
                Thread.sleep(FontDownloaderMainFrame.CTimeOut * 1000 / 18);
            }
            catch (Exception ie) {
                // empty catch block
            }
            i += 5;
        }
        if (!this.gotPropsFlag.booleanValue()) {
            this.errCode = 2;
        }
        String status = this.printerPropertiesStatus ? this.getMessage("tabbedpropertiesdialog.printer_properties_have_successfully_been_read") : this.getMessage("tabbedpropertiesdialog.error_reading_printer_properties");
        this.firstTimeFlag = true;
        fdl.statusPanel.displayStatus(status);
        pbar.setValue(0);
        fdl.setBusy(false);
        fdl.prtList.prtTable.setBusy(false);
        fdl.validate();
        this.setVisible(true);
    }

    public void show() {
        FontDownloaderMainFrame fdl = (FontDownloaderMainFrame)this.parent;
        switch (this.errCode) {
            case 0: {
                this.firstTimeFlag = true;
                this.displayGeneralProperties();
                this.FillTable();
                if (fdl.prtProps.CIDFontArray != null && fdl.prtProps.CIDFontArray.length > 0) {
                    JPanel CIDFontPanel = this.createCIDFontPanel();
                    this.tabbedPane.addTab(this.getMessage("tabbedpropertiesdialog.cid_fonts"), CIDFontPanel);
                }
                if (fdl.prtProps.CMAPArray != null && fdl.prtProps.CMAPArray.length > 0) {
                    JPanel CMapFilesPanel = this.createCMapFilesPanel();
                    this.tabbedPane.addTab(this.getMessage("tabbedpropertiesdialog.cmap_files"), CMapFilesPanel);
                }
                this.tabbedPane.addTab(this.getMessage("tabbedpropertiesdialog.advanced"), this.advancedPanel);
                this.tabbedPane.setSize(this.WIDTH, this.HEIGHT - 40);
                this.tabbedPane.setSelectedIndex(TAB_INDEX_0);
                if (fdl.prtProps.getNumDisks() == 0) {
                    this.formatDiskButton.setEnabled(false);
                }
                super.show();
                return;
            }
            case 1: {
                JOptionPane.showMessageDialog(this.propDialog, fdl.prtProps.errorMsg, this.getMessage("tabbedpropertiesdialog.error"), 0);
                fdl.statusPanel.displayStatus(fdl.prtProps.errorMsg);
                return;
            }
            case 2: {
                JOptionPane.showMessageDialog(this.propDialog, this.getMessage("tabbedpropertiesdialog.could_not_get_printer_properties_-_operation_timed_out"), this.getMessage("tabbedpropertiesdialog.error"), 0);
                fdl.statusPanel.displayStatus(this.getMessage("tabbedpropertiesdialog.could_not_get_printer_properties_-_operation_timed_out"));
                return;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.propDialog, this.getMessage("tabbedpropertiesdialog.printer_returned_unrecognized_information"), this.getMessage("tabbedpropertiesdialog.error"), 0);
                fdl.statusPanel.displayStatus(this.getMessage("tabbedpropertiesdialog.printer_returned_unrecognized_information"));
                return;
            }
        }
        JOptionPane.showMessageDialog(this.propDialog, this.getMessage("tabbedpropertiesdialog.font_downloader_internal_error"), this.getMessage("tabbedpropertiesdialog.error"), 0);
        fdl.statusPanel.displayStatus(this.getMessage("tabbedpropertiesdialog.font_downloader_internal_error"));
    }

    public void SetSelectedCount(int numElements) {
        if (this.cidList != null && this.cidList.hasFocus()) {
            if (this.cidList.getSelectedIndex() == -1) {
                this.removeCIDFont.setEnabled(false);
            } else {
                this.removeCIDFont.setEnabled(true);
            }
        }
        if (this.cmapList != null && this.cmapList.hasFocus()) {
            if (this.cmapList.getSelectedIndex() == -1) {
                this.removeCmap.setEnabled(false);
            } else {
                this.removeCmap.setEnabled(true);
            }
        }
    }

    public void MouseDoubleClicked() {
    }

    public void getPrinterProperties() {
        this.gotPropsFlag = new Boolean(false);
        GetPrinterPropertiesThread gp = new GetPrinterPropertiesThread();
        gp.start();
    }

    boolean displayGeneralProperties() {
        String psVersion = this.fdl.prtProps.getPSVersion();
        String psLangLevel = this.fdl.prtProps.getPSLangLevel();
        String trueType = this.fdl.prtProps.isTrueType();
        String type11 = this.fdl.prtProps.isType11Fonts();
        String ramInfo = this.fdl.prtProps.getTotalRam();
        String freeMem = this.fdl.prtProps.getFreeRam();
        String productStr = this.fdl.prtProps.getProductInfo();
        boolean errorFlag = false;
        if (productStr != null) {
            this.product.setText(productStr.trim());
        } else {
            errorFlag = true;
        }
        if (psVersion != null) {
            this.psInterpreter.setText(psVersion.trim());
        } else {
            errorFlag = true;
        }
        if (psLangLevel != null) {
            this.psLevel.setText(psLangLevel.trim());
        } else {
            errorFlag = true;
        }
        if (trueType != null) {
            if (trueType.trim().startsWith("true")) {
                this.type42Fonts.setText(this.getMessage("tabbedpropertiesdialog.supported"));
            } else {
                this.type42Fonts.setText(this.getMessage("tabbedpropertiesdialog.not_supported"));
            }
        } else {
            errorFlag = true;
        }
        if (type11 != null) {
            if (type11.trim().startsWith("true")) {
                this.type11Fonts.setText(this.getMessage("tabbedpropertiesdialog.supported"));
            } else {
                this.type11Fonts.setText(this.getMessage("tabbedpropertiesdialog.not_supported"));
            }
        } else {
            errorFlag = true;
        }
        if (ramInfo != null) {
            this.totalMemory.setText(ramInfo);
        } else {
            errorFlag = true;
        }
        if (this.fdl.prtProps.getNumDisks() > 0) {
            Integer numdisks = new Integer(this.fdl.prtProps.getNumDisks());
            this.numDisks.setText(numdisks.toString());
            this.diskSize.setText(this.fdl.prtProps.getDiskSize());
            this.availDisk.setText(this.fdl.prtProps.getFreeDisk());
        } else {
            this.numDisks.setText("0");
            this.diskSize.setText("0");
            this.availDisk.setText("0");
            this.diskSize.textf.setEnabled(false);
            this.availDisk.textf.setEnabled(false);
            this.diskSizeLabel.setEnabled(false);
            this.availDiskLabel.setEnabled(false);
        }
        this.totalPages.setText(this.fdl.prtProps.getTotalPages());
        return errorFlag;
    }

    void createPropsDialog() {
        this.tabbedPane = new JTabbedPane();
        this.generalPanel = this.layoutGenProperties(this.WIDTH);
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                if (TabbedPropertiesDialog.this.firstTimeFlag) {
                    TabbedPropertiesDialog.this.firstTimeFlag = false;
                    return;
                }
                JTabbedPane tpane = (JTabbedPane)evt.getComponent();
                JPanel panel = (JPanel)tpane.getComponentAt(0);
                int panWidth = panel.getSize().width;
                panel.invalidate();
                panel.removeAll();
                panel = TabbedPropertiesDialog.this.layoutGenProperties(panWidth);
                TabbedPropertiesDialog.this.displayGeneralProperties();
                panel.validate();
                tpane.setComponentAt(0, panel);
                tpane.validate();
            }
        });
        this.defListModel = new DefaultListModel();
        JPanel flistButtonPanel = this.createFontListButtonPanel();
        RemoveFontListener removeFontListener = new RemoveFontListener();
        this.removeFontButton.addActionListener(removeFontListener);
        PrintSampleListener printSampleListener = new PrintSampleListener();
        this.printSampleButton.addActionListener(printSampleListener);
        this.printSampleButton.setEnabled(false);
        this.printListButton.setEnabled(false);
        this.removeFontButton.setEnabled(false);
        this.printListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TabbedPropertiesDialog.this.fdl.prtProps.printFontList();
            }
        });
        JPanel topPanel = new JPanel(false);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel fontListPanel = new JPanel();
        this.createFontListTable();
        fontListPanel.setLayout(new FontListPanelLayout(fontListPanel));
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbl.setConstraints(fontListPanel, gbc);
        topPanel.add(fontListPanel);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbl.setConstraints(flistButtonPanel, gbc);
        topPanel.add(flistButtonPanel);
        this.statusPanel = new JPanel(false);
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.fontListStatus = new JLabel(this.EMPTY_STRING);
        this.statusPanel.add(this.fontListStatus);
        this.statusPanel.setBorder(new BevelBorder(1));
        this.fontPanel = new JPanel();
        this.fontPanel.setLayout(new BorderLayout());
        this.fontPanel.add("Center", topPanel);
        this.fontPanel.add("South", this.statusPanel);
        this.advancedPanel = new JPanel(false);
        this.advancedPanel.setLayout(new BorderLayout());
        this.advancedPanel.setBorder(new EmptyBorder(15, 15, 45, 15));
        this.exitServerPasswdTextfield = new JTextField();
        this.exitServerPasswdTextfield.setText(this.fdl.prtProps.getExitServerPasswd());
        this.exitServerPasswdTextfield.setBackground(Color.white);
        this.exitServerPasswdTextfield.setCaretPosition(0);
        JPanel exitServerPanel = new JPanel();
        exitServerPanel.setLayout(new BoxLayout(exitServerPanel, 0));
        this.exitPasswdLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.exitserver_password:"));
        this.formatDiskButton = new JButton(this.getMessage("tabbedpropertiesdialog.format_disk"));
        JPanel exitServerPasswdPanel = new JPanel();
        exitServerPasswdPanel.setLayout(new exitLayout(exitServerPasswdPanel));
        exitServerPanel.setBorder(new EmptyBorder(10, 20, 10, 20));
        this.exitServerPasswdTextfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String passwd = TabbedPropertiesDialog.this.exitServerPasswdTextfield.getText().trim();
                TabbedPropertiesDialog.this.fdl.prtProps.setExitServerPasswd(passwd);
            }
        });
        JPanel formatButtonPanel = new JPanel();
        JPanel topAdvPanel = this.createAdvancedPanel();
        this.advancedPanel.add((Component)topAdvPanel, "North");
        this.advancedPanel.add((Component)exitServerPasswdPanel, "Center");
        this.tabbedPane.addTab(this.getMessage("tabbedpropertiesdialog.general_properties"), this.generalPanel);
        this.tabbedPane.addTab(this.getMessage("tabbedpropertiesdialog.font_list"), this.fontPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                int index = TabbedPropertiesDialog.this.tabbedPane.getSelectedIndex();
                int total = TabbedPropertiesDialog.this.tabbedPane.getTabCount();
                String title = TabbedPropertiesDialog.this.tabbedPane.getTitleAt(index);
                if (index == TAB_INDEX_0) {
                    ComponentEvent ce = new ComponentEvent(TabbedPropertiesDialog.this.tabbedPane, 101);
                    TabbedPropertiesDialog.this.tabbedPane.dispatchEvent(ce);
                }
                if (index == TAB_INDEX_1) {
                    TabbedPropertiesDialog.this.fontListTable.grabFocus();
                }
                if (title == TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.cid_fonts")) {
                    TabbedPropertiesDialog.this.cidList.grabFocus();
                }
                if (title == TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.cmap_files")) {
                    TabbedPropertiesDialog.this.cmapList.grabFocus();
                }
                if (index == total - 1) {
                    TabbedPropertiesDialog.this.okButton.setEnabled(true);
                    TabbedPropertiesDialog.this.applyButton.setEnabled(true);
                } else {
                    TabbedPropertiesDialog.this.okButton.setEnabled(false);
                    TabbedPropertiesDialog.this.applyButton.setEnabled(false);
                }
            }
        });
        this.okButton = new JButton(this.getMessage("tabbedpropertiesdialog.ok"));
        this.okButton.setMnemonic(79);
        this.applyButton = new JButton(this.getMessage("tabbedpropertiesdialog.apply"));
        this.applyButton.setMnemonic(65);
        this.cancelButton = new JButton(this.getMessage("tabbedpropertiesdialog.cancel"));
        this.cancelButton.setMnemonic('C');
        this.okButton.setMnemonic(79);
        this.okButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new ButtonPanelLayout(buttonPanel));
        this.getContentPane().add(Box.createRigidArea(this.labelvpad), "North");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.addActions();
        this.formatDiskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String dialogTitle = TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.format_disk_confirm_dialog");
                String confirmStr = TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.formatting_disk_will_cause_deletion_of_new_line_");
                confirmStr = confirmStr + TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.all_fonts_residing_on_the_disk_new_line__new_line_");
                int ans = JOptionPane.showConfirmDialog(TabbedPropertiesDialog.this.parent, confirmStr = confirmStr + TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.are_you_sure_that_you_wish_to_format_the_disk?"), dialogTitle, 0);
                if (ans == 0) {
                    TabbedPropertiesDialog.this.propDialog.setCursor(new Cursor(3));
                    String passwd = TabbedPropertiesDialog.this.exitServerPasswdTextfield.getText().trim();
                    TabbedPropertiesDialog.this.fdl.prtProps.setExitServerPasswd(passwd);
                    int exitValue = TabbedPropertiesDialog.this.fdl.prtProps.formatDisk();
                    TabbedPropertiesDialog.this.propDialog.setCursor(new Cursor(0));
                }
            }
        });
    }

    JPanel createCIDFontPanel() {
        JPanel panel = new JPanel();
        this.removeCIDFont = new JButton(this.getMessage("tabbedpropertiesdialog.remove"));
        this.dlmCID = new DefaultListModel();
        this.cidList = new FontDownloaderList(this.dlmCID, this.propDialog);
        this.cidLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.cid_fonts:"));
        this.CIDScroll = new JScrollPane(this.cidList);
        int i = 0;
        while (i < this.fdl.prtProps.CIDFontArray.length) {
            this.dlmCID.addElement(this.fdl.prtProps.CIDFontArray[i]);
            ++i;
        }
        this.cidList.setSelectedIndex(0);
        panel.setLayout(new CIDPanelLayout(panel));
        this.removeCIDFont.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Boolean bl = TabbedPropertiesDialog.this.isOpened;
                synchronized (bl) {
                    if (TabbedPropertiesDialog.this.isOpened.booleanValue()) {
                        return;
                    }
                }
                Boolean bl2 = TabbedPropertiesDialog.this.isOpened;
                synchronized (bl2) {
                    TabbedPropertiesDialog.this.isOpened = new Boolean(true);
                }
                int[] selRows = TabbedPropertiesDialog.this.cidList.getSelectedIndices();
                int numfonts = selRows.length;
                TabbedPropertiesDialog.this.pmd = new ProgressMonitorDialog(TabbedPropertiesDialog.this.propDialog, TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.removing_font_dot__dot__dot_"));
                TabbedPropertiesDialog.this.pmd.setTitle(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.progress:_removing_cid_font"));
                new ProgressMonitorThread().start();
                String[] files = new String[numfonts];
                int i = 0;
                while (i < numfonts) {
                    int FontIndex = selRows[i];
                    files[i] = (String)TabbedPropertiesDialog.this.dlmCID.getElementAt(FontIndex);
                    ++i;
                }
                new RemoveCIDThread(files).start();
            }
        });
        return panel;
    }

    JPanel createCMapFilesPanel() {
        JPanel panel = new JPanel();
        this.removeCmap = new JButton(this.getMessage("tabbedpropertiesdialog.remove"));
        this.dlmCMAP = new DefaultListModel();
        this.cmapList = new FontDownloaderList(this.dlmCMAP, this.propDialog);
        this.cmapLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.cmap_files:"));
        this.CMapScroll = new JScrollPane(this.cmapList);
        int i = 0;
        while (i < this.fdl.prtProps.CMAPArray.length) {
            this.dlmCMAP.addElement(this.fdl.prtProps.CMAPArray[i]);
            ++i;
        }
        this.cmapList.setSelectedIndex(0);
        panel.setLayout(new CMapPanelLayout(panel));
        this.removeCmap.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Boolean bl = TabbedPropertiesDialog.this.isOpened;
                synchronized (bl) {
                    if (TabbedPropertiesDialog.this.isOpened.booleanValue()) {
                        return;
                    }
                }
                Boolean bl2 = TabbedPropertiesDialog.this.isOpened;
                synchronized (bl2) {
                    TabbedPropertiesDialog.this.isOpened = new Boolean(true);
                }
                int[] selRows = TabbedPropertiesDialog.this.cmapList.getSelectedIndices();
                int numfonts = selRows.length;
                TabbedPropertiesDialog.this.pmd = new ProgressMonitorDialog(TabbedPropertiesDialog.this.propDialog, TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.removing_font_dot__dot__dot_"));
                TabbedPropertiesDialog.this.pmd.setTitle(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.progress:_removing_cmap_files"));
                new ProgressMonitorThread().start();
                String[] files = new String[numfonts];
                int i = 0;
                while (i < numfonts) {
                    int FontIndex = selRows[i];
                    files[i] = (String)TabbedPropertiesDialog.this.dlmCMAP.getElementAt(FontIndex);
                    ++i;
                }
                new RemoveCMapThread(files).start();
            }
        });
        return panel;
    }

    JPanel layoutGenProperties(int width) {
        JPanel generalLabels = new JPanel(false);
        generalLabels.setLayout(new GridLayout(0, 1));
        generalLabels.setBorder(new EmptyBorder(0, 10, 5, 0));
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.product"), 2));
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.version"), 2));
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.postscript_level"), 2));
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.type_42_fonts"), 2));
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.type_11_fonts"), 2));
        this.totalRamLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.total_ram"), 2);
        generalLabels.add(this.totalRamLabel);
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.number_of_disks"), 2));
        this.diskSizeLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.total_disk_size"), 2);
        generalLabels.add(this.diskSizeLabel);
        this.availDiskLabel = new JLabel(this.getMessage("tabbedpropertiesdialog.available_disk"), 2);
        generalLabels.add(this.availDiskLabel);
        generalLabels.add(new JLabel(this.getMessage("tabbedpropertiesdialog.total_pages_printed"), 2));
        FontMetrics fm = this.getFontMetrics(FontDownloaderMainFrame.defaultFont);
        int maxstrlen = fm.stringWidth(new String(this.getMessage("tabbedpropertiesdialog.postscript_interpreter")));
        int panWidth = width - maxstrlen - 50;
        this.product = new PropertiesTextPanel(panWidth);
        this.psInterpreter = new PropertiesTextPanel(panWidth);
        this.psLevel = new PropertiesTextPanel(panWidth);
        this.type42Fonts = new PropertiesTextPanel(panWidth);
        this.type11Fonts = new PropertiesTextPanel(panWidth);
        this.totalMemory = new PropertiesTextPanel(panWidth);
        this.numDisks = new PropertiesTextPanel(panWidth);
        this.diskSize = new PropertiesTextPanel(panWidth);
        this.availDisk = new PropertiesTextPanel(panWidth);
        this.totalPages = new PropertiesTextPanel(panWidth);
        JPanel generalProps = new JPanel(false);
        generalProps.setLayout(new GridLayout(0, 1));
        generalProps.add(this.product);
        generalProps.add(this.psInterpreter);
        generalProps.add(this.psLevel);
        generalProps.add(this.type42Fonts);
        generalProps.add(this.type11Fonts);
        generalProps.add(this.totalMemory);
        generalProps.add(this.numDisks);
        generalProps.add(this.diskSize);
        generalProps.add(this.availDisk);
        generalProps.add(this.totalPages);
        generalProps.setBorder(new EmptyBorder(0, 10, 5, 0));
        JPanel generalFolder = new JPanel(false);
        generalFolder.setLayout(new BoxLayout(generalFolder, 0));
        String printerName = this.fdl.prtProps.getPrinterName();
        generalFolder.setBorder(new TitledBorder(new EtchedBorder(), this.getMessage("tabbedpropertiesdialog.printer:") + printerName));
        generalFolder.add(generalLabels);
        generalFolder.add(Box.createRigidArea(new Dimension(20, 1)));
        generalFolder.add(generalProps);
        JPanel generalPanel = new JPanel();
        GridBagLayout gbl_gen = new GridBagLayout();
        GridBagConstraints gbc_gen = new GridBagConstraints();
        gbc_gen.anchor = 18;
        gbc_gen.fill = 0;
        gbc_gen.gridx = 0;
        gbc_gen.gridy = 0;
        gbc_gen.weightx = 0.0;
        gbc_gen.weighty = 1.0;
        gbl_gen.setConstraints(generalFolder, gbc_gen);
        generalPanel.setLayout(gbl_gen);
        generalPanel.add(generalFolder);
        generalPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        JPanel generalJustifiedPanel = new JPanel();
        generalJustifiedPanel.setLayout(new BorderLayout());
        generalJustifiedPanel.add((Component)generalPanel, "West");
        return generalJustifiedPanel;
    }

    JPanel createFontListButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1));
        this.printSampleButton = new JButton(this.getMessage("tabbedpropertiesdialog.print_sample"));
        this.removeFontButton = new JButton(this.getMessage("tabbedpropertiesdialog.remove"));
        this.printListButton = new JButton(this.getMessage("tabbedpropertiesdialog.print_list"));
        this.printSampleButton.setMnemonic('S');
        this.printListButton.setMnemonic('L');
        buttonPanel.add(this.removeFontButton);
        buttonPanel.add(this.printSampleButton);
        buttonPanel.add(this.printListButton);
        buttonPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JPanel outerPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(buttonPanel, gbc);
        outerPanel.add(buttonPanel);
        return outerPanel;
    }

    public void createFontListTable() {
        this.rowSelector = new DefaultListSelectionModel();
        this.rowSelector.setSelectionInterval(0, 0);
        this.rowSelector.setSelectionMode(2);
        this.sortableModel = new SortableTable(0);
        this.fontListTable = new PrinterTable(this.sortableModel);
        this.fontListTable.setBackground(Color.white);
        this.fontListTable.setGridColor(Color.white);
        this.fontListTable.setAutoResizeMode(0);
        this.col1 = new TableColumn(0, 100);
        this.col1.setIdentifier(new String(this.getMessage("tabbedpropertiesdialog.name")));
        this.col1.setHeaderValue(new String(this.getMessage("tabbedpropertiesdialog.name")));
        this.col2 = new TableColumn(1, 100);
        this.col2.setIdentifier(new String(this.getMessage("tabbedpropertiesdialog.type")));
        this.col2.setHeaderValue(new String(this.getMessage("tabbedpropertiesdialog.type")));
        this.col3 = new TableColumn(2, 100);
        this.col3.setIdentifier(new String(this.getMessage("tabbedpropertiesdialog.location")));
        this.col3.setHeaderValue(new String(this.getMessage("tabbedpropertiesdialog.location")));
        this.fontListTable.addColumn(this.col1);
        this.fontListTable.addColumn(this.col2);
        this.fontListTable.addColumn(this.col3);
        this.header = this.fontListTable.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setResizingAllowed(true);
        this.fontListTable.setTableHeader(this.header);
        this.fontListTable.setAutoCreateColumnsFromModel(false);
        this.fontListTable.setColumnSelectionAllowed(false);
        this.fontListTable.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.fontListTable.setSelectionModel(this.rowSelector);
        this.fontListTable.setGridColor(Color.white);
        this.fontListTable.setBackground(Color.white);
        this.fontListTable.getCellSelectionEnabled();
        this.fontListTable.setSelectionBackground(Color.black);
        this.fontListScrollPane = new JScrollPane(this.fontListTable);
        this.fontListScrollPane.setHorizontalScrollBarPolicy(30);
        this.fontListScrollPane.setVerticalScrollBarPolicy(20);
        this.fontListTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 34: {
                        break;
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 33: {
                        break;
                    }
                    case 36: {
                        int prevRow = 0;
                        int newRow = 0;
                        TabbedPropertiesDialog.this.rowSelector.setSelectionInterval(newRow, prevRow);
                        TabbedPropertiesDialog.this.fontListTable.scrollRectToVisible(TabbedPropertiesDialog.this.fontListTable.getCellRect(0, 0, true));
                        TabbedPropertiesDialog.this.repaint();
                        break;
                    }
                    case 35: {
                        int lastRow = TabbedPropertiesDialog.this.fontListTable.getRowCount();
                        int prevRow = --lastRow;
                        int newRow = lastRow;
                        TabbedPropertiesDialog.this.rowSelector.setSelectionInterval(prevRow, newRow);
                        Rectangle visRect = TabbedPropertiesDialog.this.fontListTable.getCellRect(lastRow, 0, true);
                        TabbedPropertiesDialog.this.fontListTable.scrollRectToVisible(visRect);
                    }
                }
            }
        });
    }

    void addActions() {
        this.rowSelector.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean romfont_exists = false;
                int[] selectedRows = TabbedPropertiesDialog.this.fontListTable.getSelectedRows();
                if (selectedRows.length == 0) {
                    TabbedPropertiesDialog.this.removeFontButton.setEnabled(false);
                    return;
                }
                int i = 0;
                while (i < selectedRows.length) {
                    String where = (String)TabbedPropertiesDialog.this.sortableModel.getValueAt(selectedRows[i], 2);
                    if (where.equals(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.rom"))) {
                        romfont_exists = true;
                    }
                    ++i;
                }
                if (romfont_exists) {
                    TabbedPropertiesDialog.this.removeFontButton.setEnabled(false);
                } else {
                    TabbedPropertiesDialog.this.removeFontButton.setEnabled(true);
                }
                if (selectedRows.length > 1) {
                    TabbedPropertiesDialog.this.displayStatus(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.number_of_fonts_selected:") + selectedRows.length);
                } else {
                    TabbedPropertiesDialog.this.displayStatus("  ");
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String passwd = TabbedPropertiesDialog.this.exitServerPasswdTextfield.getText().trim();
                TabbedPropertiesDialog.this.fdl.prtProps.setExitServerPasswd(passwd);
                TabbedPropertiesDialog.this.fdl.statusPanel.displayStatus(" ");
                TabbedPropertiesDialog.this.propDialog.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabbedPropertiesDialog.this.fdl.statusPanel.displayStatus(" ");
                TabbedPropertiesDialog.this.propDialog.setVisible(false);
            }
        });
    }

    public void displayStatus(String text) {
        this.fontListStatus.getParent().getParent().invalidate();
        this.fontListStatus.invalidate();
        this.fontListStatus.setText(text);
        this.fontListStatus.validate();
        this.fontListStatus.getParent().getParent().validate();
    }

    JPanel createAdvancedPanel() {
        JPanel sampleConfPanel = new JPanel();
        sampleConfPanel.setLayout(new BoxLayout(sampleConfPanel, 0));
        this.buttongroup = new ButtonGroup();
        this.decButton = new JRadioButton(this.getMessage("tabbedpropertiesdialog.decimal"), true);
        this.hexButton = new JRadioButton(this.getMessage("tabbedpropertiesdialog.hexadecimal"));
        this.buttongroup.add(this.decButton);
        this.buttongroup.add(this.hexButton);
        sampleConfPanel.add(this.decButton);
        sampleConfPanel.add(this.hexButton);
        JPanel label1panel = new JPanel();
        label1panel.setLayout(new BoxLayout(label1panel, 0));
        label1panel.add(new JLabel(this.getMessage("tabbedpropertiesdialog.sample_page_radix")));
        label1panel.setBorder(new EmptyBorder(26, 5, 0, 0));
        JPanel topPanel1 = new JPanel();
        topPanel1.setLayout(new BoxLayout(topPanel1, 0));
        topPanel1.add(label1panel);
        topPanel1.add(Box.createRigidArea(new Dimension(10, 1)));
        topPanel1.add(sampleConfPanel);
        JPanel topPanel = new JPanel(false);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbl.setConstraints(topPanel1, gbc);
        topPanel.add(topPanel1);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 0));
        this.paperChoice = new JComboBox();
        JPanel label2panel = new JPanel();
        label2panel.setLayout(new BoxLayout(label2panel, 0));
        label2panel.setBorder(new EmptyBorder(0, 17, 0, 25));
        label2panel.add(new JLabel(this.getMessage("tabbedpropertiesdialog.sample_page_size")));
        lowerPanel.add(label2panel);
        lowerPanel.add(this.paperChoice);
        this.paperChoice.addItem(PrinterProperties.US_LETTER_PAPERSIZE_STR);
        this.paperChoice.addItem(PrinterProperties.US_LEGAL_PAPERSIZE_STR);
        this.paperChoice.addItem(PrinterProperties.A4_PAPERSIZE_STR);
        lowerPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        JPanel combinedPanel = new JPanel();
        combinedPanel.setLayout(new BoxLayout(combinedPanel, 1));
        combinedPanel.add(topPanel);
        combinedPanel.add(lowerPanel);
        combinedPanel.setBorder(new TitledBorder(new EtchedBorder(), this.getMessage("tabbedpropertiesdialog.sample_page_configuration")));
        return combinedPanel;
    }

    public class exitLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int x;
        int y;
        int buttonWidth;
        int buttonHeight;

        public exitLayout(Container c) {
            this.buttonWidth = new Integer(TabbedPropertiesDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            this.buttonHeight = new Integer(TabbedPropertiesDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.panel = (JPanel)c;
            this.panel.add(TabbedPropertiesDialog.this.exitServerPasswdTextfield);
            this.panel.add(TabbedPropertiesDialog.this.formatDiskButton);
            this.panel.add(TabbedPropertiesDialog.this.exitPasswdLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 100);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 100);
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            TabbedPropertiesDialog.this.exitPasswdLabel.setBounds(5, 8, 117, 17);
            TabbedPropertiesDialog.this.exitServerPasswdTextfield.setBounds(127, 5, this.panelWidth - 127, 25);
            TabbedPropertiesDialog.this.formatDiskButton.setBounds(this.panelWidth / 2 - this.buttonWidth / 2, 35, this.buttonWidth, this.buttonHeight);
        }
    }

    public class FontListPanelLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int scrollPaneWidth;
        int scrollPaneHeight;

        public FontListPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(TabbedPropertiesDialog.this.fontListScrollPane);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.scrollPaneWidth = this.panelWidth;
            this.scrollPaneHeight = this.panelHeight;
            TabbedPropertiesDialog.this.fontListScrollPane.setBounds(0, 0, this.scrollPaneWidth, this.scrollPaneHeight);
            int totalwidth = TabbedPropertiesDialog.this.fontListScrollPane.getWidth();
            Insets i = TabbedPropertiesDialog.this.fontListTable.getInsets();
            int width = (int)((double)(totalwidth -= i.left + i.right) * 0.6);
            TabbedPropertiesDialog.this.col1.setPreferredWidth(width);
            width = (totalwidth - width) / 2;
            TabbedPropertiesDialog.this.col2.setPreferredWidth(width - 9);
            TabbedPropertiesDialog.this.col3.setPreferredWidth(width - 9);
            int rowh = TabbedPropertiesDialog.this.fontListTable.getRowHeight();
            Rectangle table = TabbedPropertiesDialog.this.fontListTable.getVisibleRect();
        }
    }

    public class CMapPanelLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int buttonX;
        int scrollPaneWidth;
        int scrollPaneHeight;

        public CMapPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(TabbedPropertiesDialog.this.removeCmap);
            this.panel.add(TabbedPropertiesDialog.this.CMapScroll);
            this.panel.add(TabbedPropertiesDialog.this.cmapLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 525;
            dim.height = 450;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 525;
            dim.height = 450;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.buttonX = this.panelWidth - TabbedPropertiesDialog.this.BUTTON_WIDTH - BUTTON_PADDING;
            this.scrollPaneWidth = this.panelWidth - TabbedPropertiesDialog.this.BUTTON_WIDTH - BUTTON_PADDING * 2 - PADDING_LEFT;
            this.scrollPaneHeight = this.panelHeight - 22 - 12;
            TabbedPropertiesDialog.this.removeCmap.setBounds(this.buttonX, 22, TabbedPropertiesDialog.this.BUTTON_WIDTH, TabbedPropertiesDialog.this.BUTTON_HEIGHT);
            TabbedPropertiesDialog.this.CMapScroll.setBounds(PADDING_LEFT, 22, this.scrollPaneWidth, this.scrollPaneHeight);
            TabbedPropertiesDialog.this.cmapLabel.setBounds(PADDING_LEFT, 5, 258, 14);
        }
    }

    public class CIDPanelLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int buttonX;
        int scrollPaneWidth;
        int scrollPaneHeight;

        public CIDPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(TabbedPropertiesDialog.this.removeCIDFont);
            this.panel.add(TabbedPropertiesDialog.this.CIDScroll);
            this.panel.add(TabbedPropertiesDialog.this.cidLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 525;
            dim.height = 450;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 525;
            dim.height = 450;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.buttonX = this.panelWidth - TabbedPropertiesDialog.this.BUTTON_WIDTH - BUTTON_PADDING;
            this.scrollPaneWidth = this.panelWidth - TabbedPropertiesDialog.this.BUTTON_WIDTH - BUTTON_PADDING * 2 - PADDING_LEFT;
            this.scrollPaneHeight = this.panelHeight - 22 - 12;
            TabbedPropertiesDialog.this.removeCIDFont.setBounds(this.buttonX, 22, TabbedPropertiesDialog.this.BUTTON_WIDTH, TabbedPropertiesDialog.this.BUTTON_HEIGHT);
            TabbedPropertiesDialog.this.CIDScroll.setBounds(PADDING_LEFT, 22, this.scrollPaneWidth, this.scrollPaneHeight);
            TabbedPropertiesDialog.this.cidLabel.setBounds(PADDING_LEFT, 5, 258, 14);
        }
    }

    public class ButtonPanelLayout
    implements LayoutManager {
        JPanel panel;
        int buttonX;
        int panelWidth;
        int panelHeight;
        int padding = 5;
        int buttonWidth = new Integer(TabbedPropertiesDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
        int buttonHeight = new Integer(TabbedPropertiesDialog.this.getMessage("dimensions.okcancelbuttonheight"));

        public ButtonPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(TabbedPropertiesDialog.this.okButton);
            this.panel.add(TabbedPropertiesDialog.this.applyButton);
            this.panel.add(TabbedPropertiesDialog.this.cancelButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            dim.width = 385;
            dim.height = 67;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            dim.width = 385;
            dim.height = 67;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.buttonX = this.panelWidth - 3 * this.padding - 3 * this.buttonWidth;
            TabbedPropertiesDialog.this.okButton.setBounds(this.buttonX, 15, this.buttonWidth, this.buttonHeight);
            TabbedPropertiesDialog.this.applyButton.setBounds(this.buttonX + (this.buttonWidth + this.padding), 15, this.buttonWidth, this.buttonHeight);
            TabbedPropertiesDialog.this.cancelButton.setBounds(this.buttonX + 2 * (this.buttonWidth + this.padding), 15, this.buttonWidth, this.buttonHeight);
        }
    }

    class GetPrinterPropertiesThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int exitValue = TabbedPropertiesDialog.this.fdl.prtProps.getAllProperties();
            TabbedPropertiesDialog.this.printerPropertiesStatus = false;
            if (exitValue != 0) {
                TabbedPropertiesDialog.this.errCode = 1;
            } else if (TabbedPropertiesDialog.this.fdl.prtProps.allFonts != null) {
                TabbedPropertiesDialog.this.printerPropertiesStatus = true;
            }
            Boolean bl = TabbedPropertiesDialog.this.gotPropsFlag;
            synchronized (bl) {
                TabbedPropertiesDialog.this.gotPropsFlag = new Boolean(true);
            }
        }
    }

    class PrintSampleListener
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Boolean bl = TabbedPropertiesDialog.this.isOpened;
            synchronized (bl) {
                if (TabbedPropertiesDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = TabbedPropertiesDialog.this.isOpened;
            synchronized (bl2) {
                TabbedPropertiesDialog.this.isOpened = new Boolean(true);
            }
            TabbedPropertiesDialog.this.pmd = new ProgressMonitorDialog(TabbedPropertiesDialog.this.propDialog, "Printing font samples:");
            TabbedPropertiesDialog.this.pmd.setTitle(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.progress:_printing_font_samples"));
            new ProgressMonitorThread().start();
            new PrintSampleThread(TabbedPropertiesDialog.this.propDialog, TabbedPropertiesDialog.this.pmd).start();
        }
    }

    public class PrintSampleThread
    extends Thread {
        TabbedPropertiesDialog tpd;
        ProgressMonitorDialog pmd;

        public PrintSampleThread(TabbedPropertiesDialog tpd, ProgressMonitorDialog pmd) {
            this.setPriority(3);
            this.tpd = tpd;
            this.pmd = pmd;
        }

        public void run() {
            int[] selRows = TabbedPropertiesDialog.this.fontListTable.getSelectedRows();
            int numfonts = selRows.length;
            Object[] selFonts = new Object[numfonts];
            int i = 0;
            while (i < numfonts) {
                selFonts[i] = TabbedPropertiesDialog.this.fontListTable.getValueAt(selRows[i], 0);
                ++i;
            }
            int paperType = TabbedPropertiesDialog.this.paperChoice.getSelectedIndex();
            int radix = TabbedPropertiesDialog.this.decButton.isSelected() ? PrinterProperties.DEC_RADIX : PrinterProperties.HEX_RADIX;
            int i2 = 0;
            while (i2 < numfonts) {
                String fontName = (String)selFonts[i2];
                String printerName = TabbedPropertiesDialog.this.fdl.prtProps.getPrinterName();
                this.pmd.setMessageNL(fontName);
                TabbedPropertiesDialog.this.fdl.prtProps.printSampleFont(printerName, fontName, radix, paperType);
                ++i2;
            }
            this.pmd.setTrue();
            TabbedPropertiesDialog.this.fontListStatus.invalidate();
            TabbedPropertiesDialog.this.fontListStatus.setText(numfonts + " " + TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.font_sample(s)_sent_to_the_printer"));
            TabbedPropertiesDialog.this.fontListStatus.getParent().getParent().validate();
            TabbedPropertiesDialog.this.fontListTable.grabFocus();
        }
    }

    class RemoveFontListener
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Boolean bl = TabbedPropertiesDialog.this.isOpened;
            synchronized (bl) {
                if (TabbedPropertiesDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = TabbedPropertiesDialog.this.isOpened;
            synchronized (bl2) {
                TabbedPropertiesDialog.this.isOpened = new Boolean(true);
            }
            String removeConfirmMsg = TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.are_you_sure_you_want_to_remove_the_selected_fonts?");
            int ans = JOptionPane.showConfirmDialog(TabbedPropertiesDialog.this.propDialog, removeConfirmMsg, TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.remove_font_confirmation"), 0);
            if (ans == 1) {
                return;
            }
            int[] selRows = TabbedPropertiesDialog.this.fontListTable.getSelectedRows();
            int numfonts = selRows.length;
            TabbedPropertiesDialog.this.pmd = new ProgressMonitorDialog(TabbedPropertiesDialog.this.propDialog, TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.removing_font_dot__dot__dot_"));
            TabbedPropertiesDialog.this.pmd.setTitle(TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.progress:_removing_fonts"));
            new ProgressMonitorThread().start();
            FontInfo[] temp = new FontInfo[numfonts];
            int i = 0;
            while (i < numfonts) {
                int FontInfoIndex = selRows[i];
                temp[i] = TabbedPropertiesDialog.this.fdl.prtProps.allFonts[FontInfoIndex];
                ++i;
            }
            new RemoveFontThread(temp, numfonts).start();
        }
    }

    public class RemoveFontThread
    extends Thread {
        FontInfo[] temp;
        int numfonts;

        public RemoveFontThread(FontInfo[] t, int numfonts) {
            this.setPriority(3);
            this.temp = t;
            this.numfonts = numfonts;
        }

        public void run() {
            String s = TabbedPropertiesDialog.this.fdl.prtProps.RemoveFonts(TabbedPropertiesDialog.this.fdl.prtProps.printerName, TabbedPropertiesDialog.this.fdl.prtProps.exitserverpasswd, this.temp, TabbedPropertiesDialog.this.pmd);
            int exitValue = TabbedPropertiesDialog.this.fdl.prtProps.getAllProperties(s);
            TabbedPropertiesDialog.this.pmd.setTrue();
            TabbedPropertiesDialog.this.FillTable();
            if (TabbedPropertiesDialog.this.fdl.prtProps.getNumDisks() > 0) {
                TabbedPropertiesDialog.this.availDisk.setText(TabbedPropertiesDialog.this.fdl.prtProps.getFreeDisk());
            }
            TabbedPropertiesDialog.this.displayStatus(this.numfonts + " " + TabbedPropertiesDialog.this.getMessage("tabbedpropertiesdialog.font(s)_have_been_removed"));
        }
    }

    public class RemoveCMapThread
    extends Thread {
        String[] files;

        public RemoveCMapThread(String[] t) {
            this.setPriority(3);
            this.files = t;
        }

        public void run() {
            int index = TabbedPropertiesDialog.this.cmapList.getSelectedIndex();
            String s = TabbedPropertiesDialog.this.fdl.prtProps.RemoveCMapFiles(TabbedPropertiesDialog.this.fdl.prtProps.printerName, TabbedPropertiesDialog.this.fdl.prtProps.exitserverpasswd, this.files, TabbedPropertiesDialog.this.pmd);
            int exitvalue = TabbedPropertiesDialog.this.fdl.prtProps.getAllProperties(s);
            TabbedPropertiesDialog.this.dlmCMAP.removeAllElements();
            int i = 0;
            while (i < TabbedPropertiesDialog.this.fdl.prtProps.CMAPArray.length) {
                TabbedPropertiesDialog.this.dlmCMAP.addElement(TabbedPropertiesDialog.this.fdl.prtProps.CMAPArray[i]);
                ++i;
            }
            if (index == TabbedPropertiesDialog.this.dlmCMAP.size()) {
                --index;
            }
            if (TabbedPropertiesDialog.this.dlmCMAP.getSize() == 0) {
                int tab = TabbedPropertiesDialog.this.tabbedPane.getSelectedIndex();
                TabbedPropertiesDialog.this.tabbedPane.removeTabAt(tab);
            } else {
                TabbedPropertiesDialog.this.cmapList.setSelectedIndex(index);
            }
            TabbedPropertiesDialog.this.pmd.setTrue();
        }
    }

    public class RemoveCIDThread
    extends Thread {
        String[] files;

        public RemoveCIDThread(String[] t) {
            this.setPriority(3);
            this.files = t;
        }

        public void run() {
            int index = TabbedPropertiesDialog.this.cidList.getSelectedIndex();
            String s = TabbedPropertiesDialog.this.fdl.prtProps.RemoveCIDFiles(TabbedPropertiesDialog.this.fdl.prtProps.printerName, TabbedPropertiesDialog.this.fdl.prtProps.exitserverpasswd, this.files, TabbedPropertiesDialog.this.pmd);
            int exitvalue = TabbedPropertiesDialog.this.fdl.prtProps.getAllProperties(s);
            TabbedPropertiesDialog.this.dlmCID.removeAllElements();
            int i = 0;
            while (i < TabbedPropertiesDialog.this.fdl.prtProps.CIDFontArray.length) {
                TabbedPropertiesDialog.this.dlmCID.addElement(TabbedPropertiesDialog.this.fdl.prtProps.CIDFontArray[i]);
                ++i;
            }
            if (index == TabbedPropertiesDialog.this.dlmCID.size()) {
                --index;
            }
            if (TabbedPropertiesDialog.this.dlmCID.getSize() == 0) {
                int tab = TabbedPropertiesDialog.this.tabbedPane.getSelectedIndex();
                TabbedPropertiesDialog.this.tabbedPane.removeTabAt(tab);
            } else {
                TabbedPropertiesDialog.this.cidList.setSelectedIndex(index);
            }
            TabbedPropertiesDialog.this.pmd.setTrue();
        }
    }

    public class ProgressMonitorThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread t = new Thread(TabbedPropertiesDialog.this.pmd);
            t.setPriority(10);
            t.start();
            TabbedPropertiesDialog.this.pmd.setVisible(true);
            Boolean bl = TabbedPropertiesDialog.this.isOpened;
            synchronized (bl) {
                TabbedPropertiesDialog.this.isOpened = new Boolean(false);
            }
        }
    }
}

