/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class SortableTable
extends DefaultTableModel {
    Vector unsortedDataVector;
    public static int UNSORTED = 0;
    public static int SORTED_ASCENDING = 1;
    public static int SORTED_DESCENDING = 2;
    final int MAX_STATE_INDEX = SORTED_DESCENDING;
    int[] colDisplayState;
    int numSortableCols;
    int compareColumn;
    boolean ascending = true;

    public SortableTable(int num) {
        this.setNumSortableColumns(num);
    }

    public void setNumSortableColumns(int num) {
        this.numSortableCols = num;
        this.colDisplayState = new int[num];
        int i = 0;
        while (i < num) {
            this.colDisplayState[i] = UNSORTED;
            ++i;
        }
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Vector getUnsortedDataVector() {
        return this.unsortedDataVector;
    }

    public void setUnsortedDataVector(Vector unsortedList) {
        this.unsortedDataVector = new Vector();
        int a = 0;
        while (a < unsortedList.size()) {
            Vector v = (Vector)unsortedList.elementAt(a);
            this.unsortedDataVector.addElement(v);
            ++a;
        }
    }

    public int getCurrentState(int colnum) {
        return this.colDisplayState[colnum];
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        String s2;
        Object o1 = this.getValueAt(row1, column);
        Object o2 = this.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String s1 = (String)this.getValueAt(row1, column);
        int result = s1.compareTo(s2 = (String)this.getValueAt(row2, column));
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public void setAscendingSort(boolean ascending) {
        this.ascending = ascending;
    }

    public int compare(int row1, int row2) {
        int result = this.compareRowsByColumn(row1, row2, this.compareColumn);
        if (result != 0) {
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public void sort(int colnum, boolean ascendingSortFlag) {
        this.compareColumn = colnum;
        this.setAscendingSort(ascendingSortFlag);
        this.doQuickSort(this.dataVector, 0, this.dataVector.size() - 1);
    }

    public int toggleNextState(int colnum, int selectedRow) {
        int currentState = this.colDisplayState[colnum];
        String key = (String)this.getValueAt(selectedRow, 0);
        if (++currentState > this.MAX_STATE_INDEX) {
            currentState = UNSORTED;
            Vector<Vector> tempPrinterList = new Vector<Vector>();
            int a = 0;
            while (a < this.unsortedDataVector.size()) {
                Vector v = (Vector)this.unsortedDataVector.elementAt(a);
                tempPrinterList.addElement(v);
                ++a;
            }
            this.setDataVector(tempPrinterList, this.columnIdentifiers);
        } else {
            boolean ascendingSortFlag = false;
            ascendingSortFlag = currentState == SORTED_ASCENDING;
            this.sort(colnum, ascendingSortFlag);
        }
        this.colDisplayState[colnum] = currentState;
        int row = 0;
        while (row < this.getRowCount()) {
            String prtName = (String)this.getValueAt(row, 0);
            if (prtName.equals(key)) break;
            ++row;
        }
        return row;
    }

    private void doQuickSort(Vector list, int l, int r) {
        if (l >= r) {
            return;
        }
        int i = l - 1;
        int j = r;
        Object tmp = null;
        while (true) {
            if (this.compare(++i, r) < 0) {
                continue;
            }
            while (j > 0 && this.compare(--j, r) > 0) {
            }
            tmp = list.elementAt(i);
            list.setElementAt(list.elementAt(j), i);
            list.setElementAt(tmp, j);
            if (j <= i) break;
        }
        list.setElementAt(list.elementAt(i), j);
        list.setElementAt(list.elementAt(r), i);
        list.setElementAt(tmp, r);
        this.doQuickSort(list, l, i - 1);
        this.doQuickSort(list, i + 1, r);
    }
}

