/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class PropertiesActionListener
extends AbstractAction {
    TabbedPropertiesDialog userProps = null;
    FontDownloaderMainFrame fdl;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public PropertiesActionListener(FontDownloaderMainFrame fdl) {
        this.fdl = fdl;
    }

    public void actionPerformed(ActionEvent evt) {
        int row = this.fdl.prtList.prtTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        String printerName = (String)this.fdl.prtList.prtTable.getValueAt(row, 0);
        String cmd = "/usr/sbin/ping " + printerName;
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            int val = proc.waitFor();
            if (val != 0) {
                String errMsg = this.getMessage("fontdownloadermainframe.printer") + " " + printerName + " is not responding.\n";
                errMsg = errMsg + this.getMessage("fontdownloadermainframe.please_check_the_connections_and_try_again");
                JOptionPane.showMessageDialog(this.fdl, errMsg, this.getMessage("fontdownloadermainframe.connection_error"), 0);
                return;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (this.fdl.prtProps == null) {
            this.fdl.prtProps = new PrinterProperties(printerName, this.fdl);
        } else {
            String currentPrtName = this.fdl.prtProps.getPrinterName();
            if (!printerName.equals(currentPrtName)) {
                this.fdl.prtProps.close();
                this.fdl.prtProps = new PrinterProperties(printerName, this.fdl);
            }
        }
        this.fdl.setBusy(true);
        this.userProps = new TabbedPropertiesDialog(this.fdl, this.fdl.prtProps);
        this.userProps.setTitle(printerName);
        Thread t = new Thread(this.userProps);
        t.setPriority(10);
        t.start();
        this.userProps.getPrinterProperties();
    }
}

