/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class ProgressMonitorDialog
extends JDialog
implements Runnable {
    ResourceBundle bundle;
    ProgressMonitorDialog pmd;
    JTextArea messageText;
    JScrollPane scrollpane;
    JButton closeButton;
    JProgressBar bar;
    Boolean booleanflag;
    Boolean keepopenflag;
    String newName = null;
    final int PMD_WIDTH = new Integer(this.getMessage("dimensions.progressmonitordialog_width"));
    final int PMD_HEIGHT = new Integer(this.getMessage("dimensions.progressmonitordialog_height"));
    final int BUTTON_WIDTH = new Integer(this.getMessage("dimensions.controlbuttonwidth"));
    final int BUTTON_HEIGHT = new Integer(this.getMessage("dimensions.controlbuttonheight"));

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public ProgressMonitorDialog(JDialog myparent, String message) {
        super(myparent);
        this.setLocation(myparent.getLocation());
        this.Init(message);
    }

    public ProgressMonitorDialog(JFrame myparent, String message) {
        super(myparent);
        this.setLocation(myparent.getLocation());
        this.Init(message);
    }

    public void Init(String message) {
        this.keepopenflag = new Boolean(false);
        this.booleanflag = new Boolean(false);
        this.messageText = new JTextArea("\n\n\n\n" + message, 3, 1);
        this.messageText.setLineWrap(true);
        this.messageText.setWrapStyleWord(true);
        this.messageText.setEditable(false);
        this.messageText.setBackground(Color.white);
        this.scrollpane = new JScrollPane(this.messageText);
        this.scrollpane.setHorizontalScrollBarPolicy(31);
        this.scrollpane.setVerticalScrollBarPolicy(20);
        this.closeButton = new JButton(this.getMessage("progressmonitordialog.close"));
        this.closeButton.setVisible(false);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressMonitorDialog.this.booleanflag = new Boolean(true);
                ProgressMonitorDialog.this.keepopenflag = new Boolean(false);
            }
        });
        this.bar = new JProgressBar();
        this.bar.setMaximum(100);
        this.showBar(false);
        this.setCursor(new Cursor(3));
        this.pmd = this;
        JPanel panel = new JPanel();
        panel.setLayout(new PMDPanelLayout(panel));
        this.getContentPane().add(panel);
        this.setSize(this.PMD_WIDTH, this.PMD_HEIGHT);
        this.setModal(true);
        this.setResizable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Boolean bl = this.booleanflag;
        synchronized (bl) {
            while (!this.booleanflag.booleanValue()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.setVisible(false);
            return;
        }
    }

    void setMessageNL(String text) {
        this.messageText.append("\n" + text);
        Runnable scrolling = new Runnable(){

            public void run() {
                Rectangle r = ProgressMonitorDialog.this.messageText.getBounds();
                r.y = ProgressMonitorDialog.this.messageText.getHeight();
                ProgressMonitorDialog.this.messageText.scrollRectToVisible(r);
            }
        };
        SwingUtilities.invokeLater(scrolling);
    }

    void setMessage(String text) {
        this.messageText.append(text);
        Runnable scrolling = new Runnable(){

            public void run() {
                Rectangle r = ProgressMonitorDialog.this.messageText.getBounds();
                r.y = ProgressMonitorDialog.this.messageText.getHeight();
                ProgressMonitorDialog.this.messageText.scrollRectToVisible(r);
            }
        };
        SwingUtilities.invokeLater(scrolling);
    }

    void keepOpen() {
        this.keepopenflag = new Boolean(true);
    }

    void showBar(boolean flag) {
        this.bar.setVisible(flag);
    }

    void setBar(int n) {
        this.bar.setValue(n);
    }

    void setFalse() {
        this.booleanflag = new Boolean(false);
    }

    void setTrue() {
        if (!this.keepopenflag.booleanValue()) {
            this.booleanflag = new Boolean(true);
        } else {
            this.closeButton.setVisible(true);
            while (!this.booleanflag.booleanValue()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public class PMDPanelLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;

        public PMDPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(ProgressMonitorDialog.this.scrollpane);
            this.panel.add(ProgressMonitorDialog.this.bar);
            this.panel.add(ProgressMonitorDialog.this.closeButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = ProgressMonitorDialog.this.PMD_WIDTH;
            dim.height = ProgressMonitorDialog.this.PMD_HEIGHT;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = ProgressMonitorDialog.this.PMD_WIDTH;
            dim.height = ProgressMonitorDialog.this.PMD_HEIGHT;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            ProgressMonitorDialog.this.scrollpane.setBounds(25, 15, 350, 90);
            ProgressMonitorDialog.this.bar.setBounds(25, 120, 350, 17);
            ProgressMonitorDialog.this.closeButton.setBounds(375 - ProgressMonitorDialog.this.BUTTON_WIDTH + 8, 142, ProgressMonitorDialog.this.BUTTON_WIDTH, ProgressMonitorDialog.this.BUTTON_HEIGHT);
        }
    }
}

