/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PrinterTable
extends JTable {
    boolean busyFlag = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;

    public PrinterTable(TableModel tablemodel) {
        super(tablemodel);
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PrinterTable.class$("java.lang.Object")) : class$java$lang$Object, new PrinterTableCellRenderer());
        this.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = PrinterTable.class$("java.lang.Number")) : class$java$lang$Number, new PrinterTableCellRenderer());
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    return;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    return;
                }
            }

            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    return;
                }
            }
        });
    }

    public void processMouseEvent(MouseEvent e) {
        block4: {
            try {
                if (this.isBusy()) {
                    return;
                }
                if (e.isShiftDown()) {
                    if (e.getID() != 502) break block4;
                    int prevRow = this.getSelectedRows()[0];
                    int currRow = this.rowAtPoint(e.getPoint());
                    DefaultListSelectionModel rowSelector = (DefaultListSelectionModel)this.getSelectionModel();
                    rowSelector.setSelectionInterval(prevRow, currRow);
                    this.repaint();
                    break block4;
                }
                super.processMouseEvent(e);
            }
            catch (Exception ee) {}
        }
    }

    public void PageUp() {
        Rectangle table = this.getVisibleRect();
        int range = this.rowAtPoint(new Point(2, table.height - 2));
        int current = this.getSelectedRow();
        int newrow = current - range - 1;
        if (newrow > 0) {
            this.setRowSelectionInterval(newrow, newrow);
            Rectangle visRect = this.getCellRect(newrow, 0, true);
            this.scrollRectToVisible(visRect);
        } else {
            newrow = 0;
            this.setRowSelectionInterval(newrow, newrow);
            Rectangle visRect = this.getCellRect(newrow, 0, true);
            this.scrollRectToVisible(visRect);
        }
    }

    public void PageDown() {
        Rectangle table = this.getVisibleRect();
        int range = this.rowAtPoint(new Point(2, table.height - 2));
        int current = this.getSelectedRow();
        int newrow = current + range + 1;
        if (newrow < this.getRowCount()) {
            this.setRowSelectionInterval(newrow, newrow);
            Rectangle visRect = this.getCellRect(newrow, 0, true);
            this.scrollRectToVisible(visRect);
        } else {
            newrow = this.getRowCount() - 1;
            this.setRowSelectionInterval(newrow, newrow);
            Rectangle visRect = this.getCellRect(newrow, 0, true);
            this.scrollRectToVisible(visRect);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (this.isBusy()) {
            return;
        }
        int code = evt.getKeyCode();
        int id = evt.getID();
        if (code == 224) {
            code = 38;
        } else if (code == 225) {
            code = 40;
        } else {
            if (code == 33) {
                if (id == 401) {
                    this.PageUp();
                }
                return;
            }
            if (code == 34) {
                if (id == 401) {
                    this.PageDown();
                }
                return;
            }
        }
        KeyEvent e = new KeyEvent((Component)evt.getSource(), id, evt.getWhen(), evt.getModifiers(), code);
        super.processKeyEvent(e);
    }

    public synchronized void setBusy(boolean busyFlag) {
        this.busyFlag = busyFlag;
        if (busyFlag) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setEnabled(false);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setEnabled(true);
        }
    }

    public synchronized boolean isBusy() {
        return this.busyFlag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PrinterTableCellRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        private Color unselectedForeground;
        private Color unselectedBackground;

        public PrinterTableCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            this.setBorder(this.noFocusBorder);
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }
}

