/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class PrinterProperties {
    static ResourceBundle bundle;
    String printerName;
    String productinfo;
    String truetype;
    String psversion;
    String pslanglvl;
    int totalram;
    String freeram;
    String type11Fonts;
    int numdisks;
    int disksize;
    int freedisk;
    String totalpages;
    DownloadProperties downloadProps;
    FontInfo[] allFonts;
    String[] CIDFontArray;
    String[] CMAPArray;
    String statusStr;
    Object[] propsArray;
    String errorMsg;
    String exitserverpasswd;
    int curr;
    public static String US_LETTER_PAPERSIZE_STR;
    public static String US_LEGAL_PAPERSIZE_STR;
    public static String A4_PAPERSIZE_STR;
    public static int US_LETTER_PAPERSIZE_INDEX;
    public static int US_LEGAL_PAPERSIZE_INDEX;
    public static int A4_PAPERSIZE_INDEX;
    public static int DEC_RADIX;
    public static int HEX_RADIX;
    public static final int FTYPE_TRUETYPE = 0;
    public static final int FTYPE_TYPE1_ASCII = 1;
    public static final int FTYPE_TYPE1_BIN = 2;
    public static final int FTYPE_TYPE42 = 3;
    public static final int FTYPE_CID = 4;
    public static final int FTYPE_CMAP = 5;
    FontDownloaderMainFrame parent;
    public static final String s1;
    public static final String s2;
    public static final String s3;
    public static final String s4;
    public static final String s5;
    public static final String s6;
    public static final String s7;
    public static final String s8;
    public static final String s9;
    public static final String s10;
    public static final String s11 = ".";
    public static final String s12;
    public static final String s13;
    public static final String s14;
    public static final String s15;
    public static final String s16;
    public static final String s17;
    public static final String s18;
    public static final String s19;
    public static final String s20;
    public static final String s21;
    public static final String s22;
    public static final String s23;
    public static final String s24;
    public static final String s25;
    public static final String s26;
    public static final String s27;
    public static final String s28;
    public static final String s29;

    public static String getMessage(String key) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load the resource bundle.");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public PrinterProperties(String printername, FontDownloaderMainFrame p) {
        this.printerName = printername;
        this.exitserverpasswd = "0";
        this.numdisks = -1;
        this.parent = p;
    }

    native int DownloadProgress();

    native String RemoveFonts(String var1, String var2, FontInfo[] var3, ProgressMonitorDialog var4);

    native String RemoveCIDFiles(String var1, String var2, String[] var3, ProgressMonitorDialog var4);

    native String RemoveCMapFiles(String var1, String var2, String[] var3, ProgressMonitorDialog var4);

    native String ResetPrinter(String var1, String var2, StatusBarPanel var3);

    native String queryPrinterProps(String var1, StatusBarPanel var2);

    native String Download(String var1, String var2, DownloadProperties[] var3, String var4, ProgressMonitorDialog var5);

    native String FormatDisk(String var1, String var2);

    native String PrintSample(String var1, String var2, int var3, int var4, int var5);

    native String PrintFontList(String var1);

    static native int GetFileType(String var0);

    int CheckAndParse(String s) {
        String pStr = s;
        if (s == null || s.length() == 0) {
            pStr = "-8";
        }
        if (s.charAt(0) == '+') {
            this.propsArray = StringParser.parseString(pStr.substring(1));
            this.ArrayToProps();
            return 0;
        }
        this.errorMsg = PrinterProperties.getMessage("printerproperties.tcp/ip_printer_driver_error:") + PrinterProperties.getErrorMessage(Integer.valueOf(pStr.substring(1)));
        return -1;
    }

    public String resetPrinter() {
        String s = this.ResetPrinter(this.printerName, this.exitserverpasswd, this.parent.statusPanel);
        if (s == null || s.length() == 0) {
            return "-8";
        }
        return s;
    }

    public void printFontList() {
        this.PrintFontList(this.printerName);
    }

    public int formatDisk() {
        String s = this.FormatDisk(this.printerName, this.exitserverpasswd);
        return this.CheckAndParse(s);
    }

    public void setDownloadProperties(DownloadProperties downloadProps) {
        this.downloadProps = downloadProps;
    }

    public void printSampleFont(String printer, String fontname, int radix, int papertype) {
        int height;
        int width;
        if (papertype == US_LETTER_PAPERSIZE_INDEX) {
            width = 612;
            height = 792;
        } else if (papertype == US_LEGAL_PAPERSIZE_INDEX) {
            width = 612;
            height = 1008;
        } else {
            width = 595;
            height = 841;
        }
        this.PrintSample(printer, fontname, radix, width, height);
    }

    String StringCheckAndAssign(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    String[] ArrayCheckAndAssign(Object o) {
        if (o.getClass().isArray()) {
            int n = ((Object[])o).length;
            String[] ret = new String[n];
            int i = 0;
            while (i < n) {
                Object oo = ((Object[])o)[i];
                if (!(oo instanceof String)) {
                    return null;
                }
                ret[i] = (String)oo;
                ++i;
            }
            return ret;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FontInfo[] FontInfoCheckAndAssign(Object o) {
        if (o.getClass().isArray()) {
            int n = ((Object[])o).length;
            FontInfo[] ret = new FontInfo[n];
            int i = 0;
            while (i < n) {
                Object oo = ((Object[])o)[i];
                if (!oo.getClass().isArray()) return null;
                if (((Object[])oo).length != 3) return null;
                Object s1 = ((Object[])oo)[0];
                Object s2 = ((Object[])oo)[1];
                Object s3 = ((Object[])oo)[2];
                if (!(s1 instanceof String && s2 instanceof String && s3 instanceof String)) {
                    return null;
                }
                ret[i] = new FontInfo((String)s1, Integer.parseInt((String)s2), Integer.parseInt((String)s3));
                ++i;
            }
            return ret;
        }
        System.err.println(PrinterProperties.getMessage("printerproperties.***_invalid_font_list_(4)"));
        return null;
    }

    void ArrayToProps() {
        this.psversion = this.StringCheckAndAssign(this.propsArray[0]);
        this.productinfo = this.StringCheckAndAssign(this.propsArray[1]);
        this.pslanglvl = this.StringCheckAndAssign(this.propsArray[2]);
        this.truetype = this.StringCheckAndAssign(this.propsArray[3]);
        this.type11Fonts = this.StringCheckAndAssign(this.propsArray[4]);
        this.totalram = Integer.parseInt(this.StringCheckAndAssign(this.propsArray[5]));
        this.freeram = this.StringCheckAndAssign(this.propsArray[6]);
        this.numdisks = Integer.parseInt(this.StringCheckAndAssign(this.propsArray[7]));
        this.disksize = Integer.parseInt(this.StringCheckAndAssign(this.propsArray[8]));
        this.freedisk = Integer.parseInt(this.StringCheckAndAssign(this.propsArray[9]));
        this.totalpages = this.StringCheckAndAssign(this.propsArray[10]);
        this.allFonts = this.FontInfoCheckAndAssign(this.propsArray[11]);
        this.CIDFontArray = this.ArrayCheckAndAssign(this.propsArray[12]);
        this.CMAPArray = this.ArrayCheckAndAssign(this.propsArray[13]);
        Arrays.sort(this.allFonts, new FontInfoComparator());
        if (this.productinfo.compareTo("LaserWriter 8500") == 0) {
            boolean z = false;
            boolean s = false;
            int n = this.allFonts.length;
            Vector<FontInfo> v = new Vector<FontInfo>(n);
            int i = 0;
            while (i < n) {
                if (this.allFonts[i].name.compareTo("Symbol") == 0) {
                    if (!s) {
                        v.add(this.allFonts[i]);
                    }
                    s = true;
                } else if (this.allFonts[i].name.compareTo("ZapfDingbats") == 0) {
                    if (!z) {
                        v.add(this.allFonts[i]);
                    }
                    z = true;
                } else {
                    v.add(this.allFonts[i]);
                }
                ++i;
            }
            Object[] oo = v.toArray();
            this.allFonts = new FontInfo[oo.length];
            int i2 = 0;
            while (i2 < oo.length) {
                this.allFonts[i2] = (FontInfo)oo[i2];
                ++i2;
            }
        }
    }

    String GetAllPropertiesPrim() {
        String s = this.queryPrinterProps(this.printerName, this.parent.statusPanel);
        if (s == null || s.length() == 0) {
            return "-8";
        }
        return s;
    }

    public int getAllProperties() {
        String s = this.GetAllPropertiesPrim();
        if (s.charAt(0) == '+') {
            this.propsArray = StringParser.parseString(s.substring(1));
            this.ArrayToProps();
            return 0;
        }
        this.errorMsg = PrinterProperties.getMessage("printerproperties.tcp/ip_printer_driver_error:") + PrinterProperties.getErrorMessage(Integer.valueOf(s.substring(1)));
        return -1;
    }

    public int getAllProperties(String s) {
        if (s.charAt(0) == '+') {
            this.propsArray = StringParser.parseString(s.substring(1));
            this.ArrayToProps();
            return 0;
        }
        this.errorMsg = PrinterProperties.getMessage("printerproperties.tcp/ip_printer_driver_error:") + PrinterProperties.getErrorMessage(Integer.valueOf(s.substring(1)));
        return -1;
    }

    private static String getErrorMessage(int messageID) {
        switch (messageID) {
            case 1: {
                return PrinterProperties.getMessage("printerproperties.printer_not_found");
            }
            case 2: {
                return PrinterProperties.getMessage("printerproperties.invalid_printer_name");
            }
            case 3: {
                return PrinterProperties.getMessage("printerproperties.could_not_connect_to_the_printer_(connection_timed_out_or_refused)");
            }
            case 4: {
                return PrinterProperties.getMessage("printerproperties.socket_error");
            }
            case 5: {
                return PrinterProperties.getMessage("printerproperties.error_writing_to_the_socket");
            }
            case 6: {
                return PrinterProperties.getMessage("printerproperties.attempt_to_write_more_data_after_eof_has_been_sent");
            }
            case 7: {
                return PrinterProperties.getMessage("printerproperties.error_reading_from_the_socket");
            }
            case 8: {
                return PrinterProperties.getMessage("printerproperties.internal_error");
            }
        }
        return PrinterProperties.getMessage("printerproperties.unknown_error");
    }

    public String getExitServerPasswd() {
        return this.exitserverpasswd;
    }

    public void setExitServerPasswd(String passwd) {
        this.exitserverpasswd = passwd;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public String getProductInfo() {
        return this.productinfo;
    }

    public String isTrueType() {
        return this.truetype;
    }

    public String getPSVersion() {
        return this.psversion;
    }

    public String getPSLangLevel() {
        return this.pslanglvl;
    }

    public String getTotalRam() {
        int r = this.totalram / 1024;
        if (r > 1024) {
            return String.valueOf(r / 1024) + PrinterProperties.getMessage("printerproperties.mb");
        }
        return String.valueOf(r) + PrinterProperties.getMessage("printerproperties.kb");
    }

    public String isType11Fonts() {
        return this.type11Fonts;
    }

    public String getFreeRam() {
        return this.freeram;
    }

    public int getNumDisks() {
        return this.numdisks;
    }

    public String getFreeDisk() {
        return String.valueOf(this.freedisk / 1024) + PrinterProperties.getMessage("printerproperties.mb");
    }

    public String getDiskSize() {
        return String.valueOf(this.disksize / 1024) + PrinterProperties.getMessage("printerproperties.mb");
    }

    public String getTotalPages() {
        return this.totalpages;
    }

    public String getStatusMessage() {
        return new String();
    }

    public void close() {
    }

    public int getDownloadProgress() {
        return this.DownloadProgress();
    }

    public static int getFileType(String fontpath) {
        return PrinterProperties.GetFileType(fontpath);
    }

    static {
        US_LETTER_PAPERSIZE_STR = "US Letter";
        US_LEGAL_PAPERSIZE_STR = "US Legal";
        A4_PAPERSIZE_STR = "A4";
        US_LETTER_PAPERSIZE_INDEX = 0;
        US_LEGAL_PAPERSIZE_INDEX = 1;
        A4_PAPERSIZE_INDEX = 2;
        DEC_RADIX = 0;
        HEX_RADIX = 1;
        s1 = PrinterProperties.getMessage("printerproperties.connecting_to_a_printer_dot_");
        s2 = PrinterProperties.getMessage("printerproperties.removing_from_ram:");
        s3 = PrinterProperties.getMessage("printerproperties.removing_from_the_disk:");
        s4 = PrinterProperties.getMessage("printerproperties.reading_properties_dot_");
        s5 = PrinterProperties.getMessage("printerproperties.resetting_dot_");
        s6 = PrinterProperties.getMessage("printerproperties.removing_a_cid_font:");
        s7 = PrinterProperties.getMessage("printerproperties.removing_a_cmap_file:");
        s8 = PrinterProperties.getMessage("printerproperties.updating_the_list_of_fonts_dot_");
        s9 = PrinterProperties.getMessage("printerproperties.converting_to_postscript_and_downlolading:_%s");
        s10 = PrinterProperties.getMessage("printerproperties.(file_%d_of_%d)");
        s12 = PrinterProperties.getMessage("printerproperties.converting_to_cid_and_downlolading:_%s");
        s13 = PrinterProperties.getMessage("printerproperties.downloading:_%s");
        s14 = PrinterProperties.getMessage("printerproperties.downloading_cid:_%s");
        s15 = PrinterProperties.getMessage("printerproperties.downloading_cmap:_%s");
        s16 = PrinterProperties.getMessage("printerproperties.error_creating_temporary_file");
        s17 = PrinterProperties.getMessage("printerproperties.error_#_%d_occured_new_line_");
        s18 = PrinterProperties.getMessage("printerproperties.error_converting_a_truetype_font_to_postscript_dot__error_code:_%d_dot__new_line_");
        s19 = PrinterProperties.getMessage("printerproperties.using_cmap:");
        s20 = PrinterProperties.getMessage("printerproperties.system_error_(cmaperror)_'%s';_file:_'%s',_line:_%d_dot__new_line_");
        s21 = PrinterProperties.getMessage("printerproperties.error_converting_a_truetype_font_to_cid_dot__error_code:_%d_(%s)_dot__new_line_");
        s22 = PrinterProperties.getMessage("printerproperties.'name'_or_'head'_table_is_missing");
        s23 = PrinterProperties.getMessage("printerproperties.truetype_font_does_not_have_a_postscript_name_defined_in_the_'name'_table");
        s24 = PrinterProperties.getMessage("printerproperties.cmap_file_does_not_define_any_mappings");
        s25 = PrinterProperties.getMessage("printerproperties.bogus_cmap_file");
        s26 = PrinterProperties.getMessage("printerproperties.truetype_'cmap'_file_could_not_be_used");
        s27 = PrinterProperties.getMessage("printerproperties.one_of_the_truetype_tables_is_too_big");
        s28 = PrinterProperties.getMessage("printerproperties.unknown_error");
        s29 = PrinterProperties.getMessage("printerproperties.no_error");
    }
}

