/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JTextField;

class PrinterNameTextField
extends JTextField {
    JButton escapeButton;
    JButton addButton;
    FontDownloaderMainFrame parent;
    int textLen;
    boolean checkFlag;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public PrinterNameTextField(FontDownloaderMainFrame parent, int width, boolean checkFlag) {
        this.parent = parent;
        this.textLen = width;
        this.checkFlag = checkFlag;
    }

    public boolean setRequestFocusEnabled() {
        return true;
    }

    public boolean isFocusTranversable() {
        return true;
    }

    public void actionKeys(JButton escapeButton, JButton addButton) {
        this.escapeButton = escapeButton;
        this.addButton = addButton;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.textLen, super.getPreferredSize().height);
    }

    public void processKeyEvent(KeyEvent e) {
        if (this.escapeButton != null && e.getKeyCode() == 27) {
            this.escapeButton.doClick();
            return;
        }
        if (this.addButton != null && e.getKeyCode() == 65 && e.isAltDown()) {
            if (e.getID() == 401) {
                this.addButton.doClick();
            }
            e.consume();
            return;
        }
        if (e.getKeyCode() == 67 && e.isAltDown()) {
            this.escapeButton.doClick();
            return;
        }
        if (e.isControlDown()) {
            if (e.getKeyCode() == 10 && e.getID() == 401) {
                this.addButton.doClick();
            }
            e.consume();
            return;
        }
        String enteredText = this.getText().trim();
        if (enteredText.length() == 0) {
            super.processKeyEvent(e);
            return;
        }
        if (this.checkFlag) {
            String printername = enteredText;
            if (e.getKeyCode() == 10 && e.getID() == 402) {
                if (e.getKeyCode() == 10) {
                    this.parent.addPrinterListener.addPrinter.commentField.requestFocus();
                }
                return;
            }
        }
        super.processKeyEvent(e);
    }
}

