/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PrinterListPanel
extends JPanel {
    PrinterTable prtTable = null;
    JScrollPane scrollpane;
    JTableHeader header = null;
    FontDownloaderMainFrame fontdl;
    DefaultListSelectionModel rowSelector;
    SortableTable sortableModel;
    JMenuBar menuBar = null;
    boolean shiftkey = false;
    String[] printerlist = null;
    int direction = 0;
    final int SHIFT_UP_DIR = 1;
    final int SHIFT_DN_DIR = 2;
    int[] selectedRows = null;
    Vector columnIds;
    public static int COL1_WIDTH = 120;
    public static int COL2_WIDTH = 175;
    TableColumn col1;
    TableColumn col2;
    TableColumn col3;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public PrinterListPanel(FontDownloaderMainFrame fontdl) {
        this.fontdl = fontdl;
        this.createPrinterList();
        this.scrollpane = new JScrollPane(this.prtTable);
        this.scrollpane.setHorizontalScrollBarPolicy(30);
        this.scrollpane.setVerticalScrollBarPolicy(20);
        this.setLayout(new PrinterListPanelLayout(this));
        this.columnIds = new Vector();
        this.columnIds.addElement(new String(this.getMessage("printerlistpanel.printer_name")));
        this.columnIds.addElement(new String(this.getMessage("printerlistpanel.printer_type")));
        this.columnIds.addElement(new String(this.getMessage("printerlistpanel.comments")));
        this.sortableModel.setColumnIdentifiers(this.columnIds);
    }

    public void setPrinterList(String[] printerlist) {
        this.printerlist = printerlist;
        if (printerlist != null) {
            Vector printerData = new Vector();
            int i = 0;
            while (i < printerlist.length) {
                String prtType;
                Vector<String> record = new Vector<String>();
                String printername = printerlist[i];
                UserDefaults ud = FontDownloaderMainFrame.userdefs;
                record.addElement(printername);
                String commentStr = ud.stringForKey(printername + ".comments");
                if (commentStr == null) {
                    commentStr = new String();
                }
                if ((prtType = ud.stringForKey(printername + ".prttype")) == null || prtType.trim().length() == 0) {
                    prtType = "Generic (Port 9100)";
                }
                record.addElement(prtType);
                record.addElement(commentStr);
                printerData.addElement(record);
                ++i;
            }
            this.sortableModel.setDataVector(printerData, this.columnIds);
            this.prtTable.setBackground(Color.white);
            this.rowSelector.setSelectionInterval(0, 0);
            Vector<Vector> tempPrinterList = this.sortableModel.getDataVector();
            this.sortableModel.setUnsortedDataVector(tempPrinterList);
        }
    }

    void createPrinterList() {
        TableCellRenderer renderer3;
        TableCellRenderer renderer2;
        this.sortableModel = new SortableTable(0);
        this.prtTable = new PrinterTable(this.sortableModel);
        this.col1 = new TableColumn(0, 100);
        this.col1.setIdentifier(new String(this.getMessage("printerlistpanel.printer_name")));
        this.col1.setHeaderValue(new String(this.getMessage("printerlistpanel.printer_name")));
        this.col1.setPreferredWidth(COL1_WIDTH);
        this.col2 = new TableColumn(1, 100);
        this.col2.setIdentifier(new String(this.getMessage("printerlistpanel.printer_type")));
        this.col2.setHeaderValue(new String(this.getMessage("printerlistpanel.printer_type")));
        this.col2.setPreferredWidth(COL2_WIDTH);
        this.col3 = new TableColumn(2, 100);
        this.col3.setIdentifier(new String(this.getMessage("printerlistpanel.comments")));
        this.col3.setHeaderValue(new String(this.getMessage("printerlistpanel.comments")));
        this.prtTable.addColumn(this.col1);
        this.prtTable.addColumn(this.col2);
        this.prtTable.addColumn(this.col3);
        this.prtTable.setAutoResizeMode(0);
        this.header = this.prtTable.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setResizingAllowed(true);
        this.prtTable.setTableHeader(this.header);
        this.prtTable.setAutoCreateColumnsFromModel(false);
        this.prtTable.setColumnSelectionAllowed(false);
        this.prtTable.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.rowSelector = new DefaultListSelectionModel();
        this.rowSelector.setSelectionMode(0);
        this.prtTable.setSelectionModel(this.rowSelector);
        this.prtTable.setGridColor(Color.white);
        this.prtTable.setBackground(Color.white);
        this.prtTable.getCellSelectionEnabled();
        this.prtTable.setSelectionBackground(Color.black);
        TableCellRenderer renderer = this.col1.getHeaderRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)renderer).setToolTipText(this.getMessage("printerlistpanel.logical_name_of_the_printer"));
        }
        if ((renderer2 = this.col2.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)renderer2).setToolTipText(this.getMessage("printerlistpanel.printer_type"));
        }
        if ((renderer3 = this.col3.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)renderer3).setToolTipText(this.getMessage("printerlistpanel.comments"));
        }
        this.header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (PrinterListPanel.this.prtTable.isBusy() || PrinterListPanel.this.prtTable.getRowCount() <= 1) {
                    return;
                }
                boolean PRTNAME_COLNUM = false;
                Point point = e.getPoint();
                int colnum = PrinterListPanel.this.header.columnAtPoint(point);
                String colId = PrinterListPanel.this.sortableModel.getColumnName(colnum);
                if (colId.equals(PrinterListPanel.this.getMessage("printerlistpanel.printer_name"))) {
                    return;
                }
                if (colId.equals(PrinterListPanel.this.getMessage("printerlistpanel.printer_type")) || colId.equals(PrinterListPanel.this.getMessage("printerlistpanel.comments"))) {
                    return;
                }
                int selRow = PrinterListPanel.this.prtTable.getSelectedRow();
                String sortIndicator = new String();
                int newRow = PrinterListPanel.this.sortableModel.toggleNextState(colnum, selRow);
                PrinterListPanel.this.rowSelector.setSelectionInterval(newRow, newRow);
                int currentState = PrinterListPanel.this.sortableModel.getCurrentState(colnum);
                sortIndicator = currentState == SortableTable.UNSORTED ? "" : (currentState == SortableTable.SORTED_ASCENDING ? "(^)" : "(v)");
                DefaultTableColumnModel colModel = (DefaultTableColumnModel)PrinterListPanel.this.prtTable.getColumnModel();
                TableColumn col = colModel.getColumn(colnum);
                col.setHeaderValue(colId + sortIndicator);
                if (PrinterListPanel.this.menuBar == null) {
                    PrinterListPanel.this.menuBar = PrinterListPanel.this.fontdl.getFMenuBar();
                }
                int HEIGHT_CONST = PrinterListPanel.this.menuBar.getSize().height + PrinterListPanel.this.fontdl.statusPanel.getSize().height + 70;
                int rowHeight = PrinterListPanel.this.prtTable.getRowHeight();
                int viewportHeight = rowHeight * newRow;
                int currentViewableHeight = PrinterListPanel.this.fontdl.getSize().height - HEIGHT_CONST;
                if (viewportHeight > PrinterListPanel.this.prtTable.getVisibleRect().height) {
                    PrinterListPanel.this.prtTable.scrollRectToVisible(new Rectangle(0, viewportHeight, 400, 450));
                } else {
                    PrinterListPanel.this.prtTable.scrollRectToVisible(new Rectangle(0, viewportHeight, 400, currentViewableHeight));
                }
            }
        });
        this.prtTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selRow = PrinterListPanel.this.prtTable.getSelectedRow();
                if (PrinterListPanel.this.menuBar == null) {
                    PrinterListPanel.this.menuBar = PrinterListPanel.this.fontdl.getFMenuBar();
                }
                if (e.getClickCount() > 0) {
                    int clickCount = e.getClickCount();
                    if (selRow >= 0) {
                        JMenu editMenu = PrinterListPanel.this.menuBar.getMenu(1);
                        JMenuItem fontbundle = editMenu.getItem(0);
                        fontbundle.setEnabled(true);
                        JMenu dlMenu = PrinterListPanel.this.menuBar.getMenu(0);
                        JMenuItem font = dlMenu.getItem(0);
                        JMenuItem fontbundle2 = dlMenu.getItem(1);
                        font.setEnabled(true);
                        fontbundle2.setEnabled(true);
                        JMenu prtMenu = PrinterListPanel.this.menuBar.getMenu(2);
                        JMenuItem delMenuItem = prtMenu.getItem(1);
                        delMenuItem.setEnabled(true);
                        JMenuItem propMenuItem = prtMenu.getItem(5);
                        propMenuItem.setEnabled(true);
                        JMenuItem restartMenuItem = prtMenu.getItem(3);
                        restartMenuItem.setEnabled(true);
                        JMenu fontMenu = PrinterListPanel.this.menuBar.getMenu(3);
                        fontMenu.setEnabled(true);
                        JMenuItem downloadMenuItem = fontMenu.getItem(0);
                        downloadMenuItem.setEnabled(true);
                        if (clickCount == 2) {
                            propMenuItem.doClick();
                        }
                    }
                    PrinterListPanel.this.selectedRows = PrinterListPanel.this.prtTable.getSelectedRows();
                }
            }

            public void mouseReleased(MouseEvent e) {
                int selRow = PrinterListPanel.this.prtTable.getSelectedRow();
                if (selRow < 0) {
                    return;
                }
                int numPrinters = PrinterListPanel.this.prtTable.getSelectedRowCount();
                StatusBarPanel statusBar = PrinterListPanel.this.fontdl.statusPanel;
                statusBar.displayStatus(" ");
            }
        });
        this.prtTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean fireMouseEvent = true;
                int key = e.getKeyCode();
                if (PrinterListPanel.this.menuBar == null) {
                    PrinterListPanel.this.menuBar = PrinterListPanel.this.fontdl.getFMenuBar();
                }
                int HEIGHT_CONST = PrinterListPanel.this.menuBar.getSize().height + PrinterListPanel.this.fontdl.statusPanel.getSize().height + 70;
                int rowHeight = PrinterListPanel.this.prtTable.getRowHeight();
                int numSelected = PrinterListPanel.this.prtTable.getSelectedRowCount();
                if (numSelected > 1) {
                    PrinterListPanel.this.selectedRows = PrinterListPanel.this.prtTable.getSelectedRows();
                }
                int row = PrinterListPanel.this.prtTable.getSelectedRow();
                switch (key) {
                    case 38: {
                        boolean prevRow = false;
                        boolean newRow = false;
                        boolean viewportHeight = false;
                        break;
                    }
                    case 36: {
                        int newRow;
                        int prevRow;
                        if (!PrinterListPanel.this.shiftkey) {
                            PrinterListPanel.this.prtTable.clearSelection();
                            prevRow = 0;
                            newRow = 0;
                        } else {
                            prevRow = row;
                            newRow = 0;
                        }
                        PrinterListPanel.this.rowSelector.setSelectionInterval(newRow, prevRow);
                        PrinterListPanel.this.prtTable.scrollRectToVisible(PrinterListPanel.this.prtTable.getCellRect(0, 0, true));
                        PrinterListPanel.this.repaint();
                        break;
                    }
                    case 35: {
                        int newRow;
                        int prevRow;
                        int lastRow = PrinterListPanel.this.prtTable.getRowCount();
                        --lastRow;
                        if (!PrinterListPanel.this.shiftkey) {
                            PrinterListPanel.this.prtTable.clearSelection();
                            prevRow = lastRow;
                            newRow = lastRow;
                        } else {
                            prevRow = row;
                            newRow = lastRow;
                        }
                        PrinterListPanel.this.rowSelector.setSelectionInterval(prevRow, newRow);
                        Rectangle visRect = PrinterListPanel.this.prtTable.getCellRect(lastRow, 0, true);
                        PrinterListPanel.this.prtTable.scrollRectToVisible(visRect);
                        break;
                    }
                    case 40: {
                        break;
                    }
                    case 16: {
                        PrinterListPanel.this.shiftkey = true;
                        break;
                    }
                    case 34: {
                        JViewport vp = PrinterListPanel.this.scrollpane.getViewport();
                        Rectangle newView = vp.getViewRect();
                        int currentY = newView.y;
                        int viewportHeight = newView.height;
                        int newY = currentY + viewportHeight;
                        int lastRow = PrinterListPanel.this.prtTable.getRowCount();
                        Rectangle rect = PrinterListPanel.this.prtTable.getCellRect(--lastRow, 0, true);
                        if (newY > rect.y) {
                            newY = rect.y;
                        }
                        newView.y = newY;
                        vp.scrollRectToVisible(newView);
                        if (!PrinterListPanel.this.shiftkey) break;
                        int prevRow = PrinterListPanel.this.selectedRows != null ? PrinterListPanel.this.selectedRows[0] : row;
                        int newRow = newY / rowHeight;
                        if (newRow >= PrinterListPanel.this.prtTable.getRowCount()) {
                            newRow = PrinterListPanel.this.prtTable.getRowCount() - 1;
                        }
                        PrinterListPanel.this.rowSelector.setSelectionInterval(prevRow, newRow);
                        PrinterListPanel.this.repaint();
                        break;
                    }
                    case 33: {
                        JViewport vp = PrinterListPanel.this.scrollpane.getViewport();
                        Rectangle newView = vp.getViewRect();
                        int rowsPerPage = newView.height / rowHeight;
                        newView.y -= rowHeight * 7;
                        if (newView.y < 0) {
                            newView.y = 0;
                        }
                        PrinterListPanel.this.prtTable.scrollRectToVisible(newView);
                        if (PrinterListPanel.this.shiftkey) {
                            if (PrinterListPanel.this.selectedRows != null) {
                                int prevRow = PrinterListPanel.this.selectedRows[numSelected - 1];
                            } else {
                                int prevRow = row;
                            }
                        }
                        PrinterListPanel.this.repaint();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 16: {
                        PrinterListPanel.this.shiftkey = false;
                        break;
                    }
                    default: {
                        MouseEvent mousevt = new MouseEvent(PrinterListPanel.this.prtTable, 502, 0L, 0, 0, 0, 1, false);
                        PrinterListPanel.this.prtTable.dispatchEvent(mousevt);
                        PrinterListPanel.this.prtTable.repaint();
                    }
                }
            }
        });
    }

    public class PrinterListPanelLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int scrollPaneWidth;
        int scrollPaneHeight;

        public PrinterListPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(PrinterListPanel.this.scrollpane);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.scrollPaneWidth = this.panelWidth - 10;
            this.scrollPaneHeight = this.panelHeight - 10;
            PrinterListPanel.this.scrollpane.setBounds(5, 5, this.scrollPaneWidth, this.scrollPaneHeight);
            int totalwidth = PrinterListPanel.this.scrollpane.getWidth();
            Insets i = PrinterListPanel.this.prtTable.getInsets();
            int width = (int)((double)(totalwidth -= i.left + i.right) * 0.3);
            PrinterListPanel.this.col1.setPreferredWidth(width);
            PrinterListPanel.this.col2.setPreferredWidth(width);
            width = (int)((double)totalwidth * 0.4);
            PrinterListPanel.this.col3.setPreferredWidth(width);
        }
    }
}

