/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ListKeyListener
extends KeyAdapter {
    JList list;
    JScrollPane listScrollPane;
    int direction = 0;
    final int SHIFT_UP_DIR = 1;
    final int SHIFT_DN_DIR = 2;
    boolean listShiftKey = false;
    boolean upDirection = false;
    JLabel statusLabel;
    public static int[] listSelectedRowIndices;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public ListKeyListener(JList list, JScrollPane scrollPane) {
        this.list = list;
        this.listScrollPane = scrollPane;
        this.statusLabel = null;
    }

    public void setStatusLabel(JLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        int row = this.list.getSelectedIndex();
        int[] rowList = this.list.getSelectedIndices();
        int maxRowCount = this.list.getModel().getSize();
        this.listShiftKey = e.isShiftDown();
        switch (key) {
            case 40: {
                this.list.clearSelection();
                if (++row >= maxRowCount) {
                    row = maxRowCount - 1;
                }
                if (!this.listShiftKey) {
                    this.list.setSelectedIndex(row);
                } else {
                    int rowListCount = rowList.length;
                    int[] newRowList = null;
                    if (rowListCount == 1 && this.direction == 1) {
                        this.direction = 2;
                    }
                    if (this.direction == 1) {
                        newRowList = new int[rowListCount - 1];
                        int i = 1;
                        while (i < rowListCount) {
                            newRowList[i - 1] = rowList[i];
                            ++i;
                        }
                    } else {
                        newRowList = new int[rowListCount + 1];
                        this.direction = 2;
                        int i = 0;
                        while (i < rowListCount) {
                            newRowList[i] = rowList[i];
                            ++i;
                        }
                        row = rowList[rowListCount - 1];
                        if (++row >= maxRowCount) {
                            row = maxRowCount - 1;
                        }
                        newRowList[rowListCount] = row;
                    }
                    this.list.setSelectedIndices(newRowList);
                }
                this.list.ensureIndexIsVisible(row);
                break;
            }
            case 38: {
                this.list.clearSelection();
                if (--row < 0) {
                    row = 0;
                }
                if (!this.listShiftKey) {
                    this.list.setSelectedIndex(row);
                } else {
                    int rowListCount = rowList.length;
                    int[] newRowList = null;
                    if (rowListCount == 1 && this.direction == 2) {
                        this.direction = 1;
                    }
                    if (this.direction == 2) {
                        newRowList = new int[rowListCount - 1];
                        int i = 0;
                        while (i < rowListCount - 1) {
                            newRowList[i] = rowList[i];
                            ++i;
                        }
                    } else {
                        this.direction = 1;
                        newRowList = new int[rowListCount + 1];
                        int i = 0;
                        while (i < rowListCount) {
                            newRowList[i + 1] = rowList[i];
                            ++i;
                        }
                        newRowList[0] = row;
                    }
                    this.list.setSelectedIndices(newRowList);
                }
                this.list.ensureIndexIsVisible(row);
                break;
            }
            case 36: {
                this.list.clearSelection();
                if (!this.listShiftKey) {
                    this.list.setSelectedIndex(0);
                    this.list.ensureIndexIsVisible(0);
                    break;
                }
                int numRowsUp = row;
                int[] newRowList = new int[numRowsUp + 1];
                int i = 0;
                while (i < numRowsUp + 1) {
                    newRowList[i] = i;
                    ++i;
                }
                this.list.setSelectedIndices(newRowList);
                break;
            }
            case 35: {
                this.list.clearSelection();
                if (!this.listShiftKey) {
                    this.list.setSelectedIndex(maxRowCount - 1);
                    this.list.ensureIndexIsVisible(maxRowCount - 1);
                    break;
                }
                int numRowsDown = maxRowCount - row;
                int[] newRowList = new int[numRowsDown];
                int i = 0;
                while (i < numRowsDown) {
                    newRowList[i] = row + i;
                    ++i;
                }
                this.list.setSelectedIndices(newRowList);
                break;
            }
            case 34: {
                JViewport vp = this.listScrollPane.getViewport();
                int currentY = vp.getViewRect().y;
                int viewportHeight = vp.getViewRect().height;
                int newY = currentY + viewportHeight;
                Rectangle newView = new Rectangle(0, newY, vp.getViewRect().width, viewportHeight);
                int firstVisibleIndex = this.list.getFirstVisibleIndex();
                int lastVisibleIndex = this.list.getLastVisibleIndex();
                int numVisibleItems = lastVisibleIndex - firstVisibleIndex;
                if (lastVisibleIndex < 0) {
                    return;
                }
                if (firstVisibleIndex >= 0 && lastVisibleIndex + numVisibleItems <= this.list.getModel().getSize()) {
                    this.list.scrollRectToVisible(newView);
                }
                if (this.listShiftKey) {
                    int rowListCount = rowList.length;
                    int currentRow = rowList[rowListCount - 1];
                    int visibleIndex = this.list.getFirstVisibleIndex();
                    int[] newList = null;
                    if (visibleIndex > currentRow) {
                        int addRowCount = visibleIndex - currentRow;
                        newList = new int[addRowCount + rowListCount];
                        int i = 0;
                        while (i < rowListCount) {
                            newList[i] = rowList[i];
                            ++i;
                        }
                        int i2 = rowListCount;
                        while (i2 < newList.length) {
                            newList[i2] = currentRow++;
                            ++i2;
                        }
                    } else {
                        int addRowCount = maxRowCount - currentRow;
                        newList = new int[addRowCount + rowListCount];
                        int i = 0;
                        while (i < rowListCount) {
                            newList[i] = rowList[i];
                            ++i;
                        }
                        int i3 = rowListCount;
                        while (i3 < newList.length) {
                            newList[i3] = currentRow++;
                            ++i3;
                        }
                    }
                    this.list.setSelectedIndices(newList);
                    break;
                }
                int newRow = row + numVisibleItems;
                if (newRow >= this.list.getModel().getSize()) {
                    newRow = this.list.getModel().getSize() - 1;
                }
                this.list.setSelectedIndex(newRow);
                this.list.ensureIndexIsVisible(newRow);
                break;
            }
            case 33: {
                JViewport vp = this.listScrollPane.getViewport();
                int currentY = vp.getViewRect().y;
                int viewportHeight = vp.getViewRect().height;
                int newY = currentY - viewportHeight;
                if (newY < 0) {
                    newY = 0;
                }
                Rectangle newView = new Rectangle(0, newY, vp.getViewRect().width, viewportHeight);
                this.list.scrollRectToVisible(newView);
                int firstVisibleIndex = this.list.getFirstVisibleIndex();
                int lastVisibleIndex = this.list.getLastVisibleIndex();
                if (lastVisibleIndex < 0) {
                    return;
                }
                int numVisibleItems = lastVisibleIndex - firstVisibleIndex;
                if (this.listShiftKey) {
                    int rowListCount = rowList.length;
                    int currentRow = rowList[0];
                    int visibleIndex = this.list.getFirstVisibleIndex();
                    int[] newList = null;
                    int addRowCount = currentRow - visibleIndex;
                    newList = new int[addRowCount + rowListCount];
                    int i = 0;
                    while (i < addRowCount) {
                        newList[i] = visibleIndex++;
                        ++i;
                    }
                    int i4 = 0;
                    while (i4 < rowListCount) {
                        newList[i4 + addRowCount] = rowList[i4];
                        ++i4;
                    }
                    this.list.setSelectedIndices(newList);
                    break;
                }
                int newRow = row - numVisibleItems;
                if (newRow < 0) {
                    newRow = 0;
                }
                this.list.setSelectedIndex(newRow);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                listSelectedRowIndices = this.list.getSelectedIndices();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 16: {
                this.listShiftKey = false;
                break;
            }
        }
        if (this.statusLabel != null) {
            int[] numSelected = this.list.getSelectedIndices();
            int numfonts = numSelected.length;
            this.statusLabel.getParent().invalidate();
            this.statusLabel.invalidate();
            if (numfonts > 1) {
                this.statusLabel.setText(numfonts + this.getMessage("listkeylistener.fonts_are_selected"));
            } else {
                int rowsel = numSelected[0];
                String fontName = (String)this.list.getSelectedValue();
                this.statusLabel.setText(this.getMessage("listkeylistener.font_selected:") + fontName);
            }
            this.statusLabel.validate();
            this.statusLabel.getParent().validate();
        }
    }
}

