/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class FontDownloaderMainFrame
extends JFrame {
    public static String fdlLibrary = "pfnt";
    ResourceBundle bundle;
    JMenuBar menuBar = null;
    public PrinterListPanel prtList = null;
    AddPrinterActionListener addPrinterListener = null;
    DeletePrinterActionListener delPrinterListener = null;
    PropertiesActionListener propActionListener = null;
    CleanUpListener cleanUpListener = null;
    DownloadListener downloadListener = null;
    EditPropsListener editPropsListener = null;
    DownloadFontSetListener downloadFontSetListener = null;
    DownloadBundleListener downloadBundleListener = null;
    RestartPrinterListener restartPrinterListener = null;
    AboutListener aboutListener = null;
    JProgressBar statusBar;
    public static Font defaultFont;
    public StatusBarPanel statusPanel;
    public PrinterProperties prtProps;
    FontDownloaderMainFrame instance;
    public final int WIDTH = new Integer(this.getMessage("dimensions.fontdownloadermainframe_width"));
    public final int HEIGHT = new Integer(this.getMessage("dimensions.fontdownloadermainframe_height"));
    public static UserDefaults userdefs;
    public static String ICON_HOME;
    public static String lastVisitedDir;
    public static String FACTORY_DEFAULTS;
    public ProgressMonitorDialog pmd;
    public static int CTimeOut;
    String[] initialPrinters;
    Vector tablePaths;
    XlatManager xman;
    public final String DefaultCMapFolder = "/usr/dt/lib/fdl/CMap/Adobe:/usr/dt/lib/fdl/CMap/Sun";
    public String cmapfolder;
    CMapManager cman;
    public Dimension globalButtonDim;
    boolean busyFlag;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public FontDownloaderMainFrame() {
        Image img;
        ImageIcon fdlicon;
        this.setTitle(this.getMessage("fontdownloadermainframe.fdl_title") + " " + this.getMessage("fontdownloadermainframe.fdl_version"));
        this.frameInit();
        Properties sysprops = System.getProperties();
        String userhome = sysprops.getProperty("user.home");
        userdefs = UserDefaults.readFromBinaryFile(userhome + "/.fdlrc");
        if (userdefs == null) {
            userdefs = new UserDefaults();
            this.AddFactoryBundles();
        }
        defaultFont = Font.decode("default");
        this.instance = this;
        this.prtProps = null;
        JButton tempButton = new JButton(this.getMessage("fontdownloadermainframe.download"));
        tempButton.validate();
        this.globalButtonDim = new JButton(this.getMessage("fontdownloadermainframe.download")).getPreferredSize();
        this.getContentPane().setLayout(new BorderLayout());
        this.prtList = new PrinterListPanel(this);
        this.createMenuBar();
        this.getContentPane().add((Component)this.menuBar, "North");
        this.getContentPane().add((Component)this.prtList, "Center");
        this.statusPanel = new StatusBarPanel();
        this.statusPanel.validate();
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.busyFlag = false;
        Object[] objectlist = null;
        String[] printerlist = null;
        Long cto = userdefs.longForKey("Timeout");
        CTimeOut = cto == null ? 40 : cto.intValue();
        objectlist = userdefs.arrayForKey("PrinterList");
        if (objectlist != null) {
            printerlist = new String[objectlist.length];
            this.initialPrinters = printerlist;
            int i = 0;
            while (i < printerlist.length) {
                printerlist[i] = (String)objectlist[i];
                ++i;
            }
            if (printerlist.length > 0) {
                this.prtList.setPrinterList(printerlist);
            }
        } else {
            this.statusPanel.displayStatus(this.getMessage("fontdownloadermainframe.no_printers_in_user_defaults_database"));
        }
        if (this.prtList.prtTable.getRowCount() > 0) {
            MouseEvent mousevt = new MouseEvent(this.prtList, 500, 0L, 0, 0, 0, 1, false);
            this.prtList.prtTable.dispatchEvent(mousevt);
            String printerName = (String)this.prtList.prtTable.getValueAt(0, 0);
            MessageFormat formatter = new MessageFormat("");
            Object[] obj = new Object[]{printerName};
            this.statusPanel.displayStatus(" ");
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame frame = (JFrame)e.getComponent();
                Dimension windim = frame.getSize();
                if (windim.width < FontDownloaderMainFrame.this.WIDTH || windim.height < FontDownloaderMainFrame.this.HEIGHT) {
                    FontDownloaderMainFrame.this.setSize(FontDownloaderMainFrame.this.WIDTH, FontDownloaderMainFrame.this.HEIGHT);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                new CleanUpListener(FontDownloaderMainFrame.this.instance).actionPerformed(null);
            }

            public void windowIconified(WindowEvent e) {
                FontDownloaderMainFrame.this.setTitle("fdl");
            }

            public void windowDeiconified(WindowEvent e) {
                FontDownloaderMainFrame.this.setTitle(FontDownloaderMainFrame.this.getMessage("fontdownloadermainframe.fdl_title") + " " + FontDownloaderMainFrame.this.getMessage("fontdownloadermainframe.fdl_version"));
            }
        });
        RepaintManager repaintMgr = RepaintManager.currentManager(this.getRootPane());
        if (!repaintMgr.isDoubleBufferingEnabled()) {
            repaintMgr.setDoubleBufferingEnabled(true);
        }
        if ((fdlicon = new ImageIcon(ICON_HOME + "fdl.l.gif")) != null && (img = fdlicon.getImage()) != null && fdlicon.getIconWidth() > 0) {
            this.setIconImage(img);
        }
        DefaultKeyboardFocusManager dkfm = new DefaultKeyboardFocusManager();
        FocusTraversalPolicy defaultPolicy = dkfm.getDefaultFocusTraversalPolicy();
        FdlFocusManager fdlFocusMgr = new FdlFocusManager();
        FocusManager.setCurrentManager(fdlFocusMgr);
        dkfm.setDefaultFocusTraversalPolicy(defaultPolicy);
        System.loadLibrary(fdlLibrary);
        this.tablePaths = (Vector)userdefs.objectForKey("Tablepaths");
        if (this.tablePaths == null) {
            this.tablePaths = new Vector();
            this.tablePaths.removeAllElements();
        }
        if (this.tablePaths.isEmpty()) {
            this.tablePaths.addElement(XlatManager.GetPlatformDefaultPath());
            userdefs.add("Tablepaths", this.tablePaths);
        }
        this.xman = new XlatManager(this.getColonSeparatedPath());
        this.cmapfolder = CMapManager.GetEnvCMapPath();
        if (this.cmapfolder == null || this.cmapfolder.trim().length() == 0) {
            this.cmapfolder = "/usr/dt/lib/fdl/CMap/Adobe:/usr/dt/lib/fdl/CMap/Sun";
        }
        this.cman = new CMapManager(this.cmapfolder);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Runnable forGettingFocus = new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        DefaultKeyboardFocusManager defaultKeyboardFocusManager = new DefaultKeyboardFocusManager();
                    }
                };
                SwingUtilities.invokeLater(forGettingFocus);
            }
        });
    }

    public void AddFactoryBundles() {
        UserDefaults factory = UserDefaults.readFromBinaryFile(FACTORY_DEFAULTS);
        if (factory == null) {
            return;
        }
        Object[] fl = factory.arrayForKey("FontsetList");
        int n = fl.length;
        if (n == 0) {
            return;
        }
        userdefs.add("FontsetList", fl);
        int i = 0;
        while (i < n) {
            String key = "fontset." + (String)fl[i];
            Object[] val = factory.arrayForKey(key);
            userdefs.add(key, val);
            ++i;
        }
    }

    public JMenuBar getFMenuBar() {
        return this.menuBar;
    }

    public synchronized void setBusy(boolean busyFlag) {
        this.busyFlag = busyFlag;
        if (busyFlag) {
            MenuElement[] menulist = this.menuBar.getSubElements();
            int i = 0;
            while (i < menulist.length) {
                menulist[i].getComponent().setEnabled(false);
                ++i;
            }
        } else {
            MenuElement[] menulist = this.menuBar.getSubElements();
            int i = 0;
            while (i < menulist.length) {
                menulist[i].getComponent().setEnabled(true);
                ++i;
            }
        }
    }

    private synchronized boolean isBusy() {
        return this.busyFlag;
    }

    public String getColonSeparatedPath() {
        int size = this.tablePaths.size();
        String pathList = "";
        int i = 0;
        while (i < size) {
            pathList = pathList + (String)this.tablePaths.elementAt(i);
            if (i != size - 1) {
                pathList = pathList + ":";
            }
            ++i;
        }
        return pathList;
    }

    void createMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu downloadMenu = this.menuBar.add(new JMenu(this.getMessage("fontdownloadermainframe.download")));
        downloadMenu.setMnemonic(68);
        JMenuItem fontMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.font"));
        fontMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        fontMenuItem.setEnabled(false);
        downloadMenu.add(fontMenuItem);
        fontMenuItem.setMnemonic(70);
        this.downloadListener = new DownloadListener(this.instance);
        fontMenuItem.addActionListener(this.downloadListener);
        JMenuItem downloadFontSetMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.font_bundle"));
        downloadMenu.add(downloadFontSetMenuItem);
        downloadFontSetMenuItem.setMnemonic(66);
        KeyStroke keystroke = KeyStroke.getKeyStroke(66, 2);
        downloadFontSetMenuItem.setAccelerator(keystroke);
        this.downloadBundleListener = new DownloadBundleListener(this.instance);
        downloadFontSetMenuItem.addActionListener(this.downloadBundleListener);
        downloadFontSetMenuItem.setEnabled(false);
        JMenuItem exitMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.exit"));
        exitMenuItem.setMnemonic(88);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        downloadMenu.add(new JSeparator());
        downloadMenu.add(exitMenuItem);
        this.cleanUpListener = new CleanUpListener(this);
        exitMenuItem.addActionListener(this.cleanUpListener);
        this.menuBar.registerKeyboardAction(this.cleanUpListener, KeyStroke.getKeyStroke(88, 8), 2);
        JMenu editMenu = new JMenu(this.getMessage("fontdownloadermainframe.edit"));
        editMenu.setMnemonic(69);
        this.menuBar.add(editMenu);
        JMenuItem fontsetMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.font_bundle"));
        fontsetMenuItem.setMnemonic(66);
        fontsetMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8, true));
        JMenuItem propsMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.properties"));
        propsMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8, false));
        editMenu.add(fontsetMenuItem);
        editMenu.add(propsMenuItem);
        this.editPropsListener = new EditPropsListener(this.instance);
        fontsetMenuItem.addActionListener(new DownloadFontSetListener(this.instance, true, true));
        propsMenuItem.addActionListener(this.editPropsListener);
        JMenu printerMenu = new JMenu(this.getMessage("fontdownloadermainframe.printer"));
        printerMenu.setMnemonic(80);
        this.menuBar.add(printerMenu);
        JMenuItem addMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.add"));
        addMenuItem.setMnemonic(65);
        addMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 8));
        JMenuItem delMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.remove"));
        delMenuItem.setMnemonic(68);
        delMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 8));
        JMenuItem propMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.properties"));
        propMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        JMenuItem restartPrinterMenuItem = new JMenuItem(this.getMessage("fontdownloadermainframe.reset"));
        restartPrinterMenuItem.setMnemonic(82);
        keystroke = KeyStroke.getKeyStroke(82, 8);
        restartPrinterMenuItem.setAccelerator(keystroke);
        printerMenu.add(addMenuItem);
        printerMenu.add(delMenuItem);
        printerMenu.add(new JSeparator());
        printerMenu.add(restartPrinterMenuItem);
        printerMenu.add(new JSeparator());
        printerMenu.add(propMenuItem);
        this.addPrinterListener = new AddPrinterActionListener(this.prtList);
        addMenuItem.addActionListener(this.addPrinterListener);
        delMenuItem.setEnabled(false);
        this.delPrinterListener = new DeletePrinterActionListener(this.prtList);
        delMenuItem.addActionListener(this.delPrinterListener);
        propMenuItem.setEnabled(false);
        this.propActionListener = new PropertiesActionListener(this.instance);
        propMenuItem.addActionListener(this.propActionListener);
        restartPrinterMenuItem.setEnabled(false);
        this.restartPrinterListener = new RestartPrinterListener();
        restartPrinterMenuItem.addActionListener(this.restartPrinterListener);
        JMenu helpMenu = this.menuBar.add(new JMenu(this.getMessage("fontdownloadermainframe.help")));
        JMenuItem aboutMenu = new JMenuItem(this.getMessage("fontdownloadermainframe.about"));
        aboutMenu.setMnemonic(65);
        helpMenu.add(aboutMenu);
        this.aboutListener = new AboutListener(this.instance);
        aboutMenu.addActionListener(this.aboutListener);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("UI Manager Fatal Exception: " + e.getMessage());
            System.exit(1);
        }
        FontDownloaderMainFrame fdl = new FontDownloaderMainFrame();
        Dimension d = new Dimension(fdl.WIDTH, fdl.HEIGHT);
        fdl.setSize(d);
        Dimension currentSize = fdl.getSize();
        Dimension screenSize = fdl.getToolkit().getScreenSize();
        fdl.setLocation((screenSize.width - currentSize.width) / 2, (screenSize.height - currentSize.height) / 2);
        fdl.pack();
        fdl.setVisible(true);
    }

    public void processKeyEvent(KeyEvent evt) {
        int id = evt.getID();
        if (id == 402) {
            return;
        }
    }

    static {
        ICON_HOME = "/usr/dt/lib/fdl/icons/";
        lastVisitedDir = null;
        FACTORY_DEFAULTS = "/usr/dt/lib/fdl/bundles.def";
    }

    class RestartPrinterListener
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            int row = FontDownloaderMainFrame.this.instance.prtList.prtTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            String printerName = (String)FontDownloaderMainFrame.this.instance.prtList.prtTable.getValueAt(row, 0);
            if (FontDownloaderMainFrame.this.instance.prtProps == null) {
                FontDownloaderMainFrame.this.instance.prtProps = new PrinterProperties(printerName, FontDownloaderMainFrame.this.instance);
            } else {
                String currentPrtName = FontDownloaderMainFrame.this.instance.prtProps.getPrinterName();
                if (!printerName.equals(currentPrtName)) {
                    FontDownloaderMainFrame.this.instance.prtProps.close();
                    FontDownloaderMainFrame.this.instance.prtProps = new PrinterProperties(printerName, FontDownloaderMainFrame.this.instance);
                }
            }
            String confirmStr = FontDownloaderMainFrame.this.instance.getMessage("fontdownloadermainframe.resetting_the_printer_will_cause_a_loss_of_fonts_new_line_");
            confirmStr = confirmStr + FontDownloaderMainFrame.this.instance.getMessage("fontdownloadermainframe.that_you_may_have_downloaded_to_the_ram_dot__new_line__new_line_");
            confirmStr = confirmStr + FontDownloaderMainFrame.this.instance.getMessage("fontdownloadermainframe.are_you_sure_that_you_wish_to_reset_the_printer?");
            int ans = JOptionPane.showConfirmDialog(FontDownloaderMainFrame.this.instance, confirmStr, FontDownloaderMainFrame.this.instance.getMessage("fontdownloadermainframe.reset_printer_confirm_dialog"), 0);
            FontDownloaderMainFrame.this.instance.setCursor(new Cursor(3));
            if (ans == 0) {
                FontDownloaderMainFrame.this.pmd = new ProgressMonitorDialog(FontDownloaderMainFrame.this.instance, FontDownloaderMainFrame.this.getMessage("fontdownloadermainframe.resetting_printer:") + printerName);
                FontDownloaderMainFrame.this.pmd.setTitle(FontDownloaderMainFrame.this.getMessage("fontdownloadermainframe.progress:_resetting_printer"));
                new ProgressMonitorThread().start();
                new ResetPrinterThread(FontDownloaderMainFrame.this.instance, printerName, FontDownloaderMainFrame.this.pmd).start();
            }
        }
    }

    public class ProgressMonitorThread
    extends Thread {
        public void run() {
            Thread t = new Thread(FontDownloaderMainFrame.this.pmd);
            t.setPriority(10);
            t.start();
            FontDownloaderMainFrame.this.pmd.setVisible(true);
        }
    }

    public class ResetPrinterThread
    extends Thread {
        FontDownloaderMainFrame fdl;
        String printerName;
        ProgressMonitorDialog pmd;

        public ResetPrinterThread(FontDownloaderMainFrame fdl, String printerName, ProgressMonitorDialog pmd) {
            this.setPriority(3);
            this.fdl = fdl;
            this.printerName = printerName;
            this.pmd = pmd;
        }

        public void run() {
            this.fdl.prtProps.resetPrinter();
            this.pmd.setTrue();
            MessageFormat formatter = new MessageFormat("");
            Object[] obj = new Object[]{this.printerName};
            this.fdl.statusPanel.displayStatus(MessageFormat.format(this.fdl.getMessage("fontdownloadermainframe.printer_reset"), obj));
            this.fdl.setCursor(new Cursor(0));
        }
    }

    class CleanUpListener
    extends AbstractAction {
        FontDownloaderMainFrame fdl;

        public CleanUpListener(FontDownloaderMainFrame fdl) {
            this.fdl = fdl;
        }

        public void actionPerformed(ActionEvent evt) {
            if (FontDownloaderMainFrame.this.initialPrinters != null) {
                int i = 0;
                while (i < FontDownloaderMainFrame.this.initialPrinters.length) {
                    String name = FontDownloaderMainFrame.this.initialPrinters[i];
                    userdefs.remove(name + ".prttype");
                    userdefs.remove(name + ".comments");
                    ++i;
                }
            }
            DefaultTableModel model = (DefaultTableModel)this.fdl.prtList.prtTable.getModel();
            Vector<Vector> printerData = model.getDataVector();
            int numelems = printerData.size();
            Object[] printerlist = new String[numelems];
            int i = 0;
            while (i < numelems) {
                Vector record = printerData.elementAt(i);
                String printername = (String)record.elementAt(0);
                printerlist[i] = printername;
                ++i;
            }
            userdefs.add("FDLRC_VERSION", "1");
            userdefs.add("PrinterList", printerlist);
            int i2 = 0;
            while (i2 < printerlist.length) {
                Vector record = printerData.elementAt(i2);
                String printername = (String)record.elementAt(0);
                String prtInterface = (String)record.elementAt(1);
                String comments = (String)record.elementAt(2);
                userdefs.add(printername + ".prttype", prtInterface);
                userdefs.add(printername + ".comments", comments);
                ++i2;
            }
            Properties sysprops = System.getProperties();
            String userhome = sysprops.getProperty("user.home");
            userdefs.saveToBinaryFile(userhome + "/.fdlrc", false);
            System.exit(0);
        }
    }
}

