/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class EditBundleDialog
extends JDialog
implements ListCallbackInt {
    public FontDownloaderList fontList;
    DefaultListSelectionModel rowSelector;
    PrinterTable fontbundleList;
    JTableHeader header = null;
    SortableTable sortableModel;
    Vector columnIds;
    TableColumn col1;
    TableColumn col2;
    public Boolean isOpened = new Boolean(false);
    public JButton addFontButton;
    public JButton removeFontButton;
    public JButton propsFontButton;
    JTextField bundleName;
    JLabel bundlename;
    JLabel fonts;
    public JButton cancelButton;
    JButton okButton;
    JScrollPane scrollPane;
    DownloadProperties[] edittedFontList;
    public StatusBarPanel downloadStatusPanel;
    public DefaultListModel defListModel;
    String oldname = "";
    String newname = "";
    FontDownloaderMainFrame parent;
    int selectedBundle;
    DownloadFontSetDialog downloadFontSetDialog;
    PrinterProperties prtProps;
    int[] rowsSelected;
    boolean mouseWasDragged = false;
    public Boolean downloadSync = new Boolean(false);
    EditBundleDialog editBundleDialog;
    Vector downloadPropsList = new Vector();
    final int WIDTH = new Integer(this.getMessage("dimensions.editbundledialog_width"));
    final int HEIGHT = new Integer(this.getMessage("dimensions.editbundledialog_height"));
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public EditBundleDialog(FontDownloaderMainFrame parent, DownloadFontSetDialog downloadFontSetDialog, PrinterProperties prtProps, int selectedBundle) {
        super(parent);
        this.setTitle(this.getMessage("editbundledialog.edit_font_bundle"));
        this.parent = parent;
        this.prtProps = prtProps;
        this.selectedBundle = selectedBundle;
        this.downloadFontSetDialog = downloadFontSetDialog;
        this.editBundleDialog = this;
        this.oldname = (String)downloadFontSetDialog.sortableModel.getValueAt(selectedBundle, 0);
        this.newname = null;
        this.getContentPane().setLayout(new BorderLayout());
        Dimension d = parent.getSize();
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setModal(true);
        this.createFontList();
        this.bundleName = new JTextField((String)downloadFontSetDialog.sortableModel.getValueAt(selectedBundle, 0));
        this.bundleName.setBackground(Color.white);
        this.bundlename = new JLabel(this.getMessage("editbundledialog.bundle_name:"));
        this.fonts = new JLabel(this.getMessage("editbundledialog.fonts:"));
        this.scrollPane = new JScrollPane(this.fontList, 20, 30);
        this.scrollPane.setBackground(Color.white);
        this.createControlButtons();
        int width = this.getSize().width;
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new EditDialogLayout(compositePanel));
        this.getContentPane().add((Component)compositePanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Runnable forGettingFocus = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).addFontButton.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(forGettingFocus);
            }

            static /* synthetic */ EditBundleDialog access$000(1 x0) {
                return x0.EditBundleDialog.this;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < EditBundleDialog.this.WIDTH || windim.height < EditBundleDialog.this.HEIGHT) {
                    EditBundleDialog.this.setSize(EditBundleDialog.this.WIDTH, EditBundleDialog.this.HEIGHT);
                }
            }
        });
        Dimension dim = new Dimension();
        dim = parent.getSize();
        this.setLocation(parent.getLocation().x, parent.getLocation().y + dim.height);
        this.propsFontButton.setEnabled(false);
        this.removeFontButton.setEnabled(false);
        this.propsFontButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditBundleDialog.this.propsFontButton.doClick();
            }
        }, KeyStroke.getKeyStroke(10, 8), 2);
        this.addActions();
        FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
        fdlFocusMgr.registerAction(27, this.cancelButton, this);
        fdlFocusMgr.registerAction(155, this.addFontButton, this);
        fdlFocusMgr.registerAction(127, this.removeFontButton, this);
        if (this.okButton != null) {
            fdlFocusMgr.registerAction(10, this.okButton, this);
        }
    }

    public void createBundleListTable() {
        this.rowSelector = new DefaultListSelectionModel();
        this.rowSelector.setSelectionInterval(0, 0);
        this.rowSelector.setSelectionMode(2);
        this.sortableModel = new SortableTable(0);
        this.fontbundleList = new PrinterTable(this.sortableModel);
        this.fontbundleList.setBackground(Color.white);
        this.fontbundleList.setGridColor(Color.white);
        this.fontbundleList.setAutoResizeMode(0);
        this.col1 = new TableColumn(0, 100);
        this.col1.setIdentifier(new String(this.getMessage("editbundledialog.bundle_name")));
        this.col1.setHeaderValue(new String(this.getMessage("editbundledialog.bundle_name")));
        this.col2 = new TableColumn(1, 100);
        this.col2.setIdentifier(new String(this.getMessage("editbundledialog.number_of_fonts")));
        this.col2.setHeaderValue(new String(this.getMessage("editbundledialog.number_of_fonts")));
        this.fontbundleList.addColumn(this.col1);
        this.fontbundleList.addColumn(this.col2);
        this.header = this.fontbundleList.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setResizingAllowed(true);
        this.fontbundleList.setTableHeader(this.header);
        this.fontbundleList.setAutoCreateColumnsFromModel(false);
        this.fontbundleList.setColumnSelectionAllowed(false);
        this.fontbundleList.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.fontbundleList.setSelectionModel(this.rowSelector);
        this.fontbundleList.setGridColor(Color.white);
        this.fontbundleList.setBackground(Color.white);
        this.fontbundleList.getCellSelectionEnabled();
        this.fontbundleList.setSelectionBackground(Color.black);
        this.scrollPane = new JScrollPane(this.fontbundleList);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.fontbundleList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    default: 
                }
            }

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 33: {
                        break;
                    }
                    case 36: {
                        int prevRow = 0;
                        int newRow = 0;
                        EditBundleDialog.this.rowSelector.setSelectionInterval(newRow, prevRow);
                        EditBundleDialog.this.fontbundleList.scrollRectToVisible(EditBundleDialog.this.fontbundleList.getCellRect(0, 0, true));
                        EditBundleDialog.this.repaint();
                        break;
                    }
                    case 35: {
                        int lastRow = EditBundleDialog.this.fontbundleList.getRowCount();
                        int prevRow = --lastRow;
                        int newRow = lastRow;
                        EditBundleDialog.this.rowSelector.setSelectionInterval(prevRow, newRow);
                        Rectangle visRect = EditBundleDialog.this.fontbundleList.getCellRect(lastRow, 0, true);
                        EditBundleDialog.this.fontbundleList.scrollRectToVisible(visRect);
                    }
                }
            }
        });
    }

    void createFontList() {
        this.defListModel = new DefaultListModel();
        this.fontList = new FontDownloaderList(this.defListModel, this.editBundleDialog);
        this.fontList.setBackground(Color.white);
        if (this.defListModel.size() > 0) {
            this.fontList.setSelectedIndex(0);
        }
    }

    void createControlButtons() {
        this.propsFontButton = new JButton(this.getMessage("downloadfontdialog.font_properties"));
        this.addFontButton = new JButton(this.getMessage("downloadfontdialog.add_font"));
        this.removeFontButton = new JButton(this.getMessage("downloadfontdialog.remove_font"));
        this.cancelButton = new JButton(this.getMessage("downloadfontdialog.cancel"));
        this.okButton = new JButton(this.getMessage("downloadfontdialog.ok"));
        this.addFontButton.setMnemonic(65);
        this.removeFontButton.setMnemonic(82);
        this.propsFontButton.setMnemonic(80);
    }

    public DownloadProperties[] getEdittedFontList() {
        return this.edittedFontList;
    }

    public void setFontList(DownloadProperties[] list) {
        this.defListModel.removeAllElements();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                DownloadProperties dp = list[i];
                this.defListModel.add(i, dp.fontpathstr);
                this.downloadPropsList.addElement(dp);
                ++i;
            }
            if (list.length > 0) {
                this.removeFontButton.setEnabled(true);
                this.propsFontButton.setEnabled(true);
                this.fontList.setSelectedIndex(0);
            }
        }
    }

    public void setListSelections(int[] rowsSelected) {
        this.rowsSelected = rowsSelected;
    }

    public int[] getListSelections() {
        return this.rowsSelected;
    }

    void addActions() {
        this.addFontButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Boolean bl = EditBundleDialog.this.isOpened;
                synchronized (bl) {
                    if (EditBundleDialog.this.isOpened.booleanValue()) {
                        return;
                    }
                }
                Boolean bl2 = EditBundleDialog.this.isOpened;
                synchronized (bl2) {
                    EditBundleDialog.this.isOpened = new Boolean(true);
                }
                JFileChooser fileDialog = new JFileChooser();
                fileDialog.setDialogTitle(EditBundleDialog.this.getMessage("downloadfontdialog.add_font"));
                fileDialog.setDialogType(0);
                if (FontDownloaderMainFrame.lastVisitedDir == null) {
                    String userhome;
                    Properties sysprops = System.getProperties();
                    FontDownloaderMainFrame.lastVisitedDir = userhome = sysprops.getProperty("user.home");
                }
                fileDialog.setCurrentDirectory(new File(FontDownloaderMainFrame.lastVisitedDir));
                int state = fileDialog.showOpenDialog(EditBundleDialog.this.parent);
                Boolean bl3 = EditBundleDialog.this.isOpened;
                synchronized (bl3) {
                    EditBundleDialog.this.isOpened = new Boolean(false);
                }
                if (state == 1) {
                    return;
                }
                String fontdir = null;
                try {
                    fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException io) {
                    // empty catch block
                }
                String fontfile = null;
                if (fileDialog.getSelectedFile() != null) {
                    fontfile = fileDialog.getSelectedFile().getName();
                }
                if (fileDialog.getCurrentDirectory() != null) {
                    try {
                        fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                }
                if (fontdir == null && fontfile == null) {
                    return;
                }
                String fontElement = "";
                if (fontdir != null && fontfile == null) {
                    fontElement = fontdir;
                } else if (fontdir != null && fontfile != null) {
                    fontElement = fontdir + "/" + fontfile;
                }
                File file = new File(fontElement);
                if (file.isDirectory()) {
                    FontDownloaderMainFrame.lastVisitedDir = fontdir;
                    return;
                }
                int filetype = -1;
                filetype = PrinterProperties.getFileType(fontElement);
                FontDownloaderMainFrame.lastVisitedDir = fontdir;
                if (EditBundleDialog.this.prtProps != null && EditBundleDialog.this.prtProps.getNumDisks() == 0 && (filetype == 4 || filetype == 5)) {
                    String err = "The selected font (CID or CMap) can be\n";
                    err = err + "downloaded only to a printer with a \n";
                    err = err + "hard disk";
                    JOptionPane.showMessageDialog(EditBundleDialog.this.editBundleDialog, err, EditBundleDialog.this.getMessage("downloadfontdialog.no_hard_disk_error"), 0);
                    return;
                }
                if (filetype < 0) {
                    JOptionPane.showMessageDialog(EditBundleDialog.this.editBundleDialog, EditBundleDialog.this.getMessage("downloadfontdialog.this_file_does_not_appear_to_be_a_font_file_dot__file_not_added"), EditBundleDialog.this.getMessage("downloadfontdialog.font_file_type_error"), 0);
                    return;
                }
                EditBundleDialog.this.defListModel.addElement(fontElement);
                DownloadProperties dp = new DownloadProperties();
                dp.fontpathstr = fontElement;
                dp.filetype = filetype;
                EditBundleDialog.this.downloadPropsList.addElement(dp);
                EditBundleDialog.this.fontList.setSelectedValue(fontElement, true);
                EditBundleDialog.this.fontList.setSelectedIndex(EditBundleDialog.this.getListSize() - 1);
                EditBundleDialog.this.fontList.ensureIndexIsVisible(EditBundleDialog.this.getListSize() - 1);
                if (EditBundleDialog.this.defListModel.size() >= 1) {
                    EditBundleDialog.this.removeFontButton.setEnabled(true);
                    EditBundleDialog.this.propsFontButton.setEnabled(true);
                }
                EditBundleDialog.this.fontList.grabFocus();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditBundleDialog.this.edittedFontList = null;
                EditBundleDialog.this.editBundleDialog.setVisible(false);
            }
        });
        if (this.okButton != null) {
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!EditBundleDialog.this.ValidateName()) {
                        return;
                    }
                    Object[] objList = EditBundleDialog.this.defListModel.toArray();
                    EditBundleDialog.this.edittedFontList = new DownloadProperties[objList.length];
                    int i = 0;
                    while (i < EditBundleDialog.this.edittedFontList.length) {
                        DownloadProperties dp;
                        EditBundleDialog.this.edittedFontList[i] = dp = (DownloadProperties)EditBundleDialog.this.downloadPropsList.elementAt(i);
                        ++i;
                    }
                    Integer numfonts = new Integer(objList.length);
                    EditBundleDialog.this.downloadFontSetDialog.sortableModel.setValueAt(numfonts.toString(), EditBundleDialog.this.selectedBundle, 1);
                    EditBundleDialog.this.downloadFontSetDialog.ud.remove("fontset." + EditBundleDialog.this.oldname);
                    if (EditBundleDialog.this.newname != null) {
                        EditBundleDialog.this.oldname = EditBundleDialog.this.newname;
                    }
                    EditBundleDialog.this.downloadFontSetDialog.ud.add("fontset." + EditBundleDialog.this.oldname, EditBundleDialog.this.edittedFontList);
                    EditBundleDialog.this.editBundleDialog.setVisible(false);
                }
            });
        }
        RemoveFontListener removeFontListener = new RemoveFontListener();
        this.removeFontButton.addActionListener(removeFontListener);
        this.propsFontButton.addActionListener(new FontPropsListener(this.parent));
    }

    public boolean ValidateName() {
        this.newname = this.bundleName.getText().trim();
        if (this.oldname.compareTo(this.newname) == 0) {
            this.newname = null;
            return true;
        }
        if (this.newname == null || this.newname.length() == 0) {
            String emptyMessage = this.getMessage("editbundledialog.'bundle_name'_field_is_empty");
            JOptionPane.showMessageDialog(this.editBundleDialog, emptyMessage, this.getMessage("downloadfontsetdialog.error"), 0);
            this.newname = null;
            return false;
        }
        int size = this.downloadFontSetDialog.sortableModel.getRowCount();
        int i = 0;
        while (i < size) {
            if (this.newname.compareToIgnoreCase((String)this.downloadFontSetDialog.sortableModel.getValueAt(i, 0)) == 0) {
                String duplicateMessage = "'" + this.newname + "'" + this.getMessage("editbundledialog.already_exists");
                JOptionPane.showMessageDialog(this.editBundleDialog, duplicateMessage, this.getMessage("downloadfontsetdialog.error"), 0);
                this.bundleName.requestFocus();
                this.bundleName.selectAll();
                this.newname = null;
                return false;
            }
            ++i;
        }
        this.downloadFontSetDialog.sortableModel.setValueAt(this.newname, this.selectedBundle, 0);
        return true;
    }

    public int getListSize() {
        return this.fontList.getModel().getSize();
    }

    public void SetSelectedCount(int numElements) {
        if (numElements == 1) {
            this.propsFontButton.setEnabled(true);
        } else {
            this.propsFontButton.setEnabled(false);
        }
    }

    public void MouseDoubleClicked() {
        if (this.propsFontButton != null) {
            this.propsFontButton.doClick();
        }
    }

    public class EditDialogLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int controlButtonX;
        int buttonX;
        int buttonY;
        int scrollPaneWidth;
        int scrollPaneHeight;
        int controlButtonWidth;
        int controlButtonHeight;
        int buttonWidth;
        int buttonHeight;
        int labelHeight;
        int padding_left;
        int control_button_padding;
        int button_padding;

        public EditDialogLayout(Container c) {
            this.controlButtonWidth = new Integer(EditBundleDialog.this.getMessage("dimensions.controlbuttonwidth"));
            this.controlButtonHeight = new Integer(EditBundleDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.buttonWidth = new Integer(EditBundleDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            this.buttonHeight = new Integer(EditBundleDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.labelHeight = 14;
            this.padding_left = 12;
            this.control_button_padding = 12;
            this.button_padding = 12;
            this.panel = (JPanel)c;
            this.panel.add(EditBundleDialog.this.scrollPane);
            this.panel.add(EditBundleDialog.this.addFontButton);
            this.panel.add(EditBundleDialog.this.removeFontButton);
            this.panel.add(EditBundleDialog.this.propsFontButton);
            this.panel.add(EditBundleDialog.this.okButton);
            this.panel.add(EditBundleDialog.this.cancelButton);
            this.panel.add(EditBundleDialog.this.bundleName);
            this.panel.add(EditBundleDialog.this.bundlename);
            this.panel.add(EditBundleDialog.this.fonts);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = EditBundleDialog.this.WIDTH;
            dim.height = EditBundleDialog.this.HEIGHT;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = EditBundleDialog.this.WIDTH;
            dim.height = EditBundleDialog.this.HEIGHT;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.controlButtonX = this.panelWidth - this.controlButtonWidth - this.control_button_padding;
            this.scrollPaneWidth = this.panelWidth - this.controlButtonWidth - this.control_button_padding * 2 - this.padding_left;
            int labelWidth = this.panelWidth;
            int topPadding = 8;
            int textfieldHeight = 25;
            EditBundleDialog.this.bundlename.setBounds(this.padding_left, topPadding, labelWidth, this.labelHeight);
            int totalY = topPadding + this.labelHeight;
            EditBundleDialog.this.bundleName.setBounds(this.padding_left, totalY + 5, this.scrollPaneWidth, textfieldHeight);
            EditBundleDialog.this.fonts.setBounds(this.padding_left, (totalY += 5 + textfieldHeight) + 5, labelWidth, this.labelHeight);
            this.scrollPaneHeight = this.panelHeight - (totalY += 5 + this.labelHeight) - 5 - 70;
            EditBundleDialog.this.scrollPane.setBounds(this.padding_left, totalY + 5, this.scrollPaneWidth, this.scrollPaneHeight);
            EditBundleDialog.this.addFontButton.setBounds(this.controlButtonX, totalY + 5, this.controlButtonWidth, this.controlButtonHeight);
            EditBundleDialog.this.removeFontButton.setBounds(this.controlButtonX, totalY + 5 + 35, this.controlButtonWidth, this.controlButtonHeight);
            EditBundleDialog.this.propsFontButton.setBounds(this.controlButtonX, totalY + 5 + 35 + 35, this.controlButtonWidth, this.controlButtonHeight);
            this.buttonX = this.panelWidth - 2 * this.button_padding - 2 * this.buttonWidth;
            this.buttonY = (totalY += 5 + this.scrollPaneHeight) + 15;
            EditBundleDialog.this.okButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
            this.buttonX = this.buttonX + this.buttonWidth + this.button_padding;
            EditBundleDialog.this.cancelButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
        }
    }

    class FontPropsListener
    extends AbstractAction {
        FontDownloaderMainFrame frame;
        DownloadFontPropsDialog fPropsDialog;

        public FontPropsListener(FontDownloaderMainFrame parent) {
            this.frame = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Boolean bl = EditBundleDialog.this.isOpened;
            synchronized (bl) {
                if (EditBundleDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = EditBundleDialog.this.isOpened;
            synchronized (bl2) {
                EditBundleDialog.this.isOpened = new Boolean(true);
            }
            int id = EditBundleDialog.this.fontList.getSelectedIndex();
            String fontname = (String)EditBundleDialog.this.defListModel.elementAt(id);
            File fontfile = new File(fontname);
            if (!fontfile.exists() || !fontfile.canRead()) {
                JOptionPane.showMessageDialog(EditBundleDialog.this.editBundleDialog, EditBundleDialog.this.getMessage("editbundledialog.this_font_is_unavailable_and_its_properties_are_unable_to_be_quarried"), EditBundleDialog.this.getMessage("downloadfontsetdialog.error"), 0);
                Boolean bl3 = EditBundleDialog.this.isOpened;
                synchronized (bl3) {
                    EditBundleDialog.this.isOpened = new Boolean(false);
                }
                return;
            }
            DownloadProperties dp = (DownloadProperties)EditBundleDialog.this.downloadPropsList.elementAt(id);
            this.fPropsDialog = new DownloadFontPropsDialog(this.frame, EditBundleDialog.this.prtProps, dp);
            this.fPropsDialog.setVisible(true);
            Boolean bl4 = EditBundleDialog.this.isOpened;
            synchronized (bl4) {
                EditBundleDialog.this.isOpened = new Boolean(false);
            }
            this.fPropsDialog.getDownloadProperties(dp);
            EditBundleDialog.this.downloadPropsList.setElementAt(dp, id);
        }
    }

    class RemoveFontListener
    extends AbstractAction {
        RemoveFontListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            Boolean bl = EditBundleDialog.this.isOpened;
            synchronized (bl) {
                if (EditBundleDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = EditBundleDialog.this.isOpened;
            synchronized (bl2) {
                EditBundleDialog.this.isOpened = new Boolean(true);
            }
            FontDownloaderList flist = EditBundleDialog.this.editBundleDialog.fontList;
            if (flist.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(EditBundleDialog.this.editBundleDialog, EditBundleDialog.this.getMessage("downloadfontdialog.no_font_selected_for_removal"), EditBundleDialog.this.getMessage("downloadfontdialog.warning"), 2);
                Boolean bl3 = EditBundleDialog.this.isOpened;
                synchronized (bl3) {
                    EditBundleDialog.this.isOpened = new Boolean(false);
                }
                return;
            }
            String warnmsg = new String(EditBundleDialog.this.getMessage("downloadfontdialog.are_you_sure_you_want_to_remove_the_selected_fonts?"));
            int ans = JOptionPane.showConfirmDialog(EditBundleDialog.this.editBundleDialog, warnmsg, EditBundleDialog.this.getMessage("downloadfontdialog.remove_confirmation"), 0);
            Boolean bl4 = EditBundleDialog.this.isOpened;
            synchronized (bl4) {
                EditBundleDialog.this.isOpened = new Boolean(false);
            }
            if (ans == 0) {
                int[] currentSelections = flist.getSelectedIndices();
                int i = 0;
                while (i < currentSelections.length) {
                    EditBundleDialog.this.defListModel.removeElementAt(currentSelections[i] - i);
                    EditBundleDialog.this.downloadPropsList.removeElementAt(currentSelections[i] - i);
                    ++i;
                }
                int lastIndex = currentSelections[i - 1];
                if (lastIndex >= EditBundleDialog.this.defListModel.size()) {
                    lastIndex = EditBundleDialog.this.defListModel.size() - 1;
                }
                EditBundleDialog.this.fontList.setSelectedIndex(lastIndex);
            }
            if (EditBundleDialog.this.defListModel.size() == 0) {
                if (EditBundleDialog.this.propsFontButton != null) {
                    EditBundleDialog.this.propsFontButton.setEnabled(false);
                }
                EditBundleDialog.this.removeFontButton.setEnabled(false);
            }
            EditBundleDialog.this.fontList.grabFocus();
        }
    }
}

