/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DownloadFontSetDialog
extends JDialog
implements ListCallbackInt {
    public FontDownloaderList fontsetList;
    DefaultListSelectionModel rowSelector;
    PrinterTable fontbundleList;
    JTableHeader header = null;
    SortableTable sortableModel;
    Vector columnIds;
    TableColumn col1;
    TableColumn col2;
    public Boolean isOpened = new Boolean(false);
    public JButton okButton;
    public JButton addFontButton;
    public JButton removeFontButton;
    public JButton cloneFontButton;
    public JButton editFontButton;
    public JButton renameFontButton;
    public JButton defaultButton;
    public JButton cancelButton;
    UserDefaults ud = FontDownloaderMainFrame.userdefs;
    JScrollPane scrollPane;
    DownloadFontSetDialog downloadFontSetDialog;
    public DefaultListModel defListModel;
    public Boolean downloadSync = new Boolean(false);
    FontDownloaderMainFrame parentframe;
    String[] flist;
    Object[] initialFontsetList;
    Fonts[] fonts;
    PrinterProperties prtProps;
    boolean saveFlag;
    boolean editFlag;
    public int[] rowsSelected;
    final int WIDTH = new Integer(this.getMessage("dimensions.downloadfontsetdialog_width"));
    final int HEIGHT = new Integer(this.getMessage("dimensions.downloadfontsetdialog_height"));
    String downloadStatusStr;
    JPanel compositePanel;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public DownloadFontSetDialog(FontDownloaderMainFrame parentframe, PrinterProperties prtProps, boolean saveFlag, boolean editFlag) {
        super(parentframe);
        RepaintManager repaintManager;
        this.setTitle(this.getMessage("downloadfontsetdialog.font_bundle_list"));
        this.parentframe = parentframe;
        this.prtProps = prtProps;
        this.saveFlag = saveFlag;
        this.editFlag = editFlag;
        if (editFlag) {
            this.setTitle(this.getMessage("downloadfontsetdialog.edit_font_bundle_list"));
        }
        Dimension d = parentframe.getSize();
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setModal(true);
        this.downloadFontSetDialog = this;
        this.createBundleListTable();
        this.createControlButtons();
        int width = this.getSize().width;
        this.compositePanel = new JPanel();
        this.compositePanel.setLayout(new FontSetDialogLayout(this.compositePanel));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < DownloadFontSetDialog.this.WIDTH || windim.height < DownloadFontSetDialog.this.HEIGHT) {
                    DownloadFontSetDialog.this.setSize(DownloadFontSetDialog.this.WIDTH, DownloadFontSetDialog.this.HEIGHT);
                }
            }
        });
        this.getContentPane().add((Component)this.compositePanel, "Center");
        Dimension dim = parentframe.getSize();
        this.setLocation(parentframe.getLocation().x, parentframe.getLocation().y + dim.height);
        this.addActions();
        FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
        fdlFocusMgr.registerAction(27, this.cancelButton, this);
        fdlFocusMgr.registerAction(155, this.addFontButton, this);
        fdlFocusMgr.registerAction(127, this.removeFontButton, this);
        fdlFocusMgr.registerAction(10, this.editFontButton, this);
        if (this.okButton != null) {
            this.okButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DownloadFontSetDialog.this.okButton.doClick();
                }
            }, KeyStroke.getKeyStroke(10, 2), 2);
        }
        if (!(repaintManager = RepaintManager.currentManager(this.getRootPane())).isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        if (!saveFlag || editFlag) {
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    Runnable forGettingFocus = new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            3.access$000(this.this$1).fontbundleList.requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater(forGettingFocus);
                }

                static /* synthetic */ DownloadFontSetDialog access$000(3 x0) {
                    return x0.DownloadFontSetDialog.this;
                }
            });
        } else if (saveFlag) {
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    Runnable forGettingFocus = new Runnable(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            5.access$100(this.this$1).renameFontButton.requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater(forGettingFocus);
                }

                static /* synthetic */ DownloadFontSetDialog access$100(5 x0) {
                    return x0.DownloadFontSetDialog.this;
                }
            });
        }
        this.SetButtons();
    }

    public void createBundleListTable() {
        this.rowSelector = new DefaultListSelectionModel();
        this.rowSelector.setSelectionInterval(0, 0);
        this.rowSelector.setSelectionMode(2);
        this.sortableModel = new SortableTable(0);
        this.fontbundleList = new PrinterTable(this.sortableModel);
        this.fontbundleList.setBackground(Color.white);
        this.fontbundleList.setGridColor(Color.white);
        this.fontbundleList.setAutoResizeMode(0);
        this.col1 = new TableColumn(0, 100);
        this.col1.setIdentifier(new String(this.getMessage("downloadfontsetdialog.bundle_name")));
        this.col1.setHeaderValue(new String(this.getMessage("downloadfontsetdialog.bundle_name")));
        this.col2 = new TableColumn(1, 100);
        this.col2.setIdentifier(new String(this.getMessage("downloadfontsetdialog.number_of_fonts")));
        this.col2.setHeaderValue(new String(this.getMessage("downloadfontsetdialog.number_of_fonts")));
        this.fontbundleList.addColumn(this.col1);
        this.fontbundleList.addColumn(this.col2);
        this.header = this.fontbundleList.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setResizingAllowed(true);
        this.fontbundleList.setTableHeader(this.header);
        this.fontbundleList.setAutoCreateColumnsFromModel(false);
        this.fontbundleList.setColumnSelectionAllowed(false);
        this.fontbundleList.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.fontbundleList.setSelectionModel(this.rowSelector);
        this.fontbundleList.setGridColor(Color.white);
        this.fontbundleList.setBackground(Color.white);
        this.fontbundleList.getCellSelectionEnabled();
        this.fontbundleList.setSelectionBackground(Color.black);
        this.scrollPane = new JScrollPane(this.fontbundleList);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.columnIds = new Vector();
        this.columnIds.addElement(new String(this.getMessage("downloadfontsetdialog.bundle_name")));
        this.columnIds.addElement(new String(this.getMessage("downloadfontsetdialog.number_of_fonts")));
        this.sortableModel.setColumnIdentifiers(this.columnIds);
        this.addBundleListListener();
        this.FillTable();
    }

    void addBundleListListener() {
        this.fontbundleList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    default: 
                }
            }

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 33: {
                        break;
                    }
                    case 36: {
                        int prevRow = 0;
                        int newRow = 0;
                        DownloadFontSetDialog.this.rowSelector.setSelectionInterval(newRow, prevRow);
                        DownloadFontSetDialog.this.fontbundleList.scrollRectToVisible(DownloadFontSetDialog.this.fontbundleList.getCellRect(0, 0, true));
                        DownloadFontSetDialog.this.repaint();
                        break;
                    }
                    case 35: {
                        int lastRow = DownloadFontSetDialog.this.fontbundleList.getRowCount();
                        int prevRow = --lastRow;
                        int newRow = lastRow;
                        DownloadFontSetDialog.this.rowSelector.setSelectionInterval(prevRow, newRow);
                        Rectangle visRect = DownloadFontSetDialog.this.fontbundleList.getCellRect(lastRow, 0, true);
                        DownloadFontSetDialog.this.fontbundleList.scrollRectToVisible(visRect);
                    }
                }
            }
        });
        this.fontbundleList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (DownloadFontSetDialog.this.fontbundleList.getRowCount() < 1) {
                    return;
                }
                int clickCount = e.getClickCount();
                if (clickCount == 2 && DownloadFontSetDialog.this.editFontButton != null) {
                    DownloadFontSetDialog.this.editFontButton.doClick();
                }
            }
        });
    }

    void FillTable() {
        Object[] userFontsetList = this.ud.arrayForKey("FontsetList");
        if (userFontsetList != null) {
            Vector bundleData = new Vector();
            int i = 0;
            while (i < userFontsetList.length) {
                Vector<String> record = new Vector<String>();
                String bundlename = (String)userFontsetList[i];
                Object[] objFList = this.ud.arrayForKey("fontset." + bundlename);
                Integer numfonts = new Integer(objFList.length);
                String numfontsString = numfonts.toString();
                record.addElement(bundlename);
                record.addElement(numfontsString);
                bundleData.addElement(record);
                ++i;
            }
            this.initialFontsetList = userFontsetList;
            this.fonts = new Fonts[userFontsetList.length];
            int j = 0;
            while (j < userFontsetList.length) {
                this.fonts[j] = new Fonts(this.ud.arrayForKey("fontset." + (String)userFontsetList[j]), (String)userFontsetList[j]);
                ++j;
            }
            this.sortableModel.setDataVector(bundleData, this.columnIds);
            this.fontbundleList.setBackground(Color.white);
            this.rowSelector.setSelectionInterval(0, 0);
            Vector<Vector> tempPrinterList = this.sortableModel.getDataVector();
            this.sortableModel.setUnsortedDataVector(tempPrinterList);
        }
    }

    void createControlButtons() {
        this.okButton = new JButton(this.getMessage("downloadfontsetdialog.ok"));
        this.cancelButton = new JButton(this.getMessage("downloadfontsetdialog.cancel"));
        this.addFontButton = new JButton(this.getMessage("downloadfontsetdialog.add"));
        this.addFontButton.setMnemonic(65);
        this.defaultButton = new JButton(this.getMessage("downloadfontsetdialog.default"));
        this.defaultButton.setMnemonic(68);
        if (!this.saveFlag || this.editFlag) {
            this.removeFontButton = new JButton(this.getMessage("downloadfontsetdialog.remove"));
            this.editFontButton = new JButton(this.getMessage("downloadfontsetdialog.edit"));
            this.cloneFontButton = new JButton(this.getMessage("downloadfontsetdialog.clone"));
            this.renameFontButton = new JButton(this.getMessage("downloadfontsetdialog.rename"));
            this.removeFontButton.setMnemonic(82);
            this.editFontButton.setMnemonic(69);
            this.cloneFontButton.setMnemonic(76);
            this.renameFontButton.setMnemonic(78);
        } else {
            this.removeFontButton = new JButton(this.getMessage("downloadfontsetdialog.remove"));
            this.renameFontButton = new JButton(this.getMessage("downloadfontsetdialog.rename"));
            this.removeFontButton.setMnemonic(82);
            this.renameFontButton.setMnemonic(78);
        }
        if (this.renameFontButton != null) {
            this.renameFontButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DownloadFontSetDialog.this.renameFontButton.doClick();
                }
            }, KeyStroke.getKeyStroke(82, 8), 2);
        }
    }

    public void setListSelections(int[] rowsSelected) {
        this.rowsSelected = rowsSelected;
    }

    public int[] getListSelections() {
        return this.rowsSelected;
    }

    public boolean nameExistsInList(String name) {
        int size = this.sortableModel.getRowCount();
        int i = 0;
        while (i < size) {
            if (name.compareToIgnoreCase((String)this.sortableModel.getValueAt(i, 0)) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addFontSetItem(int element) {
        String newname = element == 0 ? this.getMessage("downloadfontsetdialog.new_bundle") : this.getMessage("downloadfontsetdialog.new_bundle") + " " + element;
        int size = this.sortableModel.getRowCount();
        int i = 0;
        while (i < size) {
            if (newname.compareToIgnoreCase((String)this.sortableModel.getValueAt(i, 0)) == 0) {
                this.addFontSetItem(element + 1);
                return;
            }
            ++i;
        }
        Vector<String> newitem = new Vector<String>();
        newitem.addElement(newname);
        newitem.addElement("0");
        this.sortableModel.addRow(newitem);
        Object[] objList = new Object[]{};
        this.ud.add("fontset." + newname, objList);
        int lastRow = this.sortableModel.getRowCount() - 1;
        this.rowSelector.setSelectionInterval(lastRow, lastRow);
        Rectangle visRect = this.fontbundleList.getCellRect(lastRow, 0, true);
        this.fontbundleList.scrollRectToVisible(visRect);
        this.removeFontButton.setEnabled(true);
        this.renameFontButton.setEnabled(true);
    }

    public void setFontList(String[] flist) {
        this.flist = flist;
        String fontsetName = (String)this.fontsetList.getSelectedValue();
        Object[] dpFontList = new DownloadProperties[flist.length];
        int i = 0;
        while (i < flist.length) {
            DownloadProperties dp = new DownloadProperties();
            dp.fontpathstr = flist[i];
            dpFontList[i] = dp;
            ++i;
        }
        this.ud.add("fontset." + fontsetName, dpFontList);
    }

    void addActions() {
        if (this.addFontButton != null) {
            this.addFontButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DownloadFontSetDialog.this.addFontSetItem(0);
                    DownloadFontSetDialog.this.cloneFontButton.setEnabled(true);
                    if (DownloadFontSetDialog.this.editFontButton != null) {
                        DownloadFontSetDialog.this.editFontButton.setEnabled(true);
                    }
                }
            });
        }
        if (this.defaultButton != null) {
            this.defaultButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String warnmsg = new String(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.this_action_will_clear_all_existing_font_bundles_and_restore_the_default_factory_set._would_you_like_to_continue?"));
                    int ans = JOptionPane.showConfirmDialog(null, warnmsg, DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.remove_confirmation"), 0);
                    if (ans == 0) {
                        int rows = DownloadFontSetDialog.this.sortableModel.getRowCount();
                        int i = 0;
                        while (i < rows) {
                            String name = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(0, 0);
                            DownloadFontSetDialog.this.ud.remove("fontset." + name);
                            DownloadFontSetDialog.this.sortableModel.removeRow(0);
                            ++i;
                        }
                        UserDefaults factory = UserDefaults.readFromBinaryFile(FontDownloaderMainFrame.FACTORY_DEFAULTS);
                        if (factory == null) {
                            return;
                        }
                        Object[] fl = factory.arrayForKey("FontsetList");
                        int n = fl.length;
                        if (n == 0) {
                            return;
                        }
                        int i2 = 0;
                        while (i2 < n) {
                            String name = (String)fl[i2];
                            String key = "fontset." + name;
                            Object[] val = factory.arrayForKey(key);
                            Integer numfonts = new Integer(val.length);
                            String numfontsString = numfonts.toString();
                            Vector<String> record = new Vector<String>();
                            record.addElement(name);
                            record.addElement(numfontsString);
                            DownloadFontSetDialog.this.sortableModel.addRow(record);
                            DownloadFontSetDialog.this.ud.add(key, val);
                            ++i2;
                        }
                        if (DownloadFontSetDialog.this.sortableModel.getRowCount() > 0) {
                            DownloadFontSetDialog.this.removeFontButton.setEnabled(true);
                            DownloadFontSetDialog.this.renameFontButton.setEnabled(true);
                            DownloadFontSetDialog.this.cloneFontButton.setEnabled(true);
                            if (DownloadFontSetDialog.this.editFontButton != null) {
                                DownloadFontSetDialog.this.editFontButton.setEnabled(true);
                            }
                        }
                    }
                    DownloadFontSetDialog.this.fontbundleList.setRowSelectionInterval(0, 0);
                }
            });
        }
        if (this.editFontButton != null) {
            this.editFontButton.addActionListener(new ActionListener(){
                EditBundleDialog editFontDialog = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    Boolean bl = DownloadFontSetDialog.this.isOpened;
                    synchronized (bl) {
                        if (DownloadFontSetDialog.this.isOpened.booleanValue()) {
                            return;
                        }
                    }
                    Boolean bl2 = DownloadFontSetDialog.this.isOpened;
                    synchronized (bl2) {
                        DownloadFontSetDialog.this.isOpened = new Boolean(true);
                    }
                    this.editFontDialog = new EditBundleDialog(DownloadFontSetDialog.this.parentframe, DownloadFontSetDialog.this.downloadFontSetDialog, null, DownloadFontSetDialog.this.fontbundleList.getSelectedRow());
                    int index = DownloadFontSetDialog.this.fontbundleList.getSelectedRow();
                    String fontsetName = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(index, 0);
                    Object[] objFList = DownloadFontSetDialog.this.ud.arrayForKey("fontset." + fontsetName);
                    DownloadProperties[] dpList = null;
                    if (objFList != null) {
                        dpList = new DownloadProperties[objFList.length];
                        int i = 0;
                        while (i < objFList.length) {
                            Object obj = objFList[i];
                            if (obj instanceof String) {
                                DownloadProperties dp;
                                String str = (String)objFList[i];
                                dpList[i] = dp = DownloadProperties.decode(str);
                            } else if (obj instanceof DownloadProperties) {
                                dpList[i] = (DownloadProperties)obj;
                            }
                            ++i;
                        }
                    }
                    this.editFontDialog.setFontList(dpList);
                    this.editFontDialog.setVisible(true);
                    objFList = DownloadFontSetDialog.this.ud.arrayForKey("fontset." + fontsetName);
                    Boolean bl3 = DownloadFontSetDialog.this.isOpened;
                    synchronized (bl3) {
                        DownloadFontSetDialog.this.isOpened = new Boolean(false);
                    }
                }
            });
        }
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object[] currentFontsetList = DownloadFontSetDialog.this.ud.arrayForKey("FontsetList");
                if (currentFontsetList != null) {
                    DownloadFontSetDialog.this.ud.remove("FontsetList");
                }
                if (DownloadFontSetDialog.this.sortableModel.getRowCount() != 0) {
                    Object[] fontsetStrColl = new String[DownloadFontSetDialog.this.sortableModel.getRowCount()];
                    int i = 0;
                    while (i < fontsetStrColl.length) {
                        fontsetStrColl[i] = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(i, 0);
                        ++i;
                    }
                    DownloadFontSetDialog.this.ud.add("FontsetList", fontsetStrColl);
                    int i2 = 0;
                    while (i2 < fontsetStrColl.length) {
                        Object currsetname = fontsetStrColl[i2];
                        Object[] setlist = DownloadFontSetDialog.this.ud.arrayForKey("fontset." + (String)currsetname);
                        if (setlist != null) {
                            DownloadFontSetDialog.this.ud.add("fontset." + (String)currsetname, setlist);
                        }
                        ++i2;
                    }
                }
                DownloadFontSetDialog.this.downloadFontSetDialog.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object[] currentFontsetList = DownloadFontSetDialog.this.ud.arrayForKey("FontsetList");
                int i = 0;
                while (i < DownloadFontSetDialog.this.sortableModel.getRowCount()) {
                    DownloadFontSetDialog.this.ud.remove("fontset." + (String)DownloadFontSetDialog.this.sortableModel.getValueAt(i, 0));
                    ++i;
                }
                if (currentFontsetList != null) {
                    DownloadFontSetDialog.this.ud.remove("FontsetList");
                    int j = 0;
                    while (j < DownloadFontSetDialog.this.fonts.length) {
                        DownloadFontSetDialog.this.ud.add("fontset." + DownloadFontSetDialog.this.fonts[j].bundlename, DownloadFontSetDialog.this.fonts[j].fontlist);
                        ++j;
                    }
                }
                if (DownloadFontSetDialog.this.initialFontsetList != null) {
                    DownloadFontSetDialog.this.ud.add("FontsetList", DownloadFontSetDialog.this.initialFontsetList);
                }
                DownloadFontSetDialog.this.downloadFontSetDialog.setVisible(false);
            }
        });
        RemoveFontListener removeFontListener = new RemoveFontListener();
        this.removeFontButton.addActionListener(removeFontListener);
        RenameFontSetListener renameFontSetListener = new RenameFontSetListener();
        this.renameFontButton.addActionListener(renameFontSetListener);
        if (this.cloneFontButton != null) {
            this.cloneFontButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int row = DownloadFontSetDialog.this.fontbundleList.getSelectedRow();
                    String fontsetName = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(row, 0);
                    String copyStr = DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.copy_of") + " " + fontsetName;
                    int cloneNum = 0;
                    String test = copyStr;
                    while (DownloadFontSetDialog.this.nameExistsInList(test)) {
                        test = copyStr + " " + ++cloneNum;
                    }
                    copyStr = test;
                    String numfonts = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(row, 1);
                    Vector<String> clone = new Vector<String>();
                    clone.addElement(copyStr);
                    clone.addElement(numfonts);
                    DownloadFontSetDialog.this.sortableModel.insertRow(++row, clone);
                    DownloadFontSetDialog.this.rowSelector.setSelectionInterval(row, row);
                    Rectangle visRect = DownloadFontSetDialog.this.fontbundleList.getCellRect(row, 0, true);
                    DownloadFontSetDialog.this.fontbundleList.scrollRectToVisible(visRect);
                    Object[] objFList = DownloadFontSetDialog.this.ud.arrayForKey("fontset." + fontsetName);
                    DownloadFontSetDialog.this.ud.add("fontset." + copyStr, objFList);
                }
            });
        }
        if (this.okButton != null) {
            this.okButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DownloadFontSetDialog.this.okButton.doClick();
                }
            }, KeyStroke.getKeyStroke(10, 2), 2);
        }
        this.validate();
    }

    public int getListSize() {
        return this.fontsetList.getModel().getSize();
    }

    void SetButtons() {
        if (this.sortableModel.getRowCount() == 0) {
            this.removeFontButton.setEnabled(false);
            this.renameFontButton.setEnabled(false);
            if (this.cloneFontButton != null) {
                this.cloneFontButton.setEnabled(false);
            }
            if (this.editFontButton != null) {
                this.editFontButton.setEnabled(false);
            }
        } else {
            if (this.cloneFontButton != null) {
                this.cloneFontButton.setEnabled(true);
            }
            if (this.editFontButton != null) {
                this.editFontButton.setEnabled(true);
            }
            if (this.renameFontButton != null) {
                this.renameFontButton.setEnabled(true);
            }
        }
    }

    public void SetSelectedCount(int n) {
        if (n == 1) {
            if (this.cloneFontButton != null) {
                this.cloneFontButton.setEnabled(true);
            }
            if (this.editFontButton != null) {
                this.editFontButton.setEnabled(true);
            }
            this.renameFontButton.setEnabled(true);
        } else {
            if (this.cloneFontButton != null) {
                this.cloneFontButton.setEnabled(false);
            }
            if (this.editFontButton != null) {
                this.editFontButton.setEnabled(false);
            }
            this.renameFontButton.setEnabled(false);
        }
    }

    public void MouseDoubleClicked() {
        if (this.editFontButton != null) {
            this.editFontButton.doClick();
        }
    }

    public class FontSetDialogLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int controlButtonX;
        int buttonX;
        int buttonY;
        int scrollPaneWidth;
        int scrollPaneHeight;
        int controlButtonWidth;
        int controlButtonHeight;
        int buttonWidth;
        int buttonHeight;
        int padding_left;
        int control_button_padding;
        int button_padding;

        public FontSetDialogLayout(Container c) {
            this.controlButtonWidth = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.controlbuttonwidth"));
            this.controlButtonHeight = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.buttonWidth = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            this.buttonHeight = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.padding_left = 12;
            this.control_button_padding = 12;
            this.button_padding = 12;
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontSetDialog.this.scrollPane);
            if (!DownloadFontSetDialog.this.saveFlag || DownloadFontSetDialog.this.editFlag) {
                this.panel.add(DownloadFontSetDialog.this.addFontButton);
                this.panel.add(DownloadFontSetDialog.this.cloneFontButton);
                this.panel.add(DownloadFontSetDialog.this.editFontButton);
                this.panel.add(DownloadFontSetDialog.this.removeFontButton);
                this.panel.add(DownloadFontSetDialog.this.renameFontButton);
                this.panel.add(DownloadFontSetDialog.this.defaultButton);
            } else {
                this.panel.add(DownloadFontSetDialog.this.removeFontButton);
                this.panel.add(DownloadFontSetDialog.this.renameFontButton);
            }
            this.panel.add(DownloadFontSetDialog.this.okButton);
            this.panel.add(DownloadFontSetDialog.this.cancelButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontSetDialog.this.WIDTH;
            dim.height = DownloadFontSetDialog.this.HEIGHT;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontSetDialog.this.WIDTH;
            dim.height = DownloadFontSetDialog.this.HEIGHT;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.controlButtonX = this.panelWidth - this.controlButtonWidth - this.control_button_padding;
            this.scrollPaneWidth = this.panelWidth - this.controlButtonWidth - this.control_button_padding * 2 - this.padding_left;
            this.scrollPaneHeight = this.panelHeight - 8 - 70;
            int remainder = this.scrollPaneHeight % 19;
            this.scrollPaneHeight -= remainder;
            DownloadFontSetDialog.this.scrollPane.setBounds(this.padding_left, 8, this.scrollPaneWidth, this.scrollPaneHeight);
            if (!DownloadFontSetDialog.this.saveFlag || DownloadFontSetDialog.this.editFlag) {
                DownloadFontSetDialog.this.addFontButton.setBounds(this.controlButtonX, 22, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.cloneFontButton.setBounds(this.controlButtonX, 57, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.editFontButton.setBounds(this.controlButtonX, 92, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.removeFontButton.setBounds(this.controlButtonX, 127, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.renameFontButton.setBounds(this.controlButtonX, 162, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.defaultButton.setBounds(this.controlButtonX, 197, this.controlButtonWidth, this.controlButtonHeight);
            } else {
                DownloadFontSetDialog.this.removeFontButton.setBounds(this.controlButtonX, 22, this.controlButtonWidth, this.controlButtonHeight);
                DownloadFontSetDialog.this.renameFontButton.setBounds(this.controlButtonX, 57, this.controlButtonWidth, this.controlButtonHeight);
            }
            int topPadding = (this.panelHeight - (this.scrollPaneHeight + 8 + this.buttonHeight)) / 2;
            this.buttonX = this.panelWidth - 2 * this.button_padding - 2 * this.buttonWidth;
            this.buttonY = this.scrollPaneHeight + 8 + topPadding;
            DownloadFontSetDialog.this.okButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
            DownloadFontSetDialog.this.cancelButton.setBounds(this.buttonX + this.buttonWidth + this.button_padding, this.buttonY, this.buttonWidth, this.buttonHeight);
            Insets i = DownloadFontSetDialog.this.scrollPane.getInsets();
            this.scrollPaneWidth = this.scrollPaneWidth - i.left - i.right;
            int col1_w = (int)((double)this.scrollPaneWidth * 0.78);
            int col2_w = this.scrollPaneWidth - col1_w - 4;
            DownloadFontSetDialog.this.col1.setPreferredWidth(col1_w);
            DownloadFontSetDialog.this.col2.setPreferredWidth(col2_w);
        }
    }

    class RenameFontDialog
    extends JDialog {
        JTextField oldField;
        FocusableTextField newField;
        JButton okButton;
        JButton cancelButton;
        RenameFontDialog renameDialog;
        String newName = null;
        final int RENAME_WIDTH = 380;
        final int RENAME_HEIGHT = 200;

        public RenameFontDialog(FontDownloaderMainFrame myparent, String oldName) {
            super(myparent);
            this.setTitle(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.rename_font_bundle"));
            JLabel oldLabel = new JLabel(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.current_name"), 4);
            JLabel newLabel = new JLabel(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.new_name"), 4);
            this.renameDialog = this;
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new GridLayout(0, 1));
            labelPanel.add(oldLabel);
            labelPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            labelPanel.add(newLabel);
            this.oldField = new JTextField(oldName);
            this.oldField.setEditable(false);
            this.oldField.setOpaque(false);
            this.newField = new FocusableTextField("  ");
            this.oldField.setBackground(Color.white);
            this.newField.setBackground(Color.white);
            JPanel fieldPanel = new JPanel();
            fieldPanel.setLayout(new GridLayout(0, 1));
            fieldPanel.add(this.oldField);
            fieldPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            fieldPanel.add(this.newField);
            this.oldField.setColumns(20);
            this.newField.setColumns(20);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new BoxLayout(textPanel, 0));
            textPanel.add(labelPanel);
            textPanel.add(fieldPanel);
            textPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            JPanel compositePanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(compositePanel, gbc);
            compositePanel.add(textPanel);
            JPanel buttonPanel = new JPanel();
            this.okButton = new JButton(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.ok"));
            this.cancelButton = new JButton(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.cancel"));
            int buttonWidth = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            int buttonHeight = new Integer(DownloadFontSetDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            Dimension dim = new Dimension(buttonWidth, buttonHeight);
            this.cancelButton.setPreferredSize(dim);
            this.okButton.setPreferredSize(dim);
            this.newField.actionKeys(this.okButton, this.cancelButton);
            this.addActions();
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
            bottomPanel.add(Box.createRigidArea(new Dimension(126, 1)));
            bottomPanel.add(buttonPanel);
            this.getContentPane().add((Component)compositePanel, "West");
            this.getContentPane().add((Component)bottomPanel, "South");
            this.setSize(380, 200);
            this.setModal(true);
            this.setResizable(false);
            this.setLocation(DownloadFontSetDialog.this.downloadFontSetDialog.getLocation());
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ RenameFontDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowActivated(WindowEvent e) {
                    Runnable forGettingFocus = new Runnable(this){
                        private final /* synthetic */ 17 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            17.access$200(this.this$2).newField.requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater(forGettingFocus);
                }

                static /* synthetic */ RenameFontDialog access$200(17 x0) {
                    return x0.this$1;
                }
            });
            FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
            fdlFocusMgr.registerAction(27, this.cancelButton, this);
            fdlFocusMgr.registerAction(10, this.okButton, this);
        }

        public void show() {
            this.newField.setText("");
            this.newField.requestFocus();
            super.show();
        }

        void addActions() {
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ RenameFontDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.newName = this.this$1.newField.getText().trim();
                    if (this.this$1.newName == null || this.this$1.newName.length() == 0) {
                        String emptyMessage = RenameFontDialog.access$300(this.this$1).getMessage("downloadfontsetdialog.new_name_field_is_empty");
                        JOptionPane.showMessageDialog(this.this$1.renameDialog, emptyMessage, RenameFontDialog.access$300(this.this$1).getMessage("downloadfontsetdialog.error"), 0);
                        this.this$1.newName = null;
                        return;
                    }
                    int size = RenameFontDialog.access$300((RenameFontDialog)this.this$1).sortableModel.getRowCount();
                    int i = 0;
                    while (i < size) {
                        if (this.this$1.newName.compareToIgnoreCase((String)RenameFontDialog.access$300((RenameFontDialog)this.this$1).sortableModel.getValueAt(i, 0)) == 0) {
                            String duplicateMessage = "'" + this.this$1.newName + RenameFontDialog.access$300(this.this$1).getMessage("downloadfontsetdialog.'_already_exists");
                            JOptionPane.showMessageDialog(this.this$1.renameDialog, duplicateMessage, RenameFontDialog.access$300(this.this$1).getMessage("downloadfontsetdialog.error"), 0);
                            this.this$1.newField.requestFocus();
                            this.this$1.newField.selectAll();
                            this.this$1.newName = null;
                            return;
                        }
                        ++i;
                    }
                    this.this$1.renameDialog.setVisible(false);
                }
            });
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ RenameFontDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.renameDialog.setVisible(false);
                }
            });
            this.newField.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ RenameFontDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent evt) {
                    int key = evt.getKeyCode();
                    switch (key) {
                        case 79: {
                            if (!evt.isAltDown()) break;
                            this.this$1.okButton.doClick();
                            evt.consume();
                            return;
                        }
                    }
                }
            });
        }

        public String getNewFontName() {
            return this.newName;
        }

        static /* synthetic */ DownloadFontSetDialog access$300(RenameFontDialog x0) {
            return x0.DownloadFontSetDialog.this;
        }
    }

    class FocusableTextField
    extends JTextField {
        JButton okButton;
        JButton escapeButton;

        public FocusableTextField(String text) {
            super(text);
        }

        public boolean isFocusTranversable() {
            return true;
        }

        public void actionKeys(JButton okButton, JButton escapeButton) {
            this.okButton = okButton;
            this.escapeButton = escapeButton;
        }

        public void processKeyEvent(KeyEvent e) {
            if (this.okButton != null && e.getKeyCode() == 79 && e.isAltDown()) {
                if (e.getID() == 401) {
                    this.okButton.doClick();
                }
                e.consume();
                return;
            }
            if (e.getKeyCode() == 67 && e.isAltDown()) {
                this.escapeButton.doClick();
                return;
            }
            if (e.isControlDown()) {
                if (e.getKeyCode() == 10 && e.getID() == 401) {
                    this.okButton.doClick();
                }
                e.consume();
                return;
            }
            String enteredText = this.getText().trim();
            if (enteredText.length() == 0) {
                super.processKeyEvent(e);
                return;
            }
            super.processKeyEvent(e);
        }
    }

    class RenameFontSetListener
    extends AbstractAction {
        RenameFontSetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            Boolean bl = DownloadFontSetDialog.this.isOpened;
            synchronized (bl) {
                if (DownloadFontSetDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = DownloadFontSetDialog.this.isOpened;
            synchronized (bl2) {
                DownloadFontSetDialog.this.isOpened = new Boolean(true);
            }
            int index = DownloadFontSetDialog.this.fontbundleList.getSelectedRow();
            String oldName = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(index, 0);
            RenameFontDialog renameFont = new RenameFontDialog(DownloadFontSetDialog.this.parentframe, oldName);
            renameFont.show();
            Boolean bl3 = DownloadFontSetDialog.this.isOpened;
            synchronized (bl3) {
                DownloadFontSetDialog.this.isOpened = new Boolean(false);
            }
            String newFontName = renameFont.getNewFontName();
            if (newFontName == null) {
                return;
            }
            DownloadFontSetDialog.this.sortableModel.setValueAt(newFontName, index, 0);
            Object[] objList = DownloadFontSetDialog.this.ud.arrayForKey("fontset." + oldName);
            if (objList == null) {
                objList = new Object[]{};
            }
            DownloadFontSetDialog.this.ud.remove("fontset." + oldName);
            DownloadFontSetDialog.this.ud.add("fontset." + newFontName, objList);
        }
    }

    class RemoveFontListener
    extends AbstractAction {
        RemoveFontListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            Boolean bl = DownloadFontSetDialog.this.isOpened;
            synchronized (bl) {
                if (DownloadFontSetDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = DownloadFontSetDialog.this.isOpened;
            synchronized (bl2) {
                DownloadFontSetDialog.this.isOpened = new Boolean(true);
            }
            if (DownloadFontSetDialog.this.rowSelector.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(null, DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.no_font_bundle_selected_for_removal"), DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.warning"), 2);
                Boolean bl3 = DownloadFontSetDialog.this.isOpened;
                synchronized (bl3) {
                    DownloadFontSetDialog.this.isOpened = new Boolean(false);
                }
                return;
            }
            String warnmsg = new String(DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.are_you_sure_you_want_to_remove_the_selected_font_set?"));
            int ans = JOptionPane.showConfirmDialog(null, warnmsg, DownloadFontSetDialog.this.getMessage("downloadfontsetdialog.remove_confirmation"), 0);
            Boolean bl4 = DownloadFontSetDialog.this.isOpened;
            synchronized (bl4) {
                DownloadFontSetDialog.this.isOpened = new Boolean(false);
            }
            if (ans == 0) {
                int[] currentSelections = DownloadFontSetDialog.this.fontbundleList.getSelectedRows();
                int selSize = currentSelections.length;
                int i = 0;
                while (i < selSize) {
                    int index = currentSelections[i] - i;
                    String fontsetName = (String)DownloadFontSetDialog.this.sortableModel.getValueAt(index, 0);
                    DownloadFontSetDialog.this.sortableModel.removeRow(index);
                    DownloadFontSetDialog.this.ud.remove("fontset." + fontsetName);
                    ++i;
                }
                if (DownloadFontSetDialog.this.sortableModel.getRowCount() > 0) {
                    int selLen = currentSelections.length;
                    int index = currentSelections[selLen - 1];
                    if (index >= DownloadFontSetDialog.this.sortableModel.getRowCount()) {
                        index = DownloadFontSetDialog.this.sortableModel.getRowCount() - 1;
                    }
                    DownloadFontSetDialog.this.rowSelector.setSelectionInterval(index, index);
                }
                DownloadFontSetDialog.this.SetButtons();
            }
        }
    }

    class Fonts {
        String bundlename;
        Object[] fontlist;

        public Fonts(Object[] arg, String bn) {
            this.fontlist = arg;
            this.bundlename = bn;
        }
    }
}

