/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DownloadFontPropsDialog
extends JDialog {
    ResourceBundle bundle;
    JFrame parent;
    PrinterProperties prtProps;
    DownloadProperties downloadProps;
    InfoTextField fontName;
    InfoTextField fontFullName;
    InfoTextField fontType;
    JLabel nameLabel;
    JLabel fullnameLabel;
    JLabel typeLabel;
    JLabel copyrightLabel;
    JPanel advPanel;
    JTextArea fontCopyright;
    JScrollPane copyrightScrollPane;
    final int WIDTH = new Integer(this.getMessage("dimensions.downloadfontpropsdialog_width"));
    final int HEIGHT = new Integer(this.getMessage("dimensions.downloadfontpropsdialog_height"));
    JButton okButton;
    JButton cancelButton;
    JLabel psNameLabel;
    JLabel includeCMapLabel;
    JLabel typeConvLabel;
    JLabel encodingLabel;
    JLabel destLabel;
    JComboBox typeConvCBox;
    JComboBox encodingCBox;
    JComboBox destCBox;
    JCheckBox includeCMapCBox;
    JComboBox cmapCBox;
    JButton CMapButton;
    JLabel CMapLabel;
    JLabel CMapNameLabel;
    JTextField psNameField;
    JTextField filename;
    JTextField CMapName;
    boolean newvar;
    DownloadFontPropsDialog fontPropsDialog;
    boolean fontisTT;
    boolean fontisCID;
    XlatManager.Translation[] trs;
    String lastVisitedDir;
    String[] SystemCMapNames;
    String[] SystemCMapFiles;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    int findEncodingIndex(int encID) {
        int res = 0;
        int i = 0;
        while (i < this.trs.length) {
            if (encID == this.trs[i].src) {
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    int findCMapIndex(String cmap) {
        int i = 0;
        while (i < this.SystemCMapNames.length) {
            if (cmap.compareTo(this.SystemCMapNames[i]) == 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public DownloadFontPropsDialog(JFrame parent, PrinterProperties prtProps, DownloadProperties dp) {
        super((Frame)parent, true);
        this.setTitle(this.getMessage("downloadfontpropsdialog.font_properties"));
        this.parent = parent;
        this.prtProps = prtProps;
        this.downloadProps = dp;
        this.newvar = true;
        this.trs = ((FontDownloaderMainFrame)parent).xman.getType42Translations();
        JPanel basicPanel = this.layoutBasicProps(this.WIDTH);
        this.createAdvPropsComponents();
        this.advPanel = new JPanel();
        this.advPanel.setLayout(new AdvancedPropsLayout(this.advPanel));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(this.getMessage("downloadfontpropsdialog.basic"), basicPanel);
        tabbedPane.addTab(this.getMessage("downloadfontpropsdialog.advanced"), this.advPanel);
        tabbedPane.setSize(this.WIDTH, this.HEIGHT - 60);
        RepaintManager repaintManager = RepaintManager.currentManager(tabbedPane);
        if (!repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        this.newvar = false;
        tabbedPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                DownloadFontPropsDialog.this.newvar = true;
                JTabbedPane tpane = (JTabbedPane)evt.getComponent();
                JPanel panel = (JPanel)tpane.getComponentAt(0);
                panel.invalidate();
                panel.removeAll();
                int width = panel.getSize().width;
                panel = DownloadFontPropsDialog.this.layoutBasicProps(width);
                DownloadFontPropsDialog.this.displayBasicFontProps();
                panel.validate();
                tpane.setComponentAt(0, panel);
                JPanel panel2 = (JPanel)tpane.getComponentAt(1);
                panel2.invalidate();
                panel2.removeAll();
                panel2.setLayout(new AdvancedPropsLayout(panel2));
                panel2.validate();
                tpane.setComponentAt(1, panel2);
                tpane.validate();
                DownloadFontPropsDialog.this.newvar = false;
            }
        });
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane tpane = (JTabbedPane)e.getSource();
                if (tpane.getSelectedIndex() == 0) {
                    JPanel panel = (JPanel)tpane.getComponentAt(0);
                    panel.invalidate();
                    panel.removeAll();
                    int width = tpane.getSize().width;
                    panel = DownloadFontPropsDialog.this.layoutBasicProps(width);
                    panel.validate();
                    tpane.setComponentAt(0, panel);
                    tpane.validate();
                    DownloadFontPropsDialog.this.okButton.setEnabled(false);
                    return;
                }
                DownloadFontPropsDialog.this.okButton.setEnabled(true);
            }
        });
        this.okButton = new JButton(this.getMessage("downloadfontpropsdialog.ok"));
        this.cancelButton = new JButton(this.getMessage("downloadfontpropsdialog.cancel"));
        this.addActions();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new ButtonPanelLayout(buttonPanel));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setModal(true);
        this.fontPropsDialog = this;
        FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
        fdlFocusMgr.registerAction(27, this.cancelButton, this);
        this.okButton.setEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < DownloadFontPropsDialog.this.WIDTH || windim.height < DownloadFontPropsDialog.this.HEIGHT) {
                    DownloadFontPropsDialog.this.setSize(DownloadFontPropsDialog.this.WIDTH, DownloadFontPropsDialog.this.HEIGHT);
                }
            }
        });
        this.okButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadFontPropsDialog.this.okButton.doClick();
            }
        }, KeyStroke.getKeyStroke(10, 2), 2);
    }

    public void getDownloadProperties(DownloadProperties dp) {
        dp.destination = this.downloadProps.destination;
        dp.includeCMap = this.downloadProps.includeCMap;
    }

    JPanel layoutButtonPanel() {
        this.okButton = new JButton(this.getMessage("downloadfontpropsdialog.ok"));
        this.cancelButton = new JButton(this.getMessage("downloadfontpropsdialog.cancel"));
        this.addActions();
        JPanel buttonPanel = new JPanel();
        return buttonPanel;
    }

    int displayTrueTypeFontProps() {
        TrueTypeConvNative ttConv = new TrueTypeConvNative();
        int MAX_PROPS = 6;
        String[] infoarr = new String[6];
        int result = ttConv.parseInfo(this.downloadProps.fontpathstr, infoarr);
        if (result == 0) {
            this.fontName.setText(infoarr[0]);
            if (this.downloadProps.psname.equals("")) {
                this.downloadProps.psname = infoarr[0];
            }
            this.fontFullName.setText(infoarr[1]);
            this.fontCopyright.setText(infoarr[3]);
            this.fontType.setText(infoarr[4]);
            this.fontisTT = true;
        }
        return result;
    }

    void displayPSFontProps() {
        PSFileParser psf = new PSFileParser();
        int MAX_PSFILE_PROPS = 6;
        String[] infoarr = new String[6];
        int i = 0;
        while (i <= 5) {
            infoarr[i] = new String();
            ++i;
        }
        psf.parseFile(this.downloadProps.fontpathstr, infoarr);
        this.fontName.setText(infoarr[0]);
        this.fontFullName.setText(infoarr[1]);
        this.fontType.setText(infoarr[3]);
        this.fontCopyright.setText(infoarr[5]);
        this.fontisTT = false;
    }

    void displayCIDFontProps() {
        String[] cidprops = new String[3];
        int i = 0;
        while (i < 3) {
            cidprops[i] = new String();
            ++i;
        }
        PSFileParser.parseCID(this.downloadProps.fontpathstr, cidprops);
        this.fontName.setText(cidprops[0]);
        this.fontFullName.setText(cidprops[1]);
        this.fontType.setText(this.getMessage("downloadfontpropsdialog.cid"));
        this.fontCopyright.setText(cidprops[2]);
    }

    void displayCMapFontProps() {
        String[] cmapprops = new String[3];
        int i = 0;
        while (i < 3) {
            cmapprops[i] = new String();
            ++i;
        }
        PSFileParser.parseCMap(this.downloadProps.fontpathstr, cmapprops);
        this.fontName.setText(cmapprops[0]);
        this.fontFullName.setText(cmapprops[1]);
        this.fontType.setText(this.getMessage("downloadfontpropsdialog.cmap"));
        this.fontCopyright.setText(cmapprops[2]);
    }

    void displayBasicFontProps() {
        int result = PrinterProperties.getFileType(this.downloadProps.fontpathstr);
        switch (result) {
            case 0: {
                this.displayTrueTypeFontProps();
                this.fontisTT = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.displayPSFontProps();
                break;
            }
            case 4: {
                this.displayCIDFontProps();
                this.fontisCID = true;
                break;
            }
            case 5: {
                this.displayCMapFontProps();
            }
        }
        if (!this.fontisTT) {
            this.encodingCBox.setEnabled(false);
            this.typeConvCBox.setEnabled(false);
            this.encodingLabel.setEnabled(false);
            this.typeConvLabel.setEnabled(false);
            this.psNameField.setEnabled(false);
            this.psNameLabel.setEnabled(false);
        }
        if (this.fontisCID) {
            this.includeCMapCBox.setEnabled(true);
            this.includeCMapLabel.setEnabled(true);
            this.destLabel.setEnabled(false);
            this.destCBox.setEnabled(false);
        }
        if (result == 5) {
            this.destCBox.setEnabled(false);
            this.destLabel.setEnabled(false);
        }
    }

    JPanel layoutBasicProps(int width) {
        this.nameLabel = new JLabel(this.getMessage("downloadfontpropsdialog.name"));
        this.fullnameLabel = new JLabel(this.getMessage("downloadfontpropsdialog.full_name"));
        this.typeLabel = new JLabel(this.getMessage("downloadfontpropsdialog.type"));
        this.copyrightLabel = new JLabel(this.getMessage("downloadfontpropsdialog.copyright"));
        FontMetrics fm = this.getFontMetrics(FontDownloaderMainFrame.defaultFont);
        int maxstrlen = fm.stringWidth(new String(this.getMessage("downloadfontpropsdialog.full_name")));
        maxstrlen -= 10;
        this.fontName = new InfoTextField();
        this.fontFullName = new InfoTextField();
        this.fontType = new InfoTextField();
        this.fontCopyright = new JTextArea(4, 32);
        this.fontCopyright.setLineWrap(true);
        this.fontCopyright.setWrapStyleWord(true);
        this.copyrightScrollPane = new JScrollPane(this.fontCopyright);
        this.copyrightScrollPane.setHorizontalScrollBarPolicy(31);
        this.copyrightScrollPane.setVerticalScrollBarPolicy(20);
        this.copyrightScrollPane.createVerticalScrollBar();
        this.fontCopyright.setEditable(false);
        JPanel p = new JPanel();
        p.setLayout(new BasicPropsLayout(p));
        return p;
    }

    void createAdvPropsComponents() {
        int dest;
        this.psNameLabel = new JLabel(this.getMessage("downloadfontpropsdialog.ps_name"));
        this.psNameField = new JTextField();
        this.psNameField.setBackground(Color.white);
        this.destLabel = new JLabel(this.getMessage("downloadfontpropsdialog.destination"));
        this.CMapLabel = new JLabel(this.getMessage("downloadfontpropsdialog.cmap"));
        this.CMapNameLabel = new JLabel(this.getMessage("downloadfontpropsdialog.cmap_name"));
        this.CMapButton = new JButton(this.getMessage("downloadfontpropsdialog.cmap_file"));
        this.cmapCBox = new JComboBox();
        this.cmapCBox.addItem(this.getMessage("downloadfontpropsdialog.not_selected"));
        this.cmapCBox.addItem(this.getMessage("downloadfontpropsdialog.custom"));
        this.SystemCMapNames = ((FontDownloaderMainFrame)this.parent).cman.GetSystemCMapNames();
        this.SystemCMapFiles = ((FontDownloaderMainFrame)this.parent).cman.GetSystemCMapFiles();
        int i = 0;
        while (i < this.SystemCMapNames.length) {
            this.cmapCBox.addItem(this.SystemCMapNames[i]);
            ++i;
        }
        this.filename = new JTextField();
        this.filename.setOpaque(true);
        this.addListener(this.filename);
        this.CMapName = new JTextField();
        this.CMapName.setOpaque(true);
        this.addListener(this.CMapName);
        this.typeConvCBox = new JComboBox();
        this.typeConvCBox.addItem(this.getMessage("downloadfontpropsdialog.automatic"));
        this.typeConvCBox.addItem(this.getMessage("downloadfontpropsdialog.type_42"));
        this.typeConvCBox.addItem(this.getMessage("downloadfontpropsdialog.cid"));
        this.encodingCBox = new JComboBox();
        int i2 = 0;
        while (i2 < this.trs.length) {
            this.encodingCBox.addItem(this.trs[i2].srcNameShort);
            ++i2;
        }
        this.destCBox = new JComboBox();
        int numDisks = -1;
        if (this.prtProps != null) {
            this.destCBox.addItem("   RAM   ");
            numDisks = this.prtProps.getNumDisks();
            if (numDisks == -1) {
                try {
                    this.prtProps.getAllProperties();
                    numDisks = this.prtProps.getNumDisks();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (numDisks > 0) {
                this.destCBox.addItem(this.getMessage("downloadfontpropsdialog.disk"));
            } else {
                this.destCBox.setEnabled(false);
            }
        } else {
            this.destCBox.addItem(this.getMessage("downloadfontpropsdialog.ram"));
            this.destCBox.addItem(this.getMessage("downloadfontpropsdialog.disk_only"));
            this.destCBox.addItem(this.getMessage("downloadfontpropsdialog.disk_or_memory"));
        }
        this.includeCMapCBox = new JCheckBox();
        this.includeCMapCBox.setEnabled(false);
        if (this.downloadProps.includeCMap == 1) {
            this.includeCMapCBox.setSelected(true);
        } else {
            this.includeCMapCBox.setSelected(false);
        }
        this.includeCMapLabel = new JLabel(this.getMessage("downloadfontpropsdialog.include_cmap_files"));
        this.includeCMapLabel.setEnabled(false);
        this.typeConvLabel = new JLabel(this.getMessage("downloadfontpropsdialog.type_conversion"));
        this.encodingLabel = new JLabel(this.getMessage("downloadfontpropsdialog.encoding"));
        if (this.prtProps != null && numDisks <= 0) {
            this.destLabel.setEnabled(false);
        }
        if ((dest = this.downloadProps.destination) == 1) {
            this.destCBox.setSelectedIndex(0);
        } else if (dest == 2) {
            this.destCBox.setSelectedIndex(1);
        } else if (dest == 3) {
            this.destCBox.setSelectedIndex(2);
        }
        this.encodingCBox.setSelectedIndex(this.findEncodingIndex(this.downloadProps.encodingID));
        this.typeConvCBox.setSelectedIndex(this.downloadProps.conversion);
        if (this.typeConvCBox.getSelectedIndex() == 2) {
            this.encodingLabel.setEnabled(false);
            this.encodingCBox.setEnabled(false);
            this.psNameField.setEnabled(false);
            this.psNameField.setOpaque(true);
            this.psNameLabel.setEnabled(false);
            this.CMapButton.setEnabled(false);
            this.filename.setEnabled(false);
            this.CMapNameLabel.setEnabled(false);
            this.CMapName.setEnabled(false);
        } else {
            this.CMapLabel.setEnabled(false);
            this.cmapCBox.setEnabled(false);
            this.CMapButton.setEnabled(false);
            this.filename.setEnabled(false);
            this.CMapNameLabel.setEnabled(false);
            this.CMapName.setEnabled(false);
        }
        if (this.downloadProps.cmapstate == 0) {
            this.cmapCBox.setSelectedIndex(0);
        } else if (this.downloadProps.cmapstate == 1) {
            this.cmapCBox.setSelectedIndex(1);
            this.CMapButton.setEnabled(true);
            this.filename.setEnabled(true);
            this.filename.setText(this.downloadProps.cmapfile);
            this.CMapNameLabel.setEnabled(true);
            this.CMapName.setEnabled(true);
            this.CMapName.setText(this.downloadProps.cmapname);
        } else if (this.downloadProps.cmapstate == 2) {
            this.cmapCBox.setSelectedIndex(this.findCMapIndex(this.downloadProps.cmapname) + 2);
        }
        this.typeConvCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() == 2) {
                    DownloadFontPropsDialog.this.cmapCBox.setEnabled(true);
                    DownloadFontPropsDialog.this.CMapLabel.setEnabled(true);
                    DownloadFontPropsDialog.this.encodingLabel.setEnabled(false);
                    DownloadFontPropsDialog.this.encodingCBox.setEnabled(false);
                    DownloadFontPropsDialog.this.psNameField.setEnabled(false);
                    DownloadFontPropsDialog.this.psNameField.setOpaque(true);
                    DownloadFontPropsDialog.this.psNameLabel.setEnabled(false);
                    if (DownloadFontPropsDialog.this.cmapCBox.getSelectedIndex() == 1) {
                        DownloadFontPropsDialog.this.CMapButton.setEnabled(true);
                        DownloadFontPropsDialog.this.filename.setEnabled(true);
                        DownloadFontPropsDialog.this.CMapNameLabel.setEnabled(true);
                        DownloadFontPropsDialog.this.CMapName.setEnabled(true);
                    } else {
                        DownloadFontPropsDialog.this.CMapButton.setEnabled(false);
                        DownloadFontPropsDialog.this.filename.setEnabled(false);
                        DownloadFontPropsDialog.this.CMapNameLabel.setEnabled(false);
                        DownloadFontPropsDialog.this.CMapName.setEnabled(false);
                    }
                } else {
                    DownloadFontPropsDialog.this.encodingLabel.setEnabled(true);
                    DownloadFontPropsDialog.this.encodingCBox.setEnabled(true);
                    DownloadFontPropsDialog.this.psNameField.setEnabled(true);
                    DownloadFontPropsDialog.this.psNameField.setBackground(Color.white);
                    DownloadFontPropsDialog.this.psNameLabel.setEnabled(true);
                    DownloadFontPropsDialog.this.CMapLabel.setEnabled(false);
                    DownloadFontPropsDialog.this.cmapCBox.setEnabled(false);
                    DownloadFontPropsDialog.this.CMapButton.setEnabled(false);
                    DownloadFontPropsDialog.this.filename.setEnabled(false);
                    DownloadFontPropsDialog.this.CMapNameLabel.setEnabled(false);
                    DownloadFontPropsDialog.this.CMapName.setEnabled(false);
                }
            }
        });
        this.cmapCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() != 1) {
                    DownloadFontPropsDialog.this.CMapButton.setEnabled(false);
                    DownloadFontPropsDialog.this.filename.setEnabled(false);
                    DownloadFontPropsDialog.this.CMapNameLabel.setEnabled(false);
                    DownloadFontPropsDialog.this.CMapName.setEnabled(false);
                } else if (cb.getSelectedIndex() == 1) {
                    DownloadFontPropsDialog.this.CMapButton.setEnabled(true);
                    DownloadFontPropsDialog.this.filename.setEnabled(true);
                    DownloadFontPropsDialog.this.CMapNameLabel.setEnabled(true);
                    DownloadFontPropsDialog.this.CMapName.setEnabled(true);
                }
            }
        });
    }

    void addListener(JTextField tf) {
        tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int code = evt.getKeyCode();
                if (code == 39) {
                    return;
                }
                if (code == 37) {
                    return;
                }
                if (code == 227) {
                    return;
                }
                if (code == 226) {
                    return;
                }
                evt.consume();
            }

            public void keyTyped(KeyEvent evt) {
                int code = evt.getKeyCode();
                if (code == 39) {
                    return;
                }
                if (code == 37) {
                    return;
                }
                if (code == 227) {
                    return;
                }
                if (code == 226) {
                    return;
                }
                evt.consume();
            }

            public void keyReleased(KeyEvent evt) {
                int code = evt.getKeyCode();
                if (code == 39) {
                    return;
                }
                if (code == 37) {
                    return;
                }
                if (code == 227) {
                    return;
                }
                if (code == 226) {
                    return;
                }
                evt.consume();
            }
        });
    }

    void addActions() {
        this.CMapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String fontElement;
                block17: {
                    block16: {
                        JFileChooser fileDialog = new JFileChooser();
                        fileDialog.setDialogTitle(DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.select_cmap_file"));
                        fileDialog.setDialogType(0);
                        if (DownloadFontPropsDialog.this.lastVisitedDir == null) {
                            String userhome;
                            Properties sysprops = System.getProperties();
                            DownloadFontPropsDialog.this.lastVisitedDir = userhome = sysprops.getProperty("user.home");
                        }
                        fileDialog.setCurrentDirectory(new File(DownloadFontPropsDialog.this.lastVisitedDir));
                        int state = fileDialog.showOpenDialog(DownloadFontPropsDialog.this.fontPropsDialog);
                        if (state == 1) {
                            return;
                        }
                        String fontdir = null;
                        try {
                            fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                        }
                        catch (IOException io) {
                            // empty catch block
                        }
                        String fontfile = null;
                        if (fileDialog.getSelectedFile() != null) {
                            fontfile = fileDialog.getSelectedFile().getName();
                        }
                        if (fileDialog.getCurrentDirectory() != null) {
                            try {
                                fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                            }
                            catch (IOException io) {
                                // empty catch block
                            }
                        }
                        if (fontdir == null && fontfile == null) {
                            return;
                        }
                        fontElement = "";
                        if (fontdir != null && fontfile == null) {
                            fontElement = fontdir;
                        } else if (fontdir != null && fontfile != null) {
                            fontElement = fontdir + "/" + fontfile;
                        }
                        File file = new File(fontElement);
                        if (file.isDirectory()) {
                            DownloadFontPropsDialog.this.lastVisitedDir = fontdir;
                            return;
                        }
                        int filetype = -1;
                        filetype = PrinterProperties.getFileType(fontElement);
                        DownloadFontPropsDialog.this.lastVisitedDir = fontdir;
                        if (filetype == -1) break block16;
                        CMapManager cfr_ignored_0 = ((FontDownloaderMainFrame)DownloadFontPropsDialog.this.parent).cman;
                        if (CMapManager.isCMap(fontElement)) break block17;
                    }
                    JOptionPane.showMessageDialog(DownloadFontPropsDialog.this.fontPropsDialog, DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.this_is_not_a_cmap_file"), DownloadFontPropsDialog.this.getMessage("downloadfontdialog.font_file_type_error"), 0);
                    DownloadFontPropsDialog.this.CMapButton.doClick();
                    return;
                }
                DownloadFontPropsDialog.this.filename.setText(fontElement);
                CMapManager cfr_ignored_1 = ((FontDownloaderMainFrame)DownloadFontPropsDialog.this.parent).cman;
                DownloadFontPropsDialog.this.CMapName.setText(CMapManager.GetCMapName(fontElement));
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadFontPropsDialog.this.fontPropsDialog.setVisible(false);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int cmapindex = -1;
                int convindex = DownloadFontPropsDialog.this.typeConvCBox.getSelectedIndex();
                if (DownloadFontPropsDialog.this.cmapCBox.isEnabled()) {
                    cmapindex = DownloadFontPropsDialog.this.cmapCBox.getSelectedIndex();
                }
                if (convindex == 2) {
                    if (cmapindex <= 0) {
                        JOptionPane.showMessageDialog(DownloadFontPropsDialog.this.fontPropsDialog, DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.you_have_not_selected_a_cmap_file"), DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.cmap_not_selected_error"), 0);
                        return;
                    }
                    if (cmapindex == 1) {
                        String text = DownloadFontPropsDialog.this.filename.getText().trim();
                        if (text == null || text.length() == 0) {
                            JOptionPane.showMessageDialog(DownloadFontPropsDialog.this.fontPropsDialog, DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.you_have_not_selected_a_cmap_file"), DownloadFontPropsDialog.this.getMessage("downloadfontpropsdialog.cmap_not_selected_error"), 0);
                            return;
                        }
                        DownloadProperties cfr_ignored_0 = DownloadFontPropsDialog.this.downloadProps;
                        DownloadFontPropsDialog.this.downloadProps.cmapstate = 1;
                        DownloadFontPropsDialog.this.downloadProps.cmapfile = DownloadFontPropsDialog.this.filename.getText().trim();
                        DownloadFontPropsDialog.this.downloadProps.cmapname = DownloadFontPropsDialog.this.CMapName.getText().trim();
                    } else {
                        DownloadProperties cfr_ignored_1 = DownloadFontPropsDialog.this.downloadProps;
                        DownloadFontPropsDialog.this.downloadProps.cmapstate = 2;
                        DownloadFontPropsDialog.this.downloadProps.cmapfile = DownloadFontPropsDialog.this.SystemCMapFiles[cmapindex - 2];
                        DownloadFontPropsDialog.this.downloadProps.cmapname = DownloadFontPropsDialog.this.SystemCMapNames[cmapindex - 2];
                    }
                } else {
                    DownloadProperties cfr_ignored_2 = DownloadFontPropsDialog.this.downloadProps;
                    DownloadFontPropsDialog.this.downloadProps.cmapstate = 0;
                    DownloadFontPropsDialog.this.downloadProps.cmapfile = "";
                    DownloadFontPropsDialog.this.downloadProps.cmapname = "";
                }
                int index = DownloadFontPropsDialog.this.encodingCBox.getSelectedIndex();
                DownloadFontPropsDialog.this.downloadProps.encodingID = DownloadFontPropsDialog.this.trs[index].src;
                DownloadFontPropsDialog.this.downloadProps.psname = DownloadFontPropsDialog.this.psNameField.getText();
                DownloadFontPropsDialog.this.downloadProps.conversion = DownloadFontPropsDialog.this.typeConvCBox.getSelectedIndex();
                DownloadFontPropsDialog.this.downloadProps.destination = index = DownloadFontPropsDialog.this.destCBox.getSelectedIndex() + 1;
                DownloadFontPropsDialog.this.downloadProps.includeCMap = DownloadFontPropsDialog.this.includeCMapCBox.isSelected() ? 1 : 0;
                DownloadFontPropsDialog.this.fontPropsDialog.setVisible(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DownloadFontPropsDialog.this.cancelButton.doClick();
                    return;
                }
                if (e.getKeyCode() == 10 && e.isControlDown()) {
                    DownloadFontPropsDialog.this.okButton.doClick();
                    return;
                }
            }
        });
    }

    public class BasicPropsLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int x;
        int y;
        int labelHeight = 25;
        int labelWidth = 75;

        public BasicPropsLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontPropsDialog.this.fontName);
            this.panel.add(DownloadFontPropsDialog.this.fontFullName);
            this.panel.add(DownloadFontPropsDialog.this.fontType);
            this.panel.add(DownloadFontPropsDialog.this.copyrightScrollPane);
            this.panel.add(DownloadFontPropsDialog.this.nameLabel);
            this.panel.add(DownloadFontPropsDialog.this.fullnameLabel);
            this.panel.add(DownloadFontPropsDialog.this.typeLabel);
            this.panel.add(DownloadFontPropsDialog.this.copyrightLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 100);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 100);
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.x = 5;
            this.y = 10;
            int fieldwidth = this.panelWidth - (this.x + this.labelWidth + 5) - 10;
            DownloadFontPropsDialog.this.nameLabel.setBounds(this.x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.fontName.setBounds(this.x + this.labelWidth + 5, this.y, fieldwidth, this.labelHeight);
            this.y = this.y + this.labelHeight + 3;
            DownloadFontPropsDialog.this.fullnameLabel.setBounds(this.x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.fontFullName.setBounds(this.x + this.labelWidth + 5, this.y, fieldwidth, this.labelHeight);
            this.y = this.y + this.labelHeight + 3;
            DownloadFontPropsDialog.this.typeLabel.setBounds(this.x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.fontType.setBounds(this.x + this.labelWidth + 5, this.y, fieldwidth, this.labelHeight);
            this.y = this.y + this.labelHeight + 3;
            int scrollWidth = this.panelWidth - (this.x + this.labelWidth + 5) - 10;
            int scrollHeight = this.panelHeight - this.y - 10;
            DownloadFontPropsDialog.this.copyrightLabel.setBounds(this.x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.copyrightScrollPane.setBounds(this.x + this.labelWidth + 5, this.y, scrollWidth, scrollHeight);
            DownloadFontPropsDialog.this.displayBasicFontProps();
        }
    }

    public class AdvancedPropsLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int boxWidth = 210;
        int boxHeight = 25;
        int labelHeight = 25;
        int labelWidth = 109;
        int col1_x = 20;
        int padding = 5;
        int col2_x = this.col1_x + this.labelWidth + this.padding;
        int y = 13;

        public AdvancedPropsLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontPropsDialog.this.includeCMapLabel);
            this.panel.add(DownloadFontPropsDialog.this.typeConvLabel);
            this.panel.add(DownloadFontPropsDialog.this.encodingLabel);
            this.panel.add(DownloadFontPropsDialog.this.destLabel);
            this.panel.add(DownloadFontPropsDialog.this.typeConvCBox);
            this.panel.add(DownloadFontPropsDialog.this.encodingCBox);
            this.panel.add(DownloadFontPropsDialog.this.destCBox);
            this.panel.add(DownloadFontPropsDialog.this.includeCMapCBox);
            this.panel.add(DownloadFontPropsDialog.this.cmapCBox);
            this.panel.add(DownloadFontPropsDialog.this.CMapButton);
            this.panel.add(DownloadFontPropsDialog.this.CMapLabel);
            this.panel.add(DownloadFontPropsDialog.this.CMapNameLabel);
            this.panel.add(DownloadFontPropsDialog.this.filename);
            this.panel.add(DownloadFontPropsDialog.this.CMapName);
            this.panel.add(DownloadFontPropsDialog.this.psNameField);
            this.panel.add(DownloadFontPropsDialog.this.psNameLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 300);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 300);
            return dim;
        }

        public void layoutContainer(Container parent) {
            if (!DownloadFontPropsDialog.this.newvar) {
                return;
            }
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            DownloadFontPropsDialog.this.typeConvLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.typeConvCBox.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + this.padding;
            DownloadFontPropsDialog.this.destLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.destCBox.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 3 * this.padding;
            DownloadFontPropsDialog.this.includeCMapLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.includeCMapCBox.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 3 * this.padding;
            DownloadFontPropsDialog.this.encodingLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.encodingCBox.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 2 * this.padding;
            DownloadFontPropsDialog.this.psNameLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.psNameField.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 5 * this.padding;
            DownloadFontPropsDialog.this.CMapLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.cmapCBox.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 2 * this.padding;
            DownloadFontPropsDialog.this.CMapButton.setBounds(this.col1_x - 8, this.y - 5, this.labelWidth, this.labelHeight + 10);
            DownloadFontPropsDialog.this.filename.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            this.y = this.y + this.labelHeight + 2 * this.padding;
            DownloadFontPropsDialog.this.CMapNameLabel.setBounds(this.col1_x, this.y, this.labelWidth, this.labelHeight);
            DownloadFontPropsDialog.this.CMapName.setBounds(this.col2_x, this.y, this.boxWidth, this.boxHeight);
            DownloadFontPropsDialog.this.psNameField.setText(DownloadFontPropsDialog.this.downloadProps.psname);
        }
    }

    public class ButtonPanelLayout
    implements LayoutManager {
        JPanel panel;
        int buttonX;
        int panelWidth;
        int panelHeight;
        int padding = 5;
        int buttonWidth = new Integer(DownloadFontPropsDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
        int buttonHeight = new Integer(DownloadFontPropsDialog.this.getMessage("dimensions.okcancelbuttonheight"));

        public ButtonPanelLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontPropsDialog.this.okButton);
            this.panel.add(DownloadFontPropsDialog.this.cancelButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            dim.width = 385;
            dim.height = 67;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            dim.width = 385;
            dim.height = 67;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.buttonX = this.panelWidth - 2 * this.padding - 2 * this.buttonWidth;
            DownloadFontPropsDialog.this.okButton.setBounds(this.buttonX, 15, this.buttonWidth, this.buttonHeight);
            DownloadFontPropsDialog.this.cancelButton.setBounds(this.buttonX + (this.buttonWidth + this.padding), 15, this.buttonWidth, this.buttonHeight);
        }
    }

    public class InfoTextField
    extends JTextField {
        public InfoTextField() {
            this.setFont(FontDownloaderMainFrame.defaultFont);
            this.setBorder(null);
            this.setOpaque(true);
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ InfoTextField this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent evt) {
                    int code = evt.getKeyCode();
                    if (code == 39) {
                        return;
                    }
                    if (code == 37) {
                        return;
                    }
                    if (code == 227) {
                        return;
                    }
                    if (code == 226) {
                        return;
                    }
                    evt.consume();
                }

                public void keyTyped(KeyEvent evt) {
                    int code = evt.getKeyCode();
                    if (code == 39) {
                        return;
                    }
                    if (code == 37) {
                        return;
                    }
                    if (code == 227) {
                        return;
                    }
                    if (code == 226) {
                        return;
                    }
                    evt.consume();
                }

                public void keyReleased(KeyEvent evt) {
                    int code = evt.getKeyCode();
                    if (code == 39) {
                        return;
                    }
                    if (code == 37) {
                        return;
                    }
                    if (code == 227) {
                        return;
                    }
                    if (code == 226) {
                        return;
                    }
                    evt.consume();
                }
            });
        }
    }
}

