/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DownloadFontDialog
extends JDialog
implements ListCallbackInt {
    ResourceBundle bundle;
    public FontDownloaderList fontList;
    public JButton addFontButton;
    public JButton removeFontButton;
    public JButton propsFontButton;
    public JButton saveFontButton;
    public JButton downloadButton;
    public JButton cancelButton;
    JButton okButton;
    JScrollPane scrollPane;
    DownloadProperties[] edittedFontList;
    DownloadFontListener downloadListener;
    public DefaultListModel defListModel;
    public ProgressMonitorDialog pmd;
    public Boolean isOpened = new Boolean(false);
    FontDownloaderMainFrame parent;
    PrinterProperties prtProps;
    boolean downloadFlag;
    int[] rowsSelected;
    boolean mouseWasDragged = false;
    public Boolean downloadSync = new Boolean(false);
    DownloadFontDialog downloadDialog;
    Vector downloadPropsList = new Vector();
    final Dimension labelvpad = new Dimension(1, 10);
    final int WIDTH = new Integer(this.getMessage("dimensions.downloadfontdialog_width"));
    final int HEIGHT = new Integer(this.getMessage("dimensions.downloadfontdialog_height"));

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public DownloadFontDialog(FontDownloaderMainFrame parent, PrinterProperties prtProps, boolean downloadFlag) {
        super(parent);
        this.setTitle(this.getMessage("downloadfontdialog.download_fonts"));
        this.parent = parent;
        this.prtProps = prtProps;
        this.downloadFlag = downloadFlag;
        this.downloadDialog = this;
        this.getContentPane().setLayout(new BorderLayout());
        Dimension d = parent.getSize();
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setModal(true);
        this.createFontList();
        this.scrollPane = new JScrollPane(this.fontList, 20, 30);
        this.createControlButtons();
        int width = this.getSize().width;
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new FontDialogLayout(compositePanel));
        this.getContentPane().add((Component)compositePanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Runnable forGettingFocus = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).addFontButton.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(forGettingFocus);
            }

            static /* synthetic */ DownloadFontDialog access$000(1 x0) {
                return x0.DownloadFontDialog.this;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < DownloadFontDialog.this.WIDTH || windim.height < DownloadFontDialog.this.HEIGHT) {
                    DownloadFontDialog.this.setSize(DownloadFontDialog.this.WIDTH, DownloadFontDialog.this.HEIGHT);
                }
            }
        });
        Dimension dim = new Dimension();
        dim = parent.getSize();
        this.setLocation(parent.getLocation().x, parent.getLocation().y + dim.height);
        if (this.downloadButton != null) {
            this.downloadButton.setEnabled(false);
        }
        this.propsFontButton.setEnabled(false);
        if (this.saveFontButton != null) {
            this.saveFontButton.setEnabled(false);
            this.saveFontButton.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DownloadFontDialog.this.saveFontButton.doClick();
                }
            }, KeyStroke.getKeyStroke(83, 8), 2);
        }
        this.removeFontButton.setEnabled(false);
        this.propsFontButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadFontDialog.this.propsFontButton.doClick();
            }
        }, KeyStroke.getKeyStroke(10, 8), 2);
        this.addActions();
        FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
        fdlFocusMgr.registerAction(27, this.cancelButton, this);
        fdlFocusMgr.registerAction(155, this.addFontButton, this);
        fdlFocusMgr.registerAction(127, this.removeFontButton, this);
        if (this.okButton != null) {
            fdlFocusMgr.registerAction(10, this.okButton, this);
        }
    }

    void createFontList() {
        this.defListModel = new DefaultListModel();
        this.fontList = new FontDownloaderList(this.defListModel, this.downloadDialog);
        this.fontList.setBackground(Color.white);
        if (this.defListModel.size() > 0) {
            this.fontList.setSelectedIndex(0);
        }
    }

    void createControlButtons() {
        this.propsFontButton = new JButton(this.getMessage("downloadfontdialog.font_properties"));
        this.addFontButton = new JButton(this.getMessage("downloadfontdialog.add_font"));
        this.removeFontButton = new JButton(this.getMessage("downloadfontdialog.remove_font"));
        this.cancelButton = new JButton(this.getMessage("downloadfontdialog.cancel"));
        if (this.downloadFlag) {
            this.saveFontButton = new JButton(this.getMessage("downloadfontdialog.save_font"));
            this.saveFontButton.setMnemonic('S');
        }
        if (this.downloadFlag) {
            this.downloadButton = new JButton(this.getMessage("downloadfontdialog.download"));
        } else {
            this.okButton = new JButton(this.getMessage("downloadfontdialog.ok"));
        }
        this.addFontButton.setMnemonic(65);
        this.removeFontButton.setMnemonic(82);
        this.propsFontButton.setMnemonic(80);
        if (this.saveFontButton != null) {
            this.saveFontButton.setMnemonic(83);
        }
    }

    public DownloadProperties[] getEdittedFontList() {
        return this.edittedFontList;
    }

    public void setFontList(DownloadProperties[] list) {
        this.defListModel.removeAllElements();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                DownloadProperties dp = list[i];
                this.defListModel.add(i, dp.fontpathstr);
                this.downloadPropsList.addElement(dp);
                ++i;
            }
            if (list.length > 0) {
                this.removeFontButton.setEnabled(true);
                this.propsFontButton.setEnabled(true);
                if (this.saveFontButton != null) {
                    this.saveFontButton.setEnabled(true);
                }
                this.fontList.setSelectedIndex(0);
            }
        }
    }

    public void setListSelections(int[] rowsSelected) {
        this.rowsSelected = rowsSelected;
    }

    public int[] getListSelections() {
        return this.rowsSelected;
    }

    void addActions() {
        this.addFontButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Boolean bl = DownloadFontDialog.this.isOpened;
                synchronized (bl) {
                    if (DownloadFontDialog.this.isOpened.booleanValue()) {
                        return;
                    }
                }
                Boolean bl2 = DownloadFontDialog.this.isOpened;
                synchronized (bl2) {
                    DownloadFontDialog.this.isOpened = new Boolean(true);
                }
                JFileChooser fileDialog = new JFileChooser();
                fileDialog.setDialogTitle(DownloadFontDialog.this.getMessage("downloadfontdialog.add_font"));
                fileDialog.setDialogType(0);
                if (FontDownloaderMainFrame.lastVisitedDir == null) {
                    String userhome;
                    Properties sysprops = System.getProperties();
                    FontDownloaderMainFrame.lastVisitedDir = userhome = sysprops.getProperty("user.home");
                }
                fileDialog.setCurrentDirectory(new File(FontDownloaderMainFrame.lastVisitedDir));
                int state = fileDialog.showOpenDialog(DownloadFontDialog.this.parent);
                Boolean bl3 = DownloadFontDialog.this.isOpened;
                synchronized (bl3) {
                    DownloadFontDialog.this.isOpened = new Boolean(false);
                }
                if (state == 1) {
                    return;
                }
                String fontdir = null;
                try {
                    fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException io) {
                    // empty catch block
                }
                String fontfile = null;
                if (fileDialog.getSelectedFile() != null) {
                    fontfile = fileDialog.getSelectedFile().getName();
                }
                if (fileDialog.getCurrentDirectory() != null) {
                    try {
                        fontdir = fileDialog.getCurrentDirectory().getCanonicalPath();
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                }
                if (fontdir == null && fontfile == null) {
                    return;
                }
                String fontElement = "";
                if (fontdir != null && fontfile == null) {
                    fontElement = fontdir;
                } else if (fontdir != null && fontfile != null) {
                    fontElement = fontdir + "/" + fontfile;
                }
                File file = new File(fontElement);
                if (file.isDirectory()) {
                    FontDownloaderMainFrame.lastVisitedDir = fontdir;
                    return;
                }
                int filetype = -1;
                filetype = PrinterProperties.getFileType(fontElement);
                FontDownloaderMainFrame.lastVisitedDir = fontdir;
                if (DownloadFontDialog.this.prtProps != null && DownloadFontDialog.this.prtProps.getNumDisks() == 0 && (filetype == 4 || filetype == 5)) {
                    String err = "The selected CID font or CMap file\n";
                    err = err + "can be only downloaded to a printer with a \n";
                    err = err + "hard disk";
                    JOptionPane.showMessageDialog(DownloadFontDialog.this.downloadDialog, err, DownloadFontDialog.this.getMessage("downloadfontdialog.no_hard_disk_error"), 0);
                    return;
                }
                if (filetype < 0) {
                    JOptionPane.showMessageDialog(DownloadFontDialog.this.downloadDialog, DownloadFontDialog.this.getMessage("downloadfontdialog.this_file_does_not_appear_to_be_a_font_file_dot__file_not_added"), DownloadFontDialog.this.getMessage("downloadfontdialog.font_file_type_error"), 0);
                    return;
                }
                DownloadFontDialog.this.defListModel.addElement(fontElement);
                DownloadProperties dp = new DownloadProperties();
                dp.fontpathstr = fontElement;
                dp.filetype = filetype;
                DownloadFontDialog.this.downloadPropsList.addElement(dp);
                DownloadFontDialog.this.fontList.setSelectedValue(fontElement, true);
                DownloadFontDialog.this.fontList.setSelectedIndex(DownloadFontDialog.this.getListSize() - 1);
                DownloadFontDialog.this.fontList.ensureIndexIsVisible(DownloadFontDialog.this.getListSize() - 1);
                if (DownloadFontDialog.this.defListModel.size() >= 1) {
                    if (DownloadFontDialog.this.downloadButton != null) {
                        DownloadFontDialog.this.downloadButton.setEnabled(true);
                    }
                    DownloadFontDialog.this.removeFontButton.setEnabled(true);
                    DownloadFontDialog.this.propsFontButton.setEnabled(true);
                    if (DownloadFontDialog.this.saveFontButton != null) {
                        DownloadFontDialog.this.saveFontButton.setEnabled(true);
                    }
                }
                DownloadFontDialog.this.fontList.grabFocus();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadFontDialog.this.downloadDialog.setVisible(false);
                DownloadFontDialog.this.edittedFontList = null;
            }
        });
        if (this.okButton != null) {
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Object[] objList = DownloadFontDialog.this.defListModel.toArray();
                    DownloadFontDialog.this.edittedFontList = new DownloadProperties[objList.length];
                    int i = 0;
                    while (i < DownloadFontDialog.this.edittedFontList.length) {
                        DownloadProperties dp;
                        DownloadFontDialog.this.edittedFontList[i] = dp = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(i);
                        ++i;
                    }
                    DownloadFontDialog.this.downloadDialog.setVisible(false);
                }
            });
        }
        if (this.saveFontButton != null) {
            this.saveFontButton.addActionListener(new ActionListener(){
                DownloadFontSetDialog fontSetDialog;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    Boolean bl = DownloadFontDialog.this.isOpened;
                    synchronized (bl) {
                        if (DownloadFontDialog.this.isOpened.booleanValue()) {
                            return;
                        }
                    }
                    Boolean bl2 = DownloadFontDialog.this.isOpened;
                    synchronized (bl2) {
                        DownloadFontDialog.this.isOpened = new Boolean(true);
                    }
                    this.fontSetDialog = new DownloadFontSetDialog(DownloadFontDialog.this.parent, DownloadFontDialog.this.prtProps, true, false);
                    this.fontSetDialog.addFontSetItem(0);
                    int index = this.fontSetDialog.fontbundleList.getRowCount() - 1;
                    String newname = (String)this.fontSetDialog.fontbundleList.getValueAt(index, 0);
                    Object[] objList = DownloadFontDialog.this.defListModel.toArray();
                    Object[] fonts = new DownloadProperties[objList.length];
                    int i = 0;
                    while (i < fonts.length) {
                        DownloadProperties dp;
                        fonts[i] = dp = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(i);
                        ++i;
                    }
                    Integer numfonts = new Integer(objList.length);
                    this.fontSetDialog.fontbundleList.setValueAt(numfonts.toString(), index, 1);
                    this.fontSetDialog.ud.add("fontset." + newname, fonts);
                    this.fontSetDialog.setVisible(true);
                    Boolean bl3 = DownloadFontDialog.this.isOpened;
                    synchronized (bl3) {
                        DownloadFontDialog.this.isOpened = new Boolean(false);
                    }
                }
            });
        }
        RemoveFontListener removeFontListener = new RemoveFontListener();
        this.removeFontButton.addActionListener(removeFontListener);
        this.propsFontButton.addActionListener(new FontPropsListener(this.parent));
        if (this.downloadFlag) {
            this.downloadListener = new DownloadFontListener();
            this.downloadButton.addActionListener(this.downloadListener);
        }
    }

    public int getListSize() {
        return this.fontList.getModel().getSize();
    }

    public void SetSelectedCount(int numElements) {
        if (numElements == 1) {
            this.propsFontButton.setEnabled(true);
        } else {
            this.propsFontButton.setEnabled(false);
        }
    }

    public void MouseDoubleClicked() {
        if (this.propsFontButton != null) {
            this.propsFontButton.doClick();
        }
    }

    public class FontDialogLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int controlButtonX;
        int buttonX;
        int buttonY;
        int scrollPaneWidth;
        int scrollPaneHeight;
        int controlButtonWidth;
        int controlButtonHeight;
        int buttonWidth;
        int buttonHeight;
        int padding_left;
        int control_button_padding;
        int button_padding;

        public FontDialogLayout(Container c) {
            this.controlButtonWidth = new Integer(DownloadFontDialog.this.getMessage("dimensions.controlbuttonwidth"));
            this.controlButtonHeight = new Integer(DownloadFontDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.buttonWidth = new Integer(DownloadFontDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            this.buttonHeight = new Integer(DownloadFontDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            this.padding_left = 12;
            this.control_button_padding = 12;
            this.button_padding = 12;
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontDialog.this.scrollPane);
            this.panel.add(DownloadFontDialog.this.addFontButton);
            this.panel.add(DownloadFontDialog.this.removeFontButton);
            this.panel.add(DownloadFontDialog.this.propsFontButton);
            if (DownloadFontDialog.this.downloadFlag) {
                this.panel.add(DownloadFontDialog.this.saveFontButton);
                this.panel.add(DownloadFontDialog.this.downloadButton);
            } else {
                this.panel.add(DownloadFontDialog.this.okButton);
            }
            this.panel.add(DownloadFontDialog.this.cancelButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontDialog.this.WIDTH;
            dim.height = DownloadFontDialog.this.HEIGHT;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontDialog.this.WIDTH;
            dim.height = DownloadFontDialog.this.HEIGHT;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.controlButtonX = this.panelWidth - this.controlButtonWidth - this.control_button_padding;
            this.scrollPaneWidth = this.panelWidth - this.controlButtonWidth - this.control_button_padding * 2 - this.padding_left;
            this.scrollPaneHeight = this.panelHeight - 8 - 70;
            DownloadFontDialog.this.scrollPane.setBounds(this.padding_left, 8, this.scrollPaneWidth, this.scrollPaneHeight);
            DownloadFontDialog.this.addFontButton.setBounds(this.controlButtonX, 22, this.controlButtonWidth, this.controlButtonHeight);
            DownloadFontDialog.this.removeFontButton.setBounds(this.controlButtonX, 57, this.controlButtonWidth, this.controlButtonHeight);
            DownloadFontDialog.this.propsFontButton.setBounds(this.controlButtonX, 92, this.controlButtonWidth, this.controlButtonHeight);
            if (DownloadFontDialog.this.downloadFlag) {
                DownloadFontDialog.this.saveFontButton.setBounds(this.controlButtonX, 127, this.controlButtonWidth, this.controlButtonHeight);
            }
            this.buttonX = this.panelWidth - 2 * this.button_padding - 2 * this.buttonWidth;
            this.buttonY = this.scrollPaneHeight + 8 + 15;
            if (DownloadFontDialog.this.downloadFlag) {
                DownloadFontDialog.this.downloadButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
            } else {
                DownloadFontDialog.this.okButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
            }
            DownloadFontDialog.this.cancelButton.setBounds(this.buttonX + this.buttonWidth + this.button_padding, this.buttonY, this.buttonWidth, this.buttonHeight);
        }
    }

    class FontPropsListener
    extends AbstractAction {
        JFrame frame;
        DownloadFontPropsDialog fPropsDialog;

        public FontPropsListener(JFrame parent) {
            this.frame = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Boolean bl = DownloadFontDialog.this.isOpened;
            synchronized (bl) {
                if (DownloadFontDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = DownloadFontDialog.this.isOpened;
            synchronized (bl2) {
                DownloadFontDialog.this.isOpened = new Boolean(true);
            }
            int id = DownloadFontDialog.this.fontList.getSelectedIndex();
            DownloadProperties dp = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(id);
            int numDisks = DownloadFontDialog.this.prtProps.getNumDisks();
            if (numDisks == -1) {
                DownloadFontDialog.this.pmd = new ProgressMonitorDialog(DownloadFontDialog.this.downloadDialog, DownloadFontDialog.this.getMessage("downloadfontdialog.getting_printer_properties_dot__dot__dot_"));
                DownloadFontDialog.this.pmd.setTitle(DownloadFontDialog.this.getMessage("downloadfontdialog.progress:_getting_printer_properties"));
                new ProgressMonitorThread().start();
                new GetPropsThread(this.frame, this.fPropsDialog, dp, id).start();
            } else {
                this.fPropsDialog = new DownloadFontPropsDialog(this.frame, DownloadFontDialog.this.prtProps, dp);
                this.fPropsDialog.setVisible(true);
                Boolean bl3 = DownloadFontDialog.this.isOpened;
                synchronized (bl3) {
                    DownloadFontDialog.this.isOpened = new Boolean(false);
                }
                this.fPropsDialog.getDownloadProperties(dp);
                DownloadFontDialog.this.downloadPropsList.setElementAt(dp, id);
            }
        }
    }

    class GetPropsThread
    extends Thread {
        JFrame frame;
        DownloadProperties dp;
        DownloadFontPropsDialog fPropsDialog;
        int id;

        public GetPropsThread(JFrame frame, DownloadFontPropsDialog fPropsDialog, DownloadProperties dp, int id) {
            this.frame = frame;
            this.dp = dp;
            this.fPropsDialog = fPropsDialog;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.fPropsDialog = new DownloadFontPropsDialog(this.frame, DownloadFontDialog.this.prtProps, this.dp);
            DownloadFontDialog.this.pmd.setTrue();
            this.fPropsDialog.setVisible(true);
            Boolean bl = DownloadFontDialog.this.isOpened;
            synchronized (bl) {
                DownloadFontDialog.this.isOpened = new Boolean(false);
            }
            this.fPropsDialog.getDownloadProperties(this.dp);
            DownloadFontDialog.this.downloadPropsList.setElementAt(this.dp, this.id);
        }
    }

    class RemoveFontListener
    extends AbstractAction {
        RemoveFontListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            Boolean bl = DownloadFontDialog.this.isOpened;
            synchronized (bl) {
                if (DownloadFontDialog.this.isOpened.booleanValue()) {
                    return;
                }
            }
            Boolean bl2 = DownloadFontDialog.this.isOpened;
            synchronized (bl2) {
                DownloadFontDialog.this.isOpened = new Boolean(true);
            }
            FontDownloaderList flist = DownloadFontDialog.this.downloadDialog.fontList;
            if (flist.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(DownloadFontDialog.this.downloadDialog, DownloadFontDialog.this.getMessage("downloadfontdialog.no_font_selected_for_removal"), DownloadFontDialog.this.getMessage("downloadfontdialog.warning"), 2);
                return;
            }
            String warnmsg = new String(DownloadFontDialog.this.getMessage("downloadfontdialog.are_you_sure_you_want_to_remove_the_selected_fonts?"));
            int ans = JOptionPane.showConfirmDialog(DownloadFontDialog.this.downloadDialog, warnmsg, DownloadFontDialog.this.getMessage("downloadfontdialog.remove_confirmation"), 0);
            Boolean bl3 = DownloadFontDialog.this.isOpened;
            synchronized (bl3) {
                DownloadFontDialog.this.isOpened = new Boolean(false);
            }
            if (ans == 0) {
                int[] currentSelections = flist.getSelectedIndices();
                int i = 0;
                while (i < currentSelections.length) {
                    DownloadFontDialog.this.defListModel.removeElementAt(currentSelections[i] - i);
                    DownloadFontDialog.this.downloadPropsList.removeElementAt(currentSelections[i] - i);
                    ++i;
                }
                int lastIndex = currentSelections[i - 1];
                if (lastIndex >= DownloadFontDialog.this.defListModel.size()) {
                    lastIndex = DownloadFontDialog.this.defListModel.size() - 1;
                }
                DownloadFontDialog.this.fontList.setSelectedIndex(lastIndex);
            }
            if (DownloadFontDialog.this.defListModel.size() == 0) {
                if (DownloadFontDialog.this.downloadButton != null) {
                    DownloadFontDialog.this.downloadButton.setEnabled(false);
                }
                if (DownloadFontDialog.this.propsFontButton != null) {
                    DownloadFontDialog.this.propsFontButton.setEnabled(false);
                }
                if (DownloadFontDialog.this.saveFontButton != null) {
                    DownloadFontDialog.this.saveFontButton.setEnabled(false);
                }
                DownloadFontDialog.this.removeFontButton.setEnabled(false);
            }
            DownloadFontDialog.this.fontList.grabFocus();
        }
    }

    class DownloadThread
    extends Thread {
        DownloadProperties[] downloadProps;
        DownloadFontDialog fontDialog;

        public DownloadThread(DownloadFontDialog fontDialog, DownloadProperties[] dp) {
            this.fontDialog = fontDialog;
            this.downloadProps = dp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Boolean bl = this.fontDialog.downloadSync;
            synchronized (bl) {
                this.fontDialog.downloadSync = new Boolean(false);
            }
            Thread.yield();
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.fontDialog.prtProps.numdisks == -1) {
                DownloadFontDialog.this.pmd.setMessageNL(DownloadFontDialog.this.getMessage("downloadfontdialog.reading_printer_properties_dot"));
                try {
                    this.fontDialog.prtProps.getAllProperties();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.fontDialog.prtProps.Download(this.fontDialog.prtProps.printerName, this.fontDialog.prtProps.exitserverpasswd, this.downloadProps, this.fontDialog.prtProps.parent.cmapfolder, DownloadFontDialog.this.pmd);
            Boolean bl2 = this.fontDialog.downloadSync;
            synchronized (bl2) {
                this.fontDialog.downloadSync = new Boolean(true);
            }
            DownloadFontDialog.this.pmd.setTrue();
            if (this.fontDialog.saveFontButton != null) {
                this.fontDialog.saveFontButton.setEnabled(true);
            }
            this.fontDialog.cancelButton.setEnabled(true);
            this.fontDialog.cancelButton.setText(DownloadFontDialog.this.getMessage("downloadfontdialog.ok"));
            this.fontDialog.cancelButton.setMnemonic(79);
        }
    }

    public class ProgressMonitorThread
    extends Thread {
        public void run() {
            Thread t = new Thread(DownloadFontDialog.this.pmd);
            t.setPriority(10);
            t.start();
            DownloadFontDialog.this.pmd.setVisible(true);
        }
    }

    class DownloadThreadDisplay
    extends Thread {
        DownloadFontDialog fontDialog;

        public DownloadThreadDisplay(DownloadFontDialog fontDialog) {
            this.fontDialog = fontDialog;
        }

        void checkForCIDFonts() {
            int numProps = DownloadFontDialog.this.downloadPropsList.size();
            int n = 0;
            while (n < numProps) {
                DownloadProperties dp1 = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(n);
                if (dp1.filetype == 4 && dp1.includeCMap == 1) {
                    int m = 0;
                    while (m < numProps) {
                        DownloadProperties dp2 = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(m);
                        if (dp2.filetype == 4) {
                            dp2.includeCMap = 1;
                            DownloadFontDialog.this.downloadPropsList.setElementAt(dp2, m);
                            int l = ++m;
                            while (l < numProps) {
                                DownloadProperties dpcid = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(l);
                                if (dpcid.filetype == 4) {
                                    dpcid.includeCMap = 0;
                                }
                                DownloadFontDialog.this.downloadPropsList.setElementAt(dpcid, l);
                                ++l;
                            }
                            return;
                        }
                        ++m;
                    }
                }
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FontDownloaderList flist = this.fontDialog.fontList;
            DefaultListModel model = (DefaultListModel)flist.getModel();
            int numFonts = this.fontDialog.getListSize();
            Boolean bl = this.fontDialog.fontList.downloadCompleteFlag;
            synchronized (bl) {
                this.fontDialog.fontList.downloadCompleteFlag = new Boolean(false);
            }
            this.fontDialog.addFontButton.setEnabled(false);
            this.fontDialog.removeFontButton.setEnabled(false);
            this.fontDialog.propsFontButton.setEnabled(false);
            if (this.fontDialog.saveFontButton != null) {
                this.fontDialog.saveFontButton.setEnabled(false);
            }
            this.fontDialog.downloadButton.setEnabled(false);
            this.fontDialog.cancelButton.setEnabled(false);
            this.checkForCIDFonts();
            DownloadProperties[] dp = new DownloadProperties[numFonts];
            int n = 0;
            while (n < numFonts) {
                String fontpath = (String)model.getElementAt(n);
                String fontName = (String)flist.getSelectedValue();
                String leafName = new String();
                int index = fontName.lastIndexOf("/");
                leafName = index > 0 ? fontName.substring(++index) : fontName;
                Boolean bl2 = this.fontDialog.downloadSync;
                synchronized (bl2) {
                    this.fontDialog.downloadSync = new Boolean(false);
                }
                dp[n] = (DownloadProperties)DownloadFontDialog.this.downloadPropsList.elementAt(n);
                ++n;
            }
            DownloadFontDialog.this.pmd = new ProgressMonitorDialog(DownloadFontDialog.this.downloadDialog, DownloadFontDialog.this.getMessage("downloadfontdialog.downloading_fonts_dot__dot__dot_"));
            DownloadFontDialog.this.pmd.setTitle(DownloadFontDialog.this.getMessage("downloadfontdialog.progress:_downloading_fonts"));
            new ProgressMonitorThread().start();
            DownloadThread t = new DownloadThread(this.fontDialog, dp);
            t.setPriority(3);
            t.start();
            Boolean bl3 = this.fontDialog.fontList.downloadCompleteFlag;
            synchronized (bl3) {
                this.fontDialog.fontList.downloadCompleteFlag = new Boolean(true);
            }
        }
    }

    class DownloadFontListener
    extends AbstractAction {
        DownloadFontListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            new DownloadThreadDisplay(DownloadFontDialog.this.downloadDialog).start();
        }
    }
}

