/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DownloadFontBundle
extends JDialog
implements ListCallbackInt {
    ResourceBundle bundle;
    public BadFontDialog bfd;
    public FontDownloaderList fontsetList;
    public JButton downloadButton;
    public JButton cancelButton;
    public JLabel topLabel;
    UserDefaults ud = FontDownloaderMainFrame.userdefs;
    JScrollPane scrollPane;
    DownloadFontBundle downloadFontBundle;
    DownloadFontListener downloadListener;
    public DefaultListModel defListModel;
    public Boolean downloadSync = new Boolean(false);
    public Boolean continueFlag = new Boolean(true);
    JFrame parentframe;
    String[] flist;
    Object[] initialFontsetList;
    PrinterProperties prtProps;
    boolean saveFlag;
    boolean editFlag;
    boolean already_pressed = false;
    public int[] rowsSelected;
    final int WIDTH = new Integer(this.getMessage("dimensions.downloadfontbundledialog_width"));
    final int HEIGHT = new Integer(this.getMessage("dimensions.downloadfontbundledialog_height"));
    String downloadStatusStr;
    final Dimension labelvpad = new Dimension(1, 10);
    public ProgressMonitorDialog pmd;
    JPanel compositePanel;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public DownloadFontBundle(JFrame parentframe, PrinterProperties prtProps) {
        super(parentframe);
        this.setTitle(this.getMessage("downloadfontbundle.download_font_bundles"));
        this.parentframe = parentframe;
        this.prtProps = prtProps;
        Dimension d = parentframe.getSize();
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setModal(true);
        this.downloadFontBundle = this;
        this.createFontSetList();
        this.fontsetList.setBackground(Color.white);
        this.scrollPane = new JScrollPane(this.fontsetList, 20, 30);
        this.createControlButtons();
        int width = this.getSize().width;
        this.topLabel = new JLabel(this.getMessage("downloadfontbundle.font_bundles_to_download"));
        this.compositePanel = new JPanel();
        this.compositePanel.setLayout(new DownloadFontBundleDialogLayout(this.compositePanel));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension windim = dialog.getSize();
                if (windim.width < DownloadFontBundle.this.WIDTH || windim.height < DownloadFontBundle.this.HEIGHT) {
                    DownloadFontBundle.this.setSize(DownloadFontBundle.this.WIDTH, DownloadFontBundle.this.HEIGHT);
                }
            }
        });
        this.getContentPane().add((Component)this.compositePanel, "Center");
        if (this.defListModel.getSize() > 0) {
            this.fontsetList.setSelectedIndex(0);
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(true);
            }
        } else if (this.downloadButton != null) {
            this.downloadButton.setEnabled(false);
        }
        Dimension dim = parentframe.getSize();
        this.setLocation(parentframe.getLocation().x, parentframe.getLocation().y + dim.height);
        this.fontsetList.validate();
        this.fontsetList.rowsSelected = this.fontsetList.getSelectedIndices();
        this.addActions();
        FdlFocusManager fdlFocusMgr = (FdlFocusManager)FocusManager.getCurrentManager();
        fdlFocusMgr.registerAction(27, this.cancelButton, this);
        fdlFocusMgr.registerAction(10, this.downloadButton, this);
        RepaintManager repaintManager = RepaintManager.currentManager(this.getRootPane());
        if (!repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Runnable forGettingFocus = new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).fontsetList.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(forGettingFocus);
            }

            static /* synthetic */ DownloadFontBundle access$000(2 x0) {
                return x0.DownloadFontBundle.this;
            }
        });
    }

    void createFontSetList() {
        this.defListModel = new DefaultListModel();
        this.fontsetList = new FontDownloaderList(this.defListModel, this.downloadFontBundle);
        Object[] userFontsetList = this.ud.arrayForKey("FontsetList");
        if (userFontsetList != null) {
            int i = 0;
            while (i < userFontsetList.length) {
                this.defListModel.add(i, userFontsetList[i]);
                ++i;
            }
            this.initialFontsetList = userFontsetList;
        }
    }

    void createControlButtons() {
        this.cancelButton = new JButton(this.getMessage("downloadfontsetdialog.cancel"));
        this.downloadButton = new JButton(this.getMessage("downloadfontsetdialog.download"));
    }

    public void setListSelections(int[] rowsSelected) {
        this.rowsSelected = rowsSelected;
    }

    public int[] getListSelections() {
        return this.rowsSelected;
    }

    public void setFontList(String[] flist) {
        this.flist = flist;
        String fontsetName = (String)this.fontsetList.getSelectedValue();
        Object[] dpFontList = new DownloadProperties[flist.length];
        int i = 0;
        while (i < flist.length) {
            DownloadProperties dp = new DownloadProperties();
            dp.fontpathstr = flist[i];
            dpFontList[i] = dp;
            ++i;
        }
        this.ud.add("fontset." + fontsetName, dpFontList);
    }

    void addActions() {
        if (this.downloadButton != null) {
            this.downloadListener = new DownloadFontListener();
            this.downloadButton.addActionListener(this.downloadListener);
        }
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefaultListModel model = (DefaultListModel)DownloadFontBundle.this.fontsetList.getModel();
                Object[] fontsetObjColl = model.toArray();
                String[] fontsetStrColl = new String[fontsetObjColl.length];
                int i = 0;
                while (i < fontsetStrColl.length) {
                    fontsetStrColl[i] = (String)fontsetObjColl[i];
                    ++i;
                }
                DownloadFontBundle.this.ud.remove("FontsetList");
                if (DownloadFontBundle.this.initialFontsetList != null) {
                    DownloadFontBundle.this.ud.add("FontsetList", DownloadFontBundle.this.initialFontsetList);
                }
                DownloadFontBundle.this.downloadFontBundle.setVisible(false);
            }
        });
    }

    public int getListSize() {
        return this.fontsetList.getModel().getSize();
    }

    public void SetSelectedCount(int n) {
    }

    public void MouseDoubleClicked() {
    }

    public class DownloadFontBundleDialogLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;
        int buttonX;
        int buttonY;
        int scrollPaneWidth;
        int scrollPaneHeight;
        int labelHeight = 14;
        int labelWidth;
        int top_padding = 12;
        int buttonWidth = new Integer(DownloadFontBundle.this.getMessage("dimensions.okcancelbuttonwidth"));
        int buttonHeight = new Integer(DownloadFontBundle.this.getMessage("dimensions.okcancelbuttonheight"));
        int padding_left = 12;
        int horizontal_button_padding = 12;
        int vertical_button_padding = 10;
        int vertical_padding = 8;

        public DownloadFontBundleDialogLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(DownloadFontBundle.this.scrollPane);
            this.panel.add(DownloadFontBundle.this.cancelButton);
            this.panel.add(DownloadFontBundle.this.downloadButton);
            this.panel.add(DownloadFontBundle.this.topLabel);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontBundle.this.WIDTH;
            dim.height = DownloadFontBundle.this.HEIGHT;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = DownloadFontBundle.this.WIDTH;
            dim.height = DownloadFontBundle.this.HEIGHT;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            this.scrollPaneWidth = this.panelWidth - 2 * this.padding_left;
            this.scrollPaneHeight = this.panelHeight - this.top_padding - this.labelHeight - 3 - this.vertical_padding - this.buttonHeight - 2 * this.vertical_button_padding;
            this.labelWidth = this.panelWidth;
            DownloadFontBundle.this.topLabel.setBounds(this.padding_left, this.top_padding, this.labelWidth, this.labelHeight);
            DownloadFontBundle.this.scrollPane.setBounds(this.padding_left, this.top_padding + this.labelHeight + 4, this.scrollPaneWidth, this.scrollPaneHeight);
            this.buttonY = this.top_padding + this.scrollPaneHeight + this.labelHeight + 3 + this.vertical_padding + this.vertical_button_padding;
            this.buttonX = this.panelWidth - this.padding_left - 2 * this.buttonWidth - this.horizontal_button_padding;
            DownloadFontBundle.this.downloadButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
            this.buttonX = this.buttonX + this.buttonWidth + this.horizontal_button_padding;
            DownloadFontBundle.this.cancelButton.setBounds(this.buttonX, this.buttonY, this.buttonWidth, this.buttonHeight);
        }
    }

    class DownloadFontSetThread
    extends Thread {
        DownloadProperties[] dprops;
        DownloadFontBundle fontDialog;

        public DownloadFontSetThread(DownloadFontBundle fontDialog, DownloadProperties[] dp) {
            this.fontDialog = fontDialog;
            this.dprops = dp;
        }

        public void run() {
            DownloadFontBundle.this.pmd.setMessageNL(DownloadFontBundle.this.getMessage("downloadfontbundle.downloading_bundles_dot__dot__dot_"));
            if (this.fontDialog.prtProps.numdisks == -1) {
                DownloadFontBundle.this.pmd.setMessageNL(DownloadFontBundle.this.getMessage("downloadfontbundle.reading_printer_properties_dot"));
                try {
                    this.fontDialog.prtProps.getAllProperties();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.fontDialog.prtProps.Download(this.fontDialog.prtProps.printerName, this.fontDialog.prtProps.exitserverpasswd, this.dprops, this.fontDialog.prtProps.parent.cmapfolder, DownloadFontBundle.this.pmd);
            this.fontDialog.downloadButton.setEnabled(true);
            this.fontDialog.cancelButton.setEnabled(true);
            DownloadFontBundle.this.pmd.setTrue();
        }
    }

    public class ProgressMonitorThread
    extends Thread {
        public void run() {
            Thread t = new Thread(DownloadFontBundle.this.pmd);
            t.setPriority(10);
            t.start();
            DownloadFontBundle.this.pmd.setVisible(true);
        }
    }

    class DownloadThread
    extends Thread {
        DownloadFontBundle fontDialog;

        public DownloadThread(DownloadFontBundle fontDialog) {
            this.fontDialog = fontDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void downloadComplete(int[] rowlist) {
            this.fontDialog.downloadButton.setEnabled(true);
            this.fontDialog.cancelButton.setEnabled(true);
            DownloadFontBundle.this.fontsetList.setSelectionBackground(Color.black);
            DownloadFontBundle.this.fontsetList.setSelectedIndices(rowlist);
            Boolean bl = this.fontDialog.fontsetList.downloadCompleteFlag;
            synchronized (bl) {
                this.fontDialog.fontsetList.downloadCompleteFlag = new Boolean(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Vector<Object> goodfonts = new Vector<Object>(0);
            Vector<String> badfonts = new Vector<String>(0);
            boolean unavailableFonts = false;
            FontDownloaderList flist = this.fontDialog.fontsetList;
            int[] selRows = DownloadFontBundle.this.fontsetList.getSelectedIndices();
            int lenSelRows = selRows.length;
            int count = 0;
            int badfontcount = 0;
            int num = 0;
            while (num < lenSelRows) {
                int n = selRows[num];
                String fontsetName = (String)DownloadFontBundle.this.defListModel.getElementAt(n);
                Object[] list = DownloadFontBundle.this.ud.arrayForKey("fontset." + fontsetName);
                if (list != null) {
                    int i = 0;
                    while (i < list.length) {
                        DownloadProperties dp = (DownloadProperties)list[i];
                        String pathname = dp.fontpathstr;
                        File fontfile = new File(pathname);
                        if (fontfile.exists() && fontfile.canRead()) {
                            Object obj = list[i];
                            goodfonts.addElement(obj);
                            ++count;
                        } else {
                            unavailableFonts = true;
                            badfonts.addElement(pathname);
                            ++badfontcount;
                        }
                        ++i;
                    }
                }
                ++num;
            }
            DownloadProperties[] dp = new DownloadProperties[count];
            int i = 0;
            while (i < count) {
                dp[i] = (DownloadProperties)goodfonts.elementAt(i);
                ++i;
            }
            String[] badFonts = new String[badfontcount];
            int counter = 0;
            boolean duplicate = false;
            int i2 = 0;
            while (i2 < badfontcount) {
                String name = (String)badfonts.elementAt(i2);
                int j = 0;
                while (j < counter) {
                    name = (String)badfonts.elementAt(i2);
                    if (name.equals(badFonts[j])) {
                        duplicate = true;
                    }
                    ++j;
                }
                if (!duplicate) {
                    badFonts[counter++] = name;
                } else {
                    duplicate = false;
                }
                ++i2;
            }
            String[] newBadFonts = new String[counter];
            int k = 0;
            while (k < counter) {
                newBadFonts[k] = badFonts[k];
                ++k;
            }
            if (unavailableFonts) {
                DownloadFontBundle.this.bfd = new BadFontDialog(newBadFonts);
                DownloadFontBundle.this.bfd.show();
                DownloadFontBundle.this.continueFlag = DownloadFontBundle.this.bfd.getValue();
            }
            if (DownloadFontBundle.this.continueFlag.booleanValue() && count != 0) {
                Boolean bl = this.fontDialog.fontsetList.downloadCompleteFlag;
                synchronized (bl) {
                    this.fontDialog.fontsetList.downloadCompleteFlag = new Boolean(false);
                }
                this.fontDialog.downloadButton.setEnabled(false);
                this.fontDialog.cancelButton.setEnabled(false);
                DownloadFontBundle.this.pmd = new ProgressMonitorDialog(DownloadFontBundle.this.downloadFontBundle, DownloadFontBundle.this.getMessage("downloadfontbundle.getting_download_properties_dot__dot__dot_"));
                DownloadFontBundle.this.pmd.setTitle(DownloadFontBundle.this.getMessage("downloadfontbundle.progress:_downloading_font_bundles"));
                new ProgressMonitorThread().start();
                DownloadFontSetThread t = new DownloadFontSetThread(this.fontDialog, dp);
                t.setPriority(3);
                t.start();
                Boolean bl2 = this.fontDialog.fontsetList.downloadCompleteFlag;
                synchronized (bl2) {
                    this.fontDialog.fontsetList.downloadCompleteFlag = new Boolean(true);
                }
            }
            DownloadFontBundle.this.continueFlag = new Boolean(true);
            DownloadFontBundle.this.already_pressed = false;
        }
    }

    class DownloadFontListener
    extends AbstractAction {
        DownloadFontListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (DownloadFontBundle.this.already_pressed) {
                return;
            }
            DownloadFontBundle.this.already_pressed = true;
            new DownloadThread(DownloadFontBundle.this.downloadFontBundle).start();
        }
    }
}

