/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

class DeletePrinterActionListener
extends AbstractAction {
    ResourceBundle bundle;
    PrinterListPanel prtList;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public DeletePrinterActionListener(PrinterListPanel prtList) {
        this.prtList = prtList;
    }

    public void actionPerformed(ActionEvent e) {
        JFrame fdl = (JFrame)this.prtList.getTopLevelAncestor();
        int selRow = this.prtList.prtTable.getSelectedRow();
        if (selRow == -1) {
            JOptionPane.showMessageDialog(fdl, this.getMessage("fontdownloadermainframe.no_printer_selected_for_deletion"), "Warning", 2);
            return;
        }
        String delConfirmMsg = this.getMessage("fontdownloadermainframe.are_you_sure_you_want_to_delete_the_selected_printer?");
        int ans = JOptionPane.showConfirmDialog(fdl, delConfirmMsg, this.getMessage("fontdownloadermainframe.delete_confirmation"), 0);
        if (ans == 0) {
            DefaultTableModel model = (DefaultTableModel)this.prtList.prtTable.getModel();
            model.removeRow(selRow);
            DefaultListSelectionModel rowSelector = (DefaultListSelectionModel)this.prtList.prtTable.getSelectionModel();
            if (selRow >= model.getRowCount()) {
                selRow = model.getRowCount() - 1;
            }
            rowSelector.setSelectionInterval(selRow, selRow);
            this.prtList.prtTable.repaint();
            if (model.getRowCount() == 0) {
                JMenuBar mb = ((FontDownloaderMainFrame)fdl).getFMenuBar();
                JMenu prtMenu = mb.getMenu(2);
                prtMenu.setEnabled(true);
                JMenuItem delMenuItem = prtMenu.getItem(1);
                JMenuItem propMenuItem = prtMenu.getItem(5);
                JMenuItem restartMenuItem = prtMenu.getItem(3);
                delMenuItem.setEnabled(false);
                propMenuItem.setEnabled(false);
                restartMenuItem.setEnabled(false);
                JMenu dlMenu = mb.getMenu(0);
                JMenuItem font = dlMenu.getItem(0);
                font.setEnabled(false);
                JMenuItem fontbundle = dlMenu.getItem(1);
                fontbundle.setEnabled(false);
            }
        }
    }
}

