/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class AddPrinterListDialog
extends JDialog {
    JButton addButton;
    JButton cancelButton;
    JLabel prtNameLabel;
    JLabel commentLabel;
    JLabel prttypeLabel;
    PrinterNameTextField prtName;
    PrinterNameTextField commentField;
    PrinterListPanel prtList;
    AddPrinterListDialog thisDialog;
    JComboBox prttypeSel;
    final Dimension vpad5 = new Dimension(1, 5);
    final int ADDPRINTER_WIDTH = new Integer(this.getMessage("dimensions.addprinterdialog_width"));
    final int ADDPRINTER_HEIGHT = new Integer(this.getMessage("dimensions.addprinterdialog_height"));
    FontDownloaderMainFrame parent;
    ResourceBundle bundle;

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("ResourceStrings");
            }
            catch (MissingResourceException e) {
                System.out.println("Could not load Resources");
                System.exit(0);
            }
        }
        String value = "";
        try {
            value = (String)this.bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find " + key);
        }
        return value;
    }

    public AddPrinterListDialog(FontDownloaderMainFrame parent, PrinterListPanel prtList) {
        super((Frame)parent, true);
        this.setTitle(this.getMessage("fontdownloadermainframe.add_printer"));
        this.parent = parent;
        this.prtList = prtList;
        this.thisDialog = this;
        this.addButton = new JButton(this.getMessage("fontdownloadermainframe.add"));
        this.cancelButton = new JButton(this.getMessage("fontdownloadermainframe.cancel"));
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Runnable forGettingFocus = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).prtName.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(forGettingFocus);
            }

            static /* synthetic */ AddPrinterListDialog access$000(1 x0) {
                return x0.AddPrinterListDialog.this;
            }
        });
        this.createObjects(this.ADDPRINTER_WIDTH);
        this.addActions();
        this.setResizable(false);
        this.setModal(true);
        this.setSize(this.ADDPRINTER_WIDTH, this.ADDPRINTER_HEIGHT);
        this.commentField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                int code = evt.getKeyCode();
                if (code == 10) {
                    AddPrinterListDialog.this.prttypeSel.requestFocus();
                }
            }
        });
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new AddPrinterLayout(compositePanel));
        this.getContentPane().add((Component)compositePanel, "Center");
        Dimension dim = parent.getSize();
        this.setLocation(parent.getLocation().x, parent.getLocation().y + dim.height);
    }

    void createObjects(int width) {
        this.prtNameLabel = new JLabel(this.getMessage("fontdownloadermainframe.printer_name:"), 4);
        this.commentLabel = new JLabel(this.getMessage("fontdownloadermainframe.comment:"), 4);
        this.prttypeLabel = new JLabel(this.getMessage("fontdownloadermainframe.tcp/ip_printer_type:"), 4);
        this.commentField = new PrinterNameTextField(this.parent, width - 160, false);
        this.prtName = new PrinterNameTextField(this.parent, width - 160, true);
        this.commentField.setBackground(Color.white);
        this.prtName.setBackground(Color.white);
        this.prtName.actionKeys(this.cancelButton, this.addButton);
        this.commentField.actionKeys(this.cancelButton, this.addButton);
        this.prttypeSel = new JComboBox();
        this.prttypeSel.addItem("Generic (Port 9100)");
        this.prttypeSel.addItem("Xerox 4900");
        this.prttypeSel.addItem("Xerox 4915");
        this.prttypeSel.addItem("Xerox 4920");
        this.prttypeSel.addItem("Xerox 4925");
    }

    public void show() {
        this.prtName.setText("");
        this.commentField.setText("");
        super.show();
    }

    void addActions() {
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<String> newPrinter = new Vector<String>();
                String printerName = AddPrinterListDialog.this.prtName.getText().trim();
                String prttype = (String)AddPrinterListDialog.this.prttypeSel.getSelectedItem();
                if (printerName.length() == 0) {
                    JOptionPane.showMessageDialog(AddPrinterListDialog.this.parent, AddPrinterListDialog.this.getMessage("fontdownloadermainframe.no_printer_name_specified"), "Error", 0);
                    return;
                }
                String comments = AddPrinterListDialog.this.commentField.getText().trim();
                int numRows = AddPrinterListDialog.this.prtList.prtTable.getRowCount();
                if (numRows > 0) {
                    int i = 0;
                    while (i < numRows) {
                        String currentname = (String)AddPrinterListDialog.this.prtList.prtTable.getValueAt(i, 0);
                        if (currentname.equals(printerName)) {
                            JOptionPane.showMessageDialog(null, AddPrinterListDialog.this.getMessage("fontdownloadermainframe.printer_name_already_exists_dot__please_change_the_printer_name"), "Error", 0);
                            return;
                        }
                        ++i;
                    }
                }
                MessageFormat formatter = new MessageFormat("");
                Object[] obj = new Object[]{printerName};
                InetAddress ipaddr = null;
                String errstr = MessageFormat.format(AddPrinterListDialog.this.getMessage("fontdownloadermainframe.ip_address_of_the_printer"), obj);
                try {
                    ipaddr = InetAddress.getByName(printerName);
                }
                catch (UnknownHostException exp) {
                    JOptionPane.showMessageDialog(AddPrinterListDialog.this.parent, errstr, "Error", 0);
                    AddPrinterListDialog.this.prtName.selectAll();
                    return;
                }
                newPrinter.addElement(printerName);
                newPrinter.addElement(prttype);
                newPrinter.addElement(comments);
                SortableTable model = (SortableTable)AddPrinterListDialog.this.prtList.prtTable.getModel();
                model.addRow(newPrinter);
                Vector unsorted = model.getUnsortedDataVector();
                if (unsorted == null) {
                    unsorted = new Vector();
                }
                unsorted.addElement(newPrinter);
                model.setUnsortedDataVector(unsorted);
                DefaultListSelectionModel rowSelector = (DefaultListSelectionModel)AddPrinterListDialog.this.prtList.prtTable.getSelectionModel();
                numRows = AddPrinterListDialog.this.prtList.prtTable.getRowCount() - 1;
                rowSelector.setSelectionInterval(numRows, numRows);
                Rectangle visRect = AddPrinterListDialog.this.prtList.prtTable.getCellRect(numRows, 0, true);
                AddPrinterListDialog.this.prtList.prtTable.scrollRectToVisible(visRect);
                AddPrinterListDialog.this.thisDialog.setVisible(false);
                KeyEvent keyevt = new KeyEvent(AddPrinterListDialog.this.prtList.prtTable, 401, 0L, 0, 35);
                AddPrinterListDialog.this.prtList.prtTable.dispatchEvent(keyevt);
                keyevt = new KeyEvent(AddPrinterListDialog.this.prtList.prtTable, 402, 0L, 0, 35);
                AddPrinterListDialog.this.prtList.prtTable.dispatchEvent(keyevt);
                JMenuBar mb = AddPrinterListDialog.this.parent.getFMenuBar();
                JMenu prtMenu = mb.getMenu(2);
                JMenuItem delMenuItem = prtMenu.getItem(1);
                delMenuItem.setEnabled(true);
                JMenuItem propMenuItem = prtMenu.getItem(5);
                propMenuItem.setEnabled(true);
                JMenuItem restartMenuItem = prtMenu.getItem(3);
                restartMenuItem.setEnabled(true);
                JMenu dlMenu = mb.getMenu(0);
                JMenuItem font = dlMenu.getItem(0);
                font.setEnabled(true);
                JMenuItem fontbundle = dlMenu.getItem(1);
                fontbundle.setEnabled(true);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddPrinterListDialog.this.thisDialog.setVisible(false);
            }
        });
        this.prtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
            }

            public void keyReleased(KeyEvent evt) {
            }
        });
        this.commentField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
            }

            public void keyReleased(KeyEvent evt) {
            }
        });
    }

    public class AddPrinterLayout
    implements LayoutManager {
        JPanel panel;
        int panelWidth;
        int panelHeight;

        public AddPrinterLayout(Container c) {
            this.panel = (JPanel)c;
            this.panel.add(AddPrinterListDialog.this.prtName);
            this.panel.add(AddPrinterListDialog.this.commentField);
            this.panel.add(AddPrinterListDialog.this.prttypeSel);
            this.panel.add(AddPrinterListDialog.this.prtNameLabel);
            this.panel.add(AddPrinterListDialog.this.commentLabel);
            this.panel.add(AddPrinterListDialog.this.prttypeLabel);
            this.panel.add(AddPrinterListDialog.this.addButton);
            this.panel.add(AddPrinterListDialog.this.cancelButton);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 1;
            dim.height = 2;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.width = 1;
            dim.height = 2;
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension d = new Dimension();
            d = this.panel.getSize(d);
            this.panelWidth = d.width;
            this.panelHeight = d.height;
            int textfieldHeight = 25;
            int labelHeight = 25;
            int padding = 30;
            int buttonWidth = new Integer(AddPrinterListDialog.this.getMessage("dimensions.okcancelbuttonwidth"));
            int buttonHeight = new Integer(AddPrinterListDialog.this.getMessage("dimensions.okcancelbuttonheight"));
            int buttonX = this.panelWidth - padding - buttonWidth;
            AddPrinterListDialog.this.cancelButton.setBounds(buttonX, 180, buttonWidth, buttonHeight);
            buttonX = buttonX - padding - buttonWidth;
            AddPrinterListDialog.this.addButton.setBounds(buttonX, 180, buttonWidth, buttonHeight);
            AddPrinterListDialog.this.prtName.setBounds(150, 20, 357, textfieldHeight);
            AddPrinterListDialog.this.commentField.setBounds(150, 55, 357, textfieldHeight);
            AddPrinterListDialog.this.prttypeSel.setBounds(150, 90, 357, textfieldHeight);
            AddPrinterListDialog.this.prtNameLabel.setBounds(15, 20, 130, labelHeight);
            AddPrinterListDialog.this.commentLabel.setBounds(15, 55, 130, labelHeight);
            AddPrinterListDialog.this.prttypeLabel.setBounds(15, 90, 130, labelHeight);
        }
    }

    class PrinterNameTextField
    extends JTextField {
        JButton escapeButton;
        JButton addButton;
        FontDownloaderMainFrame parent;
        int textLen;
        boolean checkFlag;
        ResourceBundle bundle;

        public String getMessage(String key) {
            if (this.bundle == null) {
                try {
                    this.bundle = ResourceBundle.getBundle("ResourceStrings");
                }
                catch (MissingResourceException e) {
                    System.out.println("Could not load Resources");
                    System.exit(0);
                }
            }
            String value = "";
            try {
                value = (String)this.bundle.getObject(key);
            }
            catch (MissingResourceException e) {
                System.out.println("Could not find " + key);
            }
            return value;
        }

        public PrinterNameTextField(FontDownloaderMainFrame parent, int width, boolean checkFlag) {
            this.parent = parent;
            this.textLen = width;
            this.checkFlag = checkFlag;
        }

        public boolean setRequestFocusEnabled() {
            return true;
        }

        public boolean isFocusTranversable() {
            return true;
        }

        public void actionKeys(JButton escapeButton, JButton addButton) {
            this.escapeButton = escapeButton;
            this.addButton = addButton;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.textLen, super.getPreferredSize().height);
        }

        public void processKeyEvent(KeyEvent e) {
            if (this.escapeButton != null && e.getKeyCode() == 27) {
                this.escapeButton.doClick();
                return;
            }
            if (this.addButton != null && e.getKeyCode() == 65 && e.isAltDown()) {
                if (e.getID() == 401) {
                    this.addButton.doClick();
                }
                e.consume();
                return;
            }
            if (e.getKeyCode() == 67 && e.isAltDown()) {
                this.escapeButton.doClick();
                return;
            }
            if (e.isControlDown()) {
                if (e.getKeyCode() == 10 && e.getID() == 401) {
                    this.addButton.doClick();
                }
                e.consume();
                return;
            }
            String enteredText = this.getText().trim();
            if (enteredText.length() == 0) {
                super.processKeyEvent(e);
                return;
            }
            if (this.checkFlag) {
                String printername = enteredText;
                if (e.getKeyCode() == 10 && e.getID() == 402) {
                    if (e.getKeyCode() == 10) {
                        this.parent.addPrinterListener.addPrinter.commentField.requestFocus();
                    }
                    return;
                }
            }
            super.processKeyEvent(e);
        }
    }
}

