#!/usr/bin/perl
# Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident  "@(#)upgrade_log_template.pl 1.1     03/06/06 SMI"

# This script reads 2 log_template files and merges
# the files, attempting to preserve the subscriptions
# in the first file, and using the second file as
# the latest and greatest.
#
# The merged file is written to standard output.

my $usage = "Usage:\n\n$0 existing_log_template_file  new_log_template_file";
die $usage if (scalar(@ARGV) != 2);

# we store category => [event_id] => [ subscribers ]
%orig_categories = ();
            
%orig = parseFile($ARGV[0]);

# Now determine the e-mail subscribers to each category
%category_subscribers = determine_cat_subscribers();

# Now we read in the second file, use the values from it,
# and if there are e-mail addresses from the old file, we
# append them to the new file. If an event is new, then we
# add only full category subscribers.

open(IN, $ARGV[1]) || die "Unable to open new file: $ARGV[1]: $!\n";
while(<IN>) {
    if (/^\s*#/ or $_ !~ /:/) {
        print;
        next;
    }
    chomp;
    my @F = split(/:/);
    if (exists $orig{$F[0]}) {
        print "$_", $orig{$F[0]}->[4], "\n"; #append addresses
    } else {
        print "$_";
        # now determine if there is a category subscriber
        my @cat = split(/\./, $F[0]);
        if (exists $category_subscribers{$cat[0]}) {
            print join(",", @{$category_subscribers{$cat[0]}});
        }
        print "\n";
    }
}

####################################################
# Subroutines
####################################################

# This subroute returns an Hash that looks like:
#    event_id => Array with the following indices
#                0 => event_id
#                 1 => friendly_name
#                 2 => number of arguments
#                 3 => message
#                 4 => string of subscribers for the event
#                 5 => Array of all subscribers
sub parseFile {
    my $file = $_[0];
    open(IN, $file) || die "Unable to open file: $file, $!\n\n$usage";
    my %data;
    while (<IN>) {
        next if /^\s*#/;
        next unless /:/;
        chomp;
        my @F = split(/:/);
        my @addrs = split(/[,;]/, $F[4]);
        $F[5] = \@addrs;

        $data{"$F[0]"} = \@F;

        grep(tr/A-Z/a-z/, @addrs); # make all lower case for comparisons
        my @category = split(/\./, $F[0]);
        $orig_categories{$category[0]}->[$category[1]] = \@addrs;
        
    }
    close (IN);
    return %data;
}


# Determine which e-mail addresses are subscribers to an entire
# category--not just some events
sub determine_cat_subscribers() {
    my %members;
    foreach $key (keys %orig_categories) {
        my %event_counter;
        $a_ref = $orig_categories{$key};
        foreach $event (@$a_ref) {
            foreach $sub (@$event) {
                $event_counter{$sub}++;
            }
        }

        $num_events = scalar(@$a_ref) - 1;
        foreach $addr (keys %event_counter) {
            push @{$members{$key}}, $addr 
                if ($event_counter{$addr} ==  $num_events);
        }

    }
    return %members;
}
