<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "%Z%%M%    %I%    %E%     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<!-- Place Java Script Here -->

<!-- HTML -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
    <title>
        <bean:message  key="storage.mgmt.volumes.title"/>
    </title>
</head>
<%@include file="/layout/bodytag.jsp"%>
<%@include file="/layout/top.jsp"%>
<%@include file="/layout/breadcrumb.jsp"%>
<%@include file="/layout/spacer.jsp"%>
<!-- override the selected sub item for the paging mechanism-->
<% selectedSubItem = "root.menu.item0.item4"; %>
<html:form action="root.menu.item0.item4.do">
<% try { %>
<!-- hidden element which specifies the action for this form -->
<input type="hidden" name="request_action" value="<%=request.getAttribute("request_action")%>">

<div class="content-layout">

  <%@ include file="/layout/user_messages.jsp"%>
  
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>


  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="storage.mgmt.system.expert.manage.volumes"/> 
              </div>
            </td>
            <td valign="bottom" width="99%">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr>
                  <td class="property-separator" valign="bottom"><img alt border="0" height="2" src="/images/general/dot.gif" width="1"></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
  </table>

<% boolean hasList = false; %>
<!-- show message if there are no volumes in the list --> 
<%
  List volList = (List)session.getAttribute(Constants.HttpSessionFields.VOLUME_LIST);
  if(volList != null && volList.size() > 0) {
    hasList = true;
  }
%>
<% if(!hasList) { %>
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td>
      <bean:message key="storage.mgmt.volumes.none"/>
    </td>
  </tr>
</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
<% } %>

  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td>
        <bean:message key="storage.mgmt.volumes.help"/>
      </td>
      </tr>
  <tr>
    <td><img alt border="0" height="5" width="1" src="images/general/dot.gif"></td>
  </tr>
      <tr>
      <td nowrap>
        <table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td align="left" valign="middle">
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                              <td align="center" valign="middle" nowrap>         
                                 <component:button text="button.create" href="javascript:createVolumeWizard();" title="button.create" isEnabled="<%=!readOnly%>" /> 
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>
                  <td>&nbsp;</td>
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                              <td align="center" valign="middle" nowrap>         
                                 <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item4voldelconfirm.do';document.forms[0].submit();" title="button.delete" isEnabled="<%=!readOnly && hasList%>" />
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>
                  <td>&nbsp;</td>               
                </tr>
              </table>
             </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="5" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
  

      <table>
          <% if(hasList) { %>
          <%@include file="/layout/prevnext.jsp"%>
          <% } %>
          <tr>
            <td nowrap>
              <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
                <tr>
                  <td>
                    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                      <tr class="header-row">
                        <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>                           
                        <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.volumes.name" />
                       </div>
                     </td>
                        <td nowrap >
                       <div class="table-header-text">
                          <bean:message key="report.volume.lun.label" />
                       </div>
                     </td>
                     <td nowrap >
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.volumes.capacity" />
                       </div>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.volumes.status" />
                       </div>
                     </td>
                                                                                         
                      </tr>
                      <!-- Begin Volume row listing -->
		         <logic:present name="VolumeList">
			  <%@include file="/layout/listingCalc.jsp"%>
			 <logic:iterate id="volume" indexId="index" name="VolumeList" type="StorageVolumeInterface"  offset='<%=offsetStr%>' length='<%=lengthStr%>'>
                      <tr>
                        <td align="center">
                          <div class="table-normal-text">
                            <input type="checkbox" name="id" value="<%=index%>" <% if(readOnly) {%>disabled <% } %>>
                          </div>
                        </td>
                        <td align="left" nowrap>
                          <div class="table-normal-text">
                            <html:link href="root.menu.item0.item4edit.do"
              	 		          paramId="index" paramName="index"
              	 		          ><bean:write name="volume" property="name"/></html:link>
                          </div>
                        </td>
                        <td align="right" nowrap>
                          <div class="table-normal-text">
                            <% int lunNo = volume.getLUN();
                               if(lunNo == -1) {
                            %>
                                <bean:message key="storage.mgmt.volumes.no.lun.value"/>
                            <% }else { %>
                                <%=lunNo%>
                            <% } %>
                          </div>

                        </td>
                        <td align="right" nowrap>
                          <div class="table-normal-text">
                             <component:volumeSizeDisplay size="<%=volume.getSize().toString()%>"/>
                          </div>
                        </td>
                        <td align="left" nowrap>
                          <div class="table-normal-text">
                            <bean:message key='<%="storage.mgmt.volumes.status." + volume.getStatus()%>' />
                          </div>

                        </td>
                      </tr>
                     </logic:iterate>
                     </logic:present>                                   
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
  <tr>
    <td colspan="5"><img alt border="0" height="1" width="300" src="images/general/dot.gif"></td>
  </tr>
          <% if(hasList) { %>
          <%@include file="/layout/prevnext.jsp"%>
          <% } %>
        </table>
      
</div>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>



<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
<% } catch (Exception e) {Trace.verbose(this, "JSP Page", e);} %>
</html:form>


</body>
</div>
</html:html>

