<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "%Z%%M%    %I%    %E%     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<!-- Place Java Script Here -->

<!-- HTML -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
    <title>
        <bean:message  key="storage.mgmt.system.expert.pools"/>
    </title>
</head>

<%@include file="/layout/bodytag.jsp"%>
<%@include file="/layout/top.jsp"%>
<%@include file="/layout/breadcrumb.jsp"%>
<%@include file="/layout/spacer.jsp"%>

<html:form action="root.menu.item0.item2pools.do">

<!-- hidden element which specifies the action for this form -->
<input type="hidden" name="request_action" value="<%=request.getAttribute("request_action")%>">

<div class="content-layout">
  
  <%@ include file="/layout/user_messages.jsp"%>
  
<%
  boolean hasList = false;
  com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm form = 
    (com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm)session.getAttribute("Pool");
  if(form != null) {
  	 if(form.getPoolsList() != null) {
  	     if(form.getPoolsList().size() > 0) {
		     hasList = true;
  	     } else {
  	         hasList = false;
  	         form.setPoolsList(null);
  	     }
  	 }
  }
%>
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <%
                  T4Interface array = (T4Interface)session.getAttribute(Constants.HttpSessionFields.CURRENT_T4);
                  String name = "";
                  if(array != null){
                  	name = array.getName();
                  }
                %>
                <bean:message key="storage.mgmt.system.expert.pools.header" arg0="<%=name%>"/>                 
              </div>
            </td>
            
            <td valign="bottom" width="99%">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr>
                  <td class="property-separator" valign="bottom"><img alt border="0" height="2" src="/images/general/dot.gif" width="1"></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
    <tr>
     <logic:present name="Pool" property="poolsList">
      <td>
        <bean:message key="storage.mgmt.system.expert.pools.instructions"/>
      </td>
     </logic:present>
     <logic:notPresent name="Pool" property="poolsList">
     <td>
        <bean:message key="storage.mgmt.system.expert.pools.nopools"/>
     </td>       
     </logic:notPresent>
    </tr>
     <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
  </table>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>

    <td align="left" valign="middle">
      <table border="0" cellpadding="0" cellspacing="0">
         <tr>
            <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="button.create" href="javascript:createPoolWizard();" title="button.create" isEnabled="<%=!readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>   
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>              
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <% if(!hasList) { %>
                                <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item2poolsdelete.do';document.forms[0].submit();" title="button.delete" isEnabled="<%=hasList%>" />
                              <% } else { %>
                                <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item2poolsdelete.do';document.forms[0].submit();" title="button.delete" isEnabled="<%=!readOnly%>" />
                              <% } %>
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>   
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <% if(!hasList) { %>
                                <component:button text="storage.mgmt.system.expert.pools.online.button" href="javascript:submitForm('online');" title="storage.mgmt.system.expert.pools.online.button" isEnabled="<%=hasList%>" />
                              <% } else { %>
                                <component:button text="storage.mgmt.system.expert.pools.online.button" href="javascript:submitForm('online');" title="storage.mgmt.system.expert.pools.online.button" isEnabled="<%=!readOnly%>" />
                              <% } %>
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                             <% if(!hasList) { %>                               
                               <component:button text="storage.mgmt.system.expert.pools.offline.button" href="javascript:document.forms[0].action='root.menu.item0.item2poolsoffline.do';document.forms[0].submit();" title="storage.mgmt.system.expert.pools.offline.button" isEnabled="<%=hasList%>" />
                             <% } else { %> 
                              <component:button text="storage.mgmt.system.expert.pools.offline.button" href="javascript:document.forms[0].action='root.menu.item0.item2poolsoffline.do';document.forms[0].submit();" title="storage.mgmt.system.expert.pools.offline.button" isEnabled="<%=!readOnly%>" />
                             <% } %>
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="storage.mgmt.system.expert.pools.initialize.button" href="javascript:document.forms[0].action='root.menu.item0.item2poolsinit.do';document.forms[0].submit();" title="storage.mgmt.system.expert.pools.initialize.button" isEnabled="<%=hasList && !readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>                        
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="storage.mgmt.system.expert.pools.refresh.button" href="javascript:submitForm('show');" title="storage.mgmt.system.expert.pools.refresh.button" isEnabled="true" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>                        
           </tr>
       </table>
   </td>
 
    
   
    
 </tr>
 <tr>
   <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
 </tr>
</table>


<logic:present name="Pool" property="poolsList">
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>                  
              <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
                <tr>
                  <td>
                    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                      <tr class="header-row">                        
                        <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.name"/>
                          </div>
                        </td>                                                
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.raid"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.available"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.total"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.hotspare"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.status"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.volumes"/>
                          </div>
                        </td>                        
                      </tr>
                      <!-- begin data row listing -->
                      
                         <logic:iterate id="pool" name="Pool" property="poolsList" type="RaidGroupInterface" indexId="idx">
                           <tr>
                             <td>
                                <div class="table-normal-text">
                                   <input type="checkbox" name="<%="pools" + idx %>" value="<%= idx%>" <% if(readOnly) { %> disabled <%}%>/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <bean:write name="pool" property="name"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <bean:write name="pool" property="raidLevel"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%=nf.format(nf.parse(Convert.bytesToGB(pool.getAvailableCapacity())))%>  
                                  <bean:message key="size.GB"/>                               
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%=nf.format(nf.parse(Convert.bytesToGB(pool.getTotalCapacity())))%> 
                                  <bean:message key="size.GB"/>                                                                 
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <bean:write name="pool" property="useHotSpare"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%
                                    String status = "storage.mgmt.pool.status." + pool.getStatus();                                   
                                  %>
                                  <bean:message key="<%=status%>"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%
                                     List volumes = pool.getVolumes();
                                     if(volumes != null && volumes.size() > 0) {                                     	
                                  %>
                                  <a href="root.menu.item0.item2poolsvolumes.do?poolName=<%=pool.getName()%>">
                                    <bean:message key="storage.mgmt.system.expert.pools.show"/>
                                  </html:link>
                                  <% } 
                                     else {
                                  %>
                                     <bean:message key="raid.group.table.data.novolumes"/>
                                  <% } %>
                                </div>
                             </td>
                           </tr>
                         </logic:iterate>
                                                   
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</logic:present>  

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>



</div>
</html:form>



</body>
</html:html> 
