/**
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 * 
 * "%Z%%M%		%I%		%E%		SMI"
 *
 */

/**
 * Common JavaScript functions
 */


/**
 * Function to check all checkboxes on a page
 */
function checkAll(pageForm) {
	for (var i=0; i<pageForm.elements.length; ++i)
		if (pageForm.elements[i].type == "checkbox")
			pageForm.elements[i].checked=true;
}

		
function unCheckAll(pageForm) {
	for (var i=0; i<pageForm.elements.length; ++i)
		if (pageForm.elements[i].type == "checkbox")
			pageForm.elements[i].checked=false;
}

/**
 * Function to submit the first form on a page.
 *
 * @param action If specified, the action parameter of the form will be set
 *               to this value (there must already be a hidden form element
 *               in the form named action.
 * @param confirmText String to display in a confirm dialog before submitting
 *                the form.  If the user presses cancel on the submit dialog,
 *                the form will not be submitted.
 * @param optionalParams Specify any number of additional name=value pairs
 *                       as arguments to the function call.
 * e.g. ( submitForm("save", "myfield1=val1", "myfield2=val2"...);
 * (NOTE: optional params is not yet implemented
 */
 var formSubmitted = 0;
function submitForm(action, confirmText, optonalParams) {
	var actionField;
	if (typeof document.forms[0].request_action != "undefined")
		actionField = document.forms[0].request_action;
	else
		actionField = document.forms[0].action;

	if (typeof confirmText == "string") {
		if (confirm(confirmText)) {
			actionField.value = action;
			document.forms[0].submit();
		}
	}
	// No confirm text passed, just submit the form.
	else {
		actionField.value = action;
		if(formSubmitted == 0) {
			document.forms[0].submit();
			formSubmitted = 1;
		} else {
		    alert(formSubmittedTwiceMsg);
		}
	}
}

NS4 = (document.layers) ? true : false;

function checkEnter(event, action)
{ 	
	var code = 0;
	if (NS4){
		code = event.which;
		}
	else {
		code = event.keyCode;
		}
	if (code==13){
		submitForm(action);
	}
	return 0;
}


function setReadOnly(object, isReadOnly) {
	if (isReadOnly)
		object.blur();
}

/**
 * Function to open a small external window for displaying simple text
 * @param text Text to display in the external window
 */
function openTextDialog(text) {
	var detailWindow = window.open("layout/text_dialog.jsp?text="+text, "textDialog", "HEIGHT=40,WIDTH=450");
	detailWindow.focus();
	return false;
}

// Wizard helper functions

var wizard;			// This variable holds a reference to the wizard window

function openWizard(contentAction, windowName, title, TOCTitles, UIScheme, redrawParent, activePage) {

	// Create url string to use
	urlString = "WizardFramework.do?";
	urlString += "page=wizardFrame";
	urlString += "&contentAction="+contentAction;
	urlString += "&wizardTitle="+title;
	urlString += "&redrawParent="+redrawParent;
	urlString += "&activePage="+activePage;
	urlString += "&totalPages="+TOCTitles.length;
	
	for (var i=0; i<TOCTitles.length; ++i) {
		urlString += "&tocTitles="+TOCTitles[i];
	}

    wizard = window.open(urlString, windowName,'scrollbars,resizable,width=850,height=500');
    wizard.focus();
}

function createVolumeWizard() {

	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.volumes.createwizard.toc.1",
					 		   "storage.mgmt.volumes.createwizard.toc.2",
					 		   "storage.mgmt.volumes.createwizard.toc.3",
					 		   "storage.mgmt.volumes.createwizard.toc.4");

	openWizard('VolumeCreateWizard', 'VolumeWizard', 'storage.mgmt.volumes.createvolume', TOCTitles, null, false, 0);
}

function cloneT4Wizard() {
   
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("main.menu.clone.t4.wizard.toc.1",
					 		   "main.menu.clone.t4.wizard.toc.2",
					 		   "main.menu.clone.t4.wizard.toc.3");

	openWizard('CloneT4Wizard', 'CloneWizard', 'main.menu.clone.t4.wizard.title', TOCTitles, null, false, 0);
}

function quarantineWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.quarantine.wizard.toc.1",
					 		   "storage.mgmt.system.quarantine.wizard.toc.2");

	openWizard('QuarantineWizard', 'QuarantineWizard', 'storage.mgmt.system.quarantine.wizard.title', TOCTitles, null, false, 0);
}

function changeProfileWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.chgprofile.wizard.toc.1",
					 		   "storage.mgmt.system.profile.wizard.toc.2",
					 		   "storage.mgmt.system.profile.wizard.toc.3",
					 		   "storage.mgmt.system.profile.wizard.toc.4");

	openWizard('ChangeProfileWizard', 'ChangeProfileWizard', 'storage.mgmt.system.chgprofile.wizard.title', TOCTitles, null, false, 0);
}

function addProfileWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.profile.wizard.toc.2",
					 		   "storage.mgmt.system.profile.wizard.toc.3"
					 		   );

	openWizard('AddProfileWizard', 'AddProfileWizard', 'storage.mgmt.system.addprofile.wizard.title', TOCTitles, null, false, 0);
}

function traySettingWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.expert.tray.setting.wizard.toc.1",
					 		   "storage.mgmt.system.expert.tray.setting.wizard.toc.9"
					 		   );

	openWizard('TraySettingWizard', 'TraySettingWizard', 'storage.mgmt.system.expert.tray.setting.wizard.title', TOCTitles, null, false, 0);
}

function createPoolWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.pools.createwizard.toc.1",
					 		   "storage.mgmt.pools.createwizard.toc.6"
					 		   );

	openWizard('CreatePoolWizard', 'CreatePoolWizard', 'storage.mgmt.pools.createwizard.title', TOCTitles, null, false, 0);
}

function cloneTrayWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("clone.tray.wizard.toc.1",
                               "clone.tray.wizard.toc.2", 
                               "clone.tray.wizard.toc.3",
                               "clone.tray.wizard.toc.4"
					 		   );

	openWizard('CloneTrayWizard', 'CloneTrayWizard', 'clone.tray.wizard.title', TOCTitles, null, false, 0);
}

function createVolumeGroupWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("create.volume.group.wizard.toc.1",
                               "create.volume.group.wizard.toc.2", 
                               "create.volume.group.wizard.toc.3"
					 		   );

	openWizard('CreateVolumeGroupWizard', 'CreateVolumeGroupWizard', 'create.volume.group.wizard.title', TOCTitles, null, false, 0);
}

function addExpansionWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("add.expansion.wizard.toc.1",
                               "add.expansion.wizard.toc.2", 
                               "add.expansion.wizard.toc.3", 
                               "add.expansion.wizard.toc.4" 
					 		   );

	openWizard('AddExpansionWizard', 'AddExpansionWizard', 'add.expansion.wizard.title', TOCTitles, null, false, 0);
}

function removeExpansionWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("remove.expansion.wizard.toc.1",
                               "remove.expansion.wizard.toc.2", 
                               "remove.expansion.wizard.toc.3", 
                               "remove.expansion.wizard.toc.4", 
                               "remove.expansion.wizard.toc.5" 
					 		   );

	openWizard('RemoveExpansionWizard', 'RemoveExpansionWizard', 'remove.expansion.wizard.title', TOCTitles, null, false, 0);
}

