/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.tools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMClient;
import javax.wbem.client.LocalPasswordCredential;
import javax.wbem.client.LocalUserPrincipal;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class VmConfig {
    private static int SUCCESS = 0;
    private static int ERR_GENERAL_FAILURE = 1;
    private static int ERR_INVALID_CMD = 2;
    private static int ERR_INVALID_TYPE = 3;
    private static int ERR_INVALID_CREDENTIALS = 4;
    private static int ERR_INVALID_STATUS = 5;
    private static int ERR_UNKNOWN_HOST = 6;
    private static int ERR_CIM_GENERAL_FAILURE = 7;
    private static int ERR_CIM_NETWORK = 8;
    private static int ERR_NO_CIMOM = 9;
    private static String OK = "2";
    private static String WARNING = "3";
    private static String ERROR = "6";
    private static String DOWN = "13";
    private static String UNKNOWN = "0";
    private static int IN_SERVICE = 11;
    private static int DORMANT = 15;
    private static HashMap stateMap = new HashMap();
    static final int _MANAGED_OPER = 0;
    static final int _MANAGED_DEVICE = 1;
    static final int _MANAGED_RACK_STATE = 1;
    static final int _MANAGED_NAME = 2;
    static final int _MANAGED_PASSWORD = 3;
    String ourNamespace = "//root//se6x20";
    CIMClient cc = null;
    CIMObjectPath cop = null;
    CIMNameSpace cns = new CIMNameSpace();
    UserPrincipal up = new LocalUserPrincipal();
    PasswordCredential pc = new LocalPasswordCredential();

    public static void main(String[] args) {
        VmConfig config = new VmConfig(args);
        System.exit(SUCCESS);
    }

    public VmConfig(String[] args) {
        boolean errorCode = true;
        String ipAddr = null;
        try {
            this.cns.setNameSpace(this.ourNamespace);
            this.cc = new CIMClient(this.cns, (Principal)this.up, (Object)this.pc);
            String currCmd = args[0];
            if (currCmd.equalsIgnoreCase("rack")) {
                this.setSPStatus(args);
                return;
            }
            ipAddr = InetAddress.getByName(args[2]).getHostAddress();
            this.validateCIMConnection(args);
            if (currCmd.equalsIgnoreCase("configure")) {
                this.doConfigure(args, ipAddr);
            } else if (currCmd.equalsIgnoreCase("unconfigure")) {
                this.doUnconfigure(args, ipAddr);
            } else if (currCmd.equalsIgnoreCase("online")) {
                this.doOnline(args, ipAddr);
            } else if (currCmd.equalsIgnoreCase("offline")) {
                this.doOffline(args, ipAddr);
            } else {
                System.exit(ERR_INVALID_CMD);
            }
        }
        catch (UnknownHostException ex) {
            System.exit(ERR_UNKNOWN_HOST);
        }
        catch (CIMException ex) {
            String msg = ex.getMessage();
            int exitCode = ERR_CIM_GENERAL_FAILURE;
            if (msg.equalsIgnoreCase("CIMSecurityException.INVALID_CREDENTIAL")) {
                exitCode = ERR_INVALID_CREDENTIALS;
            }
            if (msg.equalsIgnoreCase("CIMTransportException.NO_CIMOM")) {
                exitCode = ERR_NO_CIMOM;
            }
            System.exit(exitCode);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            int exitCode = ERR_GENERAL_FAILURE;
            if (msg.equalsIgnoreCase("ERR_NO_CLUSTERS_FOUND") || msg.equalsIgnoreCase("ERR_CLUSTER_NOT_FOUND") || msg.equalsIgnoreCase("ERR_ACCOUNT_CLASS_NOT_FOUND") || msg.equalsIgnoreCase("ERR_NEW_INSTANCE_FAILED") || msg.equalsIgnoreCase("ERR_CREATE_INSTANCE_FAILED") || msg.equalsIgnoreCase("ERR_ACCOUNT_INSTANCE_NOT_FOUND")) {
                exitCode = ERR_CIM_GENERAL_FAILURE;
            } else if (msg.equalsIgnoreCase("ERR_INVALID_TYPE")) {
                exitCode = ERR_INVALID_TYPE;
            } else if (msg.equalsIgnoreCase("ERR_BAD_STATUS_VALUE")) {
                exitCode = ERR_INVALID_STATUS;
            }
            System.exit(exitCode);
        }
    }

    protected void validateCIMConnection(String[] args) throws CIMException {
        this.cc = new CIMClient(this.cns, (Principal)this.up, (Object)this.pc, "cim-rmi");
        this.cop = new CIMObjectPath("StorEdge_6120Cluster");
    }

    private void doOffline(String[] args, String ipAddr) throws CIMException, Exception {
        if (!args[1].equalsIgnoreCase("t4")) {
            throw new Exception("ERR_INVALID_TYPE");
        }
        Enumeration clusts = null;
        this.cop = new CIMObjectPath("StorEdge_6120Cluster");
        clusts = this.cc.enumerateInstances(this.cop, true, false, true, false, null);
        if (clusts == null) {
            throw new Exception("ERR_NO_CLUSTERS_FOUND");
        }
        CIMInstance clust = null;
        while (clusts.hasMoreElements()) {
            CIMInstance inst = (CIMInstance)clusts.nextElement();
            String name = (String)inst.getProperty("Name").getValue().getValue();
            if (!name.equalsIgnoreCase(ipAddr)) continue;
            clust = inst;
            break;
        }
        if (clust == null) {
            throw new Exception("ERR_CLUSTER_NOT_FOUND");
        }
        Vector<UnsignedInt16> v = new Vector<UnsignedInt16>();
        v.add(new UnsignedInt16(IN_SERVICE));
        clust.setProperty("OperationalStatus", new CIMValue(v));
        this.cc.setInstance(this.cop, clust, false, null);
    }

    private void doOnline(String[] args, String ipAddr) throws CIMException, Exception {
        if (!args[1].equalsIgnoreCase("t4")) {
            throw new Exception("ERR_INVALID_TYPE");
        }
        Enumeration clusts = null;
        this.cop = new CIMObjectPath("StorEdge_6120Cluster");
        clusts = this.cc.enumerateInstances(this.cop, true, false, true, false, null);
        if (clusts == null) {
            throw new Exception("ERR_NO_CLUSTERS_FOUND");
        }
        CIMInstance clust = null;
        while (clusts.hasMoreElements()) {
            CIMInstance inst = (CIMInstance)clusts.nextElement();
            String name = (String)inst.getProperty("Name").getValue().getValue();
            if (!name.equalsIgnoreCase(ipAddr)) continue;
            clust = inst;
            break;
        }
        if (clust == null) {
            throw new Exception("ERR_CLUSTER_NOT_FOUND");
        }
        Vector<UnsignedInt16> v = new Vector<UnsignedInt16>();
        v.add(new UnsignedInt16(OK));
        clust.setProperty("OperationalStatus", new CIMValue(v));
        this.cc.setInstance(this.cop, clust, false, null);
    }

    private void doConfigure(String[] args, String ipAddr) throws CIMException, Exception {
        boolean persist = true;
        String password = args[3];
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Account");
        CIMClass proto = this.cc.getClass(cop, false, true, false, null);
        if (proto == null) {
            throw new CIMException("ERR_ACCOUNT_CLASS_NOT_FOUND");
        }
        CIMInstance aci = proto.newInstance();
        if (aci == null) {
            throw new CIMException("ERR_NEW_INSTANCE_FAILED");
        }
        aci.setProperty("Name", new CIMValue((Object)ipAddr));
        aci.setProperty("PersistPassword", new CIMValue((Object)new Boolean(persist)));
        aci.setProperty("UserID", new CIMValue((Object)"root"));
        Vector<String> passwd = new Vector<String>(1);
        passwd.add(password);
        aci.setProperty("UserPassword", new CIMValue(passwd));
        CIMObjectPath results = this.cc.createInstance(cop, aci);
        if (results == null) {
            throw new Exception("ERR_CREATE_INSTANCE_FAILED");
        }
    }

    private void doUnconfigure(String[] args, String ipAddr) throws CIMException, Exception {
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Account");
        Enumeration accounts = this.cc.enumerateInstances(cop, true, false, true, false, null);
        CIMInstance account = null;
        while (accounts.hasMoreElements()) {
            CIMInstance tmp = (CIMInstance)accounts.nextElement();
            String name = (String)tmp.getProperty("Name").getValue().getValue();
            if (!name.equalsIgnoreCase(ipAddr)) continue;
            account = tmp;
            break;
        }
        if (account == null) {
            throw new CIMException("ERR_ACCOUNT_INSTANCE_NOT_FOUND");
        }
        this.cc.deleteInstance(account.getObjectPath());
    }

    protected void setSPStatus(String[] args) throws CIMException, Exception {
        String state = null;
        int cimState = -1;
        String[] propList = new String[1];
        String protocol = "cim-rmi";
        this.cc = new CIMClient(this.cns, (Principal)this.up, (Object)this.pc);
        this.cop = new CIMObjectPath("StorEdge_6x20PhysicalPackage");
        Enumeration enumeration = this.cc.enumerateInstances(this.cop, true, false, true, false, null);
        CIMInstance spInst = (CIMInstance)enumeration.nextElement();
        state = args[1].toUpperCase();
        if (!(state.equals("OK") || state.equals("WARNING") || state.equals("ERROR") || state.equals("DOWN"))) {
            throw new Exception("ERR_BAD_STATUS_VALUE");
        }
        cimState = Integer.parseInt((String)stateMap.get(state));
        Vector<UnsignedInt16> opVect = new Vector<UnsignedInt16>();
        opVect.add(new UnsignedInt16(cimState));
        spInst.setProperty("OperationalStatus", new CIMValue(opVect));
        String[] props = new String[]{"OperationalStatus"};
        this.cc.setInstance(this.cop, spInst, false, props);
        if (this.cc != null) {
            this.cc.close();
        }
    }

    static {
        stateMap.put("OK", OK);
        stateMap.put("WARNING", WARNING);
        stateMap.put("ERROR", ERROR);
        stateMap.put("DOWN", DOWN);
        stateMap.put("UNKNOWN", UNKNOWN);
        _MANAGED_OPER = 0;
        _MANAGED_DEVICE = 1;
        _MANAGED_RACK_STATE = 1;
        _MANAGED_NAME = 2;
        _MANAGED_PASSWORD = 3;
    }
}

