/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.client;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.netstorage.array.mgmt.cfg.cli.client.CLIProxy;
import com.sun.netstorage.array.mgmt.cfg.cli.client.Encoder;
import com.sun.netstorage.array.mgmt.cfg.cli.client.ProxyServer;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;

public class ProxyServerThread
extends Thread {
    public static final int DEFAULT_RETRIES = 10;
    public static final String SUCCESS_CODE = "0";
    public static final String ERROR_CODE = "100";
    public static final String LOGIN_NAME = "777";
    public static final String LOGIN_CODE = "888";
    public static final String MODIFY_PASSWORD_CODE = "999";
    private static final String SOAP_SECURE_PROTOCOL = "https";
    private static final String SOAP_OPEN_PROTOCOL = "http";
    private static final String SOAP_SECURE_PORT = "9443";
    private static final String SOAP_OPEN_PORT = "9080";
    private String soapProtocol = "https";
    private String soapPort = "9443";
    private Call callObject = null;
    private byte[] token;
    private int serverPort;
    private Date lastConnection = new Date();
    private boolean stop = false;
    private boolean shutDown = false;
    private boolean isSecure = true;
    private CLIProxy cli = null;
    private String soapServer = "localhost";
    private boolean userLoggedIn = false;
    private static ResourceBundle resource;

    public ProxyServerThread(byte[] token, int port) {
        Trace.constructor(this);
        this.token = token;
        this.serverPort = port;
        Trace.verbose((Object)this, "constructor", "token is " + new String(token));
        Trace.verbose((Object)this, "constructor", "port is " + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String METHOD_NAME = "run";
        String request = "";
        Trace.methodBegin(this, "run");
        try {
            this.setupKeystore();
            ServerSocket server = new ServerSocket(this.getServerPort());
            ProxyServer.setConnected(true);
            this.callObject = new Call();
            while (!this.shutDown) {
                Object var10_13;
                Socket client = null;
                DataInputStream in = null;
                DataOutputStream out = null;
                CommandResult cr = new CommandResult();
                try {
                    block12: {
                        try {
                            Trace.verbose((Object)this, "run", "Waiting for connection");
                            client = server.accept();
                            out = new DataOutputStream(client.getOutputStream());
                            if (this.isLocal(client)) {
                                ProxyServer.setLastConnection(new Date());
                                Trace.verbose((Object)this, "run", "Client connected.");
                                in = new DataInputStream(client.getInputStream());
                                try {
                                    cr = this.processRequest(in, out);
                                }
                                catch (Exception cle) {
                                    cr.setErrorId(ERROR_CODE);
                                    cr.setResult(resource.getString("error.general.systemError"));
                                }
                                if (this.shutDown) {
                                    Trace.verbose((Object)this, "run", "SHUTTING DOWN");
                                }
                                this.fixNewLine(cr);
                                Trace.verbose((Object)this, "run", " return info is:\n  " + cr.getResult());
                                this.writeOutput(cr.getErrorId(), out, this.token);
                                this.writeOutput(cr.getResult(), out, this.token);
                                break block12;
                            }
                            this.remoteConnect(client, out, cr);
                        }
                        catch (IOException ioe) {
                            this.processIOEx(ioe);
                            var10_13 = null;
                            this.closeSockets(client, in, out);
                        }
                    }
                    var10_13 = null;
                    this.closeSockets(client, in, out);
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    this.closeSockets(client, in, out);
                    throw throwable;
                }
                Trace.verbose((Object)this, "run", " Shutdown value is " + this.shutDown);
            }
            ProxyServer.setStop(true);
        }
        catch (BindException mre) {
            Trace.verbose((Object)this, "run", " Couldn't bind to selected port " + this.getServerPort());
            ProxyServer.setStop(true);
        }
        catch (IOException ioe) {
            Trace.verbose((Object)this, "Problem starting server", (Throwable)ioe);
        }
        Trace.verbose((Object)this, "run", "Method end.");
    }

    private void setupKeystore() {
        String keyStore = System.getProperty("KEYSTORE");
        if (null != keyStore) {
            Trace.verbose((Object)this, "setupKeystore", "Using Keystore (" + keyStore + ")");
            System.setProperty("javax.net.ssl.trustStore", keyStore);
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
        } else {
            Trace.verbose((Object)this, "setupKeystore", "Keystore not specified");
        }
    }

    public void closeSockets(Socket client, DataInputStream in, DataOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void processIOEx(IOException ioe) {
        if (ioe instanceof InterruptedIOException) {
            Trace.verbose((Object)this, "processIOEx", "server timed out on the port" + this.getServerPort());
            this.shutDown = true;
        } else {
            Trace.verbose((Object)this, "processIOEx", "Problem with accepting connection from client.");
        }
    }

    public void remoteConnect(Socket client, DataOutputStream out, CommandResult cr) throws IOException {
        Trace.verbose((Object)this, "remoteConnect", "Attempted Connection From Non Local Host" + client.getInetAddress().getAddress());
        cr.setErrorId(ERROR_CODE);
        cr.setResult(resource.getString("error.remote.proxy.connection") + client.getInetAddress().getAddress());
        this.writeOutput(cr.getErrorId(), out, this.token);
        this.writeOutput(cr.getResult(), out, this.token);
    }

    private CommandResult processRequest(DataInputStream in, DataOutputStream out) throws Exception, IOException {
        CommandResult cr = new CommandResult();
        String request = this.readInput(in, this.token);
        if (request != null) {
            try {
                if (request.indexOf("login") >= 0) {
                    cr = this.login(request, in, out);
                } else if (this.userLoggedIn && "logout".equals(request.trim())) {
                    cr = this.logout(request, in, out);
                } else if (this.userLoggedIn) {
                    cr = this.processCommand(request, in, out);
                } else {
                    cr.setResult(resource.getString("login.notLoggedIn"));
                    cr.setErrorId(ERROR_CODE);
                }
            }
            catch (Exception e) {
                cr.setResult(resource.getString("error.systemError"));
                cr.setErrorId(ERROR_CODE);
            }
        }
        return cr;
    }

    private CommandResult login(String request, DataInputStream in, DataOutputStream out) throws Exception {
        CommandResult result = null;
        StringTokenizer tokenizer = new StringTokenizer(request, "\n");
        boolean dashHOptionFound = false;
        boolean dashHOptionArgumentFound = false;
        while (tokenizer.hasMoreTokens()) {
            String arg = tokenizer.nextToken();
            if (!arg.equals("-h") && !arg.equals("--hostname")) continue;
            dashHOptionFound = true;
            if (!tokenizer.hasMoreTokens()) continue;
            this.soapServer = tokenizer.nextToken();
            dashHOptionArgumentFound = true;
            break;
        }
        if (!dashHOptionFound || !dashHOptionArgumentFound) {
            result = new CommandResult();
            result.setErrorId(ERROR_CODE);
            result.setResult(resource.getString("login.usage"));
            return result;
        }
        this.chooseOpenOrSecurePort(request);
        this.reInitSession();
        result = this.processCommand(request, in, out);
        this.userLoggedIn = SUCCESS_CODE.equals(result.getErrorId());
        return result;
    }

    private void chooseOpenOrSecurePort(String request) {
        this.isSecure = true;
        if (request.indexOf("-t") >= 0 || request.indexOf("--http") >= 0) {
            this.isSecure = false;
        }
    }

    private void reInitSession() throws Exception {
        if (this.cli != null) {
            try {
                this.cli.processCommand("logout");
                this.callObject = new Call();
            }
            catch (Exception e) {
                Trace.verbose((Object)this, "run", (Throwable)e);
            }
        }
        this.cli = new CLIProxy(this.getSoapUrl(), this.callObject);
    }

    private CommandResult logout(String request, DataInputStream in, DataOutputStream out) throws Exception {
        this.shutDown = true;
        return this.processCommand(request, in, out);
    }

    private String readInput(DataInputStream in, byte[] token) throws IOException {
        String METHOD_NAME = "readInput";
        Trace.methodBegin(this, "readInput");
        int howMany = in.readUnsignedByte();
        Trace.verbose((Object)this, "readInput", "There is " + howMany + " to read.");
        byte[] readArray = null;
        if (howMany >= 0) {
            readArray = new byte[howMany];
            int i = 0;
            while (i < howMany) {
                Trace.verbose((Object)this, "readInput", "Reading " + i);
                readArray[i] = in.readByte();
                ++i;
            }
        } else {
            throw new IOException("Cannot read " + howMany + " characters.");
        }
        String result = Encoder.decode(readArray, token);
        return result;
    }

    private void writeOutput(String str, DataOutputStream out, byte[] token) throws IOException {
        String METHOD_NAME = "writeOutput";
        Trace.methodBegin(this, "writeOutput");
        Trace.verbose((Object)this, "writeOutput", "Writing output " + str);
        byte[] encodedArray = Encoder.encode(str, token);
        int len = encodedArray.length;
        String strLength = String.valueOf(len);
        char[] strLenChars = strLength.toCharArray();
        int lenOfLen = strLenChars.length;
        out.writeByte(lenOfLen);
        int i = 0;
        while (i < lenOfLen) {
            out.writeByte(strLenChars[i]);
            ++i;
        }
        out.flush();
        int i2 = 0;
        while (i2 < len) {
            out.writeByte(encodedArray[i2]);
            ++i2;
        }
        out.flush();
    }

    private CommandResult processCommand(String request, DataInputStream in, DataOutputStream out) {
        String METHOD_NAME = "processCommand";
        Trace.methodBegin(this, "processCommand");
        CommandResult cr = new CommandResult();
        cr.setRequest(request);
        try {
            cr = this.cli.processCommand(request);
            while (cr.getErrorId().equals(LOGIN_CODE) || cr.getErrorId().equals(LOGIN_NAME)) {
                this.writeOutput(cr.getErrorId(), out, this.token);
                this.writeOutput(cr.getResult(), out, this.token);
                Trace.verbose((Object)this, "processCommand", ">>>>>>>>>>>>>>>>>>read input");
                request = this.readInput(in, this.token);
                cr = this.cli.processCommand(request);
                if (cr.getResult() == null || cr.getResult().indexOf("parsing error: org.xml.sax.SAXParseException") < 0) continue;
                cr.setErrorId(ERROR_CODE);
                cr.setResult(resource.getString("error.invalid.input"));
            }
        }
        catch (SOAPException e) {
            cr.setErrorId(ERROR_CODE);
            cr.setResult(resource.getString("login.unableToConnect") + this.soapServer + ":" + this.soapPort);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "processCommand", (Throwable)e);
            String msg = e.getMessage();
            String res = resource.getString("system.error");
            if (msg != null && msg.indexOf("SSLHandshakeException") >= 0) {
                res = resource.getString("SSLHandshakeException");
                if (msg.indexOf("trusted cert") >= 0) {
                    res = res + resource.getString("error.trusted.certificate");
                }
            }
            cr.setResult(res);
            cr.setErrorId(ERROR_CODE);
        }
        return cr;
    }

    private boolean isLocal(Socket client) {
        String METHOD_NAME = "isLocal";
        Trace.methodBegin(this, "isLocal");
        InetAddress clientAddress = client.getInetAddress();
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.verbose((Object)this, "isLocal", "Exception while trying to get localhost address");
            return false;
        }
        Trace.verbose((Object)this, "isLocal", "Client IP(" + clientAddress.getHostAddress() + ") Hostname(" + clientAddress.getHostName() + ")");
        Trace.verbose((Object)this, "isLocal", "Client: " + clientAddress.getHostAddress());
        if (localhost.getHostAddress().equals(clientAddress.getHostAddress()) || "127.0.0.1".equals(clientAddress.getHostAddress())) {
            Trace.verbose((Object)this, "isLocal", "accepting connection");
            return true;
        }
        Trace.verbose((Object)this, "isLocal", "dropping connection");
        Trace.verbose((Object)this, "isLocal", "Method end.");
        return false;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    private String getSoapUrl() {
        String soapURI = "se6000ui/servlet/rpcrouter";
        soapURI = this.getSoapProperty("soap.uri", soapURI);
        if (this.isSecure) {
            this.soapProtocol = this.getSoapProperty("soap.secure.protocol", SOAP_SECURE_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.secure.port", SOAP_SECURE_PORT);
        } else {
            this.soapProtocol = this.getSoapProperty("soap.open.protocol", SOAP_OPEN_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.open.port", SOAP_OPEN_PORT);
        }
        String url = this.soapProtocol + "://" + this.soapServer + ":" + this.soapPort + "/" + soapURI;
        Trace.verbose((Object)this, "getSoapUrl", url);
        return url;
    }

    private String getSoapProperty(String property, String defaultValue) {
        String value = System.getProperty(property) == null ? defaultValue : System.getProperty(property);
        return value;
    }

    private void fixNewLine(CommandResult cr) {
        String result;
        if (cr.getResult() != null && !"".equals(result = cr.getResult().trim()) && !result.endsWith("\n")) {
            cr.setResult(result + "\n");
        }
    }

    static {
        DEFAULT_RETRIES = 10;
        SUCCESS_CODE = SUCCESS_CODE;
        ERROR_CODE = ERROR_CODE;
        LOGIN_NAME = LOGIN_NAME;
        LOGIN_CODE = LOGIN_CODE;
        MODIFY_PASSWORD_CODE = MODIFY_PASSWORD_CODE;
        SOAP_SECURE_PROTOCOL = SOAP_SECURE_PROTOCOL;
        SOAP_OPEN_PROTOCOL = SOAP_OPEN_PROTOCOL;
        SOAP_SECURE_PORT = SOAP_SECURE_PORT;
        SOAP_OPEN_PORT = SOAP_OPEN_PORT;
        resource = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", Locale.getDefault());
    }
}

