/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.sp.StorEdge_6x20ApplicationServer;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;

public class StorEdge_6x20RemoteServiceAccessPoint
extends StorEdge_InstanceProvider {
    private static final String DEFAULT_FW_CONFIG_FILE = "/opt/SUNWsespfw/repository";
    public static final String FIREWALL_CONFIG_SCRIPT = "/usr/local/bin/FW_config";
    private static final String PROP_SYSTEM_NAME = "SystemName";
    private static final String PROP_SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String PROP_CREATION_CLASS_NAME = "CreationClassName";
    private static final String PROP_NAME = "Name";
    private static final String PROP_ACCESS_INFO = "AccessInfo";
    private static final String PROP_INFO_FORMAT = "InfoFormat";
    private static final String PROP_DHCP_ACCESS = "DHCPAccess";
    private static final String PROP_GATEWAY_ADDRESS = "GatewayAddress";
    private static final String PROP_DNS_ADDRESS = "DNSAddress";
    private static final String PROP_DHCP_SERVER_ENABLED = "DHCPServerEnabled";
    private static final String PROP_NETMASK = "NetMask";
    private static final String PROP_DOMAIN_NAME = "DomainName";
    private static final String LAN_IP_ADDRESS = "LanIPAddr";
    private static final String WAN_ADDRESS_TYPE = "WanAddrType";
    private static final String LAN_DHCP_SERVER = "LanDHCPSrv";
    private static final String WAN_SUBNET_MASK = "WanSubnetMask";
    private static final String WAN_GATEWAY = "WanGateway";
    private static final String LAN_DNS_SERVER = "LanDNSSrv";
    private static final String WAN_IP_ADDRESS = "WanIPAddr";
    private static final String DELIMITER = ":";
    private static final String ENABLED = "enabled";
    private static final String STATIC = "static";
    private static final String DOMAIN = "domain";
    private static final String NAMESERVER = "nameserver";
    private String wanIPAddress;
    private String lanIPAddress;
    private String gatewayAddress;
    private boolean dhcpServerEnabled;
    private boolean dhcpAccess;
    private String netMask;
    private String tempDNS;
    private String tempDomain;
    public static final String CLASSNAME = "StorEdge_6x20RemoteServiceAccessPoint";

    public String getClassName() {
        return CLASSNAME;
    }

    protected CIMInstance getFirewallInstance(CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getFirewallInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getFirewallInstance" + " entered"));
        try {
            this.readConfigValues(DEFAULT_FW_CONFIG_FILE);
        }
        catch (FileNotFoundException ex) {
            WBEMDebug.trace2((String)(this.getClassName() + "." + "getFirewallInstance" + " Firewall repository file doesn't exist: " + DEFAULT_FW_CONFIG_FILE));
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getFirewallInstance" + " Error processing firewall repository file: " + DEFAULT_FW_CONFIG_FILE));
            throw new CIMException(ex.getMessage());
        }
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(this.getClassName());
            cop.setNameSpace(nameSpace);
            ci = cimomhandle.getClass(cop, false, true, true, null).newInstance();
            ci.setProperty(PROP_CREATION_CLASS_NAME, new CIMValue((Object)this.getClassName()));
            ci.setProperty(PROP_SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)new StorEdge_6x20ApplicationServer().getClassName()));
            ci.setProperty(PROP_SYSTEM_NAME, new CIMValue((Object)StorEdge_6x20ApplicationServer.getHostID().toString()));
            ci.setProperty(PROP_NAME, new CIMValue((Object)this.getLANFirewallIPAddress()));
            ci.setProperty(PROP_ACCESS_INFO, new CIMValue((Object)this.getWANFirewallIPAddress()));
            ci.setProperty(PROP_INFO_FORMAT, new CIMValue((Object)new UnsignedInt16(3)));
            ci.setProperty(PROP_NETMASK, new CIMValue((Object)this.getNetMask()));
            ci.setProperty(PROP_DHCP_ACCESS, new CIMValue((Object)new Boolean(this.getDHCPAccess())));
            ci.setProperty(PROP_GATEWAY_ADDRESS, new CIMValue((Object)this.getGatewayAddress()));
            HashMap resolvContent = null;
            resolvContent = this.readResolvFile();
            if (resolvContent.containsKey(NAMESERVER)) {
                ci.setProperty(PROP_DNS_ADDRESS, new CIMValue((Object)((String)resolvContent.get(NAMESERVER))));
            }
            if (resolvContent.containsKey(DOMAIN)) {
                ci.setProperty(PROP_DOMAIN_NAME, new CIMValue((Object)((String)resolvContent.get(DOMAIN))));
            }
            ci.setProperty(PROP_DHCP_SERVER_ENABLED, new CIMValue((Object)new Boolean(this.getDHCPServerEnabled())));
        }
        catch (CIMException e) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getFirewallInstance" + " failed to build " + "instance"), (Throwable)e);
            throw e;
        }
        return ci;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            Vector keys = op.getKeys();
            String parentClass = null;
            int i = 0;
            while (i < keys.size()) {
                CIMProperty prop = (CIMProperty)keys.elementAt(i);
                if (prop.getName().equalsIgnoreCase(PROP_SYSTEM_CREATION_CLASS_NAME)) {
                    parentClass = (String)prop.getValue().getValue();
                    break;
                }
                ++i;
            }
            if (parentClass.equalsIgnoreCase(new StorEdge_6x20ApplicationServer().getClassName())) {
                CIMInstance ci = this.getFirewallInstance((CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                if (localOnly) {
                    ci.localElements();
                }
                return ci;
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + "(Internal Error) Client attempted to retrieve" + "access point with bad SystemCreationClassName: " + parentClass));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " unknown failure."), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMException(ex.getMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        boolean newAddrType = false;
        boolean newDHCPServerState = false;
        Vector<PropertyInfo> propVector = new Vector<PropertyInfo>();
        try {
            PropertyInfo prop;
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            if (propertyList != null) {
                int i = 0;
                while (i < propertyList.length) {
                    String property = propertyList[i];
                    ++i;
                }
            }
            if (ci.getProperty(PROP_DHCP_ACCESS) != null && ci.getProperty(PROP_DHCP_ACCESS).getValue() != null) {
                Boolean val = (Boolean)ci.getProperty(PROP_DHCP_ACCESS).getValue().getValue();
                this.dhcpAccess = val;
                PropertyInfo prop2 = new PropertyInfo(PROP_DHCP_ACCESS, ci.getProperty(PROP_DHCP_ACCESS).getValue());
                propVector.addElement(prop2);
                WBEMDebug.trace2((String)("Setting dhcpAccess = " + this.dhcpAccess));
            }
            if (ci.getProperty(PROP_GATEWAY_ADDRESS) != null && ci.getProperty(PROP_GATEWAY_ADDRESS).getValue() != null) {
                this.gatewayAddress = (String)ci.getProperty(PROP_GATEWAY_ADDRESS).getValue().getValue();
                PropertyInfo prop3 = new PropertyInfo(PROP_GATEWAY_ADDRESS, ci.getProperty(PROP_GATEWAY_ADDRESS).getValue());
                propVector.addElement(prop3);
                WBEMDebug.trace2((String)("Setting gatewayAddress = " + this.gatewayAddress));
            }
            String newDNSAddress = null;
            String newDomainName = null;
            if (ci.getProperty(PROP_DNS_ADDRESS) != null && ci.getProperty(PROP_DNS_ADDRESS).getValue() != null) {
                newDNSAddress = (String)ci.getProperty(PROP_DNS_ADDRESS).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " dnsAddress = " + newDNSAddress));
            }
            if (ci.getProperty(PROP_DOMAIN_NAME) != null && ci.getProperty(PROP_DOMAIN_NAME).getValue() != null) {
                newDomainName = (String)ci.getProperty(PROP_DOMAIN_NAME).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " domainName  = " + newDomainName));
            }
            if (newDNSAddress != null || newDomainName != null) {
                PropertyInfo prop4;
                HashMap currentValues = this.updateResolvFile(newDNSAddress, newDomainName);
                StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/sendmail restart");
                StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/nscd stop");
                StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/nscd start");
                if (currentValues.containsKey(DOMAIN)) {
                    prop4 = new PropertyInfo(PROP_DOMAIN_NAME, new CIMValue(currentValues.get(DOMAIN)));
                    propVector.addElement(prop4);
                }
                if (currentValues.containsKey(NAMESERVER)) {
                    prop4 = new PropertyInfo(PROP_DNS_ADDRESS, new CIMValue(currentValues.get(NAMESERVER)));
                    propVector.addElement(prop4);
                }
            }
            if (ci.getProperty(PROP_NETMASK) != null && ci.getProperty(PROP_NETMASK).getValue() != null) {
                this.netMask = (String)ci.getProperty(PROP_NETMASK).getValue().getValue();
                prop = new PropertyInfo(PROP_NETMASK, ci.getProperty(PROP_NETMASK).getValue());
                propVector.addElement(prop);
                WBEMDebug.trace2((String)("Setting netMask = " + this.netMask));
            }
            if (ci.getProperty(PROP_ACCESS_INFO) != null && ci.getProperty(PROP_ACCESS_INFO).getValue() != null) {
                this.wanIPAddress = (String)ci.getProperty(PROP_ACCESS_INFO).getValue().getValue();
                prop = new PropertyInfo(PROP_ACCESS_INFO, ci.getProperty(PROP_ACCESS_INFO).getValue());
                propVector.addElement(prop);
                WBEMDebug.trace2((String)("Setting accessInfo = " + this.wanIPAddress));
            }
            if (!(this.dhcpAccess || this.wanIPAddress != null && this.netMask != null && this.gatewayAddress != null)) {
                throw new CIMException("CIM_ERR_FAILED: Must provide all params");
            }
            this.setFirewallConfig(propVector);
        }
        catch (Exception ex) {
            WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " setInstance failed"));
            ex.printStackTrace();
            throw new CIMException(ex.getMessage());
        }
    }

    protected String getWANFirewallIPAddress() {
        return this.wanIPAddress;
    }

    protected String getLANFirewallIPAddress() {
        return this.lanIPAddress;
    }

    protected boolean getDHCPAccess() {
        return this.dhcpAccess;
    }

    protected String getGatewayAddress() {
        return this.gatewayAddress;
    }

    private synchronized void setLanIPAddress(String newValue) throws IOException {
        block4: {
            String METHOD = "setLanIPAddress";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "setLanIPAddress" + " entered"));
            if (newValue != null && !newValue.equals(this.lanIPAddress)) {
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " Changing from " + this.lanIPAddress + " to " + newValue));
                String defaultRouterValue = this.readDefaultRouter();
                String oldValue = null;
                oldValue = this.lanIPAddress == null || !this.lanIPAddress.equals(defaultRouterValue) ? defaultRouterValue : this.lanIPAddress;
                this.lanIPAddress = newValue;
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " Updating /etc/defaultrouter file "));
                this.updateDefaultRouter();
                Process p = null;
                try {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " \n running  " + "/usr/sbin/route -n add default -gateway " + newValue));
                    p = Runtime.getRuntime().exec("/usr/sbin/route -n add default -gateway " + newValue);
                    p.waitFor();
                    if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " \n running  " + "/usr/sbin/route -n delete default -gateway " + oldValue));
                        p = Runtime.getRuntime().exec("/usr/sbin/route -n delete default -gateway " + oldValue);
                        p.waitFor();
                    }
                }
                catch (Exception e) {
                    if (p == null) break block4;
                    p.destroy();
                }
            }
        }
    }

    protected String getNetMask() {
        return this.netMask;
    }

    protected boolean getDHCPServerEnabled() {
        return this.dhcpServerEnabled;
    }

    protected void readConfigValues(String configFileName) throws FileNotFoundException, Exception {
        String METHOD = "readConfigValues";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " entered"));
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configFileName));
            String currLine = reader.readLine();
            while (currLine != null) {
                String tmpAccess;
                WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " curr line is " + currLine));
                if (currLine.startsWith(LAN_IP_ADDRESS)) {
                    String tmpLanIPAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.setLanIPAddress(tmpLanIPAddress);
                } else if (currLine.startsWith(LAN_DHCP_SERVER)) {
                    tmpAccess = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.dhcpServerEnabled = false;
                    if (tmpAccess.equalsIgnoreCase(ENABLED)) {
                        this.dhcpServerEnabled = true;
                    }
                } else if (currLine.startsWith(WAN_ADDRESS_TYPE)) {
                    tmpAccess = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.dhcpAccess = true;
                    if (tmpAccess.equalsIgnoreCase(STATIC)) {
                        this.dhcpAccess = false;
                    }
                } else if (currLine.startsWith(WAN_GATEWAY)) {
                    this.gatewayAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                } else if (currLine.startsWith(WAN_SUBNET_MASK)) {
                    this.netMask = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                } else if (currLine.startsWith(WAN_IP_ADDRESS)) {
                    this.wanIPAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                }
                currLine = reader.readLine();
            }
        }
        catch (IOException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " Firewall repository file not found " + configFileName));
            String[] arg = new String[]{configFileName};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            throw ex;
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " ex is " + ex.getMessage()));
            throw ex;
        }
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " exited."));
    }

    /*
     * Unable to fully structure code
     */
    private void setFirewallConfig(Vector properties) throws CIMException {
        METHOD = "setFirewallConfig";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setFirewallConfig" + " entered"));
        configStr = new StringBuffer("/usr/local/bin/FW_config ");
        map = new HashMap<String, String>();
        map.put("AccessInfo", "--wan_ip_addr");
        map.put("DHCPAccess", "--wan_addr_type");
        map.put("NetMask", "--wan_subnet_mask");
        map.put("GatewayAddress", "--wan_gateway");
        map.put("DNSAddress", "--dhcp_dns_server");
        map.put("DHCPServerEnabled", "--dhcp_server");
        try {
            i = 0;
            while (i < properties.size()) {
                block11: {
                    block10: {
                        prop = (PropertyInfo)properties.elementAt(i);
                        name = prop.getName();
                        cv = prop.getValue();
                        cmd = (String)map.get(name);
                        if (cmd == null) {
                            throw new CIMException("CIM_NO_SUCH_PROPERTY");
                        }
                        val = new String(cv.getValue().toString());
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "setFirewallConfig" + " initially  " + name + "=" + val));
                        if (!name.equalsIgnoreCase("DHCPAccess")) break block10;
                        val = "static";
                        if (cv.toString().equals("true")) {
                            val = "dynamic";
                            configStr = new StringBuffer("/usr/local/bin/FW_config " + cmd + " " + val);
                            break;
                        }
                        ** GOTO lbl56
                    }
                    if (!name.equalsIgnoreCase("DHCPServerEnabled")) break block11;
                    val = "dis";
                    if (cv.toString().equals("true")) {
                        val = "en";
                    }
                    ** GOTO lbl56
                }
                if (!name.equalsIgnoreCase("DNSAddress")) ** GOTO lbl56
                maseratiId = -1;
                try {
                    maseratiStr = StorEdge_6x20ApplicationServer.getOtherIdentifyingInfo();
                    maseratiId = new Integer(maseratiStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (maseratiId != 0) {
                    configStr.append((String)map.get("DHCPServerEnabled") + " dis ");
                } else {
                    configStr.append((String)map.get("DHCPServerEnabled") + " en ");
lbl56:
                    // 4 sources

                    WBEMDebug.trace2((String)(this.getClassName() + "." + "setFirewallConfig" + " " + name + "=" + val));
                    configStr.append(cmd + " " + val + " ");
                }
                ++i;
            }
            StorEdge_6x20RemoteServiceAccessPoint.setConfigValue(configStr.toString());
        }
        catch (Exception ex) {
            throw new CIMException(ex.getMessage());
        }
    }

    static void setConfigValue(String cmdStr) throws InterruptedException, Exception {
        String METHOD = "setConfigValue";
        WBEMDebug.trace3((String)"StorEdge_6x20RemoteServiceAccessPoint.setConfigValue entered");
        WBEMDebug.trace2((String)("Calling FW config script: " + cmdStr));
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            if (p.exitValue() < 0 || p.exitValue() > 0 && p.exitValue() < 100) {
                WBEMDebug.trace1((String)("StorEdge_6x20RemoteServiceAccessPoint.setConfigValue Error running FW_config script: " + cmdStr));
                WBEMDebug.trace1((String)("StorEdge_6x20RemoteServiceAccessPoint.setConfigValue The value of error code is " + p.exitValue()));
                throw new Exception("Error running FW command");
            }
            if (p.exitValue() >= 100) {
                WBEMDebug.trace2((String)("StorEdge_6x20RemoteServiceAccessPoint.setConfigValue Error code from FW_config script: " + p.exitValue()));
            }
        }
        catch (InterruptedException ex) {
            p.destroy();
            WBEMDebug.trace1((String)"StorEdge_6x20RemoteServiceAccessPoint.setConfigValue Destroying process after InterruptedException");
            throw ex;
        }
    }

    static void invokeCommandString(String cmdStr) throws InterruptedException, Exception {
        String METHOD = "invokeCommandString";
        WBEMDebug.trace3((String)"StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString entered");
        WBEMDebug.trace2((String)("Invoking Command : " + cmdStr));
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            if (p.exitValue() != 0) {
                WBEMDebug.trace1((String)("StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString Error running command: " + cmdStr));
                WBEMDebug.trace1((String)("StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString The value of error code is " + p.exitValue()));
                throw new Exception("Error Running Command");
            }
        }
        catch (InterruptedException ex) {
            p.destroy();
            WBEMDebug.trace1((String)"StorEdge_6x20RemoteServiceAccessPoint.invokeCommandString Destroying process after InterruptedException");
            throw ex;
        }
    }

    protected Vector enumerate(String nameSpace) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        Vector<CIMInstance> v = new Vector<CIMInstance>(1);
        v.addElement(this.getFirewallInstance((CIMOMHandle)this.getCimomHandle(), nameSpace));
        return v;
    }

    /*
     * Loose catch block
     */
    protected void saveProperties(String filename) throws IOException {
        block7: {
            String METHOD = "saveProperties";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "saveProperties" + " entered"));
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            String output = "// This is a temporary file.  This will hold the \n// firewall data until the firewall configuration\n// script is complete. Once complete the firewall\n// data will be stored in /opt/SUNWsespfw/repository.\n";
            String wanAddressTypeString = this.dhcpAccess ? "dynamic" : STATIC;
            output = output + "LanIPAddr:" + this.lanIPAddress + "\n";
            output = output + "WanIPAddr:" + this.wanIPAddress + "\n";
            output = output + "WanAddrType:" + wanAddressTypeString + "\n";
            output = output + "WanGateway:" + this.gatewayAddress + "\n";
            output = output + "LanDHCPSrv:" + this.dhcpServerEnabled + "\n";
            output = output + "WanSubnetMask:" + this.netMask + "\n";
            output = output + "DomainName:" + this.tempDomain + "\n";
            output = output + "LanDNSSrv:" + this.tempDNS + "\n";
            WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " writing to the file:\n" + output));
            writer.write(output, 0, output.length());
            writer.flush();
            writer.close();
            Object var7_7 = null;
            try {
                writer.close();
            }
            catch (IOException ex) {
                WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " error closing file: " + filename));
            }
            break block7;
            {
                catch (IOException ex) {
                    System.out.println("Error opening file: " + ex.toString());
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " error closing file: " + filename));
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HashMap updateResolvFile(String newDNSAddress, String newDomainName) throws IOException {
        OutputStreamWriter out;
        HashMap<String, String> result;
        block8: {
            String METHOD = "updateResolvFile";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " entered"));
            result = new HashMap<String, String>();
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " newDNS is " + newDNSAddress + " newDomain is " + newDomainName));
            out = null;
            File tmpFile = null;
            try {
                HashMap currentValues = this.readResolvFile();
                String currDNSAddress = (String)currentValues.get(NAMESERVER);
                String currDomainName = (String)currentValues.get(DOMAIN);
                WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " currDNS is " + currDNSAddress + " currDomain is " + currDomainName));
                if (newDNSAddress != null && !newDNSAddress.equals(currDNSAddress) || newDomainName != null && !newDomainName.equals(currDomainName)) {
                    File resolvFile = new File("/etc/resolv.conf");
                    StringBuffer content = new StringBuffer("");
                    if (newDNSAddress != null || currDNSAddress != null) {
                        String whichDNS = newDNSAddress != null ? newDNSAddress : currDNSAddress;
                        content.append("nameserver " + whichDNS + "\n");
                        result.put(NAMESERVER, whichDNS);
                    }
                    if (newDomainName != null || currDomainName != null) {
                        String whichDomain = newDomainName != null ? newDomainName : currDomainName;
                        content.append("domain " + whichDomain + "\n");
                        result.put(DOMAIN, whichDomain);
                    }
                    tmpFile = new File("/etc/.resolv.conf");
                    out = new FileWriter(tmpFile);
                    out.write(content.toString());
                    out.flush();
                    out.close();
                    tmpFile.renameTo(resolvFile);
                }
                Object var14_13 = null;
                if (tmpFile == null || !tmpFile.exists()) break block8;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
        }
        if (out != null) {
            out.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readDefaultRouter() throws IOException {
        String METHOD = "readDefaultRouter";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readDefaultRouter" + " entered"));
        BufferedReader reader = null;
        String result = null;
        try {
            File file = new File("/etc/defaultrouter");
            if (file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                result = reader.readLine();
            }
            Object var6_5 = null;
            if (reader == null) return result;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized HashMap readResolvFile() {
        block15: {
            block14: {
                METHOD = "readResolvFile";
                WBEMDebug.trace3((String)(this.getClassName() + "." + "readResolvFile" + " entered"));
                reader = null;
                result = new HashMap<String, String>();
                file = new File("/etc/resolv.conf");
                if (!file.exists()) break block14;
                reader = new BufferedReader(new FileReader(file));
                found = 0;
                line = null;
                if (true) ** GOTO lbl23
                do {
                    if (line.startsWith("domain") || line.startsWith("nameserver")) {
                        ++found;
                        tokenizer = new StringTokenizer(line, " \t");
                        if (tokenizer.countTokens() >= 2) {
                            firstToken = tokenizer.nextToken();
                            secondToken = tokenizer.nextToken();
                            result.put(firstToken, secondToken);
                            WBEMDebug.trace3((String)(this.getClassName() + "." + "readResolvFile" + " \n putting " + firstToken + "=" + secondToken));
                        }
                    }
lbl23:
                    // 6 sources

                    line = reader.readLine();
                    if (line == null) break;
                } while (found < 2);
            }
            var11_11 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block15;
            }
            catch (IOException ioe) {}
            break block15;
            {
                catch (IOException ie) {
                    var11_12 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block15;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable var10_17) {
                var11_13 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw var10_17;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateDefaultRouter() throws IOException {
        File tmpFile;
        block5: {
            String METHOD = "updateDefaultRouter";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateDefaultRouter" + " entered"));
            OutputStreamWriter fr = null;
            tmpFile = null;
            try {
                File dRFile = new File("/etc/defaultrouter");
                tmpFile = new File("/etc/.defaultrouter");
                String content = this.lanIPAddress + "\n";
                fr = new FileWriter(tmpFile);
                fr.write(content);
                fr.flush();
                fr.close();
                tmpFile.renameTo(dRFile);
                Object var7_6 = null;
                if (fr == null) break block5;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fr != null) {
                    fr.close();
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            fr.close();
        }
        if (tmpFile != null && tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    static {
        FIREWALL_CONFIG_SCRIPT = FIREWALL_CONFIG_SCRIPT;
        PROP_SYSTEM_NAME = PROP_SYSTEM_NAME;
        PROP_SYSTEM_CREATION_CLASS_NAME = PROP_SYSTEM_CREATION_CLASS_NAME;
        PROP_CREATION_CLASS_NAME = PROP_CREATION_CLASS_NAME;
        PROP_NAME = PROP_NAME;
        PROP_ACCESS_INFO = PROP_ACCESS_INFO;
        PROP_INFO_FORMAT = PROP_INFO_FORMAT;
        PROP_DHCP_ACCESS = PROP_DHCP_ACCESS;
        PROP_GATEWAY_ADDRESS = PROP_GATEWAY_ADDRESS;
        PROP_DNS_ADDRESS = PROP_DNS_ADDRESS;
        PROP_DHCP_SERVER_ENABLED = PROP_DHCP_SERVER_ENABLED;
        PROP_NETMASK = PROP_NETMASK;
        PROP_DOMAIN_NAME = PROP_DOMAIN_NAME;
        LAN_IP_ADDRESS = LAN_IP_ADDRESS;
        WAN_ADDRESS_TYPE = WAN_ADDRESS_TYPE;
        LAN_DHCP_SERVER = LAN_DHCP_SERVER;
        WAN_SUBNET_MASK = WAN_SUBNET_MASK;
        WAN_GATEWAY = WAN_GATEWAY;
        LAN_DNS_SERVER = LAN_DNS_SERVER;
        WAN_IP_ADDRESS = WAN_IP_ADDRESS;
        DELIMITER = DELIMITER;
        ENABLED = ENABLED;
        STATIC = STATIC;
        DOMAIN = DOMAIN;
        NAMESERVER = NAMESERVER;
        CLASSNAME = CLASSNAME;
    }

    class PropertyInfo {
        private String name;
        private CIMValue value;

        public PropertyInfo(String name, CIMValue value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public CIMValue getValue() {
            return this.value;
        }
    }
}

